/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.branchcompare;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.ide.model.Element;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.spi.CommonTableModel;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdevimpl.vcs.git.branchcompare.BranchListItem;
import oracle.jdevimpl.vcs.git.branchcompare.spi.VersionTableModel;
import oracle.jdevimpl.vcs.git.res.Resource;

public class GITBranchTableModel
extends CommonTableModel
implements VersionTableModel {
    private List<BranchListItem> _items;

    GITBranchTableModel(DisplayProperty[] prop) {
        super(prop);
    }

    public Object getValueAt(int row, int col) {
        if (row >= this._items.size()) {
            return null;
        }
        BranchListItem item = this._items.get(row);
        if (col == 0) {
            return item.getChangeType();
        }
        if (col == 1) {
            String oname;
            if (item.getOrginal() == null) {
                return URLFileSystem.getFileName((URL)item.getURL());
            }
            String name = URLFileSystem.getFileName((URL)item.getURL());
            if (name.equals(oname = URLFileSystem.getFileName((URL)item.getOrginal()))) {
                return name;
            }
            return Resource.format("BRANCH_WASNOW", oname, name);
        }
        if (col == 2) {
            String relative = null;
            if (item.getOrginal() != null) {
                relative = URLFileSystem.toRelativeSpec((URL)URLFileSystem.getParent((URL)item.getOrginal()), (URL)URLFileSystem.getParent((URL)item.getURL()), (boolean)true);
            }
            return URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)item.getURL())) + (relative != null && !relative.isEmpty() ? Resource.format("BRANCH_FROM", relative) : "");
        }
        if (col == 3) {
            return item.getBranch();
        }
        return null;
    }

    public int getRowCount() {
        if (this._items == null) {
            return 0;
        }
        return this._items.size();
    }

    void addItems(Collection<BranchListItem> items) {
        if (this._items == null) {
            this._items = new ArrayList<BranchListItem>();
        } else {
            if (this._items.size() > 0) {
                this.fireTableRowsDeleted(0, this._items.size() - 1);
            }
            this._items.clear();
        }
        this._items.addAll(items);
        if (items.size() > 0) {
            this.fireTableRowsInserted(0, items.size() - 1);
        }
    }

    @Override
    public Element getItem(int row) {
        return (Element)this._items.get(row);
    }
}

