/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.editor.EditorManager;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.git.cmd.GITAbstractOperation;
import oracle.jdevimpl.vcs.git.res.Resource;

public class GITShowIgnoreCommand
extends GITAbstractOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.git.show-ignore";

    public GITShowIgnoreCommand() {
        super(COMMAND_ID);
    }

    public int doitImpl(VCSProfile profile) {
        try {
            URL root = this.getGitClientRoot(profile);
            URL ignore = URLFactory.newURL((URL)root, (String)".gitignore");
            if (!URLFileSystem.exists((URL)ignore)) {
                if (URLFileSystem.canCreate((URL)ignore)) {
                    boolean ans = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)Resource.get("IGNORE_FILE_CREATE"), (String)Resource.get("IGNORE_FILE_CREATE_TITLE"), null);
                    if (!ans) {
                        return 1;
                    }
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)Resource.format("IGNORE_FILE_SHOW", URLFileSystem.getPlatformPathName((URL)ignore)), (String)Resource.get("IGNORE_FILE_SHOW_TITLE"), null);
                }
            }
            EditorManager.getEditorManager().openDefaultEditorInFrame(ignore);
        }
        catch (Exception e) {
            return 1;
        }
        return 0;
    }
}

