/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav;

import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ImageIconCache;
import oracle.jdevimpl.vcs.git.GITConnectionInfo;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.nav.GITBranchListNode;
import oracle.jdevimpl.vcs.git.nav.GITRemote;
import oracle.jdevimpl.vcs.git.nav.GITRemotesListNode;
import oracle.jdevimpl.vcs.git.nav.GITStashListNode;
import oracle.jdevimpl.vcs.git.nav.GITTagListNode;
import oracle.jdevimpl.vcs.git.res.Resource;

public class GITConnectionNode
extends DefaultContainer
implements GITRemote {
    private GITConnectionInfo _info;

    public GITConnectionNode(GITConnectionInfo connectionInfo) {
        this._info = connectionInfo;
        this.setURL(GITNavURLFileSystemHelper.toNavigatorURL(connectionInfo.getRootURL()));
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        return URLFileSystem.getFileName((URL)this._info.getRootURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.clear();
            this._children.add(new GITBranchListNode(this._info));
            this._children.add(new GITTagListNode(this._info));
            this._children.add(new GITRemotesListNode(this._info));
            this._children.add(new GITStashListNode(this._info));
        }
    }

    public String getToolTipText() {
        return URLFileSystem.toDisplayString((URL)this._info.getRootURL());
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public boolean canRefresh() {
        return true;
    }

    public Icon getIcon() {
        return ImageIconCache.get((URL)Resource.getBundle().getClass().getResource(Resource.get("GIT_CONN_ICON")));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GITConnectionNode)) {
            return false;
        }
        return this.equalsImpl((Node)obj);
    }
}

