/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav;

import java.net.URL;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.nav.GITBranchNode;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBranch;

public class GITLocalBranchNode
extends GITBranchNode {
    public GITLocalBranchNode(GitBranch branch, URL url) {
        super(branch, url);
    }

    @Override
    public String getShortLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBranch().getName());
        if (this.getBranch().getTrackedBranch() != null) {
            sb.append(" - ");
            if (this.getBranch().getId().equals(this.getBranch().getTrackedBranch().getId())) {
                sb.append(Resource.format("LOCAL_BRANCH_SYNC", this.getBranch().getTrackedBranch().getName()));
            } else {
                sb.append(Resource.format("LOCAL_BRANCH_DIVERGED", this.getBranch().getTrackedBranch().getName()));
            }
            sb.append(" : ");
            sb.append(GITUtil.shortCommitId(this.getBranch().getTrackedBranch().getId()));
        }
        return sb.toString();
    }
}

