/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDecoration;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.elaf.EWTTreeUI;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;

public class DTreeButtonDecoration
implements DTreeDecoration {
    private Icon _expandedIcon;
    private Icon _collapsedIcon;

    @Override
    public ImmInsets getDecorationInsets(DTree tree) {
        return new ImmInsets(0, tree.getIndentWidth(), 0, 0);
    }

    public Icon getCollapsedIcon() {
        return this._collapsedIcon;
    }

    public Icon getExpandedIcon() {
        return this._expandedIcon;
    }

    @Override
    public void processMouseEvent(MouseEvent evt, DTreeItem item) {
        if (evt.getID() == 501 && SwingUtilities.isLeftMouseButton(evt)) {
            DTree tree = item.getTree();
            int itemx = item.getX();
            int indentwidth = tree.getIndentWidth();
            int x = evt.getX();
            if (item.isExpandable() && x > itemx - indentwidth && x < itemx) {
                item.setExpanded(!item.isExpanded());
                evt.consume();
                return;
            }
        }
    }

    @Override
    public void paintDecoration(PaintContext context, Graphics g, DTreeItem item, int width, int height) {
        if (this.getHasButton(item)) {
            Icon buttonIcon;
            DTree tree = item.getTree();
            Icon icon = buttonIcon = item.isExpanded() ? this.getExpandedIcon() : this.getCollapsedIcon();
            if (buttonIcon == null) {
                EWTTreeUI treeUI = tree.getUI();
                buttonIcon = treeUI.getExpansionButtonIcon(tree, item);
            }
            if (buttonIcon == null) {
                return;
            }
            int buttonHeight = buttonIcon.getIconHeight();
            int buttonWidth = buttonIcon.getIconWidth();
            int indentwidth = tree.getIndentWidth();
            int x = width - indentwidth + (indentwidth - buttonWidth) / 2;
            int y = (height - buttonHeight) / 2;
            if ((indentwidth - buttonWidth) % 2 == 1) {
                ++x;
            }
            buttonIcon.paintIcon(tree, g, x, y);
        }
    }

    public void setCollapsedIcon(Icon collapsedIcon) {
        this._collapsedIcon = collapsedIcon;
    }

    public void setExpandedIcon(Icon expandedIcon) {
        this._expandedIcon = expandedIcon;
    }

    protected boolean getHasButton(DTreeItem item) {
        return item.isExpandable();
    }
}

