/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemEvent;
import oracle.bali.ewt.dTree.DTreeRange;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.dTree.DTreeSelectionManager;
import oracle.bali.ewt.event.Cancelable;

public class DTreeSingleSelectionManager
implements DTreeSelectionManager {
    private DTree _tree;
    private DTreeItem _selected;
    private PropertyChangeSupport _propSupport;
    private VetoableChangeSupport _vetoSupport;

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propSupport == null) {
            this._propSupport = new PropertyChangeSupport(this);
        }
        this._propSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (this._vetoSupport == null) {
            this._vetoSupport = new VetoableChangeSupport(this);
        }
        this._vetoSupport.addVetoableChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._propSupport != null) {
            this._propSupport.removePropertyChangeListener(listener);
        }
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (this._vetoSupport != null) {
            this._vetoSupport.removeVetoableChangeListener(listener);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this._propSupport != null) {
            this._propSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        if (this._vetoSupport != null) {
            this._vetoSupport.fireVetoableChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void setTree(DTree tree) {
        if (tree != this._tree) {
            this._tree = tree;
            this._selected = null;
        }
    }

    @Override
    public void extendSelection(DTreeItem item) throws PropertyVetoException {
        this.selectItem(item);
    }

    @Override
    public boolean isSomethingSelected() {
        return this._selected != null;
    }

    @Override
    public DTreeSelection getSelection() {
        DTreeItem parent;
        DTreeSelection selection = new DTreeSelection();
        if (this._selected != null && (parent = this._selected.getParent()) != null) {
            int index = this._selected.getIndex();
            selection.addRange(new DTreeRange(parent, index, 1));
        }
        return selection;
    }

    @Override
    public DTree getTree() {
        return this._tree;
    }

    @Override
    public boolean isSelected(DTreeItem item) {
        return item == this._selected;
    }

    @Override
    public void itemCollapsing(DTreeItemEvent evt) {
        DTreeItem item = evt.getItem();
        if (this._selected != null && this._selected != item && DTree.isItemDescendent(this._selected, item)) {
            try {
                this.selectItem(item);
            }
            catch (PropertyVetoException e) {
                ((Cancelable)((Object)evt)).cancel();
            }
        }
    }

    @Override
    public void itemsAdded(DTreeItem parent, int startIndex, int count) {
    }

    @Override
    public void itemsRemoved(DTreeItem parent, int startIndex, int count) {
        if (this._selected != null && this._selected.getParent() == null) {
            this._selected = null;
            try {
                this._setSelection(null, null, true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    @Override
    public void selectItem(DTreeItem item) throws PropertyVetoException {
        this._setSelection(item, item, false);
    }

    @Override
    public void setSelection(DTreeSelection selection) throws PropertyVetoException {
        DTreeItem item = null;
        if (selection != null && selection.getCount() > 0) {
            DTreeRange range = selection.getRange(0);
            int rangestart = range.getStartIndex();
            int rangecount = range.getCount();
            if (range.getCount() > 0) {
                DTreeItem parent = range.getParent();
                item = parent.getItem(range.getStartIndex());
            }
        }
        this._setSelection(item, null, false);
    }

    @Override
    public void toggleItem(DTreeItem item) throws PropertyVetoException {
        if (this.isSelected(item)) {
            this.selectItem(null);
        } else {
            this.selectItem(item);
        }
    }

    private void _setSelection(DTreeItem item, DTreeItem focusedItem, boolean alwaysDeliver) throws PropertyVetoException {
        if (this._selected == item && !alwaysDeliver) {
            return;
        }
        DTreeSelection oldSelection = this.getSelection();
        DTreeSelection newSelection = new DTreeSelection();
        if (item != null) {
            DTreeItem parent = item.getParent();
            int index = item.getIndex();
            newSelection.addRange(new DTreeRange(parent, index, 1));
        }
        this.fireVetoableChange("selection", oldSelection, newSelection);
        this._selected = item;
        if (focusedItem != null) {
            this._tree.setFocusedItem(focusedItem);
        }
        this.firePropertyChange("selection", oldSelection, newSelection);
    }
}

