/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.util.Enumeration;
import oracle.bali.ewt.dTree.OneDSparseArrayBlock;

class OneDSparseArray {
    public static final int INDEX_NONE = -1;
    private OneDSparseArrayBlock[] _blocks;
    private int _nblocks;
    private int _defblocklen;
    private int _maxblocklen;

    public OneDSparseArray() {
        this(100, 1000);
    }

    public OneDSparseArray(int defaultBlockLength, int maximumBlockLength) {
        this._defblocklen = defaultBlockLength;
        this._maxblocklen = maximumBlockLength;
    }

    public int getDefaultBlockLength() {
        return this._defblocklen;
    }

    public Object getElement(int index) {
        for (int i = 0; i < this._nblocks; ++i) {
            OneDSparseArrayBlock block = this._blocks[i];
            int blockStart = block.getStartIndex();
            if (index < blockStart) {
                return null;
            }
            if (index >= blockStart + block.getLength()) continue;
            return block.getElement(index - blockStart);
        }
        return null;
    }

    public Enumeration getEnumeration() {
        return null;
    }

    public int getFirstIndex() {
        for (int i = 0; i < this._nblocks; ++i) {
            OneDSparseArrayBlock block = this._blocks[i];
            int blockLength = block.getLength();
            for (int j = 0; j < blockLength; ++j) {
                Object element = block.getElement(j);
                if (element == null) continue;
                return block.getStartIndex() + j;
            }
        }
        return -1;
    }

    public int getLastIndex() {
        for (int i = this._nblocks - 1; i >= 0; --i) {
            OneDSparseArrayBlock block = this._blocks[i];
            int blockLength = block.getLength();
            for (int j = blockLength - 1; j >= 0; --j) {
                Object element = block.getElement(j);
                if (element == null) continue;
                return block.getStartIndex() + j;
            }
        }
        return -1;
    }

    public int getNextIndex(int index) {
        for (int i = 0; i < this._nblocks; ++i) {
            int blockLength;
            OneDSparseArrayBlock block = this._blocks[i];
            int blockStart = block.getStartIndex();
            if (index >= blockStart + (blockLength = block.getLength())) continue;
            int j = 0;
            if (index >= blockStart) {
                j = index - blockStart + 1;
            }
            while (j < blockLength) {
                Object element = block.getElement(j);
                if (element != null) {
                    return blockStart + j;
                }
                ++j;
            }
        }
        return -1;
    }

    public int getMaximumBlockLength() {
        return this._maxblocklen;
    }

    public void insertElement(Object element, int index) {
    }

    public void insertElements(int index, int count) {
        OneDSparseArrayBlock block;
        int blockIndex;
        for (blockIndex = 0; blockIndex < this._nblocks; ++blockIndex) {
            block = this._blocks[blockIndex];
            int blockStart = block.getStartIndex();
            int blockLength = block.getLength();
            if (index < blockStart) break;
            if (index >= blockStart + blockLength) continue;
            if (index == blockStart) break;
            this._splitBlock(blockIndex, index);
            ++blockIndex;
            break;
        }
        while (blockIndex < this._nblocks) {
            block = this._blocks[blockIndex];
            block.setStartIndex(block.getStartIndex() + count);
            ++blockIndex;
        }
    }

    public void insertElements(Object[] elements, int index, int count) {
    }

    public boolean isEmpty() {
        return this.getFirstIndex() == -1;
    }

    public void removeAll() {
        this._blocks = null;
        this._nblocks = 0;
    }

    public void removeElements(int index, int count) {
        int blockIndex = 0;
        while (blockIndex < this._nblocks) {
            int blockLength;
            OneDSparseArrayBlock block = this._blocks[blockIndex];
            int blockStart = block.getStartIndex();
            if (index < blockStart + (blockLength = block.getLength())) {
                if (index + count < blockStart) {
                    block.setStartIndex(block.getStartIndex() - count);
                } else {
                    if (index <= blockStart && index + count >= blockStart + blockLength) {
                        this._removeBlock(blockIndex);
                        continue;
                    }
                    this._removeElements(blockIndex, index, count);
                }
            }
            ++blockIndex;
        }
    }

    public void setDefaultBlockLength(int defaultBlockLength) {
        this._defblocklen = defaultBlockLength;
    }

    public void setElement(Object element, int index) {
        OneDSparseArrayBlock block;
        int blockStart;
        int i;
        for (i = 0; i < this._nblocks && index >= (blockStart = (block = this._blocks[i]).getStartIndex()); ++i) {
            if (index >= blockStart + block.getLength()) continue;
            block.setElement(index - blockStart, element);
            return;
        }
        this._setElement(element, index, i);
    }

    public void setElements(Object[] elements, int index, int count) {
    }

    public void setMaximumBlockLength(int maximumBlockLength) {
        this._maxblocklen = maximumBlockLength;
    }

    private void _setElement(Object element, int index, int blockIndex) {
        int blockStart;
        int blockLength;
        boolean canExtendPreviousBlock = false;
        boolean canExtendNextBlock = false;
        OneDSparseArrayBlock previousBlock = null;
        OneDSparseArrayBlock nextBlock = null;
        if (blockIndex > 0) {
            previousBlock = this._blocks[blockIndex - 1];
            blockLength = previousBlock.getLength();
            blockStart = previousBlock.getStartIndex();
            if (index - (blockStart + blockLength) < this.getDefaultBlockLength() && blockLength + this.getDefaultBlockLength() < this.getMaximumBlockLength()) {
                canExtendPreviousBlock = true;
            }
        }
        if (blockIndex < this._nblocks) {
            nextBlock = this._blocks[blockIndex];
            blockLength = nextBlock.getLength();
            blockStart = nextBlock.getStartIndex();
            if (blockStart - index <= this.getDefaultBlockLength() && blockLength + this.getDefaultBlockLength() < this.getMaximumBlockLength()) {
                canExtendNextBlock = true;
            }
        }
        if (canExtendPreviousBlock && canExtendNextBlock) {
            if (previousBlock.getLength() < nextBlock.getLength()) {
                this._extendPreviousBlock(element, index, blockIndex - 1);
            } else {
                this._extendNextBlock(element, index, blockIndex);
            }
        } else if (canExtendPreviousBlock) {
            this._extendPreviousBlock(element, index, blockIndex - 1);
        } else if (canExtendNextBlock) {
            this._extendNextBlock(element, index, blockIndex);
        } else {
            this._createNewBlock(element, index, blockIndex);
        }
    }

    private void _createNewBlock(Object element, int index, int blockIndex) {
        OneDSparseArrayBlock block = new OneDSparseArrayBlock(index, this.getDefaultBlockLength());
        block.setElement(0, element);
        if (this._blocks == null) {
            this._blocks = new OneDSparseArrayBlock[1];
        }
        if (this._nblocks == this._blocks.length) {
            OneDSparseArrayBlock[] tmpblocks = new OneDSparseArrayBlock[this._nblocks * 2];
            System.arraycopy(this._blocks, 0, tmpblocks, 0, this._nblocks);
            this._blocks = tmpblocks;
        }
        System.arraycopy(this._blocks, blockIndex, this._blocks, blockIndex + 1, this._nblocks - blockIndex);
        this._blocks[blockIndex] = block;
        ++this._nblocks;
    }

    private void _extendNextBlock(Object element, int index, int blockIndex) {
        int prevLength;
        OneDSparseArrayBlock prevBlock;
        int prevStart;
        OneDSparseArrayBlock block = this._blocks[blockIndex];
        int blockStart = block.getStartIndex();
        int newBlockStart = blockStart - this.getDefaultBlockLength();
        if (newBlockStart < 0) {
            newBlockStart = 0;
        }
        if (blockIndex > 0 && newBlockStart < (prevStart = (prevBlock = this._blocks[blockIndex - 1]).getStartIndex()) + (prevLength = prevBlock.getLength())) {
            newBlockStart = prevStart + prevLength;
        }
        int newBlockLength = block.getLength() + (blockStart - newBlockStart);
        Object[] oldData = block.getElements();
        Object[] newData = new Object[newBlockLength];
        System.arraycopy(oldData, 0, newData, blockStart - newBlockStart, oldData.length);
        OneDSparseArrayBlock newBlock = new OneDSparseArrayBlock(newBlockStart, newData, newData.length);
        newBlock.setElement(index - newBlockStart, element);
        this._blocks[blockIndex] = newBlock;
    }

    private void _extendPreviousBlock(Object element, int index, int blockIndex) {
        OneDSparseArrayBlock nextBlock;
        int nextStart;
        OneDSparseArrayBlock block = this._blocks[blockIndex];
        int blockStart = block.getStartIndex();
        int blockLength = block.getLength();
        int newBlockLength = blockLength + this.getDefaultBlockLength();
        if (blockIndex < this._nblocks - 1 && blockStart + newBlockLength > (nextStart = (nextBlock = this._blocks[blockIndex + 1]).getStartIndex())) {
            newBlockLength = nextStart - blockStart;
        }
        block.setLength(newBlockLength);
        block.setElement(index - blockStart, element);
    }

    private void _removeBlock(int blockIndex) {
        System.arraycopy(this._blocks, blockIndex + 1, this._blocks, blockIndex, this._nblocks - (blockIndex + 1));
        this._blocks[this._nblocks - 1] = null;
        --this._nblocks;
    }

    private void _removeElements(int blockIndex, int index, int count) {
        OneDSparseArrayBlock block = this._blocks[blockIndex];
        int blockStart = block.getStartIndex();
        int blockLength = block.getLength();
        int blockEnd = blockStart + blockLength;
        int removedEnd = index + count;
        int newBlockStart = blockStart;
        int newBlockLength = 0;
        if (index <= blockStart) {
            newBlockStart = index;
            newBlockLength = blockEnd - removedEnd;
        } else {
            newBlockLength = removedEnd > blockEnd ? index - blockStart : blockLength - count;
        }
        Object[] oldData = block.getElements();
        Object[] newData = new Object[newBlockLength];
        if (index > blockStart) {
            System.arraycopy(oldData, 0, newData, 0, index - blockStart);
        }
        if (removedEnd < blockEnd) {
            System.arraycopy(oldData, removedEnd - blockStart, newData, index - newBlockStart, blockEnd - removedEnd);
        }
        this._blocks[blockIndex] = new OneDSparseArrayBlock(newBlockStart, newData, newBlockLength);
    }

    private void _splitBlock(int blockIndex, int index) {
        OneDSparseArrayBlock newBlock;
        OneDSparseArrayBlock oldBlock = this._blocks[blockIndex];
        int oldStart = oldBlock.getStartIndex();
        int oldLength = oldBlock.getLength();
        Object[] oldData = oldBlock.getElements();
        int newLength = index - oldStart;
        Object[] newData = new Object[newLength];
        System.arraycopy(oldData, 0, newData, 0, newLength);
        this._blocks[blockIndex] = newBlock = new OneDSparseArrayBlock(oldStart, newData, newLength);
        newLength = oldLength - newLength;
        newData = new Object[newLength];
        System.arraycopy(oldData, index - oldStart, newData, 0, newLength);
        newBlock = new OneDSparseArrayBlock(index, newData, newLength);
        if (this._nblocks == this._blocks.length) {
            OneDSparseArrayBlock[] tmpblocks = new OneDSparseArrayBlock[this._nblocks * 2];
            System.arraycopy(this._blocks, 0, tmpblocks, 0, this._nblocks);
            this._blocks = tmpblocks;
        }
        System.arraycopy(this._blocks, blockIndex, this._blocks, blockIndex + 1, this._nblocks - blockIndex);
        this._blocks[blockIndex + 1] = newBlock;
        ++this._nblocks;
    }

    public void dump() {
        System.out.println("# runs: " + this._nblocks);
        for (int i = 0; i < this._nblocks; ++i) {
            System.out.println("Start/Length" + this._blocks[i].getStartIndex() + " " + this._blocks[i].getLength());
        }
    }
}

