/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.drawer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.drawer.DrawerPopup;
import oracle.bali.ewt.elaf.EWTDrawerUI;
import oracle.bali.ewt.elaf.EWTLookAndFeel;

public class Drawer
extends JButton
implements SwingConstants {
    private Closer _closer;
    private Component _content;
    private DrawerPopup _popup;
    private JLayeredPane _owner;
    private int _orientation;
    private transient ComponentUI ui2;
    private static boolean _sInstalled = false;

    public Drawer() {
        this((Component)null, (Icon)null);
    }

    public Drawer(Component content) {
        this(content, null);
    }

    public Drawer(Icon icon) {
        this((Component)null, icon);
    }

    public Drawer(Component content, Icon icon) {
        super(icon);
        if (!_sInstalled) {
            _sInstalled = true;
            try {
                EWTLookAndFeel.installEWTLookAndFeel();
            }
            catch (Exception e) {
                System.err.println("Could not install EWT look-and-feel:");
                e.printStackTrace();
            }
        }
        this.setRequestFocusEnabled(false);
        this.setModel(new Model());
        this._content = content;
        this._orientation = 4;
        this._popup = new DrawerPopup(this);
        this._popup.setContent(content);
        this.updateUI();
    }

    public Component getContent() {
        return this._content;
    }

    public void setContent(Component content) {
        if (this.isOpen()) {
            throw new IllegalStateException("Drawer is open");
        }
        Component oldContent = this._content;
        if (oldContent != content) {
            this._popup.setContent(content);
        }
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation < 1 || orientation > 4) {
            throw new IllegalArgumentException();
        }
        int oldOrientation = this._orientation;
        if (oldOrientation != orientation) {
            this._orientation = orientation;
            this.revalidate();
            Border oldBorder = this.getBorder();
            if (oldBorder == null || oldBorder instanceof UIResource) {
                this.setBorder(this.getEWTDrawerUI().getBorder(this));
            }
            this.firePropertyChange("orientation", oldOrientation, orientation);
        }
    }

    public boolean isOpen() {
        return this._owner != null;
    }

    public final void setOpen(boolean open) {
        if (open) {
            this.openPopup();
        } else {
            this.closePopup();
        }
    }

    public void openPopup() {
        if (this._owner != null) {
            return;
        }
        DrawerPopup popup = this._popup;
        if (popup == null) {
            return;
        }
        this._addOrRemoveListeners(true);
        Dimension popupSize = this._getPopupSize();
        int orientation = this.getOrientation();
        boolean popupPos = false;
        int popUpOverlap = this.getEWTDrawerUI().getPopUpOverlap(this);
        int perpInsets = this.getEWTDrawerUI().getPerpendicularInsets(this);
        int x = this.getX();
        int y = this.getY();
        JLayeredPane layered = null;
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (c instanceof JRootPane) {
                if (c.getParent() instanceof JInternalFrame) continue;
                layered = ((JRootPane)c).getLayeredPane();
                break;
            }
            Point p = c.getLocation();
            x += p.x;
            y += p.y;
        }
        if (layered == null) {
            throw new IllegalStateException("No root pane");
        }
        int width = 0;
        int height = 0;
        if (this._isHorizontal()) {
            y += perpInsets;
            height = this.getHeight() - 2 * perpInsets;
            if (orientation == 4) {
                int drawerWidth = this.getWidth();
                width = Math.min(popupSize.width, layered.getWidth() - (drawerWidth + x));
                x = x + drawerWidth - popUpOverlap;
            } else {
                width = Math.min(popupSize.width, x);
                x = x - width + popUpOverlap;
            }
        } else {
            x += perpInsets;
            width = this.getWidth() - 2 * perpInsets;
            if (orientation == 1) {
                height = Math.min(popupSize.height, y);
                y = y - height + popUpOverlap;
            } else {
                int drawerHeight = this.getHeight();
                height = Math.min(popupSize.height, layered.getHeight() - (drawerHeight + y));
                y = y + drawerHeight - popUpOverlap;
            }
        }
        popup.setVisible(false);
        popup.setBounds(x, y, width, height);
        layered.add(popup, JLayeredPane.POPUP_LAYER, 0);
        popup.setVisible(true);
        this._owner = layered;
        popup.open();
    }

    public void closePopup() {
        DrawerPopup popup = this._popup;
        if (popup != null) {
            popup.close();
            this.popupClosed();
        }
    }

    public void closePopupLater() {
        DrawerPopup popup = this._popup;
        if (popup != null) {
            popup.closeLater();
        }
    }

    @Override
    public void updateUI() {
        if (this._orientation == 0) {
            return;
        }
        if (this.ui2 != null) {
            this.ui2.uninstallUI(this);
        }
        Object oldValue = UIManager.get("Button.textShiftOffset");
        Object newValue = UIManager.get("EWTDrawer.textShiftOffset");
        if (newValue != null) {
            UIManager.put("Button.textShiftOffset", newValue);
        }
        this.setUI(UIManager.getUI(this));
        if (newValue != null) {
            UIManager.put("Button.textShiftOffset", oldValue);
        }
        this._setEWTDrawerUI2();
        DrawerPopup popup = this._popup;
        if (!this.isOpen() && popup != null) {
            popup.updateComponentTreeUI();
        }
    }

    @Override
    public String getUIClassID() {
        return "EWTDrawerUI";
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public Insets getInsets() {
        return this.getBorder().getBorderInsets(this);
    }

    @Override
    public Insets getInsets(Insets insets) {
        return this.getInsets();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Dimension popupSize = this._getPopupSize();
        int perpInsets = this.getEWTDrawerUI().getPerpendicularInsets(this) * 2;
        if (this._isHorizontal()) {
            if (size.height < popupSize.height + perpInsets) {
                size.height = popupSize.height + perpInsets;
            }
        } else if (size.width < popupSize.width + perpInsets) {
            size.width = popupSize.width + perpInsets;
        }
        return size;
    }

    @Override
    public void setBorder(Border border) {
        if (border == null && this.getParent() instanceof JToolBar) {
            border = this.getEWTDrawerUI().getBorder(this);
        }
        super.setBorder(border);
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        this.setOpen(!this.isOpen());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.closePopup();
    }

    protected final EWTDrawerUI getEWTDrawerUI() {
        ButtonUI ui = this.getUI();
        if (ui instanceof EWTDrawerUI) {
            return (EWTDrawerUI)((Object)ui);
        }
        if (this.ui2 != null && this.ui2 instanceof EWTDrawerUI) {
            return (EWTDrawerUI)((Object)this.ui2);
        }
        return null;
    }

    final void popupClosed() {
        this._addOrRemoveListeners(false);
        JLayeredPane owner = this._owner;
        if (owner != null) {
            DrawerPopup popup = this._popup;
            if (popup == null) {
                return;
            }
            this._owner = null;
            owner.remove(popup);
            owner.repaint(popup.getX(), popup.getY(), popup.getWidth(), popup.getHeight());
        }
    }

    private void _setEWTDrawerUI2() {
        Class<? extends ComponentUI> uiClass = UIManager.getDefaults().getUIClass("EWTDrawerUI2");
        Object uiObject = null;
        if (uiClass != null) {
            try {
                Method m = (Method)UIManager.getDefaults().get(uiClass);
                if (m == null) {
                    m = uiClass.getMethod("createUI", JComponent.class);
                    UIManager.getDefaults().put(uiClass, m);
                }
                uiObject = m.invoke(null, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ui2 = (ComponentUI)uiObject;
        if (uiObject != null) {
            ((ComponentUI)uiObject).installUI(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addOrRemoveListeners(boolean add) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Closer closer = this._getCloser();
            for (Container c = this; c != null; c = c.getParent()) {
                if (add) {
                    c.addComponentListener(closer);
                } else {
                    c.removeComponentListener(closer);
                }
                if (!(c instanceof Window)) continue;
                if (add) {
                    ((Window)c).addWindowListener(closer);
                    break;
                }
                ((Window)c).removeWindowListener(closer);
                break;
            }
        }
    }

    private boolean _isHorizontal() {
        int orientation = this.getOrientation();
        return orientation == 2 || orientation == 4;
    }

    private Dimension _getPopupSize() {
        DrawerPopup popup = this._popup;
        popup.setFont(this.getFont());
        popup.setLocale(this.getLocale());
        return popup.getPreferredSize();
    }

    private Closer _getCloser() {
        if (this._closer == null) {
            this._closer = new Closer();
        }
        return this._closer;
    }

    private class Closer
    extends WindowAdapter
    implements ComponentListener {
        private Closer() {
        }

        @Override
        public void windowIconified(WindowEvent e) {
            Drawer.this.closePopup();
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            Drawer.this.closePopup();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            Drawer.this.closePopup();
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Drawer.this.closePopup();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            Drawer.this.closePopup();
        }
    }

    private class Model
    extends DefaultButtonModel {
        private Model() {
        }

        @Override
        public boolean isRollover() {
            return super.isRollover() || Drawer.this.isOpen();
        }
    }
}

