/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.basic;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;

public class DrawerBorderPainter
extends AbstractBorderPainter {
    private static final ImmInsets[] _BORDER_INSETS = new ImmInsets[]{new ImmInsets(1, 0, 1, 1), new ImmInsets(1, 1, 0, 1), new ImmInsets(0, 1, 1, 1), new ImmInsets(1, 1, 1, 0)};
    private static Border[] _sInstances = new Border[4];
    private int _orientation;

    public static Border getDrawerBorder(int orientation) {
        Border border = _sInstances[orientation - 1];
        if (border == null) {
            DrawerBorderPainter painter = new DrawerBorderPainter(orientation);
            BorderAdapter borderAdapter = new BorderAdapter(painter);
            DrawerBorderPainter._sInstances[orientation - 1] = borderAdapter;
            border = borderAdapter;
        }
        return border;
    }

    private DrawerBorderPainter(int orientation) {
        super(new FixedBorderPainter(1, 1, 1, 1));
        this._orientation = orientation;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        return _BORDER_INSETS[this._orientation - 1];
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        int bottom = y + height - 1;
        int right = x + width - 1;
        UIDefaults defaults = context.getPaintUIDefaults();
        Color dkShadow = defaults.getColor("controlDkShadow");
        switch (this._orientation) {
            case 1: {
                g.setColor(Color.white);
                g.drawLine(x, y + 1, x, bottom);
                g.drawLine(x + 1, y, right - 1, y);
                g.setColor(dkShadow);
                g.drawLine(right, y + 1, right, bottom);
                break;
            }
            case 3: {
                g.setColor(Color.white);
                g.drawLine(x, y, x, bottom - 1);
                g.setColor(dkShadow);
                g.drawLine(x + 1, bottom, right - 1, bottom);
                g.drawLine(right, y, right, bottom - 1);
                break;
            }
            case 2: {
                g.setColor(Color.white);
                g.drawLine(x + 1, y, right, y);
                g.drawLine(x, y + 1, x, bottom - 1);
                g.setColor(dkShadow);
                g.drawLine(x + 1, bottom, right, bottom);
                break;
            }
            case 4: {
                g.setColor(Color.white);
                g.drawLine(x, y, right - 1, y);
                g.setColor(dkShadow);
                g.drawLine(x, bottom, right - 1, bottom);
                g.drawLine(right, y + 1, right, bottom - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        g.setColor(savedColor);
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }
}

