/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Image;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.elaf.EWTPivotHeaderUI;
import oracle.bali.ewt.elaf.basic.BasicTableGeometryHelper;
import oracle.bali.ewt.elaf.basic.PivotHeaderGrippyPainter;
import oracle.bali.ewt.elaf.basic.PivotHeaderGrippyPainterWithBorder;
import oracle.bali.ewt.elaf.oracle.OracleEWTTableUI;
import oracle.bali.ewt.elaf.oracle.OraclePivotCellBorderPainter;
import oracle.bali.ewt.elaf.oracle.OracleUIUtils;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;

public class OracleEWTPivotHeaderUI
extends EWTPivotHeaderUI {
    private static OracleEWTPivotHeaderUI _sInstance;
    private static OracleEWTTableUI _sTableUI;

    private OracleEWTPivotHeaderUI() {
    }

    public static ComponentUI createUI(JComponent component) {
        if (_sInstance == null) {
            _sInstance = new OracleEWTPivotHeaderUI();
            _sTableUI = (OracleEWTTableUI)OracleEWTTableUI.createUI(component);
        }
        return _sInstance;
    }

    @Override
    public void installUI(JComponent component) {
        boolean horizontal;
        _sTableUI.installUI(component);
        component.setOpaque(true);
        SpreadTable table = (SpreadTable)component;
        table.getGrid().setBackground(UIManager.getColor(LookAndFeel.CONTROL));
        table.setBorder(null);
        Grid grid = table.getGrid();
        grid.setBorder(null);
        grid.setUpperLeft(false);
        grid.setLowerRight(false);
        boolean bl = horizontal = ((PivotHeader)component).getOrientation() == 0;
        if (horizontal) {
            grid.setLowerLeft(false);
        } else {
            grid.setUpperRight(false);
        }
        grid.setOverlayBorderVisible(false);
        Header h = table.getRowHeader();
        if (h != null) {
            h.setLastEdge(false);
            h.setBorder(null);
            h.setDefaultPainter(this.getDefaultHeaderItemPainter(component, !horizontal));
        }
        if ((h = table.getColumnHeader()) != null) {
            h.setLastEdge(false);
            h.setBorder(null);
            h.setDefaultPainter(this.getDefaultHeaderItemPainter(component, !horizontal));
        }
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if ("PivotHeader.DefaultAppearance".equals(key)) {
            return OracleEWTPivotHeaderUI._getDefaultAppearance();
        }
        return null;
    }

    @Override
    public Painter getDefaultHeaderItemPainter(JComponent component, boolean horizontal) {
        return PivotHeaderGrippyPainter.getPainter(horizontal, false);
    }

    @Override
    public Painter getDefaultHeaderItemPainterWithBorder(JComponent component) {
        return PivotHeaderGrippyPainterWithBorder.getPainter(false);
    }

    @Override
    public Painter getCornerPainter(JComponent component, int which) {
        return _sTableUI.getCornerPainter(component, which);
    }

    @Override
    public Image getDrillImage(JComponent component) {
        return OracleUIUtils.getImage("drillTriangle.gif");
    }

    @Override
    public Image getDrilledImage(JComponent component) {
        return OracleUIUtils.getImage("drilledTriangle.gif");
    }

    @Override
    public Color getSwapForegroundColor(JComponent component, Appearance normAppear) {
        return UIManager.getColor("darkIntensity");
    }

    @Override
    public Color getSwapBackgroundColor(JComponent component, Appearance normAppear) {
        Color background = normAppear.getBackground();
        if (background == null) {
            background = component.getBackground();
        }
        return ColorUtils.darkerShadeColor(background);
    }

    @Override
    public void updateGeometry(JComponent component) {
        BasicTableGeometryHelper.updateGeometry((SpreadTable)component);
    }

    private static Appearance _getDefaultAppearance() {
        Appearance a = (Appearance)UIManager.get("Grid.DefaultAppearance");
        a = a.copy();
        a.setInsets(ImmInsets.getEmptyInsets());
        a.setForeground(UIManager.getColor(LookAndFeel.CONTROL_TEXT));
        a.setBackground(UIManager.getColor(LookAndFeel.CONTROL));
        a.setBorderPainter(OraclePivotCellBorderPainter.getBorderPainter());
        return a;
    }
}

