/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle2;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.print.PrinterGraphics;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class PivotHeaderGrippyPainter
extends AbstractPainter {
    private static final int _GRIPPY_SIZE = 6;
    private static final int _GRIPPY_GAP = -2;
    private static final int _GRIPPY_STRIDE = 4;
    private static final int _MIN_GRIPPIES = 3;
    private static final int _MIN_PERP_GRIPPY_SIZE = 10;
    private static final int _MIN_ORIENT_GRIPPY_SIZE = 14;
    private boolean _isHorizontal;
    private static Painter _sVerticalPainter;
    private static Painter _sHorizontalPainter;

    public static Painter getPainter(boolean horizontal) {
        if (horizontal) {
            if (_sHorizontalPainter == null) {
                _sHorizontalPainter = new PivotHeaderGrippyPainter(true);
            }
            return _sHorizontalPainter;
        }
        if (_sVerticalPainter == null) {
            _sVerticalPainter = new PivotHeaderGrippyPainter(false);
        }
        return _sVerticalPainter;
    }

    @Override
    public Dimension getSize(PaintContext context, int width, int height) {
        if (this._isHorizontal) {
            if (width > 14) {
                width = 14;
            }
            if (height > 10) {
                height = 10;
            }
        } else {
            if (width > 10) {
                width = 10;
            }
            if (height > 14) {
                height = 14;
            }
        }
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        if (this._isHorizontal) {
            return new Dimension(14, 10);
        }
        return new Dimension(10, 14);
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return 131;
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        boolean paint;
        int state;
        boolean printing;
        Color savedColor = g.getColor();
        boolean bl = printing = g instanceof PrintGraphics || g instanceof PrinterGraphics;
        if (!printing) {
            Color grippyColor = UIManager.getColor("EWTPivotPivotGrippy.background");
            g.setColor(grippyColor);
            g.fillRect(x, y, width, height);
        }
        boolean enabled = ((state = context.getPaintState()) & 1) == 0;
        boolean bl2 = paint = printing ? false : enabled;
        if (paint) {
            boolean isArmed;
            int numGrippies = 3;
            if (this._isHorizontal) {
                numGrippies = 8;
            }
            int grippySize = numGrippies * 6 + (numGrippies - 1) * -2;
            int grippyWidth = 6;
            int grippyHeight = 6;
            int xOffset = 0;
            int yOffset = 0;
            if (this._isHorizontal) {
                grippyWidth = grippySize;
                xOffset = 4;
            } else {
                grippyHeight = grippySize;
                yOffset = 4;
            }
            int grippyX = x + (width - grippyWidth) / 2;
            int grippyY = y + (height - grippyHeight) / 2;
            int topRightCornerX = grippyX + grippyWidth - 2;
            int topRightCornerY = grippyY;
            int bottomLeftCornerX = grippyX;
            int bottomLeftCornerY = grippyY + grippyHeight - 2;
            int numTopRightCornerDots = 2;
            int numBottomLeftCornerDots = 2;
            UIDefaults defaults = context.getPaintUIDefaults();
            Color highlight = Color.white;
            Color dark = defaults.getColor("PivotTable.darkGrippy");
            boolean bl3 = isArmed = (state & 2) != 0;
            while (numGrippies > 0) {
                PivotHeaderGrippyPainter.__drawGrippys(g, grippyX, grippyY, 6, highlight, dark, isArmed);
                --numGrippies;
                grippyX += xOffset;
                grippyY += yOffset;
            }
            PivotHeaderGrippyPainter.__drawGrippys(g, topRightCornerX, topRightCornerY, numTopRightCornerDots, highlight, dark, isArmed);
            PivotHeaderGrippyPainter.__drawGrippys(g, bottomLeftCornerX, bottomLeftCornerY, numBottomLeftCornerDots, highlight, dark, isArmed);
        }
        g.setColor(savedColor);
    }

    static void __drawGrippys(Graphics g, int x, int y, int length, Color highlight, Color dark, boolean isArmed) {
        int darkDots = 0;
        darkDots = length % 2 == 0 ? length / 2 : (length + 1) / 2;
        int whiteDots = length - darkDots;
        if (isArmed) {
            int i;
            g.setColor(highlight);
            int tempX = x;
            int tempY = y;
            for (i = 0; i < darkDots; ++i) {
                g.drawLine(tempX, tempY, tempX, tempY);
                tempX += 2;
                tempY += 2;
            }
            g.setColor(dark);
            ++x;
            ++y;
            for (i = 0; i < whiteDots; ++i) {
                g.drawLine(x, y, x, y);
                x += 2;
                y += 2;
            }
        } else {
            int i;
            g.setColor(dark);
            int tempX = x;
            int tempY = y;
            for (i = 0; i < darkDots; ++i) {
                g.drawLine(tempX, tempY, tempX, tempY);
                tempX += 2;
                tempY += 2;
            }
            g.setColor(highlight);
            ++x;
            ++y;
            for (i = 0; i < whiteDots; ++i) {
                g.drawLine(x, y, x, y);
                x += 2;
                y += 2;
            }
        }
    }

    private PivotHeaderGrippyPainter(boolean isHorizontal) {
        this._isHorizontal = isHorizontal;
    }
}

