/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Image;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.elaf.EWTPivotHeaderUI;
import oracle.bali.ewt.elaf.basic.PivotHeaderGrippyPainter;
import oracle.bali.ewt.elaf.basic.PivotHeaderGrippyPainterWithBorder;
import oracle.bali.ewt.elaf.windows.WindowsEWTTableUI;
import oracle.bali.ewt.elaf.windows.WindowsPivotCellBorderPainter;
import oracle.bali.ewt.elaf.windows.WindowsPivotHeaderSeparator;
import oracle.bali.ewt.elaf.windows.WindowsTableGeometryHelper;
import oracle.bali.ewt.elaf.windows.WindowsUIUtils;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;

public class WindowsEWTPivotHeaderUI
extends EWTPivotHeaderUI {
    private static WindowsEWTPivotHeaderUI _sInstance;
    private static WindowsEWTTableUI _sTableUI;

    protected WindowsEWTPivotHeaderUI() {
    }

    public static ComponentUI createUI(JComponent component) {
        if (_sInstance == null) {
            _sInstance = new WindowsEWTPivotHeaderUI();
            _sTableUI = (WindowsEWTTableUI)WindowsEWTTableUI.createUI(component);
        }
        return _sInstance;
    }

    @Override
    public void installUI(JComponent component) {
        boolean horizontal;
        _sTableUI.installUI(component);
        PivotHeader table = (PivotHeader)component;
        table.setBorder(null);
        Grid grid = table.getGrid();
        grid.setBackground(UIManager.getColor(LookAndFeel.CONTROL));
        grid.setBorder(null);
        grid.setUpperLeft(false);
        grid.setLowerRight(false);
        boolean bl = horizontal = ((PivotHeader)component).getOrientation() == 0;
        if (horizontal) {
            grid.setLowerLeft(false);
        } else {
            grid.setUpperRight(false);
        }
        grid.setOverlayBorderVisible(false);
        Painter p = WindowsPivotHeaderSeparator.getHorizontalSeparator();
        table.setHorizontalSeparatorPainter(p);
        p = WindowsPivotHeaderSeparator.getVerticalSeparator();
        table.setVerticalSeparatorPainter(p);
        Header h = table.getRowHeader();
        if (h != null) {
            h.setBorder(null);
            h.setFirstEdge(true);
            h.setDefaultPainter(this.getDefaultHeaderItemPainter(component, !horizontal));
        }
        if ((h = table.getColumnHeader()) != null) {
            h.setBorder(null);
            h.setFirstEdge(true);
            h.setDefaultPainter(this.getDefaultHeaderItemPainter(component, !horizontal));
        }
    }

    @Override
    public Painter getCornerPainter(JComponent component, int which) {
        return _sTableUI.getCornerPainter(component, which);
    }

    @Override
    public Painter getDefaultHeaderItemPainter(JComponent component, boolean horizontal) {
        return PivotHeaderGrippyPainter.getPainter(horizontal, true);
    }

    @Override
    public Painter getDefaultHeaderItemPainterWithBorder(JComponent component) {
        return PivotHeaderGrippyPainterWithBorder.getPainter(true);
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if ("PivotHeader.DefaultAppearance".equals(key)) {
            return WindowsEWTPivotHeaderUI._getDefaultAppearance();
        }
        return null;
    }

    @Override
    public Image getDrillImage(JComponent component) {
        return WindowsUIUtils.getImage("drillTriangle.gif");
    }

    @Override
    public Image getDrilledImage(JComponent component) {
        return WindowsUIUtils.getImage("drilledTriangle.gif");
    }

    @Override
    public Color getSwapForegroundColor(JComponent component, Appearance normAppear) {
        Color fg = UIManager.getColor(LookAndFeel.DARK_INTENSITY);
        if (fg == null) {
            fg = ColorUtils.lighterShadeColor(UIManager.getColor(LookAndFeel.CONTROL_TEXT));
        }
        return fg;
    }

    @Override
    public Color getSwapBackgroundColor(JComponent component, Appearance normAppear) {
        Color background = normAppear.getBackground();
        if (background == null) {
            background = component.getBackground();
        }
        return ColorUtils.darkerShadeColor(background);
    }

    @Override
    public void updateGeometry(JComponent component) {
        WindowsTableGeometryHelper.updateGeometry((SpreadTable)component, WindowsPivotCellBorderPainter.getBorderPainter(false));
    }

    private static Appearance _getDefaultAppearance() {
        Appearance a = (Appearance)UIManager.get("Grid.DefaultAppearance");
        a = a.copy();
        a.setInsets(ImmInsets.getEmptyInsets());
        a.setForeground(UIManager.getColor(LookAndFeel.CONTROL_TEXT));
        a.setBackground(UIManager.getColor(LookAndFeel.CONTROL));
        boolean horizontal = false;
        BorderPainter p = WindowsPivotCellBorderPainter.getBorderPainter(horizontal);
        a.setBorderPainter(p);
        return a;
    }
}

