/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid.bigCell;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.TextFieldInputHandler;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;

public class BigCellInputHandler
extends CellInputHandler {
    private CellInputHandler _cellInputHandler;

    public BigCellInputHandler() {
        this(null);
    }

    public BigCellInputHandler(CellInputHandler toWrap) {
        this._cellInputHandler = toWrap;
    }

    public CellInputHandler getCellInputHandler() {
        if (this._cellInputHandler == null) {
            this._cellInputHandler = TextFieldInputHandler.getCellInputHandler();
        }
        return this._cellInputHandler;
    }

    public void setCellInputHandler(CellInputHandler toWrap) {
        this._cellInputHandler = toWrap;
    }

    @Override
    public void updateUI() {
        this.getCellInputHandler().updateUI();
    }

    @Override
    public boolean validateFocus(Grid grid, int column, int row) {
        return this.getCellInputHandler().validateFocus(grid, column, row);
    }

    @Override
    public void mousePressed(MouseEvent e, Grid grid, int column, int row) {
        this.getCellInputHandler().mousePressed(e, grid, column, row);
    }

    @Override
    public void mouseClicked(MouseEvent e, Grid grid, int column, int row) {
        this.getCellInputHandler().mouseClicked(e, grid, column, row);
    }

    @Override
    public void mouseReleased(MouseEvent e, Grid grid, int column, int row) {
        this.getCellInputHandler().mouseReleased(e, grid, column, row);
    }

    @Override
    public void mouseEntered(MouseEvent e, Grid grid, int column, int row) {
        this.getCellInputHandler().mouseEntered(e, grid, column, row);
    }

    @Override
    public void mouseExited(MouseEvent e, Grid grid, int column, int row) {
        this.getCellInputHandler().mouseExited(e, grid, column, row);
    }

    @Override
    public void mouseDragged(MouseEvent e, Grid grid, int column, int row) {
        this.getCellInputHandler().mouseDragged(e, grid, column, row);
    }

    @Override
    public void mouseMoved(MouseEvent e, Grid grid, int column, int row) {
        this.getCellInputHandler().mouseMoved(e, grid, column, row);
    }

    @Override
    public void keyPressed(KeyEvent e, Grid grid, int column, int row) {
        this.getCellInputHandler().keyPressed(e, grid, column, row);
    }

    @Override
    public void keyTyped(KeyEvent e, Grid grid, int column, int row) {
        this.getCellInputHandler().keyTyped(e, grid, column, row);
    }

    @Override
    public void keyReleased(KeyEvent e, Grid grid, int column, int row) {
        this.getCellInputHandler().keyReleased(e, grid, column, row);
    }

    @Override
    public void focusGained(AWTEvent why, Grid grid, int column, int row) {
        this.getCellInputHandler().focusGained(why, grid, column, row);
    }

    @Override
    public void focusLost(AWTEvent why, Grid grid, int column, int row) {
        this.getCellInputHandler().focusLost(why, grid, column, row);
    }

    @Override
    public Component getEditControl(Grid grid, int column, int row) {
        return this.getCellInputHandler().getEditControl(grid, column, row);
    }

    @Override
    public boolean isDirty(Grid grid, int column, int row) {
        return this.getCellInputHandler().isDirty(grid, column, row);
    }

    @Override
    public synchronized void startEdit(Grid grid, int column, int row, Object data) {
        AbstractBigCell bigCell = AbstractBigCell.getBigCell(grid, column, row);
        if (bigCell != null) {
            data = bigCell.getData();
            column = bigCell.getColumn();
            row = bigCell.getRow();
        }
        CellInputHandler toWrap = this.getCellInputHandler();
        toWrap.startEdit(grid, column, row, data);
    }

    @Override
    public synchronized Object commitEdit(Grid grid, int column, int row) {
        AbstractBigCell bigCell = AbstractBigCell.getBigCell(grid, column, row);
        if (bigCell != null) {
            column = bigCell.getColumn();
            row = bigCell.getRow();
        }
        CellInputHandler toWrap = this.getCellInputHandler();
        Object data = toWrap.commitEdit(grid, column, row);
        if (bigCell == null) {
            return data;
        }
        bigCell.setData(data);
        return bigCell;
    }

    @Override
    public void cancelEdit(Grid grid, int column, int row) {
        this.getCellInputHandler().cancelEdit(grid, column, row);
    }

    @Override
    public Rectangle getEditControlBounds(Grid grid, int column, int row) {
        Rectangle rect = AbstractBigCell.getCellBounds(grid, column, row);
        --rect.width;
        --rect.height;
        this._setBigCellFont(grid, column, row);
        return rect;
    }

    @Override
    public Component[] getFocusableComponents(Grid grid, int focusColumn, int focusRow) {
        return this.getCellInputHandler().getFocusableComponents(grid, focusColumn, focusRow);
    }

    private void _setBigCellFont(Grid grid, int column, int row) {
        AbstractBigCell bigCell = AbstractBigCell.getBigCell(grid, column, row);
        if (bigCell == null) {
            return;
        }
        AppearanceManager am = grid.getAppearanceManager();
        Appearance a = am.getCellPaintingAppearance(bigCell.getColumn(), bigCell.getRow());
        Component c = this.getEditControl(grid, column, row);
        Font f = a.getFont();
        if (f != null) {
            c.setFont(f);
        }
    }
}

