/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.table.SpreadTable;

final class PivotGridLayout
implements LayoutManager {
    Grid _grid;
    Header _rowHeader;
    Header _columnHeader;

    PivotGridLayout() {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (name.equals("grid")) {
            this._grid = (Grid)comp;
        } else if (name.equals("rowHeader")) {
            this._rowHeader = (Header)comp;
        } else if (name.equals("columnHeader")) {
            this._columnHeader = (Header)comp;
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp == this._grid) {
            this._grid = null;
        } else if (comp == this._rowHeader) {
            this._rowHeader = null;
        } else if (comp == this._columnHeader) {
            this._columnHeader = null;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return ((SpreadTable)parent).getPreferredSize();
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        SpreadTable table = (SpreadTable)parent;
        Dimension d = table.getSize();
        if (d.width == 0 || d.height == 0) {
            return;
        }
        int rowWidth = table.getRowHeaderWidth();
        int columnHeight = table.getColumnHeaderHeight();
        Point origin = table.getInnerOrigin();
        int gridX = origin.x;
        int gridY = origin.y;
        if (table.isRowHeaderVisible() && this._rowHeader != null) {
            this._rowHeader.setVisible(true);
            int rowX = origin.x;
            this._rowHeader.setBounds(rowX, columnHeight + origin.y, rowWidth, d.height - columnHeight);
        } else if (this._rowHeader != null) {
            this._rowHeader.setVisible(false);
        }
        if (table.isColumnHeaderVisible() && this._columnHeader != null) {
            this._columnHeader.setVisible(true);
            int columnX = rowWidth + origin.x;
            this._columnHeader.setBounds(columnX, origin.y, d.width - rowWidth, columnHeight);
        } else if (this._columnHeader != null) {
            this._columnHeader.setVisible(false);
        }
        int gridWidth = d.width - (gridX += rowWidth) + 1;
        this._grid.setBounds(gridX, gridY += columnHeight, gridWidth, d.height - gridY + 1);
        if (table.isColumnHeaderVisible() && table.isRowHeaderVisible()) {
            Component corner = table.getCornerComponent("UPPER_LEFT_CORNER");
            if (corner != null) {
                corner.setBounds(origin.x, origin.y, rowWidth, columnHeight);
            }
            if (corner != null) {
                corner.setVisible(true);
            }
        }
    }
}

