/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.spinBox;

import oracle.bali.ewt.spinBox.NumericSpinBoxModel;
import oracle.bali.ewt.spinBox.SpinBoxModel;
import oracle.bali.ewt.spinBox.WrappingNumericSpinBoxModel;
import oracle.bali.share.collection.Range;

public class ArraySpinBoxModel
implements SpinBoxModel {
    private Object[] _array;
    private NumericSpinBoxModel _numeric;
    private boolean _wrap;

    public ArraySpinBoxModel(Object[] array, boolean wrap) {
        this._array = array;
        this._wrap = wrap;
        Range range = new Range(0, array.length - 1);
        this._numeric = wrap ? new WrappingNumericSpinBoxModel(range) : new NumericSpinBoxModel(range);
    }

    public Object[] getArray() {
        return this._array;
    }

    public boolean isWrapping() {
        return this._wrap;
    }

    public void setIndex(int index) {
        if (index < 0 || index >= this._array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._numeric.setValue(index);
    }

    public int getIndex() {
        return this._numeric.getValue();
    }

    public Object nextElement() {
        return this._array[(Integer)this._numeric.nextElement()];
    }

    @Override
    public void setIteratingForward(boolean forward) {
        this._numeric.setIteratingForward(forward);
    }

    @Override
    public boolean isIteratingForward() {
        return this._numeric.isIteratingForward();
    }

    @Override
    public boolean hasMoreElements() {
        return this._numeric.hasMoreElements();
    }

    @Override
    public Object skip(int count) {
        return this._array[(Integer)this._numeric.skip(count)];
    }

    @Override
    public int remainingElements(int desired) {
        return this._numeric.remainingElements(desired);
    }
}

