/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.table;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.elaf.EWTTableUI;
import oracle.bali.ewt.geometry.GeometryManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.ewt.scrolling.EWTScrollPane;
import oracle.bali.ewt.scrolling.ScrollableComponent;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.DummyPanel;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableGridAdapter;
import oracle.bali.ewt.table.TableGridGeometryManager;
import oracle.bali.ewt.table.TableHeaderAdapter;
import oracle.bali.ewt.table.TableHeaderGeometryManager;
import oracle.bali.ewt.table.TableLayoutManager;
import oracle.bali.ewt.table.TableMoveListener;
import oracle.bali.ewt.table.TableResizeListener;
import oracle.bali.ewt.table.TableValidateEvent;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.LocaleUtils;

public class SpreadTable
extends ScrollableComponent
implements Accessible {
    public static final Object DUPLICATE_COLUMN_HEADERS = "table.dupColHeaders";
    public static final Object DUPLICATE_ROW_HEADERS = "table.dupRowHeaders";
    public static final Object DISPLAY_COLUMN_HEADERS = "table.dispColHeaders";
    public static final Object DISPLAY_ROW_HEADERS = "table.dispRowHeaders";
    public static final Object PRINT_RAISED = "spreadTable.printRaised";
    public static final String KEY_CORNER_BORDER_COLOR = "table.cornerBorderColor";
    public static final String PROPERTY_FOCUSCELL = "focusCell";
    public static final String PROPERTY_GLOBAL_FOCUS_CELL = "globalFocusCell";
    public static final String PROPERTY_SELECTION = "selection";
    static final String _RESOURCE_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    static final String _SELECT_ALL_KEY = "SELECT_ALL";
    private Header _columnHeader;
    private Header _rowHeader;
    private Component[] _corners = new Component[4];
    private Grid _grid;
    private boolean _displayRowHeader = true;
    private boolean _displayColumnHeader = true;
    private boolean _emptyColumnHeader = true;
    private boolean _emptyRowHeader = true;
    private int _columnHeaderHeight = -1;
    private int _rowHeaderWidth = -1;
    private boolean _columnHeaderHeightSet;
    private boolean _rowHeaderWidthSet;
    private ListenerManager _cellSelectListeners;
    private ListenerManager _colSelectListeners;
    private ListenerManager _rowSelectListeners;
    private ListenerManager _focusListeners;
    private ListenerManager _editListeners;
    private ListenerManager _resizeListeners;
    private ListenerManager _moveListeners;
    private ContainerListener _containerListener;
    private ChangeListener _hHeaderListener;
    private ChangeListener _vHeaderListener;
    private ChangeListener _editListener;
    private JScrollPane _scrollPane;
    private boolean _drawRaised = true;
    private boolean _defaultRowHeightSet;
    private boolean _defaultColWidthSet;
    private TableHeaderAdapter _columnHeaderAdapter;
    private TableHeaderAdapter _rowHeaderAdapter;
    private TableGridAdapter _gridAdapter;
    private static String[] _scrollPaneKeys = new String[]{"LOWER_LEFT_CORNER", "LOWER_RIGHT_CORNER", "UPPER_LEFT_CORNER", "UPPER_RIGHT_CORNER"};
    private Cell _globalFocusCell;
    private Component _globalFocusCellComponent;
    private boolean _alwaysDrawFocusCellHighlite;
    private GlobalFocusCellListener _globalFocusCellListener;
    private Color _cornerBorderColor;
    private boolean _isAutoResize;

    public SpreadTable() {
        this(null, null, null);
    }

    public SpreadTable(TwoDModel gridModel, OneDModel columnHeaderModel, OneDModel rowHeaderModel) {
        TableHeaderGeometryManager tgm;
        GeometryManager gm;
        super.setLayout(this.createLayoutManager());
        this._grid = this.createGrid(gridModel);
        this._grid.setColumnGeometryManager(new TableGridGeometryManager(this._grid.getColumnGeometryManager()));
        this._grid.setRowGeometryManager(new TableGridGeometryManager(this._grid.getRowGeometryManager()));
        if (columnHeaderModel == null) {
            this._emptyColumnHeader = true;
        } else {
            this._columnHeader = this.createColumnHeader(columnHeaderModel);
            gm = this._grid.getColumnGeometryManager();
            tgm = new TableHeaderGeometryManager(gm);
            this._columnHeader.setGeometryManager(tgm);
            this._columnHeaderAdapter = new TableHeaderAdapter(this, this._columnHeader);
            this._columnHeader.addResizeListener(this._columnHeaderAdapter);
            this._columnHeader.addMoveListener(this._columnHeaderAdapter);
            this._columnHeader.addPropertyChangeListener(this._columnHeaderAdapter);
            this._emptyColumnHeader = false;
            this.add("columnHeader", this._columnHeader);
        }
        if (rowHeaderModel == null) {
            this._emptyRowHeader = true;
        } else {
            this._rowHeader = this.createRowHeader(rowHeaderModel);
            gm = this._grid.getRowGeometryManager();
            tgm = new TableHeaderGeometryManager(gm);
            this._rowHeader.setGeometryManager(tgm);
            this._rowHeaderAdapter = new TableHeaderAdapter(this, this._rowHeader);
            this._rowHeader.addResizeListener(this._rowHeaderAdapter);
            this._rowHeader.addMoveListener(this._rowHeaderAdapter);
            this._rowHeader.addPropertyChangeListener(this._rowHeaderAdapter);
            this._emptyRowHeader = false;
            this.add("rowHeader", this._rowHeader);
        }
        this._gridAdapter = new TableGridAdapter(this);
        this._grid.addPropertyChangeListener(this._gridAdapter);
        this._grid.addVetoableChangeListener(this._gridAdapter);
        this._grid.addEditListener(this._gridAdapter);
        this._grid.setDrawFocusCellHighlite(true);
        this.add("grid", this._grid);
        this._editListener = new EditListener();
        long mask = 20L;
        this.enableEvents(mask);
        this.updateUI();
    }

    public void dispose() {
        if (this._grid == null) {
            return;
        }
        if (this._columnHeaderAdapter != null) {
            this._columnHeader.removeResizeListener(this._columnHeaderAdapter);
            this._columnHeader.removeMoveListener(this._columnHeaderAdapter);
            this._columnHeader.removePropertyChangeListener(this._columnHeaderAdapter);
            this._columnHeaderAdapter.dispose();
        }
        if (this._rowHeaderAdapter != null) {
            this._rowHeader.removeResizeListener(this._rowHeaderAdapter);
            this._rowHeader.removeMoveListener(this._rowHeaderAdapter);
            this._rowHeader.removePropertyChangeListener(this._rowHeaderAdapter);
            this._rowHeaderAdapter.dispose();
        }
        if (this._globalFocusCellListener != null) {
            this._grid.removeFocusListener(this._globalFocusCellListener);
            this._grid.removePropertyChangeListener(this._globalFocusCellListener);
            if (this._rowHeader != null) {
                this._rowHeader.removeFocusListener(this._globalFocusCellListener);
                this._rowHeader.removePropertyChangeListener(this._globalFocusCellListener);
            }
            if (this._columnHeader != null) {
                this._columnHeader.removeFocusListener(this._globalFocusCellListener);
                this._columnHeader.removePropertyChangeListener(this._globalFocusCellListener);
            }
        }
        this._grid.removePropertyChangeListener(this._gridAdapter);
        this._grid.removeVetoableChangeListener(this._gridAdapter);
        this._grid.removeEditListener(this._gridAdapter);
        this._gridAdapter.dispose();
        this._columnHeaderAdapter = null;
        this._rowHeaderAdapter = null;
        this._gridAdapter = null;
        this._cellSelectListeners = null;
        this._colSelectListeners = null;
        this._rowSelectListeners = null;
        this._focusListeners = null;
        this._editListeners = null;
        this._resizeListeners = null;
        this._moveListeners = null;
        this._globalFocusCellListener = null;
        this._grid.dispose();
        this._grid = null;
        if (this._columnHeader != null) {
            this._columnHeader.dispose();
        }
        this._columnHeader = null;
        if (this._rowHeader != null) {
            this._rowHeader.dispose();
        }
        this._rowHeader = null;
        for (int i = 0; i < this._corners.length; ++i) {
            this._corners[i] = null;
        }
        this._clearScrollPane();
        this.removeAll();
        this.setLayout(null);
        this.setUI(null);
    }

    public void setFocusCell(Cell cell) {
        this.getGrid().setFocusCell(cell);
    }

    public Cell getFocusCell() {
        return this.getGrid().getFocusCell();
    }

    public void setSelection(TwoDSelection selection) throws PropertyVetoException {
        this.getGrid().setSelection(selection);
    }

    public TwoDSelection getSelection() {
        return this.getGrid().getSelection();
    }

    public void selectAll() throws PropertyVetoException {
        this.getGrid().selectAll();
    }

    public void deselectAll() throws PropertyVetoException {
        this.getGrid().deselectAll();
    }

    public void setDrawRaised(boolean drawRaised) {
        if (this._drawRaised != drawRaised) {
            this._drawRaised = drawRaised;
            if (this._scrollPane != null) {
                this._scrollPane.repaint();
            } else {
                this.repaint();
            }
        }
    }

    public boolean getDrawRaised() {
        return this._drawRaised;
    }

    public void setColumnGeometryManager(GeometryManager geometryManager) {
        Grid g = this.getGrid();
        g.setColumnGeometryManager(new TableGridGeometryManager(geometryManager));
        Header h = this.getColumnHeader();
        if (h != null) {
            h.setGeometryManager(new TableHeaderGeometryManager(g.getColumnGeometryManager()));
        }
    }

    public GeometryManager getColumnGeometryManager() {
        GeometryManager gm = this.getGrid().getColumnGeometryManager();
        if (gm instanceof TableGridGeometryManager) {
            return ((TableGridGeometryManager)gm).getWrappedGeometryManager();
        }
        return gm;
    }

    public void setRowGeometryManager(GeometryManager geometryManager) {
        Grid g = this.getGrid();
        g.setRowGeometryManager(new TableGridGeometryManager(geometryManager));
        Header h = this.getRowHeader();
        if (h != null) {
            h.setGeometryManager(new TableHeaderGeometryManager(g.getRowGeometryManager()));
        }
    }

    public GeometryManager getRowGeometryManager() {
        GeometryManager gm = this.getGrid().getRowGeometryManager();
        if (gm instanceof TableGridGeometryManager) {
            return ((TableGridGeometryManager)gm).getWrappedGeometryManager();
        }
        return gm;
    }

    @Override
    public void updateUI() {
        Header rowHeader;
        this.setUI((EWTTableUI)UIManager.getUI(this));
        Header columnHeader = this.getColumnHeader();
        if (columnHeader != null && this._scrollPane != null && !this.isColumnHeaderVisible()) {
            ((JComponent)columnHeader).updateUI();
        }
        if ((rowHeader = this.getRowHeader()) != null && this._scrollPane != null && !this.isRowHeaderVisible()) {
            ((JComponent)rowHeader).updateUI();
        }
        this.updateLayout();
        this._updateHeaderSize();
    }

    @Override
    public String getUIClassID() {
        return "EWTTableUI";
    }

    public synchronized void addEditListener(TableEditListener listener) {
        if (this._editListeners == null) {
            this._editListeners = new ListenerManager();
        }
        this._editListeners.addListener((EventListener)listener);
    }

    public synchronized void removeEditListener(TableEditListener listener) {
        if (this._editListeners != null) {
            this._editListeners.removeListener((EventListener)listener);
        }
    }

    public synchronized void addResizeListener(TableResizeListener listener) {
        if (this._resizeListeners == null) {
            this._resizeListeners = new ListenerManager();
        }
        this._resizeListeners.addListener((EventListener)listener);
    }

    public synchronized void removeResizeListener(TableResizeListener listener) {
        if (this._resizeListeners != null) {
            this._resizeListeners.removeListener((EventListener)listener);
        }
    }

    public synchronized void addMoveListener(TableMoveListener listener) {
        if (this._moveListeners == null) {
            this._moveListeners = new ListenerManager();
        }
        this._moveListeners.addListener((EventListener)listener);
    }

    public synchronized void removeMoveListener(TableMoveListener listener) {
        if (this._moveListeners != null) {
            this._moveListeners.removeListener((EventListener)listener);
        }
    }

    public int getOnScreenRowCount() {
        return this._grid.getOnScreenRowCount();
    }

    public int getOnScreenColumnCount() {
        return this._grid.getOnScreenColumnCount();
    }

    public int getFirstRowOnScreen() {
        return this._grid.getFirstRowOnScreen();
    }

    public void setFirstRowOnScreen(int index) {
        this._grid.setFirstRowOnScreen(index);
        if (this.isRowHeaderVisible()) {
            this._rowHeader.setFirstItemOnScreen(index);
        }
        if (this._scrollPane != null) {
            int innerHeight;
            int origin = this.getGrid().getRowPosition(index);
            int totalHeight = this.getRowGeometryManager().getTotalSize();
            if (totalHeight - origin < (innerHeight = this.getGrid().getInnerHeight())) {
                origin = totalHeight - innerHeight;
            }
            if (origin < 0) {
                origin = 0;
            }
            JViewport view = this._scrollPane.getViewport();
            Point p = view.getViewPosition();
            p.y = origin;
            view.setViewPosition(p);
            view = this._scrollPane.getRowHeader();
            if (view != null) {
                p = view.getViewPosition();
                p.y = origin;
                view.setViewPosition(p);
            }
        }
    }

    public int getFirstColumnOnScreen() {
        return this._grid.getFirstColumnOnScreen();
    }

    public void setFirstColumnOnScreen(int index) {
        this._grid.setFirstColumnOnScreen(index);
        if (this.isColumnHeaderVisible()) {
            this._columnHeader.setFirstItemOnScreen(index);
        }
        if (this._scrollPane != null) {
            int innerWidth;
            int origin = this.getGrid().getColumnPosition(index);
            int totalWidth = this.getColumnGeometryManager().getTotalSize();
            if (totalWidth - origin < (innerWidth = this.getGrid().getInnerWidth())) {
                origin = totalWidth - innerWidth;
            }
            if (origin < 0) {
                origin = 0;
            }
            JViewport view = this._scrollPane.getViewport();
            Point p = view.getViewPosition();
            p.x = origin;
            view.setViewPosition(p);
            view = this._scrollPane.getColumnHeader();
            if (view != null) {
                p = view.getViewPosition();
                p.x = origin;
                view.setViewPosition(p);
            }
        }
    }

    public Grid getGrid() {
        return this._grid;
    }

    public void setRowHeaderVisible(boolean visible) {
        if (visible && this._rowHeader == null) {
            throw new IllegalStateException("rowHeader does not have a OneDModel.");
        }
        boolean oldVisible = this.isRowHeaderVisible();
        this._displayRowHeader = visible;
        if (oldVisible != visible) {
            this.updateLayout();
            this.revalidate();
        }
    }

    public boolean isRowHeaderVisible() {
        return this._displayRowHeader && !this._emptyRowHeader;
    }

    public void setColumnHeaderVisible(boolean visible) {
        if (visible && this._columnHeader == null) {
            throw new IllegalStateException("columnHeader does not have a OneDModel.");
        }
        boolean oldVisible = this.isColumnHeaderVisible();
        this._displayColumnHeader = visible;
        if (oldVisible != visible) {
            this.updateLayout();
            this.revalidate();
        }
    }

    public boolean isColumnHeaderVisible() {
        return this._displayColumnHeader && !this._emptyColumnHeader;
    }

    public void setColumnHeaderHeight(int height) {
        if (height != this._columnHeaderHeight) {
            this._columnHeaderHeightSet = true;
            this._columnHeaderHeight = height;
            if (this._columnHeader != null) {
                this._columnHeader.setPreferredHeaderSize(this._columnHeaderHeight);
                this.revalidate();
            }
        }
    }

    public int getColumnHeaderHeight() {
        return this._columnHeaderHeight;
    }

    public Header getColumnHeader() {
        return this._columnHeader;
    }

    public void setRowHeaderWidth(int width) {
        if (width != this._rowHeaderWidth) {
            this._rowHeaderWidthSet = true;
            this._rowHeaderWidth = width;
            if (this._rowHeader != null) {
                this._rowHeader.setPreferredHeaderSize(this._rowHeaderWidth);
                this.revalidate();
            }
        }
    }

    public int getRowHeaderWidth() {
        return this._rowHeaderWidth;
    }

    public Header getRowHeader() {
        return this._rowHeader;
    }

    public void setHorizontalSeparatorsVisible(boolean visible) {
        if (this._grid.getHorizontalSeparatorsVisible() != visible) {
            this._grid.setHorizontalSeparatorsVisible(visible);
        }
    }

    public boolean getHorizontalSeparatorsVisible() {
        return this._grid.getHorizontalSeparatorsVisible();
    }

    public void setHorizontalSeparatorPainter(Painter painter) {
        if (this._grid.getHorizontalSeparatorPainter() != painter) {
            this._grid.setHorizontalSeparatorPainter(painter);
        }
    }

    public Painter getHorizontalSeparatorPainter() {
        return this._grid.getHorizontalSeparatorPainter();
    }

    public void setVerticalSeparatorsVisible(boolean visible) {
        if (this._grid.getVerticalSeparatorsVisible() != visible) {
            this._grid.setVerticalSeparatorsVisible(visible);
        }
    }

    public boolean getVerticalSeparatorsVisible() {
        return this._grid.getVerticalSeparatorsVisible();
    }

    public void setVerticalSeparatorPainter(Painter painter) {
        if (this._grid.getVerticalSeparatorPainter() != painter) {
            this._grid.setVerticalSeparatorPainter(painter);
        }
    }

    public Painter getVerticalSeparatorPainter() {
        return this._grid.getVerticalSeparatorPainter();
    }

    public void setHorizontalSeparatorColor(Color color) {
        this._grid.setHorizontalSeparatorColor(color);
    }

    public Color getHorizontalSeparatorColor() {
        return this._grid.getHorizontalSeparatorColor();
    }

    public void setVerticalSeparatorColor(Color color) {
        this._grid.setVerticalSeparatorColor(color);
    }

    public Color getVerticalSeparatorColor() {
        return this._grid.getVerticalSeparatorColor();
    }

    public void setExtraCanvasBackground(Color color) {
        Header rowHeader;
        Grid grid = this.getGrid();
        grid.setExtraCanvasBackground(color);
        Header colHeader = this.getColumnHeader();
        if (colHeader != null) {
            colHeader.setExtraCanvasBackground(color);
        }
        if ((rowHeader = this.getRowHeader()) != null) {
            rowHeader.setExtraCanvasBackground(color);
        }
    }

    public Color getExtraCanvasBackground() {
        return this.getGrid().getExtraCanvasBackground();
    }

    public void setDefaultColumnWidth(int width) {
        this._defaultColWidthSet = true;
        this._grid.setDefaultColumnWidth(width);
    }

    public int getDefaultColumnWidth() {
        return this._grid.getDefaultColumnWidth();
    }

    public void setDefaultRowHeight(int height) {
        this._defaultRowHeightSet = true;
        this._grid.setDefaultRowHeight(height);
    }

    public int getDefaultRowHeight() {
        return this._grid.getDefaultRowHeight();
    }

    public synchronized void setColumnVisibleIndex(int modelIndex, int visibleIndex) {
        if (this._columnHeader != null) {
            this._columnHeader.getGeometryManager().setItemVisibleIndex(modelIndex, visibleIndex);
        } else {
            this._grid.setColumnVisibleIndex(modelIndex, visibleIndex);
        }
    }

    public synchronized void setRowVisibleIndex(int modelIndex, int visibleIndex) {
        if (this._rowHeader != null) {
            this._rowHeader.getGeometryManager().setItemVisibleIndex(modelIndex, visibleIndex);
        } else {
            this._grid.setRowVisibleIndex(modelIndex, visibleIndex);
        }
    }

    public void setColumnVisible(int index, boolean visible) {
        if (this._columnHeader != null) {
            this._columnHeader.getGeometryManager().setItemVisible(index, visible);
        } else {
            this._grid.setColumnVisible(index, visible);
        }
    }

    public boolean isColumnVisible(int index) {
        return this._grid.isColumnVisible(index);
    }

    public void setRowVisible(int index, boolean visible) {
        if (this._rowHeader != null) {
            this._rowHeader.getGeometryManager().setItemVisible(index, visible);
        } else {
            this._grid.setRowVisible(index, visible);
        }
    }

    public boolean isRowVisible(int index) {
        return this._grid.isRowVisible(index);
    }

    public void setColumnWidth(int index, int width) {
        this._grid.setColumnWidth(index, width);
    }

    public int getColumnWidth(int index) {
        return this._grid.getColumnWidth(index);
    }

    public void setRowHeight(int index, int height) {
        this._grid.setRowHeight(index, height);
    }

    public int getRowHeight(int index) {
        return this._grid.getRowHeight(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModels(TwoDModel gridModel, OneDModel columnHeaderModel, OneDModel rowHeaderModel) {
        Grid grid = this.getGrid();
        try {
            this.freezeRepaints();
            grid.freezeRepaints();
            if (this._columnHeader != null) {
                this._columnHeader.freezeRepaints();
                this._emptyColumnHeader = columnHeaderModel == null;
                this._columnHeader.setModel(columnHeaderModel);
            } else if (columnHeaderModel != null) {
                this._columnHeader = this.createColumnHeader(columnHeaderModel);
                this._columnHeader.freezeRepaints();
                this._columnHeader.setGeometryManager(new TableHeaderGeometryManager(grid.getColumnGeometryManager()));
                this._columnHeaderAdapter = new TableHeaderAdapter(this, this._columnHeader);
                this._columnHeader.addResizeListener(this._columnHeaderAdapter);
                this._columnHeader.addMoveListener(this._columnHeaderAdapter);
                this._columnHeader.addPropertyChangeListener(this._columnHeaderAdapter);
                if (this._globalFocusCellListener != null) {
                    this._columnHeader.addFocusListener(this._globalFocusCellListener);
                    this._columnHeader.addPropertyChangeListener(this._globalFocusCellListener);
                }
                if (this._scrollPane == null) {
                    this.add("columnHeader", this._columnHeader);
                }
                this._emptyColumnHeader = false;
                this._columnHeader.setExtraCanvasBackground(this.getExtraCanvasBackground());
            }
            if (this._rowHeader != null) {
                this._rowHeader.freezeRepaints();
                this._emptyRowHeader = rowHeaderModel == null;
                this._rowHeader.setModel(rowHeaderModel);
            } else if (rowHeaderModel != null) {
                this._rowHeader = this.createRowHeader(rowHeaderModel);
                this._rowHeader.freezeRepaints();
                this._rowHeader.setGeometryManager(new TableHeaderGeometryManager(grid.getRowGeometryManager()));
                this._rowHeaderAdapter = new TableHeaderAdapter(this, this._rowHeader);
                this._rowHeader.addResizeListener(this._rowHeaderAdapter);
                this._rowHeader.addMoveListener(this._rowHeaderAdapter);
                this._rowHeader.addPropertyChangeListener(this._rowHeaderAdapter);
                this._emptyRowHeader = false;
                if (this._globalFocusCellListener != null) {
                    this._rowHeader.addFocusListener(this._globalFocusCellListener);
                    this._rowHeader.addPropertyChangeListener(this._globalFocusCellListener);
                }
                if (this._scrollPane == null) {
                    this.add("rowHeader", this._rowHeader);
                }
                this._rowHeader.setExtraCanvasBackground(this.getExtraCanvasBackground());
            }
            grid.setModel(gridModel);
        }
        finally {
            if (this._columnHeader != null) {
                this._columnHeader.unfreezeRepaints();
            }
            if (this._rowHeader != null) {
                this._rowHeader.unfreezeRepaints();
            }
            grid.unfreezeRepaints();
            this.unfreezeRepaints();
        }
        AccessibleContext ac = this.accessibleContext;
        if (ac != null) {
            ((AccessibleSpreadTable)ac).updateAccessibleParents();
        }
        this.updateLayout();
        this.revalidate();
    }

    @Override
    public Dimension getDocumentSize(PaintContext context, Dictionary printProperties) {
        return this.getGrid().getDocumentSize(context, printProperties);
    }

    @Override
    public void printPage(PaintContext context, Dictionary printProperties, Graphics g) {
        Object dispVertical;
        Object dispHorizontal;
        Font oldFont;
        Color oldColor;
        boolean old;
        int temp;
        int columnHeight;
        Shape savedClip = g.getClip();
        if (context == null) {
            context = this.getPrintPaintContext(g);
        }
        if (printProperties == null) {
            printProperties = new Hashtable<Object, Boolean>(1);
        }
        Rectangle clipBounds = g.getClipBounds();
        if (clipBounds.x < 0) {
            clipBounds.width += clipBounds.x;
            clipBounds.x = 0;
        }
        if (clipBounds.y < 0) {
            clipBounds.height += clipBounds.y;
            clipBounds.y = 0;
        }
        boolean showColHeader = PrinterUtils.getPrinterProperty(printProperties, DISPLAY_COLUMN_HEADERS, true) && (clipBounds.y == 0 || PrinterUtils.getPrinterProperty(printProperties, DUPLICATE_COLUMN_HEADERS, true));
        boolean showRowHeader = PrinterUtils.getPrinterProperty(printProperties, DISPLAY_ROW_HEADERS, true) && (clipBounds.x == 0 || PrinterUtils.getPrinterProperty(printProperties, DUPLICATE_ROW_HEADERS, true));
        Header columnHeader = showColHeader && this.isColumnHeaderVisible() ? this.getColumnHeader() : null;
        Header rowHeader = showRowHeader && this.isRowHeaderVisible() ? this.getRowHeader() : null;
        int rowWidth = rowHeader != null ? this.getRowHeaderWidth() : 0;
        int n = columnHeight = columnHeader != null ? this.getColumnHeaderHeight() : 0;
        if (columnHeight >= clipBounds.height) {
            temp = clipBounds.height / 8;
            columnHeight = clipBounds.height - temp;
        }
        if (rowWidth >= clipBounds.width) {
            temp = clipBounds.width / 8;
            rowWidth = clipBounds.width - temp;
        }
        boolean oldRaised = this.getDrawRaised();
        boolean newRaised = PrinterUtils.getPrinterProperty(printProperties, PRINT_RAISED, false);
        this.freezeRepaints();
        this.setDrawRaised(newRaised);
        clipBounds.width -= rowWidth;
        clipBounds.height -= columnHeight;
        if (columnHeader != null) {
            columnHeader.freezeRepaints();
            old = columnHeader.getDrawRaised();
            columnHeader.setDrawRaised(newRaised);
            Graphics columnGraphics = g;
            oldColor = columnGraphics.getColor();
            oldFont = columnGraphics.getFont();
            columnGraphics.translate(rowWidth, clipBounds.y);
            columnGraphics.setClip(clipBounds.x, 0, clipBounds.width, columnHeight);
            columnGraphics.setFont(columnHeader.getFont());
            columnGraphics.setColor(columnHeader.getForeground());
            columnHeader.printPage(context, printProperties, columnGraphics);
            columnGraphics.translate(-rowWidth, -clipBounds.y);
            columnGraphics.setClip(savedClip);
            columnGraphics.setColor(oldColor);
            columnGraphics.setFont(oldFont);
            columnHeader.setDrawRaised(old);
            columnHeader.unfreezeRepaints();
        }
        if (rowHeader != null) {
            rowHeader.freezeRepaints();
            old = rowHeader.getDrawRaised();
            rowHeader.setDrawRaised(newRaised);
            Graphics rowGraphics = g;
            oldColor = rowGraphics.getColor();
            oldFont = rowGraphics.getFont();
            rowGraphics.translate(clipBounds.x, columnHeight);
            rowGraphics.setClip(0, clipBounds.y, rowWidth, clipBounds.height);
            rowGraphics.setFont(rowHeader.getFont());
            rowGraphics.setColor(rowHeader.getForeground());
            rowHeader.printPage(context, printProperties, rowGraphics);
            rowGraphics.translate(-clipBounds.x, -columnHeight);
            rowGraphics.setClip(savedClip);
            rowGraphics.setColor(oldColor);
            rowGraphics.setFont(oldFont);
            rowHeader.setDrawRaised(old);
            rowHeader.unfreezeRepaints();
        }
        if ((dispHorizontal = PrinterUtils.getPrinterProperty(printProperties, Grid.DISPLAY_HORIZONTAL_SEPARATOR, null)) == null) {
            Boolean value = columnHeader == null ? Boolean.TRUE : Boolean.FALSE;
            ((Dictionary)printProperties).put(Grid.DISPLAY_HORIZONTAL_SEPARATOR, value);
        }
        if ((dispVertical = PrinterUtils.getPrinterProperty(printProperties, Grid.DISPLAY_VERTICAL_SEPARATOR, null)) == null) {
            Boolean value = rowHeader == null ? Boolean.TRUE : Boolean.FALSE;
            ((Dictionary)printProperties).put(Grid.DISPLAY_VERTICAL_SEPARATOR, value);
        }
        Grid grid = this.getGrid();
        g.translate(rowWidth, columnHeight);
        g.setClip(clipBounds);
        g.setFont(grid.getFont());
        g.setColor(grid.getForeground());
        grid.printPage(context, printProperties, g);
        g.translate(-rowWidth, -columnHeight);
        Component corner = this.getCornerComponent("UPPER_LEFT_CORNER");
        if (corner != null && rowWidth != 0 && columnHeight != 0) {
            g.translate(clipBounds.x, clipBounds.y);
            g.setClip(0, 0, rowWidth, columnHeight);
            corner.paint(g);
            g.translate(-clipBounds.x, -clipBounds.y);
        }
        g.setClip(savedClip);
        this.setDrawRaised(oldRaised);
        this.unfreezeRepaints();
        if (dispHorizontal == null) {
            ((Dictionary)printProperties).remove(Grid.DISPLAY_HORIZONTAL_SEPARATOR);
        }
        if (dispVertical == null) {
            ((Dictionary)printProperties).remove(Grid.DISPLAY_VERTICAL_SEPARATOR);
        }
    }

    @Override
    public Rectangle getPageBounds(PaintContext context, Dictionary printProperties, int pageXOrigin, int pageYOrigin, int pageWidth, int pageHeight) {
        boolean showRowHeader;
        boolean showColHeader;
        int columnHeaderHeight = 0;
        int rowHeaderWidth = 0;
        boolean bl = showColHeader = PrinterUtils.getPrinterProperty(printProperties, DISPLAY_COLUMN_HEADERS, true) && (pageYOrigin == 0 || PrinterUtils.getPrinterProperty(printProperties, DUPLICATE_COLUMN_HEADERS, true));
        if (showColHeader) {
            if (this.isColumnHeaderVisible()) {
                columnHeaderHeight = this.getColumnHeaderHeight();
            }
            if (columnHeaderHeight >= pageHeight) {
                int temp = pageHeight / 8;
                columnHeaderHeight = pageHeight - temp;
                pageHeight = temp;
            } else {
                pageHeight -= columnHeaderHeight;
            }
        }
        boolean bl2 = showRowHeader = PrinterUtils.getPrinterProperty(printProperties, DISPLAY_ROW_HEADERS, true) && (pageXOrigin == 0 || PrinterUtils.getPrinterProperty(printProperties, DUPLICATE_ROW_HEADERS, true));
        if (showRowHeader) {
            if (this.isRowHeaderVisible()) {
                rowHeaderWidth = this.getRowHeaderWidth();
            }
            if (rowHeaderWidth >= pageWidth) {
                int temp = pageWidth / 8;
                rowHeaderWidth = pageWidth - temp;
                pageWidth = temp;
            } else {
                pageWidth -= rowHeaderWidth;
            }
        }
        Rectangle gridPageBounds = this.getGrid().getPageBounds(context, printProperties, pageXOrigin, pageYOrigin, pageWidth, pageHeight);
        gridPageBounds.width += rowHeaderWidth;
        gridPageBounds.height += columnHeaderHeight;
        return gridPageBounds;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._grid.setEnabled(enabled);
        if (this._columnHeader != null) {
            this._columnHeader.setEnabled(enabled);
        }
        if (this._rowHeader != null) {
            this._rowHeader.setEnabled(enabled);
        }
        for (int i = 0; i < _scrollPaneKeys.length; ++i) {
            String s = this._toScrollPaneKey(i);
            Component c = this.getCornerComponent(s);
            if (c == null) continue;
            c.setEnabled(enabled);
        }
    }

    protected LayoutManager createLayoutManager() {
        return new TableLayoutManager();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this._configureScrollPane()) {
            this.remove(this._grid);
            super.setLayout(this.createLayoutManager());
            this.add("grid", this._grid);
            if (this._rowHeader != null) {
                this.add("rowHeader", this._rowHeader);
            }
            if (this._columnHeader != null) {
                this.add("columnHeader", this._columnHeader);
            }
            for (int i = 0; i < _scrollPaneKeys.length; ++i) {
                String s = this._toScrollPaneKey(i);
                Component c = this.getCornerComponent(s);
                if (c == null) continue;
                this.add(s, c);
            }
        }
        this.updateLayout();
        this._updateHeaderSize();
        AccessibleContext ac = this.accessibleContext;
        if (ac != null) {
            ((AccessibleSpreadTable)ac).updateAccessibleParents();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._clearScrollPane();
    }

    @Override
    public boolean isHScrollable() {
        return true;
    }

    @Override
    public boolean isVScrollable() {
        return true;
    }

    public void setScrollByColumn(boolean byColumn) {
        if (byColumn == this.getScrollByColumn()) {
            return;
        }
        this._grid.setScrollByColumn(byColumn);
        if (this._columnHeader != null) {
            this._columnHeader.setScrollByItem(byColumn);
        }
    }

    public boolean getScrollByColumn() {
        return this._grid.getScrollByColumn();
    }

    public void setScrollByRow(boolean byRow) {
        if (byRow == this.getScrollByRow()) {
            return;
        }
        this._grid.setScrollByRow(byRow);
        if (this._rowHeader != null) {
            this._rowHeader.setScrollByItem(byRow);
        }
    }

    public boolean getScrollByRow() {
        return this._grid.getScrollByRow();
    }

    public final boolean fireCancelableRowEvent(int id, int row) {
        TableValidateEvent event = new TableValidateEvent(this, id, -1, row);
        this.processEvent(event);
        return event.isCancelled();
    }

    public final boolean fireCancelableColumnEvent(int id, int column) {
        TableValidateEvent event = new TableValidateEvent(this, id, column, -1);
        this.processEvent(event);
        return event.isCancelled();
    }

    public final boolean fireCancelableCellEvent(int id, int column, int row) {
        TableValidateEvent event = new TableValidateEvent(this, id, column, row);
        this.processEvent(event);
        return event.isCancelled();
    }

    public final void fireRowEvent(int id, int row) {
        TableEvent event = new TableEvent(this, id, -1, row);
        this.processEvent(event);
    }

    public final void fireColumnEvent(int id, int column) {
        TableEvent event = new TableEvent(this, id, column, -1);
        this.processEvent(event);
    }

    public final void fireCellEvent(int id, int column, int row) {
        TableEvent event = new TableEvent(this, id, column, row);
        this.processEvent(event);
    }

    @Override
    public void requestFocus() {
        this._grid.requestFocus();
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getGrid().getPreferredScrollableViewportSize();
    }

    @Override
    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        super.fireVetoableChange(propertyName, oldValue, newValue);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    protected Object getPaintData(Object key) {
        if (EWTTableUI.KEY_DRAW_RAISED.equals(key)) {
            return this.getDrawRaised() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (KEY_CORNER_BORDER_COLOR.equals(key)) {
            return this.getCornerBorderColor();
        }
        return super.getPaintData(key);
    }

    @Override
    protected void processEventImpl(AWTEvent e) {
        if (e instanceof TableEvent) {
            switch (e.getID()) {
                case 2005: 
                case 2006: {
                    this.processEditEvent((TableEvent)e);
                    break;
                }
                case 2001: 
                case 2002: 
                case 2003: 
                case 2004: {
                    this.processResizeEvent((TableEvent)e);
                    break;
                }
                case 2007: 
                case 2008: 
                case 2009: 
                case 2010: {
                    this.processMoveEvent((TableEvent)e);
                }
            }
        } else {
            super.processEventImpl(e);
        }
    }

    protected void processEditEvent(TableEvent e) {
        if (this._editListeners == null) {
            return;
        }
        Enumeration enumer = this._editListeners.getListeners();
        if (enumer == null) {
            return;
        }
        switch (e.getID()) {
            case 2005: {
                while (enumer.hasMoreElements()) {
                    ((TableEditListener)enumer.nextElement()).cellEditing(e);
                }
                break;
            }
            case 2006: {
                while (enumer.hasMoreElements()) {
                    ((TableEditListener)enumer.nextElement()).cellEdited(e);
                }
                break;
            }
        }
    }

    protected void processResizeEvent(TableEvent e) {
        int id = e.getID();
        if (id == 2002 || id == 2004) {
            Point p = this._grid.getCanvasOrigin();
            if (p.x > 0) {
                p.x = 0;
                this._grid.setCanvasOrigin(p.x, p.y);
            }
            if (id == 2002 && this._columnHeader != null) {
                Point headerOrigin = this._columnHeader.getCanvasOrigin();
                if (headerOrigin.x != p.x) {
                    this._columnHeader.setCanvasOrigin(p.x, 0);
                }
            }
        }
        if (this._resizeListeners == null) {
            return;
        }
        Enumeration enumer = this._resizeListeners.getListeners();
        if (enumer == null) {
            return;
        }
        switch (id) {
            case 2001: {
                while (enumer.hasMoreElements()) {
                    ((TableResizeListener)enumer.nextElement()).columnResizing(e);
                }
                break;
            }
            case 2002: {
                while (enumer.hasMoreElements()) {
                    ((TableResizeListener)enumer.nextElement()).columnResized(e);
                }
                break;
            }
            case 2003: {
                while (enumer.hasMoreElements()) {
                    ((TableResizeListener)enumer.nextElement()).rowResizing(e);
                }
                break;
            }
            case 2004: {
                while (enumer.hasMoreElements()) {
                    ((TableResizeListener)enumer.nextElement()).rowResized(e);
                }
                break;
            }
        }
    }

    protected void processMoveEvent(TableEvent e) {
        if (this._moveListeners == null) {
            return;
        }
        Enumeration enumer = this._moveListeners.getListeners();
        if (enumer == null) {
            return;
        }
        switch (e.getID()) {
            case 2007: {
                while (enumer.hasMoreElements()) {
                    ((TableMoveListener)enumer.nextElement()).columnMoving(e);
                }
                break;
            }
            case 2008: {
                while (enumer.hasMoreElements()) {
                    ((TableMoveListener)enumer.nextElement()).columnMoved(e);
                }
                break;
            }
            case 2009: {
                while (enumer.hasMoreElements()) {
                    ((TableMoveListener)enumer.nextElement()).rowMoving(e);
                }
                break;
            }
            case 2010: {
                while (enumer.hasMoreElements()) {
                    ((TableMoveListener)enumer.nextElement()).rowMoved(e);
                }
                break;
            }
        }
    }

    protected Header createColumnHeader(OneDModel ds) {
        return new Header(ds, 0);
    }

    protected Header createRowHeader(OneDModel ds) {
        return new Header(ds, 1);
    }

    protected Grid createGrid(TwoDModel model) {
        return new Grid(model);
    }

    @Override
    protected int getHMaximum() {
        return this.getGrid().getHMaximum();
    }

    @Override
    protected int getHValueOfOffset(int x) {
        return this.getGrid().getHValueOfOffset(x);
    }

    @Override
    protected int getHOffsetOfValue(int value) {
        return this.getGrid().getHOffsetOfValue(value);
    }

    @Override
    protected int getVMaximum() {
        return this.getGrid().getVMaximum();
    }

    @Override
    protected int getVValueOfOffset(int y) {
        return this.getGrid().getVValueOfOffset(y);
    }

    @Override
    protected int getVOffsetOfValue(int value) {
        return this.getGrid().getVOffsetOfValue(value);
    }

    @Override
    protected Dimension layoutCanvas() {
        Dimension d = this.getGrid().layoutCanvas();
        if (this._scrollPane == null) {
            if (this.isColumnHeaderVisible()) {
                d.height += this.getColumnHeaderHeight();
            }
            if (this.isRowHeaderVisible()) {
                d.width += this.getRowHeaderWidth();
            }
        }
        return d;
    }

    protected boolean isSelectAllEnabled() {
        return this.isColumnHeaderVisible() && this.isRowHeaderVisible();
    }

    @Override
    protected void paintCanvasInterior(Graphics g) {
        if (this._scrollPane != null) {
            this.getGrid().paintCanvasInterior(g);
        }
    }

    protected void updateLayout() {
        if (!this._defaultRowHeightSet) {
            this._grid.getRowGeometryManager().setDefaultItemSize(0);
        }
        if (!this._defaultColWidthSet) {
            this._grid.getColumnGeometryManager().setDefaultItemSize(0);
        }
        this._getUI().updateGeometry(this);
        this._updateScrollpaneLayout();
    }

    @Override
    public void setCanvasOrigin(int x, int y) {
        super.setCanvasOrigin(x, y);
        this.getGrid().setCanvasOrigin(x, y);
    }

    public void setCornerComponent(String key, Component corner) {
        int indicator = this._toLocalIndicator(key);
        if (indicator == -1) {
            return;
        }
        this._corners[indicator] = corner;
        this.updateLayout();
    }

    public Component getCornerComponent(String key) {
        int indicator = this._toLocalIndicator(key);
        if (indicator == -1) {
            return null;
        }
        if (this._corners[indicator] == null) {
            if (key.equals("UPPER_LEFT_CORNER")) {
                this._corners[indicator] = new UpperLeftCorner(3);
            }
            if (key.equals("UPPER_RIGHT_CORNER")) {
                this._corners[indicator] = new Corner(1);
            }
            if (key.equals("LOWER_LEFT_CORNER")) {
                this._corners[indicator] = new Corner(0);
            }
        }
        return this._corners[indicator];
    }

    public void setCornerBorderColor(Color color) {
        if (color != this._cornerBorderColor) {
            this._cornerBorderColor = color;
            if (this._scrollPane != null) {
                this._scrollPane.repaint();
            } else {
                this.repaint();
            }
        }
    }

    public Color getCornerBorderColor() {
        return this._cornerBorderColor;
    }

    public void setAlwaysDrawFocusCellHighlite(boolean drawHighlite) {
        if (this.isAlwaysDrawFocusCellHighlite() != drawHighlite) {
            this._alwaysDrawFocusCellHighlite = drawHighlite;
            Grid grid = this.getGrid();
            Header rowHeader = this.getRowHeader();
            Header columnHeader = this.getColumnHeader();
            if (drawHighlite) {
                this._addGlobalFocusCellListener();
                grid.setAlwaysDrawFocusCellHighlite(this._globalFocusCellComponent == grid);
                if (rowHeader != null) {
                    rowHeader.setAlwaysDrawFocusItemHighlite(this._globalFocusCellComponent == rowHeader);
                }
                if (columnHeader != null) {
                    columnHeader.setAlwaysDrawFocusItemHighlite(this._globalFocusCellComponent == columnHeader);
                }
            } else {
                grid.setAlwaysDrawFocusCellHighlite(false);
                if (rowHeader != null) {
                    rowHeader.setAlwaysDrawFocusItemHighlite(false);
                }
                if (columnHeader != null) {
                    columnHeader.setAlwaysDrawFocusItemHighlite(false);
                }
            }
        }
    }

    public boolean isAlwaysDrawFocusCellHighlite() {
        return this._alwaysDrawFocusCellHighlite;
    }

    public void setGlobalFocusCell(Cell cell, Component component) {
        Grid grid = this.getGrid();
        Header rowHeader = this.getRowHeader();
        Header columnHeader = this.getColumnHeader();
        if (component == grid && cell != null && cell.row < grid.getRowCount() && cell.column < grid.getColumnCount()) {
            grid.setFocusCell(cell);
        } else if (rowHeader != null && component == rowHeader && cell != null && cell.row < rowHeader.getItemCount()) {
            rowHeader.setFocusItem(cell.row);
        } else if (columnHeader != null && component == columnHeader && cell != null && cell.column < columnHeader.getItemCount()) {
            columnHeader.setFocusItem(cell.column);
        }
        Cell old = this._globalFocusCell;
        this._globalFocusCellComponent = component;
        this._globalFocusCell = cell;
        this._addGlobalFocusCellListener();
        if (this.isAlwaysDrawFocusCellHighlite()) {
            grid.setAlwaysDrawFocusCellHighlite(this._globalFocusCellComponent == grid);
            if (rowHeader != null) {
                rowHeader.setAlwaysDrawFocusItemHighlite(this._globalFocusCellComponent == rowHeader);
            }
            if (columnHeader != null) {
                columnHeader.setAlwaysDrawFocusItemHighlite(this._globalFocusCellComponent == columnHeader);
            }
        }
        this.firePropertyChange(PROPERTY_GLOBAL_FOCUS_CELL, old, cell);
    }

    public Cell getGlobalFocusCell() {
        this._addGlobalFocusCellListener();
        return this._globalFocusCell;
    }

    public Component getGlobalFocusCellComponent() {
        this._addGlobalFocusCellListener();
        return this._globalFocusCellComponent;
    }

    public void setAutoResize(boolean isAutoResize) {
        this._isAutoResize = isAutoResize;
    }

    public boolean isAutoResize() {
        return this._isAutoResize;
    }

    protected void autoResizeColumn(int index) {
        Grid grid = this.getGrid();
        if (index < 0 || index > grid.getColumnCount() - 1) {
            return;
        }
        int width = 0;
        Header header = this.getColumnHeader();
        Painter itemPainter = header.getPainter(index);
        PaintContext itemContext = header.getItemPaintContext(index);
        width = itemPainter.getPreferredSize((PaintContext)itemContext).width;
        Appearance itemApp = (Appearance)itemContext.getPaintData(Header.KEY_APPEARANCE);
        ImmInsets itemInsets = itemApp.getInsets();
        width += itemInsets.left + itemInsets.right;
        BorderPainter headerBorder = header.getHeaderItemBorderPainter();
        ImmInsets borderInsets = headerBorder.getInsets(header.getPaintContext());
        width += borderInsets.left + borderInsets.right;
        int rowCount = grid.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            BorderPainter cellBorderP;
            if (!grid.isRowVisible(i)) continue;
            Painter cellPainter = grid.getColumnPainter(index);
            PaintContext cellContext = grid.getCellPaintContext(index, i);
            int cellWidth = cellPainter.getPreferredSize((PaintContext)cellContext).width;
            Appearance cellApp = (Appearance)cellContext.getPaintData("Appearance");
            ImmInsets cellInsets = cellApp.getInsets();
            cellWidth += cellInsets.left + cellInsets.right;
            if (grid.isCellBorderVisible() && (cellBorderP = cellApp.getBorderPainter()) != null) {
                ImmInsets cellBorderInsets = cellBorderP.getInsets(cellContext);
                cellWidth += cellBorderInsets.left + cellBorderInsets.right;
            }
            width = Math.max(width, cellWidth);
        }
        this.setColumnWidth(index, width);
    }

    int getHorizontalSeparatorSize() {
        boolean visible = this._grid.getHorizontalSeparatorsVisible();
        Painter painter = this._grid.getHorizontalSeparatorPainter();
        PaintContext context = this._grid.getPaintContext();
        int sepSize = visible ? painter.getPreferredSize((PaintContext)context).height : 0;
        return sepSize;
    }

    int getVerticalSeparatorSize() {
        boolean visible = this._grid.getVerticalSeparatorsVisible();
        Painter painter = this._grid.getVerticalSeparatorPainter();
        PaintContext context = this._grid.getPaintContext();
        int sepSize = visible ? painter.getPreferredSize((PaintContext)context).width : 0;
        return sepSize;
    }

    void matchGridWithHeader(boolean horizontal) {
        Grid grid = this.getGrid();
        if (horizontal) {
            Header h = this.getColumnHeader();
            if (h != null) {
                int x = h.getCanvasOriginX();
                grid.setCanvasOrigin(x, grid.getCanvasOriginY());
            }
        } else {
            Header h = this.getRowHeader();
            if (h != null) {
                int y = h.getCanvasOriginY();
                grid.setCanvasOrigin(grid.getCanvasOriginX(), y);
            }
        }
    }

    void matchHeadersWithGrid() {
        Header h = this.getColumnHeader();
        if (h != null) {
            h.setFirstItemOnScreen(this.getGrid().getFirstColumnOnScreen());
        }
        if ((h = this.getRowHeader()) != null) {
            h.setFirstItemOnScreen(this.getGrid().getFirstRowOnScreen());
        }
    }

    TableHeaderAdapter getRowHeaderAdapter() {
        return this._rowHeaderAdapter;
    }

    TableHeaderAdapter getColumnHeaderAdapter() {
        return this._columnHeaderAdapter;
    }

    TableGridAdapter getGridAdapter() {
        return this._gridAdapter;
    }

    private String _toScrollPaneKey(int localIndicator) {
        if (localIndicator < 0 || localIndicator >= _scrollPaneKeys.length) {
            return null;
        }
        return _scrollPaneKeys[localIndicator];
    }

    private int _toLocalIndicator(String key) {
        for (int i = 0; i < _scrollPaneKeys.length; ++i) {
            if (!_scrollPaneKeys[i].equals(key)) continue;
            return i;
        }
        return -1;
    }

    private boolean _configureScrollPane() {
        JScrollPane pane;
        JViewport viewport;
        Container gp;
        JScrollPane scrollPane = null;
        Container parent = this.getParent();
        if (parent instanceof JViewport && (gp = parent.getParent()) instanceof JScrollPane && (viewport = (pane = (JScrollPane)gp).getViewport()) != null && viewport.getView() == this) {
            if (this._editListener == null) {
                this._editListener = new EditListener();
                viewport.addChangeListener(this._editListener);
            }
            this.setBorder(null);
            scrollPane = pane;
            this.remove(this._grid);
            if (this._rowHeader != null) {
                this.remove(this._rowHeader);
            }
            if (this._columnHeader != null) {
                this.remove(this._columnHeader);
            }
            super.setLayout(new BorderLayout());
            this.add("Center", this._grid);
            LookAndFeel.installBorder(scrollPane, "EWTTable.scrollPaneBorder");
        }
        this._scrollPane = scrollPane;
        return scrollPane != null;
    }

    private EWTTableUI _getUI() {
        return (EWTTableUI)this.ui;
    }

    private void _updateHeaderSize() {
        EWTTableUI tableUI = this._getUI();
        if (this.getRowHeaderWidth() == -1 || !this._rowHeaderWidthSet) {
            this.setRowHeaderWidth(tableUI.getDefaultRowHeaderWidth(this));
            this._rowHeaderWidthSet = false;
        }
        if (this.getColumnHeaderHeight() == -1 || !this._columnHeaderHeightSet) {
            this.setColumnHeaderHeight(tableUI.getDefaultColumnHeaderHeight(this));
            this._columnHeaderHeightSet = false;
        }
    }

    private void _updateScrollpaneLayout() {
        if (this._scrollPane != null) {
            this._removeChangeListeners();
            this._scrollPane.setViewportBorder(null);
            boolean setCorner = false;
            String key = "UPPER_LEFT_CORNER";
            if (this._scrollPane.getCorner(key) == null || this._scrollPane.getCorner(key) instanceof DummyPanel) {
                this._scrollPane.setCorner(key, this.getCornerComponent(key));
                setCorner = true;
            }
            if (this._scrollPane.getCorner(key = "UPPER_RIGHT_CORNER") == null || this._scrollPane.getCorner(key) instanceof DummyPanel) {
                this._scrollPane.setCorner(key, this.getCornerComponent(key));
                setCorner = true;
            }
            if (this._scrollPane.getCorner(key = "LOWER_LEFT_CORNER") == null || this._scrollPane.getCorner(key) instanceof DummyPanel) {
                this._scrollPane.setCorner(key, this.getCornerComponent(key));
                setCorner = true;
            }
            if (setCorner && this._containerListener == null) {
                this._containerListener = new STContainerListener();
                this._scrollPane.getViewport().addContainerListener(this._containerListener);
            }
            Header view = this.isColumnHeaderVisible() ? this.getColumnHeader() : null;
            this._scrollPane.setColumnHeaderView(view);
            view = this.isRowHeaderVisible() ? this.getRowHeader() : null;
            this._scrollPane.setRowHeaderView(view);
            this._addChangeListeners();
            this.setBorder(null);
            this.getGrid().setBorder(null);
        }
    }

    private void _addChangeListeners() {
        JViewport view;
        if (this._hHeaderListener == null) {
            this._hHeaderListener = new HeaderListener(true);
            this._vHeaderListener = new HeaderListener(false);
        }
        if ((view = this._scrollPane.getColumnHeader()) != null) {
            view.addChangeListener(this._hHeaderListener);
        }
        if ((view = this._scrollPane.getRowHeader()) != null) {
            view.addChangeListener(this._vHeaderListener);
        }
    }

    private void _removeChangeListeners() {
        JViewport view = this._scrollPane.getColumnHeader();
        if (view != null) {
            view.removeChangeListener(this._hHeaderListener);
        }
        if ((view = this._scrollPane.getRowHeader()) != null) {
            view.removeChangeListener(this._vHeaderListener);
        }
    }

    private void _clearScrollPane() {
        if (this._scrollPane != null) {
            this._scrollPane.getViewport().removeChangeListener(this._editListener);
            if (this._containerListener != null) {
                this._scrollPane.getViewport().removeContainerListener(this._containerListener);
            }
            this._removeChangeListeners();
            this._scrollPane.setViewportBorder(null);
            this._scrollPane.setCorner("UPPER_LEFT_CORNER", new DummyPanel());
            this._scrollPane.setCorner("UPPER_RIGHT_CORNER", new DummyPanel());
            this._scrollPane.setCorner("LOWER_LEFT_CORNER", new DummyPanel());
            this._scrollPane.setColumnHeaderView(null);
            this._scrollPane.setRowHeaderView(null);
            LookAndFeel.uninstallBorder(this._scrollPane);
        }
        this._editListener = null;
        this._containerListener = null;
        this._hHeaderListener = null;
        this._vHeaderListener = null;
        this._scrollPane = null;
    }

    private void _addGlobalFocusCellListener() {
        if (this._globalFocusCellListener == null) {
            this._globalFocusCellListener = new GlobalFocusCellListener();
            Grid grid = this.getGrid();
            Header rowHeader = this.getRowHeader();
            Header columnHeader = this.getColumnHeader();
            grid.addFocusListener(this._globalFocusCellListener);
            grid.addPropertyChangeListener(this._globalFocusCellListener);
            if (rowHeader != null) {
                rowHeader.addFocusListener(this._globalFocusCellListener);
                rowHeader.addPropertyChangeListener(this._globalFocusCellListener);
            }
            if (columnHeader != null) {
                columnHeader.addFocusListener(this._globalFocusCellListener);
                columnHeader.addPropertyChangeListener(this._globalFocusCellListener);
            }
            if (this._globalFocusCellComponent == null) {
                Cell focusCell = null;
                ScrollableComponent component = null;
                if (rowHeader != null && rowHeader.hasFocus()) {
                    focusCell = new Cell(-1, rowHeader.getFocusItem());
                    component = rowHeader;
                } else if (columnHeader != null && columnHeader.hasFocus()) {
                    focusCell = new Cell(columnHeader.getFocusItem(), -1);
                    component = columnHeader;
                } else if (grid.hasFocus()) {
                    focusCell = grid.getFocusCell();
                    if (focusCell == null) {
                        focusCell = new Cell(0, 0);
                    }
                    component = grid;
                }
                this.setGlobalFocusCell(focusCell, component);
            }
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSpreadTable();
        }
        return this.accessibleContext;
    }

    private class GlobalFocusCellListener
    implements FocusListener,
    PropertyChangeListener {
        private GlobalFocusCellListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Component component = (Component)e.getSource();
            Grid grid = SpreadTable.this.getGrid();
            Header rowHeader = SpreadTable.this.getRowHeader();
            Header columnHeader = SpreadTable.this.getColumnHeader();
            Cell focusCell = null;
            if (component == grid) {
                focusCell = grid.getFocusCell();
                if (focusCell == null) {
                    focusCell = new Cell(0, 0);
                }
            } else if (component == rowHeader) {
                focusCell = new Cell(-1, rowHeader.getFocusItem());
            } else if (component == columnHeader) {
                focusCell = new Cell(columnHeader.getFocusItem(), -1);
            }
            if (focusCell != null) {
                SpreadTable.this.setGlobalFocusCell(focusCell, component);
            }
            if (SpreadTable.this.isAlwaysDrawFocusCellHighlite()) {
                grid.setAlwaysDrawFocusCellHighlite(SpreadTable.this._globalFocusCellComponent == grid);
                if (rowHeader != null) {
                    rowHeader.setAlwaysDrawFocusItemHighlite(SpreadTable.this._globalFocusCellComponent == rowHeader);
                }
                if (columnHeader != null) {
                    columnHeader.setAlwaysDrawFocusItemHighlite(SpreadTable.this._globalFocusCellComponent == columnHeader);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Cell focusCell;
            Component component = (Component)evt.getSource();
            if (!component.hasFocus()) {
                return;
            }
            String name = evt.getPropertyName();
            if (SpreadTable.PROPERTY_FOCUSCELL.equals(name) && component == SpreadTable.this.getGrid() && (focusCell = ((Grid)component).getFocusCell()) != null) {
                SpreadTable.this.setGlobalFocusCell(focusCell, component);
            }
            if ("focusItem".equals(name)) {
                int item = ((Header)component).getFocusItem();
                if (component == SpreadTable.this.getRowHeader()) {
                    SpreadTable.this.setGlobalFocusCell(new Cell(-1, item), component);
                } else if (component == SpreadTable.this.getColumnHeader()) {
                    SpreadTable.this.setGlobalFocusCell(new Cell(item, -1), component);
                }
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    private class Corner
    extends LWComponent {
        private int _corner;

        public Corner(int whichCorner) {
            this._corner = whichCorner;
        }

        @Override
        public void paint(Graphics g) {
            PaintContext context = this.getPaintContext();
            EWTTableUI ui = SpreadTable.this._getUI();
            Painter painter = ui.getCornerPainter(SpreadTable.this, this._corner);
            Dimension d = this.getSize();
            painter.paint(context, g, 0, 0, d.width, d.height);
        }

        @Override
        protected Object getPaintData(Object key) {
            return SpreadTable.this.getPaintData(key);
        }
    }

    private class UpperLeftCorner
    extends Corner
    implements Accessible {
        public UpperLeftCorner(int whichCorner) {
            super(whichCorner);
            long mask = 16L;
            this.enableEvents(mask);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (e.isConsumed()) {
                return;
            }
            boolean isLeftButton = SwingUtilities.isLeftMouseButton(e);
            int id = e.getID();
            if (isLeftButton && id == 501 && this.isEnabled()) {
                SpreadTable.this._grid.requestFocus();
                if (SpreadTable.this.isSelectAllEnabled()) {
                    try {
                        SpreadTable.this._grid.selectAll();
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleCorner();
            }
            return this.accessibleContext;
        }

        private class AccessibleCorner
        extends JComponent.AccessibleJComponent
        implements AccessibleAction {
            private AccessibleCorner() {
                super(UpperLeftCorner.this);
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                return this;
            }

            @Override
            public int getAccessibleActionCount() {
                return 1;
            }

            @Override
            public String getAccessibleActionDescription(int i) {
                Locale l = LocaleUtils.getDefaultableLocale((Component)SpreadTable.this);
                ResourceBundle b = ResourceBundle.getBundle(SpreadTable._RESOURCE_BUNDLE, l);
                switch (i) {
                    case 0: {
                        return b.getString(SpreadTable._SELECT_ALL_KEY);
                    }
                }
                return null;
            }

            @Override
            public boolean doAccessibleAction(int i) {
                boolean ok;
                boolean bl = ok = i == 0 && SpreadTable.this.isSelectAllEnabled();
                if (ok) {
                    try {
                        SpreadTable.this.selectAll();
                    }
                    catch (PropertyVetoException pve) {
                        ok = false;
                    }
                }
                return ok;
            }
        }
    }

    private class STContainerListener
    implements ContainerListener {
        private STContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            Container c = e.getContainer();
            if (SpreadTable.this._scrollPane != null && c == SpreadTable.this._scrollPane.getViewport() && e.getChild() == SpreadTable.this && SpreadTable.this._scrollPane instanceof EWTScrollPane) {
                c.removeContainerListener(this);
                SpreadTable.this._scrollPane.setCorner("UPPER_LEFT_CORNER", null);
                SpreadTable.this._scrollPane.setCorner("UPPER_RIGHT_CORNER", null);
                SpreadTable.this._scrollPane.setCorner("LOWER_LEFT_CORNER", null);
            }
        }
    }

    private class EditListener
    implements ChangeListener {
        private EditListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SpreadTable.this.getGrid().commitCellEdit();
        }
    }

    private class HeaderListener
    implements ChangeListener {
        private boolean _horizontal;

        public HeaderListener(boolean horizontal) {
            this._horizontal = horizontal;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SpreadTable.this.matchGridWithHeader(this._horizontal);
        }
    }

    protected class AccessibleSpreadTable
    extends JComponent.AccessibleJComponent {
        public AccessibleSpreadTable() {
            super(SpreadTable.this);
            this.updateAccessibleParents();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        @Override
        public int getAccessibleChildrenCount() {
            int count = 1;
            if (SpreadTable.this.getColumnHeader() != null) {
                ++count;
            }
            if (SpreadTable.this.getRowHeader() != null) {
                ++count;
            }
            return count;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                return null;
            }
            if (i == 0) {
                return SpreadTable.this.getGrid();
            }
            if (i == 2) {
                return SpreadTable.this.getRowHeader();
            }
            if (SpreadTable.this.getColumnHeader() != null) {
                return SpreadTable.this.getColumnHeader();
            }
            return SpreadTable.this.getRowHeader();
        }

        void updateAccessibleParents() {
            SpreadTable.this.getGrid().getAccessibleContext().setAccessibleParent(SpreadTable.this);
            if (SpreadTable.this.getColumnHeader() != null) {
                SpreadTable.this.getColumnHeader().getAccessibleContext().setAccessibleParent(SpreadTable.this);
            }
            if (SpreadTable.this.getRowHeader() != null) {
                SpreadTable.this.getRowHeader().getAccessibleContext().setAccessibleParent(SpreadTable.this);
            }
        }
    }
}

