/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IlvRect
extends Rectangle2D.Float
implements Serializable {
    static final long serialVersionUID = -8670827708447265349L;

    public IlvRect() {
    }

    public IlvRect(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.height = f4;
        this.width = f3;
    }

    public IlvRect(IlvRect ilvRect) {
        this.x = ilvRect.x;
        this.y = ilvRect.y;
        this.width = ilvRect.width;
        this.height = ilvRect.height;
    }

    public final void add(float f, float f2) {
        if (f < this.x) {
            this.width += this.x - f;
            this.x = f;
        } else if (f > this.x + this.width) {
            this.width = f - this.x;
        }
        if (f2 < this.y) {
            this.height += this.y - f2;
            this.y = f2;
        } else if (f2 > this.y + this.height) {
            this.height = f2 - this.y;
        }
    }

    public final void add(IlvRect ilvRect) {
        double d = this.x;
        double d2 = ilvRect.x;
        double d3 = d < d2 ? d : d2;
        double d4 = d > d2 ? (d += (double)this.width) : (d2 += (double)ilvRect.width);
        d = this.y;
        d2 = ilvRect.y;
        double d5 = d < d2 ? d : d2;
        double d6 = d > d2 ? (d += (double)this.height) : (d2 += (double)ilvRect.height);
        this.x = (float)d3;
        this.y = (float)d5;
        this.width = (float)(d4 - d3);
        this.height = (float)(d6 - d5);
    }

    public final boolean inside(float f, float f2) {
        float f3 = this.x;
        float f4 = this.y;
        return f >= f3 && f2 >= f4 && f <= f3 + this.width && f2 <= f4 + this.height;
    }

    public final void move(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public final void translate(float f, float f2) {
        this.x += f;
        this.y += f2;
    }

    public final void resize(float f, float f2) {
        this.width = f;
        this.height = f2;
    }

    public final void reshape(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.width = f3;
        this.height = f4;
    }

    public final void expand(float f) {
        this.x -= f;
        this.y -= f;
        this.width = Math.max(this.width + 2.0f * f, 0.0f);
        this.height = Math.max(this.height + 2.0f * f, 0.0f);
    }

    public final void expand(float f, float f2) {
        this.x -= f;
        this.y -= f2;
        this.width = Math.max(this.width + 2.0f * f, 0.0f);
        this.height = Math.max(this.height + 2.0f * f2, 0.0f);
    }

    public final boolean contains(IlvRect ilvRect) {
        float f = ilvRect.width;
        float f2 = ilvRect.height;
        if (this.width <= 0.0f || this.height <= 0.0f || f < 0.0f || f2 < 0.0f) {
            return false;
        }
        float f3 = ilvRect.x;
        float f4 = ilvRect.y;
        return f3 >= this.x && f4 >= this.y && f3 + f <= this.x + this.width && f4 + f2 <= this.y + this.height;
    }

    public final boolean intersects(IlvRect ilvRect) {
        if (this.width <= 0.0f || this.height <= 0.0f || ilvRect.width < 0.0f || ilvRect.height < 0.0f) {
            return false;
        }
        return this.x <= ilvRect.x + ilvRect.width && this.x + this.width >= ilvRect.x && this.y <= ilvRect.y + ilvRect.height && this.y + this.height >= ilvRect.y;
    }

    public final void intersection(IlvRect ilvRect) {
        float f = this.x + this.width;
        float f2 = this.y + this.height;
        float f3 = ilvRect.x + ilvRect.width;
        float f4 = ilvRect.y + ilvRect.height;
        if (ilvRect.x > this.x) {
            this.x = ilvRect.x;
            this.width = f > f3 ? ilvRect.width : f - this.x;
        } else if (f > f3) {
            this.width = f3 - this.x;
        }
        if (ilvRect.y > this.y) {
            this.y = ilvRect.y;
            this.height = f2 > f4 ? ilvRect.height : f2 - this.y;
        } else if (f2 > f4) {
            this.height = f4 - this.y;
        }
    }

    public final void floor() {
        float f = this.x > 0.0f ? (float)((int)this.x) : (float)Math.floor(this.x);
        float f2 = this.y > 0.0f ? (float)((int)this.y) : (float)Math.floor(this.y);
        float f3 = this.x + this.width;
        f3 = f3 > 0.0f ? (float)((int)f3) : (float)Math.floor(f3);
        float f4 = this.y + this.height;
        f4 = f4 > 0.0f ? (float)((int)f4) : (float)Math.floor(f4);
        this.x = f;
        this.y = f2;
        this.width = f3 - f;
        this.height = f4 - f2;
    }

    public final int xFloor() {
        return this.x > 0.0f ? (int)this.x : (int)Math.floor(this.x);
    }

    public final int yFloor() {
        return this.y > 0.0f ? (int)this.y : (int)Math.floor(this.y);
    }

    public final int widthFloor() {
        float f = this.x > 0.0f ? (float)((int)this.x) : (float)Math.floor(this.x);
        float f2 = this.x + this.width;
        f2 = f2 > 0.0f ? (float)((int)f2) : (float)Math.floor(f2);
        return (int)(f2 - f);
    }

    public final int heightFloor() {
        float f = this.y > 0.0f ? (float)((int)this.y) : (float)Math.floor(this.y);
        float f2 = this.y + this.height;
        f2 = f2 > 0.0f ? (float)((int)f2) : (float)Math.floor(f2);
        return (int)(f2 - f);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeFloat(this.x);
        objectOutputStream.writeFloat(this.y);
        objectOutputStream.writeFloat(this.width);
        objectOutputStream.writeFloat(this.height);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        try {
            this.x = getField.get("x", 0.0f);
            this.y = getField.get("y", 0.0f);
            this.width = getField.get("width", 0.0f);
            this.height = getField.get("height", 0.0f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.x = objectInputStream.readFloat();
            this.y = objectInputStream.readFloat();
            this.width = objectInputStream.readFloat();
            this.height = objectInputStream.readFloat();
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.x) + " " + String.valueOf(this.y) + " " + String.valueOf(this.width) + " " + String.valueOf(this.height);
    }
}

