/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvUtil;
import java.awt.geom.AffineTransform;
import java.io.Serializable;

public final class IlvTransformer
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1872632947377004341L;
    private double a = 1.0;
    private double b;
    private double c;
    private double d = 1.0;
    private double e;
    private double f;
    private double g = 1.0;
    private boolean h = true;
    private boolean i = true;
    private boolean j = true;
    private double k = 1.0;

    public IlvTransformer() {
    }

    public IlvTransformer(IlvTransformer ilvTransformer) {
        if (ilvTransformer == null) {
            return;
        }
        this.a = ilvTransformer.a;
        this.b = ilvTransformer.b;
        this.c = ilvTransformer.c;
        this.d = ilvTransformer.d;
        this.e = ilvTransformer.e;
        this.f = ilvTransformer.f;
        this.g = ilvTransformer.g;
        this.h = ilvTransformer.h;
        this.j = ilvTransformer.j;
        this.k = ilvTransformer.k;
        this.i = ilvTransformer.i;
    }

    public IlvTransformer(double d, double d2, double d3, double d4, double d5, double d6) {
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.e = d5;
        this.f = d6;
        this.a();
    }

    public IlvTransformer(AffineTransform affineTransform) {
        this.setAffineTransform(affineTransform);
    }

    public IlvTransformer(IlvPoint ilvPoint, double d) {
        d = IlvUtil.degreesToRadians(d);
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.setValues(d2, -d3, d3, d2, (double)ilvPoint.x * (1.0 - d2) + d3 * (double)ilvPoint.y, -((double)ilvPoint.x * d3) + (double)ilvPoint.y * (1.0 - d2));
    }

    public IlvTransformer(double d, double d2, IlvPoint ilvPoint) {
        this.setValues(d, 0.0, 0.0, d2, (double)ilvPoint.x - d * (double)ilvPoint.x, (double)ilvPoint.y - d2 * (double)ilvPoint.y);
    }

    public IlvTransformer(IlvPoint ilvPoint) {
        this.setValues(ilvPoint.x, ilvPoint.y);
    }

    private void a() {
        if (this.b == 0.0 && this.c == 0.0) {
            this.j = true;
            if (this.a == 1.0 && this.d == 1.0) {
                this.h = true;
                this.g = 1.0;
                this.k = 1.0;
                this.i = this.e == 0.0 && this.f == 0.0;
            } else {
                this.h = false;
                this.i = false;
                this.g = this.a * this.d;
                this.k = Math.min(Math.abs(this.a), Math.abs(this.d));
            }
        } else {
            this.j = false;
            this.h = false;
            this.i = false;
            this.g = this.a * this.d - this.b * this.c;
            this.k = Math.sqrt(Math.min(this.a * this.a + this.b * this.b, this.d * this.d + this.c * this.c));
        }
    }

    public final void setValues(double d, double d2) {
        this.e = d;
        this.f = d2;
        this.a();
    }

    public void setValues(double d, double d2, double d3, double d4) {
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.a();
    }

    public void setValues(double d, double d2, double d3, double d4, double d5, double d6) {
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.e = d5;
        this.f = d6;
        this.a();
    }

    public void setAffineTransform(AffineTransform affineTransform) {
        this.a = affineTransform.getScaleX();
        this.b = affineTransform.getShearX();
        this.c = affineTransform.getShearY();
        this.d = affineTransform.getScaleY();
        this.e = affineTransform.getTranslateX();
        this.f = affineTransform.getTranslateY();
        this.a();
    }

    public AffineTransform getAffineTransform(AffineTransform affineTransform) {
        if (affineTransform == null) {
            return new AffineTransform(this.a, this.c, this.b, this.d, this.e, this.f);
        }
        affineTransform.setTransform(this.a, this.c, this.b, this.d, this.e, this.f);
        return affineTransform;
    }

    public double getx0() {
        return this.e;
    }

    public double gety0() {
        return this.f;
    }

    public double getx11() {
        return this.a;
    }

    public double getx12() {
        return this.b;
    }

    public double getx21() {
        return this.c;
    }

    public double getx22() {
        return this.d;
    }

    public boolean isIdentity() {
        return this.i;
    }

    public boolean isTranslation() {
        return this.h;
    }

    public boolean isScale() {
        return this.j;
    }

    public boolean isBad() {
        return !(Math.abs(this.g) > Double.MIN_VALUE);
    }

    public double getDeterminant() {
        return this.g;
    }

    public void apply(IlvPoint ilvPoint) {
        if (this.i) {
            return;
        }
        if (this.h) {
            ilvPoint.x = (float)((double)ilvPoint.x + this.e);
            ilvPoint.y = (float)((double)ilvPoint.y + this.f);
        } else if (this.j) {
            ilvPoint.x = (float)(this.a * (double)ilvPoint.x + this.e);
            ilvPoint.y = (float)(this.d * (double)ilvPoint.y + this.f);
        } else {
            float f = (float)(this.a * (double)ilvPoint.x + this.b * (double)ilvPoint.y + this.e);
            ilvPoint.y = (float)(this.c * (double)ilvPoint.x + this.d * (double)ilvPoint.y + this.f);
            ilvPoint.x = f;
        }
    }

    public void applyFloor(IlvPoint ilvPoint) {
        float f;
        float f2;
        if (this.i) {
            f2 = ilvPoint.x;
            f = ilvPoint.y;
        } else if (this.h) {
            f2 = (float)((double)ilvPoint.x + this.e);
            f = (float)((double)ilvPoint.y + this.f);
        } else if (this.j) {
            f2 = (float)(this.a * (double)ilvPoint.x + this.e);
            f = (float)(this.d * (double)ilvPoint.y + this.f);
        } else {
            f2 = (float)(this.a * (double)ilvPoint.x + this.b * (double)ilvPoint.y + this.e);
            f = (float)(this.c * (double)ilvPoint.x + this.d * (double)ilvPoint.y + this.f);
        }
        ilvPoint.x = f2 >= 0.0f ? (float)((int)f2) : (float)((int)Math.floor(f2));
        ilvPoint.y = f >= 0.0f ? (float)((int)f) : (float)((int)Math.floor(f));
    }

    public void apply(IlvRect ilvRect) {
        if (this.i) {
            return;
        }
        if (this.h) {
            ilvRect.x = (float)((double)ilvRect.x + this.e);
            ilvRect.y = (float)((double)ilvRect.y + this.f);
        } else if (this.j) {
            double d = this.a * (double)ilvRect.x + this.e;
            double d2 = this.a * (double)ilvRect.width;
            double d3 = d + d2;
            ilvRect.x = (float)Math.min(d, d3);
            ilvRect.width = (float)(d2 <= 0.0 ? 0.0 - d2 : d2);
            double d4 = this.d * (double)ilvRect.y + this.f;
            double d5 = this.d * (double)ilvRect.height;
            double d6 = d4 + d5;
            ilvRect.y = (float)Math.min(d4, d6);
            ilvRect.height = (float)(d5 <= 0.0 ? 0.0 - d5 : d5);
        } else {
            double d = ilvRect.x;
            double d7 = ilvRect.y;
            double d8 = d + (double)ilvRect.width;
            double d9 = d7 + (double)ilvRect.height;
            double d10 = this.a * d + this.b * d7 + this.e;
            double d11 = this.c * d + this.d * d7 + this.f;
            d = d10;
            d7 = d11;
            d10 = this.a * d8 + this.b * d9 + this.e;
            d11 = this.c * d8 + this.d * d9 + this.f;
            d8 = d10;
            d9 = d11;
            ilvRect.x = (float)Math.min(d, d8);
            ilvRect.y = (float)Math.min(d7, d9);
            ilvRect.width = (float)Math.max(d, d8) - ilvRect.x;
            ilvRect.height = (float)Math.max(d7, d9) - ilvRect.y;
        }
    }

    public void boundingBox(IlvRect ilvRect, boolean bl) {
        if (this.i) {
            return;
        }
        if (this.j || this.h) {
            if (bl) {
                this.inverse(ilvRect);
            } else {
                this.apply(ilvRect);
            }
            return;
        }
        IlvPoint ilvPoint = new IlvPoint(ilvRect.x, ilvRect.y);
        if (bl) {
            this.inverse(ilvPoint);
        } else {
            this.apply(ilvPoint);
        }
        float f = ilvPoint.x;
        float f2 = ilvPoint.x;
        float f3 = ilvPoint.y;
        float f4 = ilvPoint.y;
        ilvPoint.x = ilvRect.x + ilvRect.width;
        ilvPoint.y = ilvRect.y;
        if (bl) {
            this.inverse(ilvPoint);
        } else {
            this.apply(ilvPoint);
        }
        if (ilvPoint.x > f2) {
            f2 = ilvPoint.x;
        } else if (ilvPoint.x < f) {
            f = ilvPoint.x;
        }
        if (ilvPoint.y > f3) {
            f3 = ilvPoint.y;
        } else if (ilvPoint.y < f4) {
            f4 = ilvPoint.y;
        }
        ilvPoint.x = ilvRect.x;
        ilvPoint.y = ilvRect.y + ilvRect.height;
        if (bl) {
            this.inverse(ilvPoint);
        } else {
            this.apply(ilvPoint);
        }
        if (ilvPoint.x > f2) {
            f2 = ilvPoint.x;
        } else if (ilvPoint.x < f) {
            f = ilvPoint.x;
        }
        if (ilvPoint.y > f3) {
            f3 = ilvPoint.y;
        } else if (ilvPoint.y < f4) {
            f4 = ilvPoint.y;
        }
        ilvPoint.x = ilvRect.x + ilvRect.width;
        ilvPoint.y = ilvRect.y + ilvRect.height;
        if (bl) {
            this.inverse(ilvPoint);
        } else {
            this.apply(ilvPoint);
        }
        if (ilvPoint.x > f2) {
            f2 = ilvPoint.x;
        } else if (ilvPoint.x < f) {
            f = ilvPoint.x;
        }
        if (ilvPoint.y > f3) {
            f3 = ilvPoint.y;
        } else if (ilvPoint.y < f4) {
            f4 = ilvPoint.y;
        }
        ilvRect.x = f;
        ilvRect.y = f4;
        ilvRect.width = f2 - f;
        ilvRect.height = f3 - f4;
    }

    public void applyFloor(IlvRect ilvRect) {
        double d;
        double d2 = ilvRect.x;
        double d3 = ilvRect.y;
        double d4 = d2 + (double)ilvRect.width;
        double d5 = d3 + (double)ilvRect.height;
        if (!this.i) {
            if (this.h) {
                d2 += this.e;
                d3 += this.f;
                d4 += this.e;
                d5 += this.f;
            } else if (this.j) {
                d2 = this.a * d2 + this.e;
                d3 = this.d * d3 + this.f;
                d4 = this.a * d4 + this.e;
                d5 = this.d * d5 + this.f;
            } else {
                d = this.a * d2 + this.b * d3 + this.e;
                double d6 = this.c * d2 + this.d * d3 + this.f;
                d2 = d;
                d3 = d6;
                d = this.a * d4 + this.b * d5 + this.e;
                d6 = this.c * d4 + this.d * d5 + this.f;
                d4 = d;
                d5 = d6;
            }
        }
        ilvRect.x = (d = Math.min(d2, d4)) > 0.0 ? (float)((int)d) : (float)Math.floor(d);
        d = Math.min(d3, d5);
        ilvRect.y = d > 0.0 ? (float)((int)d) : (float)Math.floor(d);
        d = Math.max(d2, d4);
        ilvRect.width = (float)(d > 0.0 ? (double)((int)d) : Math.floor(d)) - ilvRect.x;
        d = Math.max(d3, d5);
        ilvRect.height = (float)(d > 0.0 ? (double)((int)d) : Math.floor(d)) - ilvRect.y;
    }

    public void deltaApply(IlvPoint ilvPoint) {
        double d;
        double d2;
        if (this.h) {
            return;
        }
        if (this.j) {
            d2 = this.a * (double)ilvPoint.x;
            d = this.d * (double)ilvPoint.y;
        } else {
            d2 = this.a * (double)ilvPoint.x + this.b * (double)ilvPoint.y;
            d = this.c * (double)ilvPoint.x + this.d * (double)ilvPoint.y;
        }
        ilvPoint.move((float)d2, (float)d);
    }

    public boolean inverse(IlvPoint ilvPoint) {
        if (this.i) {
            return true;
        }
        if (!(Math.abs(this.g) > Double.MIN_VALUE)) {
            return false;
        }
        if (this.h) {
            ilvPoint.x = (float)((double)ilvPoint.x - this.e);
            ilvPoint.y = (float)((double)ilvPoint.y - this.f);
        } else if (this.j) {
            ilvPoint.x = (float)(((double)ilvPoint.x - this.e) / this.a);
            ilvPoint.y = (float)(((double)ilvPoint.y - this.f) / this.d);
        } else {
            float f = ilvPoint.x;
            float f2 = ilvPoint.y;
            ilvPoint.x = (float)((((double)f - this.e) * this.d - ((double)f2 - this.f) * this.b) / this.g);
            ilvPoint.y = -((float)((((double)f - this.e) * this.c - ((double)f2 - this.f) * this.a) / this.g));
        }
        return true;
    }

    public boolean inverse(IlvRect ilvRect) {
        if (!this.i) {
            if (this.h) {
                ilvRect.x = (float)((double)ilvRect.x - this.e);
                ilvRect.y = (float)((double)ilvRect.y - this.f);
            } else {
                if (!(Math.abs(this.g) > Double.MIN_VALUE)) {
                    return false;
                }
                if (this.j) {
                    double d = ((double)ilvRect.x - this.e) / this.a;
                    double d2 = (double)ilvRect.width / this.a;
                    double d3 = d + d2;
                    ilvRect.x = (float)Math.min(d, d3);
                    ilvRect.width = (float)Math.abs(d2);
                    double d4 = ((double)ilvRect.y - this.f) / this.d;
                    double d5 = (double)ilvRect.height / this.d;
                    double d6 = d4 + d5;
                    ilvRect.y = (float)Math.min(d4, d6);
                    ilvRect.height = (float)Math.abs(d5);
                } else {
                    double d = ilvRect.x;
                    double d7 = ilvRect.y;
                    double d8 = d + (double)ilvRect.width;
                    double d9 = d7 + (double)ilvRect.height;
                    double d10 = d;
                    d = ((d - this.e) * this.d - (d7 - this.f) * this.b) / this.g;
                    d7 = -(((d10 - this.e) * this.c - (d7 - this.f) * this.a) / this.g);
                    d10 = d8;
                    d8 = ((d8 - this.e) * this.d - (d9 - this.f) * this.b) / this.g;
                    d9 = -(((d10 - this.e) * this.c - (d9 - this.f) * this.a) / this.g);
                    ilvRect.x = (float)Math.min(d, d8);
                    ilvRect.y = (float)Math.min(d7, d9);
                    ilvRect.width = (float)Math.max(d, d8) - ilvRect.x;
                    ilvRect.height = (float)Math.max(d7, d9) - ilvRect.y;
                }
            }
        }
        return true;
    }

    public void compose(IlvTransformer ilvTransformer) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        if (ilvTransformer == null || ilvTransformer.i) {
            return;
        }
        if (ilvTransformer.h) {
            this.e += ilvTransformer.e;
            this.f += ilvTransformer.f;
            this.a();
            return;
        }
        if (this.i) {
            this.a = ilvTransformer.a;
            this.d = ilvTransformer.d;
            this.b = ilvTransformer.b;
            this.c = ilvTransformer.c;
            this.e = ilvTransformer.e;
            this.f = ilvTransformer.f;
            this.a();
            return;
        }
        if (this.h) {
            if (ilvTransformer.j) {
                d6 = ilvTransformer.a;
                d5 = ilvTransformer.d;
                d4 = 0.0;
                d3 = 0.0;
                d2 = ilvTransformer.a * this.e + ilvTransformer.e;
                d = ilvTransformer.d * this.f + ilvTransformer.f;
            } else {
                d6 = ilvTransformer.a;
                d5 = ilvTransformer.d;
                d4 = ilvTransformer.b * this.d;
                d3 = ilvTransformer.c * this.a;
                d2 = ilvTransformer.a * this.e + ilvTransformer.b * this.f + ilvTransformer.e;
                d = ilvTransformer.c * this.e + ilvTransformer.d * this.f + ilvTransformer.f;
            }
        } else if (this.j) {
            if (ilvTransformer.j) {
                d6 = ilvTransformer.a * this.a;
                d5 = ilvTransformer.d * this.d;
                d4 = ilvTransformer.a * this.b;
                d3 = ilvTransformer.d * this.c;
                d2 = ilvTransformer.a * this.e + ilvTransformer.e;
                d = ilvTransformer.d * this.f + ilvTransformer.f;
            } else {
                d6 = ilvTransformer.a * this.a;
                d5 = ilvTransformer.d * this.d;
                d4 = ilvTransformer.b * this.d;
                d3 = ilvTransformer.c * this.a;
                d2 = ilvTransformer.a * this.e + ilvTransformer.b * this.f + ilvTransformer.e;
                d = ilvTransformer.c * this.e + ilvTransformer.d * this.f + ilvTransformer.f;
            }
        } else if (ilvTransformer.j) {
            d6 = ilvTransformer.a * this.a;
            d5 = ilvTransformer.d * this.d;
            d4 = ilvTransformer.a * this.b;
            d3 = ilvTransformer.d * this.c;
            d2 = ilvTransformer.a * this.e + ilvTransformer.e;
            d = ilvTransformer.d * this.f + ilvTransformer.f;
        } else {
            d6 = ilvTransformer.a * this.a + ilvTransformer.b * this.c;
            d5 = ilvTransformer.c * this.b + ilvTransformer.d * this.d;
            d4 = ilvTransformer.a * this.b + ilvTransformer.b * this.d;
            d3 = ilvTransformer.c * this.a + ilvTransformer.d * this.c;
            d2 = ilvTransformer.a * this.e + ilvTransformer.b * this.f + ilvTransformer.e;
            d = ilvTransformer.c * this.e + ilvTransformer.d * this.f + ilvTransformer.f;
        }
        this.c = d3;
        this.d = d5;
        this.a = d6;
        this.b = d4;
        this.e = d2;
        this.f = d;
        this.a();
    }

    public void postCompose(IlvTransformer ilvTransformer) {
        if (ilvTransformer == null || ilvTransformer.i) {
            return;
        }
        double d = this.a * ilvTransformer.a + this.b * ilvTransformer.c;
        double d2 = this.c * ilvTransformer.b + this.d * ilvTransformer.d;
        double d3 = this.a * ilvTransformer.b + this.b * ilvTransformer.d;
        double d4 = this.c * ilvTransformer.a + this.d * ilvTransformer.c;
        double d5 = this.a * ilvTransformer.e + this.b * ilvTransformer.f + this.e;
        double d6 = this.c * ilvTransformer.e + this.d * ilvTransformer.f + this.f;
        this.c = d4;
        this.d = d2;
        this.a = d;
        this.b = d3;
        this.e = d5;
        this.f = d6;
        this.a();
    }

    public boolean computeInverse(IlvTransformer ilvTransformer) {
        if (this.i) {
            ilvTransformer.a = 1.0;
            ilvTransformer.b = 0.0;
            ilvTransformer.c = 0.0;
            ilvTransformer.d = 1.0;
            ilvTransformer.e = 0.0;
            ilvTransformer.f = 0.0;
            ilvTransformer.a();
            return true;
        }
        if (!(Math.abs(this.g) > Double.MIN_VALUE)) {
            return false;
        }
        ilvTransformer.g = 1.0 / this.g;
        ilvTransformer.a = this.d * ilvTransformer.g;
        ilvTransformer.b = -this.b * ilvTransformer.g;
        ilvTransformer.c = -this.c * ilvTransformer.g;
        ilvTransformer.d = this.a * ilvTransformer.g;
        ilvTransformer.e = (this.b * this.f - this.d * this.e) * ilvTransformer.g;
        ilvTransformer.f = (this.c * this.e - this.a * this.f) * ilvTransformer.g;
        ilvTransformer.a();
        return true;
    }

    public void translate(double d, double d2) {
        this.e += d;
        this.f += d2;
        this.a();
    }

    public void scale(double d, double d2, double d3, double d4) {
        this.e += (1.0 - d3) * (this.a * d + this.b * d2);
        this.f += (1.0 - d4) * (this.c * d + this.d * d2);
        this.a *= d3;
        this.b *= d3;
        this.c *= d4;
        this.d *= d4;
        this.a();
    }

    public void rotate(double d, double d2, double d3) {
        d3 = IlvUtil.degreesToRadians(d3);
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        double d6 = d4 * this.a + -d5 * this.c;
        double d7 = d4 * this.b + -d5 * this.d;
        this.c = d5 * this.a + d4 * this.c;
        this.d = d5 * this.b + d4 * this.d;
        this.a = d6;
        this.b = d7;
        d6 = d4 * this.e + -d5 * this.f + d * (1.0 - d4) + d2 * d5;
        d7 = d5 * this.e + d4 * this.f + d2 * (1.0 - d4) - d * d5;
        this.e = d6;
        this.f = d7;
        this.a();
    }

    public static IlvTransformer computeTransformer(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        if (ilvTransformer == null) {
            ilvTransformer = new IlvTransformer();
        }
        double d = 1.0;
        double d2 = 1.0;
        if (ilvRect2.width != ilvRect.width) {
            d = (double)ilvRect2.width / (double)ilvRect.width;
        }
        if (ilvRect2.height != ilvRect.height) {
            d2 = (double)ilvRect2.height / (double)ilvRect.height;
        }
        ilvTransformer.setValues(d, 0.0, 0.0, d2, (double)ilvRect2.x - d * (double)ilvRect.x, (double)ilvRect2.y - d2 * (double)ilvRect.y);
        return ilvTransformer;
    }

    public double zoomFactor() {
        return this.k;
    }

    public double zoomXFactor() {
        if (this.j) {
            return Math.abs(this.a);
        }
        return Math.sqrt(this.a * this.a + this.b * this.b);
    }

    public double zoomYFactor() {
        if (this.j) {
            return Math.abs(this.d);
        }
        return Math.sqrt(this.c * this.c + this.d * this.d);
    }

    public Object clone() {
        return new IlvTransformer(this);
    }

    public boolean equals(Object object) {
        if (object instanceof IlvTransformer) {
            IlvTransformer ilvTransformer = (IlvTransformer)object;
            return this.a == ilvTransformer.a && this.b == ilvTransformer.b && this.c == ilvTransformer.c && this.d == ilvTransformer.d && this.e == ilvTransformer.e && this.f == ilvTransformer.f;
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.e + 1.20798 * this.f + 0.21067 * this.a + 2.6047 * this.b + 2.1067 * this.c + 0.26047 * this.d);
        return (int)(l ^ l >> 32);
    }

    public String toString() {
        return "Transformer:" + String.valueOf(this.a) + " " + String.valueOf(this.b) + " " + String.valueOf(this.c) + " " + String.valueOf(this.d) + "\t" + String.valueOf(this.e) + " " + String.valueOf(this.f);
    }
}

