/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.util;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.util.logging.IlvLog;
import ilog.views.util.IlvFrameworkProduct;
import ilog.views.util.internal.IlvURLUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class IlvUtil {
    private IlvUtil() {
    }

    public static Object[] AddToArray(Object[] objectArray, Object object, int n) {
        if (objectArray == null || objectArray.length == 0) {
            return new Object[]{object};
        }
        Object[] objectArray2 = new Object[objectArray.length + 1];
        if (n > 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        }
        objectArray2[n] = object;
        if (n < objectArray.length) {
            System.arraycopy(objectArray, n, objectArray2, n + 1, objectArray.length - n);
        }
        return objectArray2;
    }

    public static Object[] AddToArray(Object[] objectArray, Object object) {
        return IlvUtil.AddToArray(objectArray, object, objectArray == null ? 0 : objectArray.length);
    }

    public static Object[] RemoveFromArray(Object[] objectArray, int n) {
        if (objectArray == null || objectArray.length == 0 || n == -1) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[objectArray.length - 1];
        if (n > 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        }
        if (n < objectArray.length - 1) {
            System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray.length - n - 1);
        }
        return objectArray2;
    }

    public static Object[] RemoveFromArray(Object[] objectArray, Object object) {
        return IlvUtil.RemoveFromArray(objectArray, IlvUtil.IndexOf(objectArray, object));
    }

    public static int IndexOf(Object[] objectArray, Object object) {
        if (objectArray == null || objectArray.length == 0) {
            return -1;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != object) continue;
            return i;
        }
        return -1;
    }

    public static Object[] SetElementAt(Object[] objectArray, Object object, int n) {
        if (objectArray == null) {
            objectArray = new Object[n + 1];
        }
        if (objectArray.length > n) {
            objectArray[n] = object;
            return objectArray;
        }
        Object[] objectArray2 = new Object[n + 1];
        if (objectArray.length > 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        }
        objectArray2[n] = object;
        return objectArray2;
    }

    public static Object[] CopyArray(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return new Object[0];
        }
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public static String AbbreviatePathName(String string, IlvApplication ilvApplication, int n, boolean bl) {
        char c;
        if (n >= string.length()) {
            return string;
        }
        String string2 = null;
        if (ilvApplication != null) {
            string2 = ilvApplication.getString("Pathname.AbbreviationFormat");
        }
        if (string2 == null) {
            string2 = "...{0}";
        }
        int n2 = (c = File.separatorChar) == '\\' ? 47 : 92;
        int n3 = 0;
        while (true) {
            int n4 = string.indexOf(c, n3 + 1);
            int n5 = string.indexOf(n2, n3 + 1);
            if (n4 == -1 || n5 != -1 && n5 < n4) {
                n4 = n5;
            }
            if (n4 == -1) break;
            String string3 = MessageFormat.format(string2, string.substring(n4));
            if (string3.length() <= n) {
                return string3;
            }
            n3 = n4;
        }
        return bl ? MessageFormat.format(string2, string.substring(n3)) : null;
    }

    public static String GetFileName(String string) {
        if (string != null) {
            char c = File.separatorChar;
            int n = File.separatorChar == '\\' ? 47 : 92;
            int n2 = string.lastIndexOf(c);
            int n3 = string.lastIndexOf(n);
            if (n2 == -1) {
                n2 = n3;
            } else if (n3 != -1) {
                int n4 = n2 = n3 < n2 ? n3 : n2;
            }
            if (n2 == -1) {
                return string;
            }
            return string.substring(n2 + 1);
        }
        return null;
    }

    static String[] a(String string) {
        int n;
        string = string.substring(0, string.lastIndexOf(IlvUtil.GetFileName(string)));
        char c = File.separatorChar;
        char c2 = c == '\\' ? (char)'/' : '\\';
        int n2 = string.indexOf(c);
        int n3 = string.indexOf(c2);
        if (n2 == -1) {
            c = c2;
        } else {
            string = string.replace(c2, c);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n = string.indexOf(c)) != -1) {
            String string2 = string.substring(0, n);
            if (string2.length() > 0) {
                arrayList.add(string2);
            }
            string = string.substring(n + 1);
        }
        if (string != null && string.length() > 0) {
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String GetRelativePath(String string, String string2) {
        int n;
        String string3;
        if (string == null || string2 == null) {
            return null;
        }
        String string4 = string;
        String string5 = string2;
        String string6 = string3 = IlvUtil.GetFileName(string4);
        if (string3 != null) {
            string4 = string4.substring(0, string4.lastIndexOf(string3));
        }
        if ((string3 = IlvUtil.GetFileName(string5)) != null) {
            string5 = string5.substring(0, string5.lastIndexOf(string3));
        }
        String[] stringArray = IlvUtil.a(string4);
        String[] stringArray2 = IlvUtil.a(string5);
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; n2 < stringArray.length && i < stringArray2.length && stringArray[n2].equals(stringArray2[i]); ++n2, ++i) {
            bl = true;
        }
        if (!bl) {
            return string;
        }
        String string7 = "";
        for (n = i; n < stringArray2.length; ++n) {
            string7 = string7.concat(".." + File.separator);
        }
        for (n = n2; n < stringArray.length; ++n) {
            string7 = string7.concat(stringArray[n] + File.separator);
        }
        if (string6 != null) {
            string7 = string7.concat(string6);
        }
        return string7;
    }

    public static String GetFileName(URL uRL) {
        if (uRL != null) {
            try {
                File file = IlvURLUtil.convertFileURLToFile(uRL);
                return file.getName();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static String GetFileExtension(String string) {
        String string2 = null;
        if (string == null) {
            return string2;
        }
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(File.separator);
        if (n > 0 && n < string.length() - 1 && n > n2) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }

    public static boolean IsWhitespace(String string) {
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (Character.isWhitespace(string.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String EncodeColor(Color color) {
        if (color == null) {
            return "";
        }
        return "#" + (color.getAlpha() != 255 ? IlvUtil.a(color.getAlpha()) : "") + IlvUtil.a(color.getRed()) + IlvUtil.a(color.getGreen()) + IlvUtil.a(color.getBlue());
    }

    static String a(int n) {
        String string = Integer.toHexString(n);
        if (string.length() == 2) {
            return string;
        }
        return "0" + string;
    }

    static int a(String string, int n) {
        int n2 = string.length() / 2;
        int n3 = 0;
        int n4 = string.length() - 1;
        int n5 = 1;
        while (n4 >= n) {
            switch (string.charAt(n4)) {
                case '0': {
                    break;
                }
                case '1': {
                    n3 += n5 * 1;
                    break;
                }
                case '2': {
                    n3 += n5 * 2;
                    break;
                }
                case '3': {
                    n3 += n5 * 3;
                    break;
                }
                case '4': {
                    n3 += n5 * 4;
                    break;
                }
                case '5': {
                    n3 += n5 * 5;
                    break;
                }
                case '6': {
                    n3 += n5 * 6;
                    break;
                }
                case '7': {
                    n3 += n5 * 7;
                    break;
                }
                case '8': {
                    n3 += n5 * 8;
                    break;
                }
                case '9': {
                    n3 += n5 * 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    n3 += n5 * 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    n3 += n5 * 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    n3 += n5 * 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    n3 += n5 * 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    n3 += n5 * 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    n3 += n5 * 15;
                }
            }
            --n4;
            n5 *= 16;
        }
        return n3;
    }

    public static Color DecodeColor(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = 0;
        try {
            boolean bl = false;
            if (string.startsWith("0x")) {
                if (string.length() > 8) {
                    bl = true;
                }
                n = IlvUtil.a(string, 2);
            } else if (string.startsWith("#")) {
                if (string.length() > 7) {
                    bl = true;
                }
                n = IlvUtil.a(string, 1);
            } else {
                n = string.startsWith("0") && string.length() > 1 ? Integer.parseInt(string.substring(1), 8) : Integer.parseInt(string, 10);
            }
            return new Color(n, bl);
        }
        catch (NumberFormatException numberFormatException) {
            IlvLog.Log("ilog.views.appframe", IlvLog.WARNING, "Logging.util.BadColorFormat", new Object[]{string});
            return null;
        }
    }

    public static String EncodeFont(Font font) {
        if (font == null) {
            return "";
        }
        return "font-family:'" + font.getFamily() + "';font-size:" + font.getSize() + (font.isBold() ? ";font-weight:bold" : "") + (font.isItalic() ? ";font-style:italic" : "");
    }

    public static Font DecodeFont(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = null;
        int n = 12;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            int n3 = string.indexOf(58);
            if (n3 == -1) continue;
            String string3 = string.substring(0, n3);
            if (string3.equals("font-family")) {
                string2 = string.substring(n3 + 1);
                continue;
            }
            if ("font-size".equals(string3)) {
                try {
                    n = Integer.parseInt(string.substring(n3 + 1));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if ("font-style".equals(string3)) {
                if (!string.substring(n3 + 1).equals("italic")) continue;
                n2 += 2;
                continue;
            }
            if (!string3.equals("font-weight")) continue;
            if (!string.substring(n3 + 1).equals("bold")) continue;
            ++n2;
        }
        return new Font(string2, n2, n);
    }

    public static final int GetVersion() {
        return IlvFrameworkProduct.getVersion();
    }

    public static final int GetMinorVersion() {
        return IlvFrameworkProduct.getMinorVersion();
    }
}

