/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.beans.editor;

import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.beans.editor.IlvURLStringPropertyEditor;
import ilog.views.util.internal.IlvURLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class URLEditor
extends JPanel
implements PropertyEditor {
    private URL a = null;
    private PropertyChangeSupport b = null;
    private JTextField c;
    private FileDialog d;

    public URLEditor() {
        final ResourceBundle resourceBundle = IlvResourceUtil.getBundle("editors", IlvURLStringPropertyEditor.class, IlvLocaleUtil.getCurrentLocale());
        this.setLayout(new BorderLayout(0, 0));
        this.b = new PropertyChangeSupport(this);
        this.c = new JTextField(20);
        this.add((Component)new JLabel(resourceBundle.getString("URLStringPropertyEditor.EnterURL")), "North");
        this.add((Component)this.c, "Center");
        JButton jButton = new JButton("...");
        this.add((Component)jButton, "After");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                URL uRL;
                if (URLEditor.this.d == null) {
                    URLEditor.this.d = new FileDialog((Frame)new JFrame(), resourceBundle.getString("URLStringPropertyEditor.ChooseURL"));
                }
                URLEditor.this.d.show();
                try {
                    uRL = IlvURLUtil.convertFilenameToURL(URLEditor.this.d.getDirectory() + URLEditor.this.d.getFile());
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
                if (uRL != null) {
                    URLEditor.this.c.setText(uRL.toExternalForm());
                }
                URLEditor.this.c.requestFocus();
            }
        });
        this.c.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (URLEditor.this.c.getText() != null && URLEditor.this.c.getText().length() != 0) {
                    URL uRL = (URL)URLEditor.this.getValue();
                    try {
                        URL uRL2 = new URL(URLEditor.this.c.getText());
                        URLEditor.this.a = uRL2;
                        URLEditor.this.b.firePropertyChange(null, uRL, uRL2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    public void setValue(Object object) {
        URL uRL = this.a;
        this.a = (URL)object;
        this.firePropertyChange(uRL, this.a);
        if (this.a != null) {
            this.c.setText(this.a.toString());
        } else {
            this.c.setText("");
        }
    }

    @Override
    public Object getValue() {
        return this.a;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    @Override
    public String getJavaInitializationString() {
        int n;
        if (this.a == null) {
            return "null";
        }
        String string = this.a.toString().trim();
        int n2 = 0;
        while ((n = string.indexOf("\\", n2)) != -1) {
            string = string.substring(0, n) + "\\" + string.substring(n);
            n2 = n + 2;
        }
        return "new java.net.URL(\"" + string + "\")";
    }

    @Override
    public String getAsText() {
        if (this.a != null) {
            return this.a.toString();
        }
        return "";
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        try {
            this.setValue(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    public String[] getTags() {
        return null;
    }

    public void firePropertyChange(URL uRL, URL uRL2) {
        this.b.firePropertyChange(null, uRL, uRL2);
    }

    @Override
    public Component getCustomEditor() {
        if (this.a != null) {
            this.c.setText(this.a.toString());
        } else {
            this.c.setText("");
        }
        return this;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.b.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.b.removePropertyChangeListener(propertyChangeListener);
    }
}

