/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvBidiGraphic;
import ilog.views.IlvFontInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTextInterface;
import ilog.views.IlvToolkit;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.IlvTextSelection;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.util.text.IlvBidiUtil;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.text.AttributedString;

public class IlvLabel
extends IlvBidiGraphic
implements IlvFontInterface,
IlvTextInterface {
    private Color a;
    private String b;
    private Font c = IlvToolkit.defaultFont;
    private final IlvPoint d = new IlvPoint();
    private int e;
    private int f;

    public IlvLabel() {
        this(new IlvPoint(0.0f, 0.0f), "");
    }

    public IlvLabel(IlvPoint ilvPoint, String string) {
        this.setLabel(string);
        this.setCenter(ilvPoint);
        this.a();
    }

    public IlvLabel(IlvLabel ilvLabel) {
        super(ilvLabel);
        this.setCenter(ilvLabel.getCenter());
        this.setLabel(ilvLabel.getLabel());
        this.setFont(ilvLabel.getFont());
        this.setForeground(ilvLabel.a);
        this.setAntialiasing(ilvLabel.isAntialiasing());
        this.a();
    }

    @Override
    public IlvGraphic copy() {
        return new IlvLabel(this);
    }

    @Override
    public void setLabel(String string) {
        this.b = string != null ? string : "";
        this.a();
    }

    @Override
    public String getLabel() {
        return this.b;
    }

    @Override
    public boolean supportMultiline() {
        return false;
    }

    public void setCenter(IlvPoint ilvPoint) {
        this.d.move(ilvPoint.x, ilvPoint.y);
    }

    public IlvPoint getCenter() {
        return new IlvPoint(this.d.x, this.d.y);
    }

    public final boolean isAntialiasing() {
        return this.getProperty("__ILVAntialiasing") != null;
    }

    public void setAntialiasing(boolean bl) {
        this.setProperty("__ILVAntialiasing", bl ? new Boolean(true) : null);
        this.a();
    }

    void a() {
        if (this.b == null) {
            return;
        }
        IlvRect ilvRect = IlvGraphicUtil.GetStringBounds(this, this.b, this.c, this.isAntialiasing());
        this.e = (int)ilvRect.width;
        this.f = (int)ilvRect.height;
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (this.b == null) {
            return;
        }
        IlvPoint ilvPoint = this.getCenter();
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint);
        }
        graphics.setFont(this.c);
        graphics.setColor(this.getForeground());
        int n = (int)Math.floor(ilvPoint.x) - this.e / 2;
        int n2 = (int)Math.floor(ilvPoint.y) + this.f / 2;
        IlvGraphicUtil.DrawString(this, graphics, this.b, n, n2, this.isAntialiasing());
    }

    @Override
    public boolean zoomable() {
        return false;
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint = this.getCenter();
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint);
        }
        if (this.b != null) {
            IlvRect ilvRect = new IlvRect(ilvPoint.x - (float)(this.e / 2), ilvPoint.y - (float)(this.f / 2), this.e, this.f);
            if (ilvRect.width < 1.0E-20f) {
                ilvRect.width = 1.0E-20f;
            }
            if (ilvRect.height < 1.0E-20f) {
                ilvRect.height = 1.0E-20f;
            }
            return ilvRect;
        }
        return new IlvRect(ilvPoint.x, ilvPoint.y, 1.0E-20f, 1.0E-20f);
    }

    @Override
    public IlvRect getLabelBBox(IlvTransformer ilvTransformer) {
        return this.boundingBox(ilvTransformer);
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        ilvTransformer.apply(this.d);
    }

    @Override
    public IlvSelection makeSelection() {
        return new IlvTextSelection(this, false);
    }

    public IlvLabel(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setForeground(ilvInputStream.readColor("foreground"));
        this.setFont(ilvInputStream.readFont("font"));
        this.setCenter(ilvInputStream.readPoint("center"));
        this.setLabel(ilvInputStream.readString("label"));
        try {
            this.setAntialiasing(ilvInputStream.readBoolean("antialiasing"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void setForeground(Color color) {
        Color color2 = this.a;
        this.a = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getForeground() {
        if (this.a != null) {
            return this.a;
        }
        return Color.black;
    }

    @Override
    public void setFont(Font font) {
        this.c = font;
        this.a();
    }

    @Override
    public Font getFont() {
        return this.c;
    }

    @Override
    public boolean usesBidiMarkers() {
        return IlvBidiUtil.isStringRTL(this, this.b, this.getComponentOrientation());
    }

    @Override
    public boolean isBaseTextDirectionSensitive() {
        return IlvBidiUtil.isAdvancedBidiOn();
    }

    @Override
    public void baseTextDirectionChanged(int n, int n2) {
        super.baseTextDirectionChanged(n, n2);
        this.a();
    }

    @Override
    public void componentOrientationChanged(ComponentOrientation componentOrientation, ComponentOrientation componentOrientation2) {
        super.componentOrientationChanged(componentOrientation, componentOrientation2);
        if (this.getResolvedBaseTextDirection() == 527) {
            this.a();
        }
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("foreground", this.getForeground());
        ilvOutputStream.write("font", this.getFont());
        ilvOutputStream.write("center", this.d);
        ilvOutputStream.write("label", this.getLabel());
        if (this.isAntialiasing()) {
            ilvOutputStream.write("antialiasing", this.isAntialiasing());
        }
    }

    @Override
    public String toString() {
        String string = this.getLabel();
        if (string == null) {
            string = "[null string]";
        } else if (string.length() == 0) {
            string = "[empty string]";
        }
        return super.toString() + " Label: " + string;
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (super.contains(ilvPoint, ilvPoint2, ilvTransformer)) {
            return true;
        }
        return IlvText.a(this, ilvPoint2, ilvTransformer);
    }

    @Override
    public Shape getCaretShape(IlvTextSelection.Range range, IlvTransformer ilvTransformer) {
        Shape shape;
        Shape[] shapeArray;
        TextLayout textLayout;
        if (range.isEmpty()) {
            return null;
        }
        Font font = this.getFont();
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        if (!IlvBidiUtil.isAdvancedBidiOn()) {
            String string = this.b() ? " " : this.getLabel();
            textLayout = new TextLayout(string, font, fontRenderContext);
        } else {
            boolean bl = IlvBidiUtil.isStringRTL(this, this.getLabel(), this.getComponentOrientation());
            String string = this.b() ? " " : (bl ? "\u200f" : "") + this.getLabel() + (bl ? "\u200f" : "");
            shapeArray = new AttributedString(string);
            shapeArray.addAttribute(TextAttribute.RUN_DIRECTION, bl ? TextAttribute.RUN_DIRECTION_RTL : TextAttribute.RUN_DIRECTION_LTR);
            shapeArray.addAttribute(TextAttribute.FONT, font);
            textLayout = new TextLayout(shapeArray.getIterator(), fontRenderContext);
        }
        if (range.isCollapsed()) {
            shapeArray = textLayout.getCaretShapes(range.from);
            shape = shapeArray[0];
        } else {
            shape = textLayout.getLogicalHighlightShape(range.from, range.to);
        }
        return this.a(shape, font, fontRenderContext, ilvTransformer);
    }

    boolean b() {
        return this.b == null || this.b.length() == 0;
    }

    Shape a(Shape shape, Font font, FontRenderContext fontRenderContext, IlvTransformer ilvTransformer) {
        AffineTransform affineTransform = this.a(font, fontRenderContext, ilvTransformer);
        return affineTransform.createTransformedShape(shape);
    }

    AffineTransform a(Font font, FontRenderContext fontRenderContext, IlvTransformer ilvTransformer) {
        LineMetrics lineMetrics = font.getLineMetrics(this.getLabel(), fontRenderContext);
        IlvRect ilvRect = this.boundingBox(ilvTransformer);
        double d = ilvRect.getX();
        double d2 = ilvRect.getMaxY() - (double)lineMetrics.getDescent();
        return new AffineTransform(1.0, 0.0, 0.0, 1.0, d, d2);
    }

    @Override
    public int pickCharacter(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        Object object;
        TextLayout textLayout;
        Font font = this.getFont();
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        if (!IlvBidiUtil.isAdvancedBidiOn()) {
            String string = this.b() ? " " : this.getLabel();
            textLayout = new TextLayout(string, font, fontRenderContext);
        } else {
            boolean bl = IlvBidiUtil.isStringRTL(this, this.getLabel(), this.getComponentOrientation());
            String string = this.b() ? " " : (bl ? "\u200f" : "") + this.getLabel() + (bl ? "\u200f" : "");
            object = new AttributedString(string);
            ((AttributedString)object).addAttribute(TextAttribute.RUN_DIRECTION, bl ? TextAttribute.RUN_DIRECTION_RTL : TextAttribute.RUN_DIRECTION_LTR);
            ((AttributedString)object).addAttribute(TextAttribute.FONT, font);
            textLayout = new TextLayout(((AttributedString)object).getIterator(), fontRenderContext);
        }
        AffineTransform affineTransform = this.a(font, fontRenderContext, ilvTransformer);
        object = new Point2D.Float(ilvPoint.x, ilvPoint.y);
        Point2D.Float float_ = new Point2D.Float();
        try {
            affineTransform.inverseTransform((Point2D)object, float_);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
            return -1;
        }
        TextHitInfo textHitInfo = textLayout.hitTestChar(float_.x, float_.y);
        if (this.b()) {
            return Math.min(0, textHitInfo.getInsertionIndex());
        }
        return textHitInfo.getInsertionIndex();
    }

    @Override
    public int lineCount() {
        return 1;
    }

    @Override
    public int lineOffset(int n) {
        return 0;
    }
}

