/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite.layout;

import ilog.views.IlvRect;
import ilog.views.graphic.composite.layout.IlvAttachable;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IlvStackerLayout
implements IlvLayoutManager {
    private int a = 3;
    private int b = 4;
    private int c = 0;
    private LinkedList d = new LinkedList();

    public IlvStackerLayout() {
    }

    public IlvStackerLayout(int n, int n2, int n3) {
        this.setSpacing(n3);
        this.setOrientation(n);
        this.setAlignment(n2);
        this.checkValues();
    }

    public IlvStackerLayout(IlvInputStream ilvInputStream) throws IlvReadFileException {
        this.setAlignment(ilvInputStream.readInt("alignment"));
        this.setOrientation(ilvInputStream.readInt("orientation"));
        this.setSpacing(ilvInputStream.readInt("spacing"));
    }

    protected void checkValues() {
        if (this.b == 4 || this.b == 2) {
            if (this.c != 1 && this.c != 3 && this.c != 0) {
                this.c = 0;
            }
        } else if (this.b == 1 || this.b == 3) {
            if (this.c != 2 && this.c != 4 && this.c != 0) {
                this.c = 0;
            }
        } else {
            this.b = 4;
            this.c = 0;
        }
    }

    public void setOrientation(int n) {
        this.b = n;
    }

    public int getOrientation() {
        return this.b;
    }

    public void setAlignment(int n) {
        this.c = n;
    }

    public int getAlignment() {
        return this.c;
    }

    public void setSpacing(int n) {
        this.a = n;
    }

    public int getSpacing() {
        return this.a;
    }

    @Override
    public void setConstraints(IlvAttachable ilvAttachable, Object object) {
        this.d.add(ilvAttachable);
    }

    @Override
    public void removeConstraints(IlvAttachable ilvAttachable) {
        this.d.remove(ilvAttachable);
    }

    @Override
    public void layoutGroup(IlvAttachable ilvAttachable) {
        this.computeChildrenAttachmentCoordinates(ilvAttachable);
    }

    @Override
    public void attach(IlvAttachable ilvAttachable) {
        if (this.d.size() > 0) {
            return;
        }
        IlvAttachable[] ilvAttachableArray = ilvAttachable.getAttachables();
        for (int i = 0; i < ilvAttachableArray.length; ++i) {
            if (ilvAttachableArray[i] == null) continue;
            this.setConstraints(ilvAttachableArray[i], null);
        }
    }

    protected void computeChildrenAttachmentCoordinates(IlvAttachable ilvAttachable) {
        block8: {
            float f;
            float f2;
            float f3;
            Iterator iterator;
            block9: {
                IlvRect ilvRect = null;
                List list = this.a();
                iterator = list.iterator();
                if (!iterator.hasNext()) break block8;
                while (iterator.hasNext()) {
                    IlvAttachable ilvAttachable2 = (IlvAttachable)iterator.next();
                    IlvRect ilvRect2 = ilvAttachable2.getAttachmentBounds();
                    if (ilvRect == null) {
                        ilvRect = new IlvRect(ilvRect2);
                        continue;
                    }
                    ilvRect.add(ilvRect2);
                }
                f3 = ilvRect.width;
                float f4 = ilvRect.height;
                f2 = this.b == 2 ? ilvRect.x + f3 : ilvRect.x;
                f = this.b == 1 ? ilvRect.y + f4 : ilvRect.y;
                iterator = list.iterator();
                if (this.b != 4 && this.b != 2) break block9;
                while (iterator.hasNext()) {
                    IlvAttachable ilvAttachable3 = (IlvAttachable)iterator.next();
                    IlvRect ilvRect3 = ilvAttachable3.getAttachmentBounds();
                    float f5 = this.c == 3 ? f + f4 - ilvRect3.height : (this.c == 0 ? f + 0.5f * f4 - 0.5f * ilvRect3.height : (ilvRect3.y = f));
                    if (this.b == 4) {
                        ilvRect3.x = f2;
                        f2 = f2 + ilvRect3.width + (float)this.a;
                    } else {
                        ilvRect3.x = f2 -= ilvRect3.width;
                        f2 -= (float)this.a;
                    }
                    ilvAttachable3.move(ilvRect3.x, ilvRect3.y);
                }
                break block8;
            }
            if (this.b != 1 && this.b != 3) break block8;
            while (iterator.hasNext()) {
                IlvAttachable ilvAttachable4 = (IlvAttachable)iterator.next();
                IlvRect ilvRect = ilvAttachable4.getAttachmentBounds();
                float f6 = this.c == 4 ? f2 + f3 - ilvRect.width : (this.c == 0 ? f2 + 0.5f * f3 - 0.5f * ilvRect.width : (ilvRect.x = f2));
                if (this.b == 3) {
                    ilvRect.y = f;
                    f = f + ilvRect.height + (float)this.a;
                } else {
                    ilvRect.y = f -= ilvRect.height;
                    f -= (float)this.a;
                }
                ilvAttachable4.move(ilvRect.x, ilvRect.y);
            }
        }
    }

    private List a() {
        LinkedList<IlvAttachable> linkedList = new LinkedList<IlvAttachable>();
        for (IlvAttachable ilvAttachable : this.d) {
            if (!ilvAttachable.isVisible()) continue;
            linkedList.add(ilvAttachable);
        }
        return linkedList;
    }

    @Override
    public void reset() {
        this.d = new LinkedList();
    }

    @Override
    public Object clone() {
        try {
            IlvStackerLayout ilvStackerLayout = (IlvStackerLayout)super.clone();
            ilvStackerLayout.reset();
            return ilvStackerLayout;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError();
        }
    }

    @Override
    public boolean resizeFirstChildOnly() {
        return false;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        ilvOutputStream.write("alignment", this.getAlignment());
        ilvOutputStream.write("orientation", this.getOrientation());
        ilvOutputStream.write("spacing", this.getSpacing());
    }
}

