/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.interactor;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.graphic.IlvSpline;
import ilog.views.interactor.IlvMakePolyPointsInteractor;
import ilog.views.interactor.IlvPolyPointsObjectFactory;
import java.awt.Graphics;

public class IlvMakeSplineInteractor
extends IlvMakePolyPointsInteractor
implements IlvPolyPointsObjectFactory {
    private float a = 0.65f;
    private int b = 2;
    private static final int c = 2;
    private static final int d = 4;
    private static final int e = 8;

    public IlvMakeSplineInteractor() {
        this.setObjectFactory(this);
    }

    @Override
    public IlvGraphic createObject(IlvPoint[] ilvPointArray) {
        IlvSpline ilvSpline = new IlvSpline(ilvPointArray);
        ilvSpline.setSmoothness(this.getSmoothness());
        ilvSpline.setFillOn(this.isFillOn());
        ilvSpline.setStrokeOn(this.isStrokeOn());
        ilvSpline.setClosed(this.isClosed());
        return ilvSpline;
    }

    @Override
    protected void drawGhost(Graphics graphics) {
        if (this.isOpaqueMode()) {
            super.drawGhost(graphics);
        } else if (this.count() > 1) {
            if (!this.isClosed()) {
                IlvPoint[] ilvPointArray = this.getPoints(true);
                IlvGraphicUtil.DrawBezier(graphics, ilvPointArray, ilvPointArray.length, true, this.getSmoothness(), 0.0f, 1, 0, null, null, false);
            } else if (!this.isFillOn()) {
                IlvPoint[] ilvPointArray = this.getPoints(true);
                IlvGraphicUtil.DrawClosedBezier(graphics, ilvPointArray, ilvPointArray.length, true, this.getSmoothness(), 0.0f, 1, 0, null, null);
            } else {
                IlvPoint[] ilvPointArray = this.getPoints(true);
                IlvGraphicUtil.FillBezier(graphics, ilvPointArray, ilvPointArray.length, true, this.getSmoothness(), null);
            }
        }
    }

    public void setSmoothness(float f) {
        if (f == -1.0f || f >= 0.0f && f <= 1.0f) {
            this.a = f;
        }
    }

    public float getSmoothness() {
        return this.a;
    }

    public boolean isFillOn() {
        return (this.b & 4) != 0;
    }

    public void setFillOn(boolean bl) {
        this.b = bl ? (this.b |= 4) : (this.b &= 0xFFFFFFFB);
    }

    public boolean isStrokeOn() {
        return (this.b & 2) != 0;
    }

    public void setStrokeOn(boolean bl) {
        this.b = bl ? (this.b |= 2) : (this.b &= 0xFFFFFFFD);
    }

    public void setClosed(boolean bl) {
        this.b = bl ? (this.b |= 8) : (this.b &= 0xFFFFFFF7);
    }

    public boolean isClosed() {
        return (this.b & 8) != 0;
    }
}

