/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.linkconnector;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvPolicyAwareLinkImage;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;
import java.util.HashMap;

public abstract class IlvCachingLinkConnector
extends IlvLinkConnector {
    private HashMap a;
    private HashMap b;
    private static final int c = 3;
    private int d = 3;

    public IlvCachingLinkConnector() {
    }

    public IlvCachingLinkConnector(IlvGraphic ilvGraphic) {
        super(ilvGraphic);
    }

    public IlvCachingLinkConnector(IlvLinkImage ilvLinkImage, boolean bl) {
        super(ilvLinkImage, bl);
    }

    public IlvCachingLinkConnector(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        try {
            this.setCacheSize(ilvInputStream.readInt("cacheSize"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        if (this.d != 3) {
            ilvOutputStream.write("cacheSize", this.d);
        }
    }

    protected abstract boolean useCache();

    protected boolean useCache(IlvLinkImage ilvLinkImage) {
        return this.useCache() && ilvLinkImage instanceof IlvPolicyAwareLinkImage && ilvLinkImage.getGraphicBag() instanceof IlvGrapher;
    }

    public void setCacheSize(int n) {
        if (n < 2) {
            n = 2;
        }
        if (this.d != n) {
            this.d = n;
            this.cleanCache();
        }
    }

    public int getCacheSize() {
        if (this.d == 0) {
            return 3;
        }
        return this.d;
    }

    @Override
    public IlvPoint getConnectionPoint(IlvLinkImage ilvLinkImage, boolean bl, IlvTransformer ilvTransformer) {
        if (this.useCache(ilvLinkImage)) {
            IlvPoint ilvPoint = this.a(ilvLinkImage, bl, ilvTransformer);
            if (ilvPoint != null) {
                return ilvPoint;
            }
            ilvPoint = this.calcConnectionPoint(ilvLinkImage, bl, ilvTransformer);
            IlvPoint ilvPoint2 = ilvPoint == null ? null : new IlvPoint(ilvPoint);
            this.a(ilvLinkImage, bl, ilvTransformer, ilvPoint);
            return ilvPoint2;
        }
        return this.calcConnectionPoint(ilvLinkImage, bl, ilvTransformer);
    }

    protected abstract IlvPoint calcConnectionPoint(IlvLinkImage var1, boolean var2, IlvTransformer var3);

    @Override
    public void detach(boolean bl) {
        super.detach(bl);
        this.b = null;
        this.a = null;
    }

    @Override
    public void detach(IlvLinkImage ilvLinkImage, boolean bl, boolean bl2) {
        super.detach(ilvLinkImage, bl, bl2);
        if (this.useCache(ilvLinkImage)) {
            this.cleanCache(ilvLinkImage);
        }
    }

    @Override
    public void linkRemoved(IlvLinkImage ilvLinkImage) {
        super.linkRemoved(ilvLinkImage);
        if (this.useCache(ilvLinkImage)) {
            this.cleanCache(ilvLinkImage);
        }
    }

    @Override
    protected void allLinksRemoved() {
        super.allLinksRemoved();
        this.b = null;
        this.a = null;
    }

    @Override
    public void disconnectLink(IlvLinkImage ilvLinkImage, boolean bl) {
        super.disconnectLink(ilvLinkImage, bl);
        if (this.useCache(ilvLinkImage)) {
            this.cleanCache(ilvLinkImage);
        }
    }

    public void disconnectAllLinks() {
        this.b = null;
        this.a = null;
    }

    public void linkChanged(IlvLinkImage ilvLinkImage) {
        if (this.useCache(ilvLinkImage)) {
            this.cleanCache(ilvLinkImage);
        }
    }

    public static void LinkChanged(IlvLinkImage ilvLinkImage) {
        IlvLinkConnector ilvLinkConnector;
        IlvLinkConnector ilvLinkConnector2 = IlvLinkConnector.Get(ilvLinkImage, true);
        if (ilvLinkConnector2 != null && ilvLinkConnector2 instanceof IlvCachingLinkConnector) {
            ((IlvCachingLinkConnector)ilvLinkConnector2).linkChanged(ilvLinkImage);
        }
        if ((ilvLinkConnector = IlvLinkConnector.Get(ilvLinkImage, false)) != ilvLinkConnector2 && ilvLinkConnector != null && ilvLinkConnector instanceof IlvCachingLinkConnector) {
            ((IlvCachingLinkConnector)ilvLinkConnector).linkChanged(ilvLinkImage);
        }
    }

    public static void LinkRemoved(IlvLinkImage ilvLinkImage) {
        IlvLinkConnector ilvLinkConnector;
        IlvLinkConnector ilvLinkConnector2 = IlvLinkConnector.Get(ilvLinkImage, true);
        if (ilvLinkConnector2 != null && ilvLinkConnector2 instanceof IlvCachingLinkConnector) {
            ((IlvCachingLinkConnector)ilvLinkConnector2).cleanCache(ilvLinkImage);
        }
        if ((ilvLinkConnector = IlvLinkConnector.Get(ilvLinkImage, false)) != ilvLinkConnector2 && ilvLinkConnector != null && ilvLinkConnector instanceof IlvCachingLinkConnector) {
            ((IlvCachingLinkConnector)ilvLinkConnector).cleanCache(ilvLinkImage);
        }
    }

    protected void cleanCache(IlvLinkImage ilvLinkImage) {
        if (this.a != null) {
            this.a.remove(ilvLinkImage);
            if (this.a.size() == 0) {
                this.a = null;
            }
        }
        if (this.b != null) {
            this.b.remove(ilvLinkImage);
            if (this.b.size() == 0) {
                this.b = null;
            }
        }
    }

    protected void cleanCache() {
        this.b = null;
        this.a = null;
    }

    private IlvPoint a(IlvLinkImage ilvLinkImage, boolean bl, IlvTransformer ilvTransformer) {
        HashMap hashMap = this.a(ilvLinkImage, bl, false);
        if (hashMap == null) {
            return null;
        }
        Object v = hashMap.get(ilvLinkImage);
        if (v == null) {
            return null;
        }
        return ((LinkPointCache)v).a(ilvTransformer);
    }

    private void a(IlvLinkImage ilvLinkImage, boolean bl, IlvTransformer ilvTransformer, IlvPoint ilvPoint) {
        HashMap hashMap = this.a(ilvLinkImage, bl, true);
        LinkPointCache linkPointCache = (LinkPointCache)hashMap.get(ilvLinkImage);
        if (linkPointCache == null) {
            linkPointCache = new LinkPointCache(this.getCacheSize());
            hashMap.put(ilvLinkImage, linkPointCache);
        }
        linkPointCache.a(ilvTransformer, ilvPoint);
    }

    private HashMap a(IlvLinkImage ilvLinkImage, boolean bl, boolean bl2) {
        if (!bl && IlvLinkConnector.Get(ilvLinkImage, true) == IlvLinkConnector.Get(ilvLinkImage, false)) {
            if (bl2 && this.b == null) {
                this.b = new HashMap(4);
            }
            return this.b;
        }
        if (bl2 && this.a == null) {
            this.a = new HashMap(4);
        }
        return this.a;
    }

    static class LinkPointCache {
        IlvTransformer[] a;
        IlvPoint[] b;

        LinkPointCache(int n) {
            this.a = new IlvTransformer[n];
            this.b = new IlvPoint[n];
        }

        void a() {
            if (this.b != null) {
                this.b = new IlvPoint[this.b.length];
            }
        }

        strictfp IlvPoint a(IlvTransformer ilvTransformer) {
            double d = 0.0;
            double d2 = 0.0;
            IlvPoint ilvPoint = null;
            if (this.b == null) {
                return null;
            }
            if (ilvTransformer != null && ilvTransformer.isScale()) {
                d = ilvTransformer.getx0();
                d2 = ilvTransformer.gety0();
                ilvTransformer = new IlvTransformer(ilvTransformer.getx11(), 0.0, 0.0, ilvTransformer.getx22(), 0.0, 0.0);
            }
            if (ilvTransformer == null || ilvTransformer.isIdentity()) {
                ilvPoint = this.b[0];
            } else {
                for (int i = 1; i < this.a.length; ++i) {
                    if (!ilvTransformer.equals(this.a[i])) continue;
                    ilvPoint = this.b[i];
                    break;
                }
            }
            if (ilvPoint == null) {
                return null;
            }
            return new IlvPoint((float)((double)ilvPoint.x + d), (float)((double)ilvPoint.y + d2));
        }

        strictfp void a(IlvTransformer ilvTransformer, IlvPoint ilvPoint) {
            int n;
            if (this.b == null || this.a == null) {
                return;
            }
            if (ilvTransformer != null && ilvTransformer.isScale()) {
                double d = ilvTransformer.getx0();
                double d2 = ilvTransformer.gety0();
                if (ilvPoint != null) {
                    ilvPoint.x = (float)((double)ilvPoint.x - d);
                    ilvPoint.y = (float)((double)ilvPoint.y - d2);
                }
                ilvTransformer = new IlvTransformer(ilvTransformer.getx11(), 0.0, 0.0, ilvTransformer.getx22(), 0.0, 0.0);
            }
            if (ilvTransformer == null || ilvTransformer.isIdentity()) {
                this.b[0] = ilvPoint;
                return;
            }
            for (n = 1; n < this.a.length; ++n) {
                if (!ilvTransformer.equals(this.a[n])) continue;
                this.b[n] = ilvPoint;
                return;
            }
            n = this.a.length - 2;
            System.arraycopy(this.a, 1, this.a, 2, n);
            System.arraycopy(this.b, 1, this.b, 2, n);
            this.a[1] = new IlvTransformer(ilvTransformer);
            this.b[1] = ilvPoint;
        }
    }
}

