/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.objectinteractor;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvManager;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvReshapeSelection;
import ilog.views.IlvTextInterface;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvTextSelection;
import ilog.views.util.text.IlvAttributedStringUtil;
import ilog.views.util.text.IlvBidiUtil;
import ilog.views.util.text.IlvWrappedICUBreakIterator;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.AttributedString;
import java.text.BreakIterator;

public class IlvTextEditor
extends IlvReshapeSelection
implements ClipboardOwner {
    private transient int a = 0;
    transient int b = 0;
    transient int c = 0;
    transient BreakIterator d = null;
    transient String e = null;
    private static LabelSetter f = new LabelSetter();

    @Override
    public boolean processEvent(IlvGraphic ilvGraphic, AWTEvent aWTEvent, IlvObjectInteractorContext ilvObjectInteractorContext) {
        if (!(ilvGraphic instanceof IlvTextSelection)) {
            return false;
        }
        IlvTextSelection ilvTextSelection = (IlvTextSelection)ilvGraphic;
        if (ilvTextSelection.supportsResize() && super.processEvent(ilvGraphic, aWTEvent, ilvObjectInteractorContext)) {
            return true;
        }
        if (!(ilvTextSelection.getObject() instanceof IlvTextInterface)) {
            return false;
        }
        IlvTextInterface ilvTextInterface = (IlvTextInterface)((Object)ilvTextSelection.getObject());
        if (aWTEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            IlvTransformer ilvTransformer = ilvObjectInteractorContext.getTransformer();
            IlvPoint ilvPoint = new IlvPoint(mouseEvent.getX(), mouseEvent.getY());
            if (mouseEvent.getID() == 503) {
                Cursor cursor = null;
                if (ilvTextSelection.isOnBorder(ilvPoint, ilvTransformer)) {
                    int n = 0;
                    if (ilvTextSelection.supportsResize()) {
                        n = ilvTextSelection.direction(ilvPoint, ilvTransformer);
                    }
                    cursor = n != 0 ? this.getCursor(n) : Cursor.getPredefinedCursor(13);
                } else {
                    cursor = Cursor.getPredefinedCursor(2);
                }
                if (cursor != null && cursor != ilvObjectInteractorContext.getCursor()) {
                    ilvObjectInteractorContext.setCursor(cursor);
                }
            }
            if (ilvTextSelection.isOnBorder(ilvPoint, ilvTransformer)) {
                return false;
            }
            if (!ilvTextSelection.isEditable()) {
                return false;
            }
            switch (mouseEvent.getID()) {
                case 501: {
                    this.b = ilvTextInterface.pickCharacter(ilvPoint, ilvTransformer);
                    this.a(this.a(aWTEvent));
                    this.a(ilvTextInterface, this.b);
                    this.a(ilvTextSelection);
                    this.b(ilvTextSelection);
                    return true;
                }
                case 506: {
                    this.b = ilvTextInterface.pickCharacter(ilvPoint, ilvTransformer);
                    this.a(ilvTextInterface, this.b);
                    this.a(ilvTextSelection);
                    this.b(ilvTextSelection);
                    return true;
                }
            }
            return false;
        }
        if (aWTEvent instanceof KeyEvent) {
            boolean bl = false;
            if (!ilvTextSelection.isEditable()) {
                return false;
            }
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            switch (keyEvent.getID()) {
                case 400: {
                    bl = this.b(keyEvent, ilvTextSelection, ilvTextInterface);
                    break;
                }
                case 401: {
                    bl = this.a(keyEvent, ilvTextSelection, ilvTextInterface);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (bl) {
                ((KeyEvent)aWTEvent).consume();
            }
            return bl;
        }
        return false;
    }

    private void a(boolean bl) {
        if (!bl) {
            this.a = this.b;
        }
    }

    private boolean a(KeyEvent keyEvent, IlvTextSelection ilvTextSelection, IlvTextInterface ilvTextInterface) {
        String string = ilvTextInterface.getLabel();
        IlvTextSelection.Range range = ilvTextSelection.getRange();
        if (range.isEmpty()) {
            return false;
        }
        int n = keyEvent.getKeyCode();
        if (keyEvent.getModifiers() == 3) {
            if (!(ilvTextInterface instanceof IlvGraphic)) {
                return true;
            }
            IlvGraphic ilvGraphic = (IlvGraphic)((Object)ilvTextInterface);
            if (!IlvBidiUtil.isAdvancedBidiOn()) {
                return true;
            }
            int n2 = ilvGraphic.getResolvedBaseTextDirection();
            String string2 = ilvTextInterface.getLabel();
            switch (n) {
                case 40: {
                    if (n2 == 527) {
                        return false;
                    }
                    ilvGraphic.setBaseTextDirection(527);
                    this.a(ilvGraphic, string2);
                    return false;
                }
                case 39: {
                    if (n2 == 516) {
                        return false;
                    }
                    ilvGraphic.setBaseTextDirection(516);
                    this.a(ilvGraphic, string2);
                    return false;
                }
                case 37: {
                    if (n2 == 520) {
                        return false;
                    }
                    ilvGraphic.setBaseTextDirection(520);
                    this.a(ilvGraphic, string2);
                    return false;
                }
                case 38: {
                    if (n2 == 514) {
                        return false;
                    }
                    ilvGraphic.setBaseTextDirection(514);
                    this.a(ilvGraphic, string2);
                    return false;
                }
            }
            return true;
        }
        if (keyEvent.getModifiers() == 2) {
            switch (n) {
                case 67: {
                    if (range.isCollapsed()) {
                        return true;
                    }
                    this.copySelection(ilvTextInterface, range.from, range.to);
                    return true;
                }
                case 86: {
                    Object object = this.b();
                    if (object == null) {
                        return true;
                    }
                    int n3 = 0;
                    if (object instanceof String) {
                        n3 = ((String)object).length();
                    } else if (object instanceof AttributedString) {
                        n3 = IlvAttributedStringUtil.length((AttributedString)object);
                    }
                    if (n3 == 0) {
                        return true;
                    }
                    IlvTextSelection.Range range2 = new IlvTextSelection.Range(range.from, range.to);
                    this.b = range.from + n3;
                    this.a(false);
                    this.a(ilvTextInterface, this.b);
                    if (object instanceof String) {
                        this.replaceSelection(ilvTextInterface, range2.from, range2.to, (String)object);
                    } else {
                        this.replaceSelection(ilvTextInterface, range2.from, range2.to, (AttributedString)object);
                    }
                    this.a(ilvTextSelection);
                    return true;
                }
            }
        }
        switch (n) {
            case 37: {
                if (!this.a(ilvTextInterface)) {
                    this.b(ilvTextInterface);
                } else {
                    this.c(ilvTextInterface);
                }
                this.a(this.a(keyEvent));
                this.a(ilvTextInterface, this.b);
                this.a(ilvTextSelection);
                this.b(ilvTextSelection);
                return true;
            }
            case 39: {
                if (!this.a(ilvTextInterface)) {
                    this.c(ilvTextInterface);
                } else {
                    this.b(ilvTextInterface);
                }
                this.a(this.a(keyEvent));
                this.a(ilvTextInterface, this.b);
                this.a(ilvTextSelection);
                this.b(ilvTextSelection);
                return true;
            }
            case 38: {
                this.e(ilvTextInterface);
                this.a(this.a(keyEvent));
                this.a(ilvTextInterface, this.b);
                this.a(ilvTextSelection);
                this.b(ilvTextSelection);
                return true;
            }
            case 40: {
                this.d(ilvTextInterface);
                this.a(this.a(keyEvent));
                this.a(ilvTextInterface, this.b);
                this.a(ilvTextSelection);
                this.b(ilvTextSelection);
                return true;
            }
            case 127: {
                int n4 = string.length();
                if (n4 == 0) {
                    return true;
                }
                if (range.isCollapsed() && range.from == n4) {
                    return true;
                }
                int n5 = range.from;
                int n6 = range.to;
                if (range.isCollapsed()) {
                    this.b(string);
                    ++n6;
                    while (n6 < n4 && this.d != null && !this.d.isBoundary(n6)) {
                        ++n6;
                    }
                    this.deleteSelection(ilvTextInterface, n5, n6);
                } else {
                    this.b = range.from;
                    this.a(false);
                    this.a(ilvTextInterface, this.b);
                    this.deleteSelection(ilvTextInterface, n5, n6);
                    this.a(ilvTextSelection);
                }
                keyEvent.consume();
                return true;
            }
        }
        return true;
    }

    private final boolean a(IlvTextInterface ilvTextInterface) {
        return IlvBidiUtil.isStringRTL((IlvGraphic)((Object)ilvTextInterface), ilvTextInterface.getLabel(), ((IlvGraphic)((Object)ilvTextInterface)).getComponentOrientation());
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    Object b() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable == null) {
            return "";
        }
        DataFlavor[] dataFlavorArray = new DataFlavor[]{IlvAttributedStringUtil.ATTRIBUTED_STRING_FLAVOR, DataFlavor.stringFlavor};
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!transferable.isDataFlavorSupported(dataFlavorArray[i])) continue;
            try {
                return transferable.getTransferData(dataFlavorArray[i]);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "";
    }

    void a(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    private boolean b(KeyEvent keyEvent, IlvTextSelection ilvTextSelection, IlvTextInterface ilvTextInterface) {
        String string = ilvTextInterface.getLabel();
        IlvTextSelection.Range range = ilvTextSelection.getRange();
        if (range.isEmpty()) {
            return false;
        }
        if (keyEvent.getModifiers() == 2) {
            return false;
        }
        if (keyEvent.getModifiers() == 3) {
            return false;
        }
        char c = keyEvent.getKeyChar();
        switch (c) {
            case '\uffff': {
                return false;
            }
            case '\u001b': {
                range.setRange(-1, -1);
                ilvTextSelection.setRange(range);
                this.b(ilvTextSelection);
                return true;
            }
            case '\u007f': {
                return true;
            }
            case '\b': {
                if (string.length() == 0) {
                    return true;
                }
                if (range.isCollapsed() && range.from == (((IlvGraphic)((Object)ilvTextInterface)).usesBidiMarkers() ? 1 : 0)) {
                    return true;
                }
                int n = range.from;
                int n2 = range.to;
                if (range.isCollapsed()) {
                    --n;
                    this.b = Math.max(0, range.from - 1);
                } else {
                    this.b = range.from;
                }
                this.a(false);
                this.a(ilvTextInterface, this.b);
                this.deleteSelection(ilvTextInterface, n, n2);
                this.a(ilvTextSelection);
                return true;
            }
        }
        int n = range.from;
        int n3 = range.to;
        if (ilvTextInterface.getLabel().length() == 0 && ((IlvGraphic)((Object)ilvTextInterface)).usesBidiMarkers()) {
            n3 = 1;
            n = 1;
        }
        this.b = n + 1;
        this.a(false);
        this.a(ilvTextInterface, this.b);
        this.replaceSelection(ilvTextInterface, n, n3, "" + c);
        this.a(ilvTextSelection);
        return true;
    }

    private boolean a(AWTEvent aWTEvent) {
        if (aWTEvent instanceof InputEvent) {
            return ((InputEvent)aWTEvent).getModifiers() == 1;
        }
        return false;
    }

    private void b(String string) {
        if (string == null) {
            this.d = null;
            this.e = null;
        } else if (this.d == null || !string.equals(this.e)) {
            this.d = IlvWrappedICUBreakIterator.getCharacterInstance();
            this.d.setText(string);
            this.e = string;
        }
    }

    private void a(IlvTextInterface ilvTextInterface, int n) {
        int n2 = this.c(ilvTextInterface, n);
        this.c = n - ilvTextInterface.lineOffset(n2);
    }

    private static int b(IlvTextInterface ilvTextInterface, int n) {
        int n2 = ilvTextInterface.lineCount();
        if (n2 == 1 || n < 0 || n >= n2 - 1) {
            return ilvTextInterface.getLabel().length() - 1;
        }
        return ilvTextInterface.lineOffset(n + 1) - 1;
    }

    private void a(IlvTextSelection ilvTextSelection) {
        int n;
        IlvTextInterface ilvTextInterface = (IlvTextInterface)((Object)ilvTextSelection.getObject());
        int n2 = ilvTextInterface.getLabel().length();
        int n3 = Math.max(this.a, this.b);
        this.b(ilvTextInterface.getLabel());
        for (n = Math.min(this.a, this.b); n < n2 && this.d != null && !this.d.isBoundary(n); ++n) {
        }
        while (n3 < n2 && this.d != null && !this.d.isBoundary(n3)) {
            ++n3;
        }
        ilvTextSelection.setRange(new IlvTextSelection.Range(n, n3));
    }

    private void b(IlvTextSelection ilvTextSelection) {
        ilvTextSelection.reDraw();
    }

    private void b(IlvTextInterface ilvTextInterface) {
        int n = !((IlvGraphic)((Object)ilvTextInterface)).usesBidiMarkers() ? 0 : 1;
        this.b = Math.max(n, this.b - 1);
        this.b(ilvTextInterface.getLabel());
        while (this.b > n && this.d != null && !this.d.isBoundary(this.b)) {
            --this.b;
        }
    }

    private void c(IlvTextInterface ilvTextInterface) {
        int n = !((IlvGraphic)((Object)ilvTextInterface)).usesBidiMarkers() ? ilvTextInterface.getLabel().length() : ilvTextInterface.getLabel().length() + 1;
        this.b = Math.min(n, this.b + 1);
        this.b(ilvTextInterface.getLabel());
        while (this.b < n && this.d != null && !this.d.isBoundary(this.b)) {
            ++this.b;
        }
    }

    private void d(IlvTextInterface ilvTextInterface) {
        int n = this.c(ilvTextInterface, this.b);
        if (n == ilvTextInterface.lineCount() - 1) {
            return;
        }
        int n2 = n + 1;
        int n3 = ilvTextInterface.lineOffset(n2) + this.c;
        int n4 = IlvTextEditor.b(ilvTextInterface, n2);
        this.b = Math.min(n4, n3);
        this.b(ilvTextInterface.getLabel());
        while (this.b < n4 && this.d != null && !this.d.isBoundary(this.b)) {
            ++this.b;
        }
    }

    private void e(IlvTextInterface ilvTextInterface) {
        int n = this.c(ilvTextInterface, this.b);
        if (n == 0) {
            return;
        }
        int n2 = n - 1;
        int n3 = ilvTextInterface.lineOffset(n2) + this.c;
        int n4 = IlvTextEditor.b(ilvTextInterface, n2);
        this.b = Math.min(n4, n3);
        this.b(ilvTextInterface.getLabel());
        while (this.b > ilvTextInterface.lineOffset(n2) && this.d != null && !this.d.isBoundary(this.b)) {
            --this.b;
        }
    }

    private int c(IlvTextInterface ilvTextInterface, int n) {
        if (ilvTextInterface.lineCount() == 1) {
            return 0;
        }
        int n2 = ilvTextInterface.lineCount();
        int n3 = n2 - 1;
        if (n >= ilvTextInterface.lineOffset(n3)) {
            return n3;
        }
        for (int i = 1; i <= n3; ++i) {
            if (n >= ilvTextInterface.lineOffset(i)) continue;
            return i - 1;
        }
        return n3;
    }

    protected void deleteSelection(IlvTextInterface ilvTextInterface, int n, int n2) {
        String string = ilvTextInterface.getLabel();
        if (((IlvGraphic)((Object)ilvTextInterface)).usesBidiMarkers()) {
            --n;
            --n2;
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= string.length()) {
            return;
        }
        String string2 = n2 >= string.length() || n2 <= n ? string.substring(0, n) : string.substring(0, n) + string.substring(n2);
        this.a((IlvGraphic)((Object)ilvTextInterface), string2);
    }

    protected void replaceSelection(IlvTextInterface ilvTextInterface, int n, int n2, String string) {
        String string2 = ilvTextInterface.getLabel();
        if (((IlvGraphic)((Object)ilvTextInterface)).usesBidiMarkers()) {
            --n;
            --n2;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > string2.length()) {
            n = string2.length();
        }
        String string3 = n2 >= string2.length() || n2 < n ? string2.substring(0, n) + string : string2.substring(0, n) + string + string2.substring(n2);
        this.a((IlvGraphic)((Object)ilvTextInterface), string3);
    }

    protected void replaceSelection(IlvTextInterface ilvTextInterface, int n, int n2, AttributedString attributedString) {
        this.replaceSelection(ilvTextInterface, n, n2, IlvAttributedStringUtil.getString(attributedString));
    }

    protected void copySelection(IlvTextInterface ilvTextInterface, int n, int n2) {
        if (((IlvGraphic)((Object)ilvTextInterface)).usesBidiMarkers()) {
            --n;
            --n2;
        }
        if (n < 0) {
            return;
        }
        String string = ilvTextInterface.getLabel();
        if (n2 >= string.length()) {
            n2 = string.length();
        }
        if (n >= n2) {
            return;
        }
        String string2 = string.substring(n, n2);
        StringSelection stringSelection = new StringSelection(string2);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvGraphic ilvGraphic, String string) {
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        IlvGraphicBag ilvGraphicBag2 = ilvGraphic.getTopLevelGraphicBag();
        IlvManager ilvManager = null;
        if (ilvGraphicBag2 != ilvGraphicBag && ilvGraphicBag2 != null) {
            ilvManager = (IlvManager)ilvGraphicBag2;
            ilvManager.setContentsAdjusting(true);
        }
        try {
            ilvGraphicBag.applyToObject(ilvGraphic, f, string, true);
        }
        finally {
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(false);
            }
        }
    }

    private static final class LabelSetter
    implements IlvApplyObject {
        @Override
        public void apply(IlvGraphic ilvGraphic, Object object) {
            String string = (String)object;
            if (!(ilvGraphic instanceof IlvLabelInterface)) {
                throw new IllegalArgumentException("object must implement IlvLabelInterface");
            }
            ((IlvLabelInterface)((Object)ilvGraphic)).setLabel(string);
        }
    }
}

