/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.collections;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import java.util.Queue;

public class IlvUnsynchronizedStack<E>
extends ArrayList<E>
implements Queue<E> {
    public IlvUnsynchronizedStack(int n) {
        super(n);
    }

    public IlvUnsynchronizedStack() {
    }

    @Override
    public Object clone() {
        IlvUnsynchronizedStack ilvUnsynchronizedStack = (IlvUnsynchronizedStack)super.clone();
        return ilvUnsynchronizedStack;
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public E poll() {
        int n = this.size();
        if (n == 0) {
            return null;
        }
        return this.remove(n - 1);
    }

    @Override
    public E remove() {
        try {
            return this.remove(this.size() - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public E peek() {
        int n = this.size();
        if (n == 0) {
            return null;
        }
        return this.get(n - 1);
    }

    @Override
    public E element() {
        try {
            return this.get(this.size() - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
    }

    public E push(E e) {
        this.add(e);
        return e;
    }

    public E pop() {
        try {
            return this.remove(this.size() - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new EmptyStackException();
        }
    }

    public boolean empty() {
        return this.size() == 0;
    }
}

