/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.data;

import ilog.views.util.data.TableModelDelegate;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

class DirectTableModelDelegate
implements TableModelDelegate {
    static final String a = "cannot connect to the result set";
    protected ResultSet _resultSet;
    protected ResultSetMetaData _metadata;
    protected int _rowCount = -1;

    public DirectTableModelDelegate(ResultSet resultSet) {
        this._resultSet = resultSet;
        try {
            this._metadata = resultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            Logger.getLogger("ilog.views.util.data").log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        this._rowCount = this.computeRowCount();
    }

    protected int computeRowCount() {
        return DirectTableModelDelegate.a(this._resultSet);
    }

    @Override
    public void join() {
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        try {
            if (!this.advanceResultSetTo(n)) {
                Logger.getLogger("ilog.views.util.data").log(Level.WARNING, "rowIndex: " + n + " is not available");
                throw new RuntimeException("rowIndex: " + n + " is not available");
            }
            object = this._resultSet.getObject(n2 + 1);
        }
        catch (SQLException sQLException) {
            Logger.getLogger("ilog.views.util.data").log(Level.WARNING, sQLException.getMessage(), sQLException);
            throw new RuntimeException(a, sQLException);
        }
        return object;
    }

    @Override
    public int getRowCount() {
        return this._rowCount;
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        return this._metadata.getColumnLabel(n + 1);
    }

    @Override
    public int getColumnCount() {
        try {
            return this._metadata.getColumnCount();
        }
        catch (SQLException sQLException) {
            Logger.getLogger("ilog.views.util.data").log(Level.WARNING, sQLException.getMessage(), sQLException);
            return 0;
        }
    }

    @Override
    public Class getColumnClass(int n) throws Exception {
        return Class.forName(this._metadata.getColumnClassName(n + 1));
    }

    protected boolean advanceResultSetTo(int n) throws SQLException {
        return DirectTableModelDelegate.a(this._resultSet, n);
    }

    static int a(ResultSet resultSet) {
        int n = -1;
        try {
            resultSet.last();
            n = resultSet.getRow();
            resultSet.beforeFirst();
        }
        catch (SQLException sQLException) {
            Logger.getLogger("ilog.views.util.data").log(Level.WARNING, sQLException.getMessage(), sQLException);
            throw new RuntimeException(a, sQLException);
        }
        return n;
    }

    static boolean a(ResultSet resultSet, int n) throws SQLException {
        int n2 = resultSet.getRow();
        if (n2 != 1 && n == 0) {
            resultSet.first();
        } else {
            if (n2 != 0 && n2 == n) {
                return resultSet.next();
            }
            if (n2 != n + 1) {
                return resultSet.absolute(n + 1);
            }
        }
        return true;
    }
}

