/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.data;

import ilog.views.util.data.DirectTableModelDelegate;
import ilog.views.util.data.IlvRowSetTableModel;
import ilog.views.util.data.IlvTableModelEvent;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSet;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.spi.SyncProviderException;

class RowSetTableModelDelegate
extends DirectTableModelDelegate {
    protected IlvRowSetTableModel _model;

    public RowSetTableModelDelegate(IlvRowSetTableModel ilvRowSetTableModel) {
        super(ilvRowSetTableModel.getRowSet());
        this._model = ilvRowSetTableModel;
    }

    @Override
    public int getRowCount() {
        try {
            int n = ((RowSet)this._resultSet).getMaxRows();
            if (n == 0) {
                return this._rowCount;
            }
            return Math.min(this._rowCount, n);
        }
        catch (SQLException sQLException) {
            Logger.getLogger("ilog.views.util.data").log(Level.WARNING, sQLException.getMessage(), sQLException);
            return 0;
        }
    }

    @Override
    protected int computeRowCount() {
        if (this._resultSet instanceof CachedRowSet) {
            return this.getCachedRowSet().size();
        }
        return DirectTableModelDelegate.a(this._resultSet);
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        try {
            bl = this._metadata.isWritable(n2 + 1);
        }
        catch (SQLException sQLException) {
            Logger.getLogger("ilog.views.util.data").log(Level.WARNING, sQLException.getMessage(), sQLException);
        }
        return bl;
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            this.advanceResultSetTo(n);
            this._resultSet.updateObject(n2 + 1, object);
            this._resultSet.updateRow();
            this.a();
            this._model.fireTableCellUpdated(n, n2);
        }
        catch (SyncProviderException syncProviderException) {
            Logger.getLogger("ilog.views.util.data").log(Level.WARNING, syncProviderException.getMessage(), syncProviderException);
            throw new RuntimeException(syncProviderException.getMessage(), syncProviderException);
        }
        catch (SQLException sQLException) {
            Logger.getLogger("ilog.views.util.data").log(Level.WARNING, sQLException.getMessage(), sQLException);
            throw new RuntimeException("cannot connect to the result set", sQLException);
        }
    }

    public void addRow(Object[] objectArray) {
        try {
            this.advanceResultSetTo(this.getRowCount() - 1);
            int n = this.computeInsertRow();
            this._resultSet.moveToInsertRow();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    this._resultSet.updateObject(i + 1, objectArray[i]);
                }
            }
            this._resultSet.insertRow();
            this._resultSet.moveToCurrentRow();
            this.afterInsertRow();
            ++this._rowCount;
            this._model.fireTableRowsInserted(n, n);
        }
        catch (SyncProviderException syncProviderException) {
            Logger.getLogger("ilog.views.util.data").log(Level.WARNING, syncProviderException.getMessage(), syncProviderException);
            throw new RuntimeException(syncProviderException.getMessage(), syncProviderException);
        }
        catch (SQLException sQLException) {
            Logger.getLogger("ilog.views.util.data").log(Level.WARNING, sQLException.getMessage(), sQLException);
            throw new RuntimeException("cannot connect to the result set", sQLException);
        }
    }

    public void removeRow(int n) {
        IlvTableModelEvent.fireBeforeTableRowsDeleted(this._model, n, n);
        try {
            this.advanceResultSetTo(n);
            this._resultSet.deleteRow();
            this.afterRemoveRow();
            --this._rowCount;
            this._model.fireTableRowsDeleted(n, n);
        }
        catch (SyncProviderException syncProviderException) {
            Logger.getLogger("ilog.views.util.data").log(Level.WARNING, syncProviderException.getMessage(), syncProviderException);
            throw new RuntimeException(syncProviderException.getMessage(), syncProviderException);
        }
        catch (SQLException sQLException) {
            Logger.getLogger("ilog.views.util.data").log(Level.WARNING, sQLException.getMessage(), sQLException);
            throw new RuntimeException("cannot connect to the result set", sQLException);
        }
    }

    protected int computeInsertRow() throws SQLException {
        return this._resultSet.getRow();
    }

    protected void afterInsertRow() throws SQLException {
        this.a();
        if (this._model.isAutoCommit() && this._resultSet instanceof CachedRowSet) {
            this._model.refreshRows();
        }
    }

    protected void afterRemoveRow() throws SQLException {
        this.a();
        this._resultSet.first();
    }

    protected CachedRowSet getCachedRowSet() {
        return (CachedRowSet)this._resultSet;
    }

    private void a() throws SyncProviderException {
        if (this._model.isAutoCommit() && this._resultSet instanceof CachedRowSet) {
            this.performAcceptChanges();
        }
    }

    protected void performAcceptChanges() throws SyncProviderException {
        if (!this.getCachedRowSet().isReadOnly()) {
            this.getCachedRowSet().acceptChanges();
        }
    }
}

