/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.java2d;

import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class IlvContrastingColor
extends Color
implements Composite {
    private final Color a;
    private final Color b;
    private final float c;
    private final float d;
    public static final RenderingHints.Key KNOWN_BACKGROUND_COLOR = KnownBackgroundColorKey.a;

    public IlvContrastingColor(Color color, Color color2, float f) {
        super(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        this.a = color;
        this.b = color2;
        this.c = f;
        this.d = f * 255.0f;
    }

    public IlvContrastingColor() {
        this(Color.black, Color.white, 0.5f);
    }

    public Color getDarkColor() {
        return this.a;
    }

    public Color getBrightColor() {
        return this.b;
    }

    public float getThreshold() {
        return this.c;
    }

    public Color chooseColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        float f = 0.299f * (float)n + 0.587f * (float)n2 + 0.114f * (float)n3;
        return f >= this.d ? this.a : this.b;
    }

    @Override
    public CompositeContext createContext(ColorModel colorModel, final ColorModel colorModel2, RenderingHints renderingHints) {
        return new CompositeContext(){
            private Object a;
            private Object b;
            private int c;
            private int d;
            {
                this.a = colorModel2.getDataElements(IlvContrastingColor.this.a.getRGB(), null);
                this.b = colorModel2.getDataElements(IlvContrastingColor.this.b.getRGB(), null);
                switch (colorModel2.getTransferType()) {
                    case 0: {
                        this.c = ((byte[])this.a)[0] & 0xFF;
                        this.d = ((byte[])this.b)[0] & 0xFF;
                        break;
                    }
                    case 1: {
                        this.c = ((short[])this.a)[0] & 0xFFFF;
                        this.d = ((short[])this.b)[0] & 0xFFFF;
                        break;
                    }
                    case 3: {
                        this.c = ((int[])this.a)[0];
                        this.d = ((int[])this.b)[0];
                    }
                }
            }

            private void a(Raster raster, Raster raster2, WritableRaster writableRaster) {
                int n = raster.getMinX();
                int n2 = raster.getMinY();
                int n3 = raster2.getMinX();
                int n4 = raster2.getMinY();
                int n5 = writableRaster.getMinX();
                int n6 = writableRaster.getMinY();
                int n7 = Math.min(raster.getWidth(), raster2.getWidth());
                int n8 = Math.min(raster.getHeight(), writableRaster.getHeight());
                Object var12_12 = null;
                Object object = null;
                Object object2 = null;
                for (int i = 0; i < n8; ++i) {
                    for (int j = 0; j < n7; ++j) {
                        object = raster2.getDataElements(n3 + j, n4 + i, object);
                        Color color = new Color(colorModel2.getRGB(object));
                        Color color2 = IlvContrastingColor.this.chooseColor(color);
                        object2 = colorModel2.getDataElements(color2.getRGB(), object2);
                        writableRaster.setDataElements(n5 + j, n6 + i, object2);
                    }
                }
            }

            private void b(Raster raster, Raster raster2, WritableRaster writableRaster) {
                int n = raster.getMinX();
                int n2 = raster.getMinY();
                int n3 = raster2.getMinX();
                int n4 = raster2.getMinY();
                int n5 = writableRaster.getMinX();
                int n6 = writableRaster.getMinY();
                int n7 = Math.min(raster.getWidth(), raster2.getWidth());
                int n8 = Math.min(raster.getHeight(), writableRaster.getHeight());
                Object var12_12 = null;
                Object object = null;
                int n9 = 0xFFFFFF;
                Object object2 = this.a;
                for (int i = 0; i < n8; ++i) {
                    for (int j = 0; j < n7; ++j) {
                        Object object3;
                        int n10 = colorModel2.getRGB(object = raster2.getDataElements(n3 + j, n4 + i, object));
                        if (n10 == n9) {
                            object3 = object2;
                        } else {
                            int n11 = (n10 & 0xFF0000) >> 16;
                            int n12 = (n10 & 0xFF00) >> 8;
                            int n13 = n10 & 0xFF;
                            float f = 0.299f * (float)n11 + 0.587f * (float)n12 + 0.114f * (float)n13;
                            object3 = f >= IlvContrastingColor.this.d ? this.a : this.b;
                            n9 = n10;
                            object2 = object3;
                        }
                        writableRaster.setDataElements(n5 + j, n6 + i, object3);
                    }
                }
            }

            private void c(Raster raster, Raster raster2, WritableRaster writableRaster) {
                int n = raster.getMinX();
                int n2 = raster.getMinY();
                int n3 = raster2.getMinX();
                int n4 = raster2.getMinY();
                int n5 = writableRaster.getMinX();
                int n6 = writableRaster.getMinY();
                int n7 = Math.min(raster.getWidth(), raster2.getWidth());
                int n8 = Math.min(raster.getHeight(), writableRaster.getHeight());
                int n9 = 0xFFFFFF;
                int n10 = this.c;
                switch (colorModel2.getTransferType()) {
                    case 0: {
                        byte[] byArray = new byte[n7];
                        for (int i = 0; i < n8; ++i) {
                            byArray = (byte[])raster2.getDataElements(n3, n4 + i, n7, 1, byArray);
                            for (int j = 0; j < n7; ++j) {
                                int n11;
                                int n12 = byArray[j] & 0xFF;
                                int n13 = colorModel2.getRGB(n12);
                                if (n13 == n9) {
                                    n11 = n10;
                                } else {
                                    int n14 = (n13 & 0xFF0000) >> 16;
                                    int n15 = (n13 & 0xFF00) >> 8;
                                    int n16 = n13 & 0xFF;
                                    float f = 0.299f * (float)n14 + 0.587f * (float)n15 + 0.114f * (float)n16;
                                    n11 = f >= IlvContrastingColor.this.d ? this.c : this.d;
                                    n9 = n13;
                                    n10 = n11;
                                }
                                byArray[j] = (byte)n11;
                            }
                            writableRaster.setDataElements(n5, n6 + i, n7, 1, byArray);
                        }
                        break;
                    }
                    case 1: {
                        short[] sArray = new short[n7];
                        for (int i = 0; i < n8; ++i) {
                            sArray = (short[])raster2.getDataElements(n3, n4 + i, n7, 1, sArray);
                            for (int j = 0; j < n7; ++j) {
                                int n17;
                                int n18 = sArray[j] & 0xFFFF;
                                int n19 = colorModel2.getRGB(n18);
                                if (n19 == n9) {
                                    n17 = n10;
                                } else {
                                    int n20 = (n19 & 0xFF0000) >> 16;
                                    int n21 = (n19 & 0xFF00) >> 8;
                                    int n22 = n19 & 0xFF;
                                    float f = 0.299f * (float)n20 + 0.587f * (float)n21 + 0.114f * (float)n22;
                                    n17 = f >= IlvContrastingColor.this.d ? this.c : this.d;
                                    n9 = n19;
                                    n10 = n17;
                                }
                                sArray[j] = (short)n17;
                            }
                            writableRaster.setDataElements(n5, n6 + i, n7, 1, sArray);
                        }
                        break;
                    }
                    case 3: {
                        int[] nArray = new int[n7];
                        for (int i = 0; i < n8; ++i) {
                            nArray = (int[])raster2.getDataElements(n3, n4 + i, n7, 1, nArray);
                            for (int j = 0; j < n7; ++j) {
                                int n23;
                                int n24 = nArray[j];
                                int n25 = colorModel2.getRGB(n24);
                                if (n25 == n9) {
                                    n23 = n10;
                                } else {
                                    int n26 = (n25 & 0xFF0000) >> 16;
                                    int n27 = (n25 & 0xFF00) >> 8;
                                    int n28 = n25 & 0xFF;
                                    float f = 0.299f * (float)n26 + 0.587f * (float)n27 + 0.114f * (float)n28;
                                    n23 = f >= IlvContrastingColor.this.d ? this.c : this.d;
                                    n9 = n25;
                                    n10 = n23;
                                }
                                nArray[j] = n23;
                            }
                            writableRaster.setDataElements(n5, n6 + i, n7, 1, nArray);
                        }
                        break;
                    }
                    default: {
                        this.b(raster, raster2, writableRaster);
                    }
                }
            }

            private void d(Raster raster, Raster raster2, WritableRaster writableRaster) {
                Object object;
                Object[] objectArray;
                int n = raster.getMinX();
                int n2 = raster.getMinY();
                int n3 = raster2.getMinX();
                int n4 = raster2.getMinY();
                int n5 = writableRaster.getMinX();
                int n6 = writableRaster.getMinY();
                int n7 = Math.min(raster.getWidth(), raster2.getWidth());
                int n8 = Math.min(raster.getHeight(), writableRaster.getHeight());
                int n9 = colorModel2.getNumComponents();
                switch (colorModel2.getTransferType()) {
                    case 2: {
                        objectArray = new short[n9];
                        object = new short[n7 * n9];
                        break;
                    }
                    case 4: {
                        objectArray = new float[n9];
                        object = new float[n7 * n9];
                        break;
                    }
                    case 5: {
                        objectArray = new double[n9];
                        object = new double[n7 * n9];
                        break;
                    }
                    case 0: {
                        objectArray = new byte[n9];
                        object = new byte[n7 * n9];
                        break;
                    }
                    case 1: {
                        objectArray = new short[n9];
                        object = new short[n7 * n9];
                        break;
                    }
                    case 3: {
                        objectArray = new int[n9];
                        object = new int[n7 * n9];
                        break;
                    }
                    default: {
                        this.b(raster, raster2, writableRaster);
                        return;
                    }
                }
                int n10 = 0xFFFFFF;
                Object object2 = this.a;
                for (int i = 0; i < n8; ++i) {
                    object = raster2.getDataElements(n3, n4 + i, n7, 1, object);
                    int n11 = 0;
                    int n12 = 0;
                    while (n12 < n7) {
                        Object object3;
                        System.arraycopy(object, n11, objectArray, 0, n9);
                        int n13 = colorModel2.getRGB(objectArray);
                        if (n13 == n10) {
                            object3 = object2;
                        } else {
                            int n14 = (n13 & 0xFF0000) >> 16;
                            int n15 = (n13 & 0xFF00) >> 8;
                            int n16 = n13 & 0xFF;
                            float f = 0.299f * (float)n14 + 0.587f * (float)n15 + 0.114f * (float)n16;
                            object3 = f >= IlvContrastingColor.this.d ? this.a : this.b;
                            n10 = n13;
                            object2 = object3;
                        }
                        System.arraycopy(object3, 0, object, n11, n9);
                        ++n12;
                        n11 += n9;
                    }
                    writableRaster.setDataElements(n5, n6 + i, n7, 1, object);
                }
            }

            @Override
            public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
                if (colorModel2 instanceof DirectColorModel || colorModel2 instanceof IndexColorModel) {
                    this.c(raster, raster2, writableRaster);
                } else if (colorModel2 instanceof ComponentColorModel) {
                    this.d(raster, raster2, writableRaster);
                } else {
                    this.b(raster, raster2, writableRaster);
                }
            }

            @Override
            public void dispose() {
            }
        };
    }

    private static class KnownBackgroundColorKey
    extends RenderingHints.Key {
        static KnownBackgroundColorKey a = new KnownBackgroundColorKey(560442483);

        protected KnownBackgroundColorKey(int n) {
            super(n);
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            return object == null || object instanceof Color;
        }

        public String toString() {
            return "Known background color";
        }
    }
}

