/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectFactory;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

public abstract class AbstractDBObjectBuilder<T extends AbstractBuildableObject>
implements DBObjectBuilder<T> {
    static final Collection<String> s_specialProps = Arrays.asList("name", "ID", "parent", "properties", "schema", "type");
    private static final Iterator<String> s_tsKeyGen = DBUtil.getTimestampKeyGenerator(DBObjectBuilder.class.getName());
    private final AbstractDBObjectProvider m_pro;
    private final String m_type;
    private Boolean m_supportsTimestamp;
    private Map<String, Method> m_propMap;
    private MultiMap<String, String> m_derivedProperties;
    private final Map<T, Boolean> m_cancelled = new IdentityHashMap<T, Boolean>();

    protected AbstractDBObjectBuilder(AbstractDBObjectProvider abstractDBObjectProvider, String string) {
        this.m_type = string;
        this.m_pro = abstractDBObjectProvider;
        if (this.m_pro == null) {
            this.m_supportsTimestamp = false;
        }
    }

    protected final String getObjectType() {
        return this.m_type;
    }

    protected final AbstractDBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }

    @Override
    public boolean canBuildEditableObject() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelCurrentBuild(T t) {
        boolean bl = false;
        Map<T, Boolean> map = this.m_cancelled;
        synchronized (map) {
            if (Boolean.FALSE.equals(this.m_cancelled.get(t))) {
                this.m_cancelled.put(t, Boolean.TRUE);
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isCurrentBuildCancelled(T t) {
        Map<T, Boolean> map = this.m_cancelled;
        synchronized (map) {
            return Boolean.TRUE.equals(this.m_cancelled.get(t));
        }
    }

    protected void checkInterruptOrCancel(T t) throws CancelledException {
        if (Thread.currentThread().isInterrupted() || this.isCurrentBuildCancelled(t)) {
            throw new CancelledException();
        }
    }

    protected final Schema getSchema(String string) throws DBException {
        return this.m_pro.findSchema(string);
    }

    protected final SystemObject findObjectInProviderCache(String string, Schema schema, String string2) {
        return this.m_pro == null ? null : this.m_pro.findObject(string, schema, string2);
    }

    protected final SystemObject findObjectInProviderCache(DBObjectID dBObjectID) {
        return this.m_pro == null ? null : this.m_pro.findObject(dBObjectID);
    }

    protected final <D extends DBObject> D newObject(Class<? extends D> clazz, String string) {
        return this.newObject(clazz, null, string);
    }

    protected final <D extends DBObject> D newObject(Class<? extends D> clazz, DBObject dBObject, String string) {
        DBObjectFactory dBObjectFactory = this.getProvider().getObjectFactory();
        return dBObjectFactory.newObject(clazz, dBObject, string, false, false);
    }

    @Override
    public T createObject(String string, Schema schema, DBObjectID dBObjectID) {
        String string2 = this.getObjectType();
        Class<? extends DBObject> clazz = Metadata.getInstance().getObjectClass(string2);
        AbstractBuildableObject abstractBuildableObject = null;
        if (clazz != null) {
            try {
                AbstractBuildableObject abstractBuildableObject2 = (AbstractBuildableObject)this.newObject(clazz, schema, string);
                abstractBuildableObject2.setID(dBObjectID);
                abstractBuildableObject = abstractBuildableObject2;
            }
            catch (Exception exception) {
                DBLog.getLogger(this).log(Level.SEVERE, "Error instantiating object", exception);
            }
        }
        return (T)abstractBuildableObject;
    }

    protected Executor getPropertyExecutor(T t) {
        return null;
    }

    private void checkTimestamp(T t) {
        if (!(this instanceof DerivedPropertyBuilder) && this.m_pro != null && this.m_pro.supportsTimestamps(t.getType())) {
            AbstractBuildableObject abstractBuildableObject = null;
            try {
                DBObjectID dBObjectID = ((AbstractDBObject)t).getID();
                abstractBuildableObject = dBObjectID == null ? (AbstractBuildableObject)DBUtil.getProviderDefinition(t, (DBObjectProvider)this.m_pro) : (AbstractBuildableObject)dBObjectID.resolveID();
            }
            catch (DBException dBException) {
                DBLog.getLogger(this).log(Level.WARNING, "Couldn't lookup existing object: " + dBException.getMessage());
            }
            if (abstractBuildableObject == null) {
                DBLog.getLogger(this).log(Level.WARNING, "Building {0} {1} but it doesn't exist any more.", new String[]{t.getType(), ((AbstractDBObject)t).getName()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String startBuild(T t) {
        String string = null;
        Map<T, Boolean> map = this.m_cancelled;
        synchronized (map) {
            if (this.m_cancelled.get(t) == null) {
                string = s_tsKeyGen.next();
                this.m_cancelled.put(t, Boolean.FALSE);
            }
        }
        if (string != null) {
            DBUtil.suspendTimestampChecking(this.m_pro, string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishBuild(T t, String string) {
        Map<T, Boolean> map = this.m_cancelled;
        synchronized (map) {
            this.m_cancelled.remove(t);
        }
        DBUtil.resumeTimestampChecking(this.m_pro, string);
    }

    @Override
    public final void buildObject(T t) throws DBException {
        String string = this.startBuild(t);
        try {
            ((AbstractBuildableObject)t).getPropertySupport().setBuildingAll();
            this.checkTimestamp(t);
            this.fillInObject(t);
            ((AbstractBuildableObject)t).getPropertySupport().markAsBuilt();
            this.registerObject(t);
        }
        finally {
            if (string != null) {
                this.finishBuild(t, string);
            }
        }
    }

    protected void fillInObject(T t) throws DBException {
        if (this.canBuildComponents()) {
            for (String string : this.getPropertyMethodMap().keySet()) {
                this.ensureComponent(t, string);
            }
        }
        for (DBObject dBObject : ((AbstractDBObject)t).getOwnedObjects()) {
            if (!(dBObject instanceof AbstractBuildableObject)) continue;
            ((AbstractBuildableObject)dBObject).checkInit();
        }
    }

    protected void registerObject(T t) throws DBException {
        this.updateTimestamp(t);
        if (t instanceof SchemaObject) {
            CascadeManager cascadeManager;
            CascadeManager cascadeManager2 = cascadeManager = this.m_pro == null ? null : this.m_pro.getCascadeManager();
            if (cascadeManager instanceof SchemaObjectManager) {
                ((SchemaObjectManager)cascadeManager).registerObject((SystemObject)((SchemaObject)t), true);
            }
        }
    }

    @PropertyBuilder(value={"Timestamp"})
    public final void updateTimestamp(T t) throws DBException {
        this.updateTimestamp(t, false);
    }

    protected final void updateTimestamp(T t, boolean bl) throws DBException {
        if (this.m_supportsTimestamp == null) {
            this.m_supportsTimestamp = this.m_pro.supportsTimestamps(this.getObjectType());
        }
        if (this.m_supportsTimestamp.booleanValue() && t instanceof SystemObject) {
            if (bl) {
                this.m_pro.putCachedTimestampKey(((AbstractDBObject)t).getID(), null);
            }
            if (bl || DBUtil.getFrozenProperties(t).get("Timestamp") == null) {
                ((AbstractDBObject)t).setProperty("Timestamp", this.m_pro.getExternalTimestamp((SystemObject)t));
            }
        }
    }

    protected final boolean needsBuilding(T t, String string) {
        return this.needsBuilding(t, string, false);
    }

    public final boolean needsBuilding(T t, String string, boolean bl) {
        if (bl && !((AbstractBuildableObject)t).needsInitialization()) {
            return false;
        }
        return !((AbstractBuildableObject)t).isBuilt(string);
    }

    protected final void markAsBuilt(T t) {
        ((AbstractBuildableObject)t).getPropertySupport().markAsBuilt();
    }

    protected final void setBuilder(T t) {
        ((AbstractBuildableObject)t).getPropertySupport().setBuilder(this);
    }

    protected final void ensureComponent(T t, String string) throws DBException {
        if (this.needsBuilding(t, string)) {
            this.buildObjectComponent(t, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void buildObjectComponent(T t, String string) throws DBException {
        if (!this.isBuildableProperty(string)) return;
        if (this.canBuildComponents()) {
            String string2 = this.startBuild(t);
            try {
                if (!this.fillInObjectComponent(t, string)) return;
                this.registerObject(t);
                return;
            }
            finally {
                if (string2 != null) {
                    this.finishBuild(t, string2);
                }
            }
        } else {
            this.buildObject(t);
        }
    }

    protected final boolean fillInObjectComponent(T t, String string) throws DBException {
        this.checkInterruptOrCancel(t);
        boolean bl = false;
        if (this.isBuildableProperty(string)) {
            if (!"Timestamp".equals(string)) {
                this.checkTimestamp(t);
            }
            String[] stringArray = this.getBuiltProperties(string);
            try {
                ((AbstractBuildableObject)t).getPropertySupport().startBuilding(stringArray);
                String[] stringArray2 = this.getPropertyDependencies(string);
                if (stringArray2 != null) {
                    for (String string2 : stringArray2) {
                        this.ensureComponent(t, string2);
                    }
                }
                bl = this.fillInObjectComponentImpl(t, string);
                this.markAsBuilt(t, stringArray);
            }
            catch (DBException dBException) {
                if (dBException instanceof CancelledException || !this.isBuiltOnFailure(t, stringArray, dBException)) {
                    ((AbstractBuildableObject)t).getPropertySupport().setUnbuilt(stringArray);
                } else {
                    this.markAsBuilt(t, stringArray);
                }
                throw dBException;
            }
            finally {
                ((AbstractBuildableObject)t).getPropertySupport().finishBuilding(stringArray);
            }
        }
        return bl;
    }

    protected boolean isBuiltOnFailure(T t, String[] stringArray, DBException dBException) {
        return true;
    }

    protected final void markAsBuilt(T t, String ... stringArray) {
        ((AbstractBuildableObject)t).getPropertySupport().setBuilt(stringArray);
    }

    protected boolean fillInObjectComponentImpl(T t, String string) throws DBException {
        Method method = this.getPropertyMethodMap().get(string);
        return this.invokeBuilderMethod(method, t, string);
    }

    private boolean invokeBuilderMethod(Method method, T t, String string) throws DBException {
        boolean bl = true;
        try {
            Object object = method.invoke((Object)this, t);
            bl = !Boolean.FALSE.equals(object);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (throwable instanceof InvocationTargetException) {
                throwable2 = throwable.getCause();
            }
            if (throwable2 instanceof DBException) {
                throw (DBException)throwable2;
            }
            if (throwable2 instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                throw new CancelledException();
            }
            String string2 = "Build of property " + string + " failed: " + throwable2.getMessage();
            this.getLogger().log(DBLog.getExceptionLogLevel(), string2, throwable2);
            throw new DBException((DBObject)t, string2, throwable2);
        }
        return bl;
    }

    protected boolean canBuildComponents() {
        return false;
    }

    @Override
    public boolean isBuildableProperty(String string) {
        boolean bl;
        boolean bl2 = bl = !s_specialProps.contains(string);
        if (bl && this.canBuildComponents()) {
            bl = this.getPropertyMethodMap().containsKey(string);
        }
        return bl;
    }

    Collection<String> listBuildableProperties() {
        Collection<String> collection = this.canBuildComponents() ? Collections.unmodifiableCollection(this.getPropertyMethodMap().keySet()) : null;
        return collection;
    }

    private synchronized Map<String, Method> getPropertyMethodMap() {
        if (this.m_propMap == null) {
            this.m_propMap = new TreeMap<String, Method>();
            Class<?> clazz = this.getClass();
            ArrayList<Method> arrayList = new ArrayList<Method>();
            for (Method stringArray : clazz.getMethods()) {
                PropertyBuilder propertyBuilder = stringArray.getAnnotation(PropertyBuilder.class);
                if (propertyBuilder == null) continue;
                Class<?>[] classArray = stringArray.getParameterTypes();
                if (classArray == null || classArray.length != 1 || !AbstractBuildableObject.class.isAssignableFrom(classArray[0])) {
                    this.logMethodError(stringArray, "@PropertyBuilder methods must have a single AbstractBuildableObject parameter.");
                    continue;
                }
                if (propertyBuilder.derived()) {
                    arrayList.add(stringArray);
                    continue;
                }
                for (String string : this.getBuiltProperties(propertyBuilder)) {
                    Method method = this.m_propMap.get(string);
                    if (method != null) {
                        Class<?> clazz2;
                        if (ModelUtil.areDifferent((Object)method.getName(), (Object)stringArray.getName())) {
                            this.logMethodError(stringArray, "Two different @PropertyBuilder methods cannot both build " + string);
                            continue;
                        }
                        Class<?> clazz3 = method.getParameterTypes()[0];
                        if (!clazz3.isAssignableFrom(clazz2 = classArray[0])) continue;
                        this.m_propMap.put(string, stringArray);
                        continue;
                    }
                    this.m_propMap.put(string, stringArray);
                }
            }
            for (Method method : arrayList) {
                PropertyBuilder propertyBuilder = method.getAnnotation(PropertyBuilder.class);
                for (String string : this.getBuiltProperties(propertyBuilder)) {
                    if (this.m_propMap.containsKey(string)) continue;
                    this.m_propMap.put(string, method);
                }
            }
        }
        return this.m_propMap;
    }

    private void logMethodError(Method method, String string) {
        this.getLogger().log(DBLog.getExceptionLogLevel(), method.getName(), new IllegalStateException(string));
    }

    protected String[] getBuiltProperties(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Map<String, Method> map = this.getPropertyMethodMap();
        Method method = map.get(string);
        if (method == null) {
            throw new IllegalStateException("Property " + string + " has no associated @PropertyBuilder.");
        }
        for (Map.Entry<String, Method> entry : map.entrySet()) {
            if (entry.getValue() != method) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private String[] getBuiltProperties(PropertyBuilder propertyBuilder) {
        String[] stringArray;
        if (propertyBuilder.derived()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : propertyBuilder.value()) {
                Collection<String> collection = this.getDerivedProperties(string);
                if (collection == null) continue;
                arrayList.addAll(collection);
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        } else {
            stringArray = propertyBuilder.value();
        }
        return stringArray;
    }

    String[] getPropertyDependencies(String string) {
        PropertyBuilder propertyBuilder = this.getAnnotation(string);
        return propertyBuilder == null ? null : propertyBuilder.depends();
    }

    private PropertyBuilder getAnnotation(String string) {
        PropertyBuilder propertyBuilder = null;
        Method method = this.getPropertyMethodMap().get(string);
        if (method != null) {
            propertyBuilder = method.getAnnotation(PropertyBuilder.class);
        }
        return propertyBuilder;
    }

    private synchronized Map<String, Collection<String>> getDerivedPropertyMap() {
        if (this.m_derivedProperties == null) {
            this.m_derivedProperties = new MultiMap();
            PropertyManager propertyManager = this.getProvider().getPropertyManager();
            Class<? extends DBObject> clazz = Metadata.getInstance().getObjectClass(this.getObjectType());
            PropertyCriteria propertyCriteria = new PropertyCriteria();
            propertyCriteria.setInternal(null);
            propertyCriteria.setDerived(true);
            for (PropertyInfo propertyInfo : propertyManager.getPropertyInfos(clazz, propertyCriteria).values()) {
                this.m_derivedProperties.add((Object)propertyInfo.getDerivedSourceProperty(), (Object)propertyInfo.getPropertyName());
            }
        }
        return this.m_derivedProperties;
    }

    public Collection<String> getDerivedProperties(String string) {
        Collection<String> collection = this.getDerivedPropertyMap().get(string);
        return collection == null ? null : Collections.unmodifiableCollection(collection);
    }

    protected String getDerivedPropertySource(String string) {
        String string2 = null;
        for (Map.Entry<String, Collection<String>> entry : this.getDerivedPropertyMap().entrySet()) {
            if (!entry.getValue().contains(string)) continue;
            string2 = entry.getKey();
            break;
        }
        return string2;
    }

    protected void replaceReferenceIDs(T t, Map<DBObjectID, DBObjectID> map) {
        ((AbstractDBObject)t).replaceReferenceIDsDirectly(map);
    }

    protected static Executor getPropertyExecutorForObject(AbstractBuildableObject abstractBuildableObject) {
        return abstractBuildableObject.getPropertyExecutor();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface PropertyBuilder {
        public String[] value();

        public String[] depends() default {};

        public boolean derived() default false;
    }
}

