/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFactory;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.DBObjectProviderListener;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.ObjectCache;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectExpander;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceApplier;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.plsql.Procedure;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.db.refactoring.CascadeProcessor;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.util.DBObjectIDMultiMap;
import oracle.javatools.db.util.DBObjectIDSet;
import oracle.javatools.db.util.IdentitySet;
import oracle.javatools.db.util.NameComparator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.MissingValidatorException;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

public abstract class AbstractDBObjectProvider
implements DBObjectProvider {
    public static final int MIXED_CASE_NAME_POLICY = 0;
    public static final int LOWER_CASE_NAME_POLICY = 1;
    public static final int UPPER_CASE_NAME_POLICY = 2;
    public static final int CASE_SENSITIVE_NAME_POLICY = 3;
    public static final String TIMESTAMP_PROPERTY = "Timestamp";
    public static final String NEW_FROM_TEMPLATE_TYPE = "<?>";
    private final Set<String> m_timestampKeys = new HashSet<String>();
    private final Map m_timestamps = new HashMap();
    private CascadeManager m_objManager;
    private final ObjectCache m_objectCache;
    private final List<oracle.javatools.db.event.DBObjectProviderListener> m_listeners = new CopyOnWriteArrayList<oracle.javatools.db.event.DBObjectProviderListener>();
    private final MultiMap<DBObjectCriteria, DBObjectListener> m_objectListeners = new MultiMap(ConcurrentHashMap.class, CopyOnWriteArrayList.class);
    private final MultiMap<DBObjectID, DBObjectListener> m_objectSpecficListeners = new DBObjectIDMultiMap<DBObjectListener>(true, true);
    private final Collection<DBObject> m_resetLocks = new IdentitySet<DBObject>();
    private DBObjectFactory m_dbObjFactory;
    private DDLGenerator m_ddlGenerator;
    protected static final String[] EMPTY_LIST = new String[0];

    protected AbstractDBObjectProvider() {
        this(false);
    }

    protected AbstractDBObjectProvider(boolean bl) {
        this.m_objectCache = new ObjectCache(this, bl);
    }

    @Override
    public final String getDescription() {
        return DBObjectProviderFactory.getDescription(this.getProviderType(), this.getProviderIdentifier());
    }

    public boolean isClosed() {
        return false;
    }

    @Override
    public final void removeProviderListener(oracle.javatools.db.event.DBObjectProviderListener dBObjectProviderListener) {
        this.m_listeners.remove(dBObjectProviderListener);
    }

    @Override
    @Deprecated
    public final void removeProviderListener(DBObjectProviderListener dBObjectProviderListener) {
        for (oracle.javatools.db.event.DBObjectProviderListener dBObjectProviderListener2 : this.m_listeners) {
            if (!(dBObjectProviderListener2 instanceof ListenerBridge) || !((ListenerBridge)dBObjectProviderListener2).isBridgeFor(dBObjectProviderListener)) continue;
            this.m_listeners.remove(dBObjectProviderListener2);
        }
    }

    @Override
    public final void addProviderListener(oracle.javatools.db.event.DBObjectProviderListener dBObjectProviderListener) {
        if (dBObjectProviderListener != null && !this.m_listeners.contains(dBObjectProviderListener)) {
            this.m_listeners.add(dBObjectProviderListener);
        }
    }

    @Override
    @Deprecated
    public final void addProviderListener(DBObjectProviderListener dBObjectProviderListener) {
        this.addProviderListener(new ListenerBridge(dBObjectProviderListener));
    }

    @Override
    public final void addObjectListener(DBObjectListener dBObjectListener, DBObjectCriteria dBObjectCriteria) {
        if (dBObjectListener != null) {
            dBObjectCriteria = dBObjectCriteria == null ? DBObjectCriteria.createTypeCriteria(new String[0]) : dBObjectCriteria.clone();
            dBObjectCriteria.setDatabaseDescriptor(this.getDescriptor());
            if (!this.m_objectListeners.contains(dBObjectCriteria, (Object)dBObjectListener)) {
                this.m_objectListeners.add(dBObjectCriteria, (Object)dBObjectListener);
            }
        }
    }

    @Override
    public final void addObjectListener(DBObjectListener dBObjectListener, SystemObject systemObject) {
        this.addObjectListener(dBObjectListener, systemObject.getID());
    }

    @Override
    public final void addObjectListener(DBObjectListener dBObjectListener, DBObjectID dBObjectID) {
        if (dBObjectID != null && dBObjectListener != null && !this.m_objectSpecficListeners.contains((Object)dBObjectID, (Object)dBObjectListener)) {
            this.m_objectSpecficListeners.add((Object)dBObjectID, (Object)dBObjectListener);
        }
    }

    @Override
    public final void removeObjectListener(DBObjectListener dBObjectListener) {
        for (Object object : this.m_objectListeners.keySet()) {
            this.m_objectListeners.removeValue(object, (Object)dBObjectListener);
        }
        for (Object object : this.m_objectSpecficListeners.keySet()) {
            this.m_objectSpecficListeners.removeValue(object, (Object)dBObjectListener);
        }
    }

    public String getDefaultSchemaName(DatabaseLink databaseLink) {
        return null;
    }

    protected final void fireProviderClosed() {
        this.logEvent("fire provider {0} closed", this.getName());
        for (oracle.javatools.db.event.DBObjectProviderListener dBObjectProviderListener : this.m_listeners) {
            try {
                dBObjectProviderListener.providerClosed(this);
            }
            catch (Throwable throwable) {
                this.processListenerException(dBObjectProviderListener, throwable);
            }
        }
    }

    @Deprecated
    public final void fireProviderDeleted() {
    }

    protected final void fireProviderOpened() {
        this.logEvent("fire provider {0} opened", this.getName());
        for (oracle.javatools.db.event.DBObjectProviderListener dBObjectProviderListener : this.m_listeners) {
            try {
                dBObjectProviderListener.providerOpened(this);
            }
            catch (Throwable throwable) {
                this.processListenerException(dBObjectProviderListener, throwable);
            }
        }
    }

    protected final void fireProviderReloaded() {
        this.logEvent("fire provider {0} reloaded", this.getName());
        for (oracle.javatools.db.event.DBObjectProviderListener dBObjectProviderListener : this.m_listeners) {
            try {
                dBObjectProviderListener.providerReloaded(this);
            }
            catch (Throwable throwable) {
                this.processListenerException(dBObjectProviderListener, throwable);
            }
        }
    }

    @Deprecated
    protected final void fireSchemaAdded(Schema schema) {
        this.fireObjectsAdded(Collections.singleton(schema));
    }

    protected final void fireObjectsAdded(Collection<? extends SystemObject> collection) {
        if (collection != null && collection.size() > 0) {
            this.logListEvent("system objects added", collection);
            for (Map.Entry<Schema, Collection<SystemObject>> entry : DBUtil.sortIntoSchemas(collection).entrySet()) {
                Schema schema = entry.getKey();
                for (oracle.javatools.db.event.DBObjectProviderListener dBObjectProviderListener : this.m_listeners) {
                    try {
                        Collection<SystemObject> collection2 = entry.getValue();
                        if (schema == null) {
                            dBObjectProviderListener.systemObjectsAdded(this, collection2);
                            continue;
                        }
                        dBObjectProviderListener.schemaObjectsAdded(this, schema, collection2);
                    }
                    catch (Throwable throwable) {
                        this.processListenerException(dBObjectProviderListener, throwable);
                    }
                }
            }
        }
    }

    @Deprecated
    protected final void fireSchemaUpdated(DBObjectChange dBObjectChange) {
        this.fireObjectUpdated(dBObjectChange);
    }

    @Deprecated
    protected final void fireSchemaObjectUpdated(DBObjectChange dBObjectChange) {
        this.fireObjectUpdated(dBObjectChange);
    }

    protected final void fireObjectUpdated(DBObjectChange dBObjectChange) {
        PropertyChangeEvent propertyChangeEvent;
        DBObject dBObject = dBObjectChange.getDBObject();
        if (!(dBObject instanceof SystemObject)) {
            throw new IllegalStateException("Cannot fire event on non-SystemObject.");
        }
        dBObjectChange.ensureProvider(this);
        this.logEvent("fire schema object {0} updated in {1}", dBObject.getName(), this.getName());
        HashSet hashSet = new HashSet();
        Set set = this.m_objectListeners.entrySet();
        for (Object object2 : set) {
            DBObjectCriteria object3 = (DBObjectCriteria)object2.getKey();
            boolean bl = true;
            if (object3 != null) {
                propertyChangeEvent = dBObjectChange.getPropertyChange("name");
                bl = propertyChangeEvent != null ? object3.accept(dBObject.getType(), DBUtil.getSchema(dBObject), (String)propertyChangeEvent.getOldValue()) : object3.accept((SystemObject)dBObject);
            }
            if (!bl) continue;
            hashSet.addAll((Collection)object2.getValue());
        }
        DBObjectID dBObjectID = dBObject.getID();
        if (dBObjectID != null) {
            Object object2;
            object2 = null;
            PropertyChangeEvent propertyChangeEvent2 = dBObjectChange.getPropertyChange("ID");
            if (propertyChangeEvent2 != null) {
                object2 = (DBObjectID)propertyChangeEvent2.getOldValue();
            } else if (dBObjectID instanceof NameBasedID) {
                PropertyChangeEvent propertyChangeEvent3 = dBObjectChange.getPropertyChange("name");
                propertyChangeEvent = dBObjectChange.getPropertyChange("schema");
                if (propertyChangeEvent3 != null || propertyChangeEvent != null) {
                    object2 = (NameBasedID)dBObjectID.copyTo(null);
                    if (propertyChangeEvent3 != null) {
                        ((NameBasedID)object2).setName((String)propertyChangeEvent3.getOldValue());
                    }
                    if (propertyChangeEvent != null) {
                        ((NameBasedID)object2).setSchema((Schema)propertyChangeEvent.getOldValue());
                    }
                }
            }
            Collection collection = null;
            if (object2 == null) {
                collection = this.m_objectSpecficListeners.get((Object)dBObjectID);
            } else if (!object2.equals(dBObjectID, true) && (collection = this.m_objectSpecficListeners.get(object2)) != null) {
                this.m_objectSpecficListeners.addAll((Object)dBObjectID, collection);
                this.m_objectSpecficListeners.remove(object2);
            }
            if (collection != null) {
                hashSet.addAll(collection);
            }
        }
        for (DBObjectListener dBObjectListener : hashSet) {
            try {
                dBObjectListener.objectUpdated(dBObjectChange);
            }
            catch (Throwable throwable) {
                this.processListenerException(dBObjectListener, throwable);
            }
        }
        for (oracle.javatools.db.event.DBObjectProviderListener dBObjectProviderListener : this.m_listeners) {
            try {
                dBObjectProviderListener.objectUpdated(dBObjectChange);
            }
            catch (Throwable throwable) {
                this.processListenerException(dBObjectProviderListener, throwable);
            }
        }
    }

    @Deprecated
    protected final void fireSchemaRemoved(Schema schema) {
        this.fireObjectsRemoved(Collections.singleton(schema));
    }

    private void logListEvent(String string, Iterable<? extends DBObject> iterable) {
        Level level;
        Logger logger = this.getLogger();
        if (logger.isLoggable(level = Level.FINE)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("fire ");
            stringBuffer.append(string);
            stringBuffer.append(" in provider ");
            stringBuffer.append(this.getName());
            stringBuffer.append(": ");
            for (DBObject dBObject : iterable) {
                stringBuffer.append(DBUtil.getFullyQualifiedName(dBObject, true));
                stringBuffer.append(" ");
            }
            this.logEvent(stringBuffer.toString(), new Object[0]);
        }
    }

    protected final void fireObjectsRemoved(Collection<? extends SystemObject> collection) {
        if (collection != null && collection.size() > 0) {
            this.logListEvent("system objects removed", collection);
            for (Map.Entry<Schema, Collection<SystemObject>> entry : DBUtil.sortIntoSchemas(collection).entrySet()) {
                Schema schema = entry.getKey();
                for (oracle.javatools.db.event.DBObjectProviderListener dBObjectProviderListener : this.m_listeners) {
                    try {
                        Collection<SystemObject> collection2 = entry.getValue();
                        if (schema == null) {
                            dBObjectProviderListener.systemObjectsRemoved(this, collection2);
                            continue;
                        }
                        dBObjectProviderListener.schemaObjectsRemoved(this, schema, collection2);
                    }
                    catch (Throwable throwable) {
                        this.processListenerException(dBObjectProviderListener, throwable);
                    }
                }
            }
        }
    }

    @Deprecated
    public final void fireObjectsAdded(Schema schema, SchemaObject[] schemaObjectArray) {
        this.fireObjectsAdded(Arrays.asList(schemaObjectArray));
    }

    @Deprecated
    protected final void fireObjectsRemoved(Schema schema, SchemaObject[] schemaObjectArray) {
        this.fireObjectsRemoved(Arrays.asList(schemaObjectArray));
    }

    private void processListenerException(Object object, Throwable throwable) {
        this.getLogger().log(Level.WARNING, MessageFormat.format("listener {0} threw exception:", object.getClass()), throwable);
    }

    protected final void registerType(String string, DBObjectBuilder dBObjectBuilder, DBObjectValidator dBObjectValidator) {
        this.m_objectCache.registerType(string, dBObjectBuilder, dBObjectValidator);
    }

    protected final void registerBuilder(String string, DBObjectBuilder dBObjectBuilder) {
        this.registerType(string, dBObjectBuilder, null);
    }

    protected DBObjectBuilder getBuilderForType(String string) {
        return this.m_objectCache.getBuilderForType(string);
    }

    protected final void registerValidator(String string, DBObjectValidator dBObjectValidator) {
        this.registerType(string, null, dBObjectValidator);
    }

    public final DBObjectValidator getValidatorForType(String string) {
        return this.m_objectCache.getValidatorForType(string);
    }

    public final <T extends DBObject> DBObjectValidator<? super T> getValidator(T t) throws MissingValidatorException {
        DBObjectValidator dBObjectValidator = this.getValidatorForType(t.getType());
        if (dBObjectValidator == null) {
            throw new MissingValidatorException(t);
        }
        return dBObjectValidator;
    }

    protected SystemObject findObject(String string, Schema schema, String string2) {
        return this.m_objectCache.findObject(string, null, schema, string2);
    }

    protected final SystemObject findObject(DBObjectID dBObjectID) {
        SystemObject systemObject = null;
        if (dBObjectID != null) {
            systemObject = this.m_objectCache.findObject(dBObjectID);
        }
        return systemObject;
    }

    protected void destroyCache() {
        this.clearAllCaches();
        this.m_objectCache.destroyCache();
    }

    public void clearAllCaches() {
        this.m_objectCache.clearAllCaches();
        if (this.m_objManager instanceof SchemaObjectManager) {
            ((SchemaObjectManager)this.m_objManager).clearAllCaches();
        }
        this.m_timestampKeys.clear();
        this.m_timestamps.clear();
        this.m_ddlGenerator = null;
    }

    @Override
    public synchronized CascadeManager getCascadeManager() {
        if (this.m_objManager == null) {
            this.m_objManager = this.createObjectManager();
        }
        return this.m_objManager;
    }

    protected CascadeManager createObjectManager() {
        return new SchemaObjectManager(this);
    }

    protected void cacheObject(SystemObject systemObject, boolean bl) {
        if (systemObject != null) {
            this.m_objectCache.cacheObject(systemObject);
            CascadeManager cascadeManager = this.getCascadeManager();
            if (cascadeManager instanceof SchemaObjectManager) {
                ((SchemaObjectManager)cascadeManager).registerObject(systemObject, bl);
            }
        }
    }

    protected final void uncacheObject(SystemObject systemObject) {
        if (systemObject != null) {
            this.m_objectCache.uncacheObject(systemObject);
            if (systemObject instanceof Table && !DBUtil.needsBuilding(systemObject, "indexes")) {
                Index[] indexArray;
                for (Index index : indexArray = ((Table)systemObject).getIndexes()) {
                    this.uncacheObject(index);
                }
            }
            if (this.m_objManager instanceof SchemaObjectManager) {
                ((SchemaObjectManager)this.m_objManager).unregisterObject(systemObject);
            }
        }
    }

    protected String[] listObjectsImpl(String string, Schema schema, String string2) throws DBException {
        DBObjectCriteria<SystemObject> dBObjectCriteria = DBObjectCriteria.createCriteria(string, schema, string2);
        Collection<SystemObject> collection = this.listObjects(dBObjectCriteria);
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (SystemObject systemObject : collection) {
            stringArray[n] = systemObject.getName();
            ++n;
        }
        return stringArray;
    }

    @Deprecated
    protected Collection<SystemObject> listObjectsImpl(String[] stringArray, Schema schema, String string) throws DBException {
        return this.listObjects(DBObjectCriteria.createCriteria(stringArray, schema, string));
    }

    protected abstract <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> var1) throws DBException;

    protected final <T extends SystemObject> Collection<T> listObjectsFromCache(DBObjectCriteria<T> dBObjectCriteria) {
        dBObjectCriteria.setDatabaseDescriptor(this.getDescriptor());
        return this.m_objectCache.listObjectsFromCache(dBObjectCriteria);
    }

    protected <T extends SystemObject> T getObjectImpl(DBObjectCriteria<T> dBObjectCriteria) throws DBException {
        dBObjectCriteria.setDatabaseDescriptor(this.getDescriptor());
        String string = dBObjectCriteria.getName();
        ArrayList<String> arrayList = new ArrayList<String>(dBObjectCriteria.getTypes());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (this.m_objectCache.hasTypeEntry((String)iterator.next())) continue;
            iterator.remove();
        }
        SystemObject systemObject = null;
        if (!arrayList.isEmpty() && ModelUtil.hasLength((String)string)) {
            String string2 = dBObjectCriteria.getSchemaName();
            Schema schema = ModelUtil.hasLength((String)string2) ? this.findSchema(string2) : null;
            String string3 = dBObjectCriteria.getDatabaseName();
            for (String string4 : arrayList) {
                systemObject = this.m_objectCache.findObject(string4, string3, schema, string);
                if (systemObject != null && !dBObjectCriteria.getSkipTimestampCheck()) {
                    systemObject = this.checkCachedObject(systemObject);
                }
                if (systemObject == null) continue;
                break;
            }
            if (systemObject == null && (systemObject = (SystemObject)this.loadObjectImpl(dBObjectCriteria)) != null) {
                this.cacheObject(systemObject, true);
            }
        }
        return (T)systemObject;
    }

    protected final Long getExistingTimestamp(SystemObject systemObject) {
        return systemObject == null ? null : (Long)((AbstractDBObject)((Object)systemObject)).getPropertySupport().get(TIMESTAMP_PROPERTY);
    }

    protected <T extends SystemObject> T checkCachedObject(T t) throws DBException {
        DBObjectCriteria<T> dBObjectCriteria;
        Object object;
        Object object2;
        String string = t.getType();
        boolean bl = false;
        if (this.supportsTimestamps(string) && (object2 = this.getExistingTimestamp(t)) != null) {
            bl = true;
            object = this.getExternalTimestamp(t);
            if (object == null || ((Long)object).compareTo((Long)object2) > 0) {
                dBObjectCriteria = new DBObjectCriteria<T>(t);
                dBObjectCriteria.setSkipTimestampCheck(true);
                T t2 = this.loadObjectImpl(dBObjectCriteria);
                if (t2 != null) {
                    this.resetObject(t, t2, (Long)object);
                } else {
                    this.uncacheObject(t);
                    t = null;
                }
            }
        }
        if (!bl) {
            object2 = t.getID();
            if (object2 != null) {
                boolean bl2 = bl = this.putCachedTimestampKey(object2, true) != null;
            }
            if (bl) {
                this.getLogger().log(Level.FINE, "Database {0}: exists test skipped for {1} {2}", new Object[]{this.getName(), t.getType(), DBUtil.getFullyQualifiedName(t)});
            } else {
                object = new DBObjectCriteria<T>(t);
                ((DBObjectCriteria)object).setSkipTimestampCheck(true);
                dBObjectCriteria = this.loadObjectImpl((DBObjectCriteria<T>)object);
                if (dBObjectCriteria == null) {
                    this.uncacheObject(t);
                    t = null;
                } else if (dBObjectCriteria != t) {
                    this.resetObject(t, (SystemObject)((Object)dBObjectCriteria), null);
                }
            }
        }
        return t;
    }

    @Override
    public Schema[] listSchemas() throws DBException {
        return this.listSchemas(true);
    }

    @Override
    public Schema[] listSchemas(boolean bl) throws DBException {
        DBObjectCriteria<Schema> dBObjectCriteria = new DBObjectCriteria<Schema>(Schema.class, new String[0]);
        dBObjectCriteria.setUserOnly(!bl);
        dBObjectCriteria.setDatabaseDescriptor(this.getDescriptor());
        Collection<Schema> collection = this.listObjectsImpl(dBObjectCriteria);
        return collection.toArray(new Schema[collection.size()]);
    }

    @Override
    public Schema getSchema(String string) throws DBException {
        return this.getSchemaImpl(string, false);
    }

    protected Schema findSchema(String string) throws DBException {
        return this.getSchemaImpl(string, true);
    }

    private Schema getSchemaImpl(String string, boolean bl) throws DBException {
        Schema schema = null;
        if (ModelUtil.hasLength((String)string)) {
            DBObjectCriteria<Schema> dBObjectCriteria = new DBObjectCriteria<Schema>(Schema.class, new String[0]);
            dBObjectCriteria.setName(string);
            dBObjectCriteria.setSkipTimestampCheck(bl);
            schema = this.getObject(dBObjectCriteria);
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resumeTimestampQueries(String string) {
        Set<String> set = this.m_timestampKeys;
        synchronized (set) {
            if (this.m_timestampKeys.remove(string)) {
                if (this.m_timestampKeys.size() == 0) {
                    this.m_timestamps.clear();
                    this.getLogger().log(Level.FINEST, "Database {0}: timestamp resume ({1})", new Object[]{this.getName(), string});
                }
            } else if (!this.isClosed()) {
                this.getLogger().log(Level.FINE, "Database " + this.getName() + ": timestamp resume for " + string + " but a suspend is not active for that key!", new IllegalStateException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suspendTimestampQueries(String string) {
        Set<String> set = this.m_timestampKeys;
        synchronized (set) {
            if (this.m_timestampKeys.isEmpty()) {
                this.m_timestamps.clear();
                this.getLogger().log(Level.FINEST, "Database {0}: timestamp suspend ({1})", new Object[]{this.getName(), string});
            } else if (this.m_timestampKeys.contains(string)) {
                this.getLogger().log(DBLog.getExceptionLogLevel(), "Database " + this.getName() + ": timestamp suspend called for " + string + " but that key is already suspended!", new IllegalStateException());
            }
            this.m_timestampKeys.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object getCachedTimestamp(Object object) {
        Object var2_2 = null;
        if (this.m_timestampKeys != null) {
            Set<String> set = this.m_timestampKeys;
            synchronized (set) {
                if (!this.m_timestampKeys.isEmpty()) {
                    var2_2 = this.m_timestamps.get(object);
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object putCachedTimestampKey(Object object, Object object2) {
        Object object3 = null;
        if (this.m_timestampKeys != null) {
            Set<String> set = this.m_timestampKeys;
            synchronized (set) {
                if (object2 == null) {
                    this.m_timestamps.remove(object);
                } else if (!this.m_timestampKeys.isEmpty()) {
                    object3 = this.m_timestamps.put(object, object2);
                }
            }
        }
        return object3;
    }

    @Override
    public boolean supportsTimestamps(String string) {
        return false;
    }

    @Deprecated
    public boolean supportsTimestamps() {
        return false;
    }

    @Override
    public final Long getTimestamp(String string, Schema schema, String string2) throws DBException {
        SchemaObject schemaObject;
        Long l = null;
        if (this.supportsTimestamps(string) && (schemaObject = this.getObject(string, schema, string2)) != null) {
            l = (Long)schemaObject.getProperty(TIMESTAMP_PROPERTY);
        }
        return l;
    }

    @Override
    public final Long getTimestamp(DBObjectID dBObjectID) throws DBException {
        if (this.supportsTimestamps(dBObjectID.getType())) {
            DBObject dBObject = this.resolveID(dBObjectID);
            return dBObject != null ? (Long)dBObject.getProperty(TIMESTAMP_PROPERTY) : null;
        }
        return null;
    }

    protected DBObject resolveID(DBObjectID dBObjectID) throws DBException {
        SystemObject systemObject = null;
        if (dBObjectID instanceof ReferenceID) {
            systemObject = this.resolveReferenceID((ReferenceID)dBObjectID);
        } else if (dBObjectID instanceof BaseObjectID) {
            systemObject = this.resolveIDImpl((BaseObjectID)dBObjectID);
        }
        return systemObject;
    }

    protected SystemObject resolveIDImpl(BaseObjectID baseObjectID) throws DBException {
        SystemObject systemObject = null;
        String string = baseObjectID.getType();
        if (this.m_objectCache.hasTypeEntry(string)) {
            SystemObject systemObject2 = this.m_objectCache.findObject(baseObjectID);
            if (systemObject2 == null) {
                systemObject = this.loadObjectImpl(baseObjectID);
                if (systemObject != null) {
                    this.cacheObject(systemObject, true);
                }
            } else {
                Long l;
                Long l2;
                systemObject = systemObject2;
                if (this.supportsTimestamps(string) && (l2 = this.getExistingTimestamp(systemObject2)) != null && ((l = this.getExternalTimestamp(systemObject2)) == null || l.compareTo(l2) > 0)) {
                    SystemObject systemObject3 = this.loadObjectImpl(baseObjectID);
                    if (systemObject3 == null && baseObjectID instanceof IdentifierBasedID) {
                        String string2 = systemObject.getName();
                        DBObjectCriteria<SystemObject> dBObjectCriteria = DBObjectCriteria.createSingleObjectCriteria(string, DBUtil.getSchema(systemObject), string2);
                        dBObjectCriteria.setSkipTimestampCheck(true);
                        systemObject3 = this.loadObjectImpl(dBObjectCriteria);
                        if (systemObject3 != null) {
                            this.getLogger().info(APIBundle.format("OBJ_DROPPED_AND_CREATED", string, string2, this.getName()));
                            systemObject = null;
                        }
                    }
                    if (systemObject3 != null) {
                        this.resetObject(systemObject2, systemObject3, l);
                    } else {
                        this.uncacheObject(systemObject2);
                        this.fireObjectsRemoved(Collections.singleton(systemObject2));
                        systemObject = null;
                    }
                }
            }
        }
        return systemObject;
    }

    protected SystemObject resolveReferenceID(ReferenceID referenceID) throws DBException {
        String string = referenceID.toString();
        SystemObject systemObject = (SystemObject)this.getCachedTimestamp(string);
        if (systemObject == null) {
            String string2 = referenceID.getType();
            if ("UNSPECIFIED_TYPE".equals(string2)) {
                systemObject = this.resolveUnspecifiedTypeID(referenceID);
            } else if (this.m_objectCache.hasTypeEntry(string2)) {
                Object object;
                String string3 = referenceID.getDatabaseName();
                Object object2 = referenceID.getIdentifier();
                if (object2 != null) {
                    object = new IdentifierBasedID(string2, object2, this);
                    ((BaseObjectID)object).setDatabaseName(string3);
                    systemObject = this.resolveIDImpl((BaseObjectID)object);
                }
                if (systemObject == null) {
                    object = referenceID.getName();
                    String string4 = referenceID.getSchemaName();
                    if (object != null) {
                        NameBasedID nameBasedID = new NameBasedID(string2, string4, (String)object, this);
                        nameBasedID.setDatabaseName(string3);
                        systemObject = this.resolveIDImpl(nameBasedID);
                    }
                }
            }
            if (systemObject != null) {
                this.putCachedTimestampKey(string, systemObject);
            }
        }
        return systemObject;
    }

    /*
     * WARNING - void declaration
     */
    protected SystemObject resolveUnspecifiedTypeID(ReferenceID referenceID) throws DBException {
        SystemObject systemObject = null;
        String string = referenceID.getName();
        if (ModelUtil.hasLength((String)string)) {
            int n;
            DBObjectCriteria<SystemObject> dBObjectCriteria;
            Collection<SystemObject> collection;
            Object object;
            String string2 = referenceID.getSchemaName();
            String string3 = referenceID.getDatabaseName();
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            for (String dBObjectCriteria22 : this.listObjectTypes()) {
                object = "1";
                if ("TABLE".equals(dBObjectCriteria22)) {
                    object = "0";
                } else if (!Metadata.getInstance().isSchemaObject(dBObjectCriteria22)) {
                    object = "2";
                }
                treeMap.put((String)object + dBObjectCriteria22, dBObjectCriteria22);
            }
            ArrayList arrayList = new ArrayList();
            for (String string4 : treeMap.values()) {
                void var10_17;
                if (arrayList.contains(string4)) continue;
                DBObjectCriteria<?> dBObjectCriteria2 = this.getNamespaceCriteria(string4, null, string);
                if (dBObjectCriteria2 == null) {
                    DBObjectCriteria<SystemObject> dBObjectCriteria3 = DBObjectCriteria.createSingleObjectCriteria(string4, string3, string2, string);
                } else {
                    dBObjectCriteria2.setSchemaName(string2);
                    dBObjectCriteria2.setDatabaseName(string3);
                }
                arrayList.addAll(var10_17.getTypes());
                object = this.listObjects((DBObjectCriteria)var10_17);
                if (object.isEmpty()) continue;
                systemObject = (SystemObject)object.iterator().next();
                break;
            }
            String string5 = this.getDescriptor().getPublicSchemaName();
            if (systemObject == null && this.supportsObjectType("SYNONYM") && string5 != null && !(collection = this.listObjects(dBObjectCriteria = DBObjectCriteria.createSingleObjectCriteria("SYNONYM", string3, string5, string))).isEmpty()) {
                systemObject = collection.iterator().next();
            }
            if (systemObject == null && (this.supportsObjectType("PROCEDURE") || this.supportsObjectType("FUNCTION")) && (n = string.indexOf("(")) > 0) {
                String string4 = string.substring(0, string.indexOf("("));
                object = DBObjectCriteria.createTypeCriteria("FUNCTION", "PROCEDURE", "SYNONYM");
                ((DBObjectCriteria)object).setName(string4);
                ((DBObjectCriteria)object).setDatabaseName(string3);
                ((DBObjectCriteria)object).setSchemaName(string2);
                Collection<SystemObject> collection2 = this.listObjects((DBObjectCriteria)object);
                if (!collection2.isEmpty() && (systemObject = collection2.iterator().next()) instanceof Synonym && !(DBUtil.getSynonymReference((Synonym)systemObject) instanceof Procedure)) {
                    systemObject = null;
                }
            }
        }
        return systemObject;
    }

    protected DBObjectChange resetObject(SystemObject systemObject, SystemObject systemObject2, Long l) {
        return this.resetObject(systemObject, systemObject2, l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DBObjectChange resetObject(SystemObject systemObject, SystemObject systemObject2, Long l, boolean bl) {
        DBObjectChange dBObjectChange = null;
        boolean bl2 = false;
        Collection<DBObject> collection = this.m_resetLocks;
        synchronized (collection) {
            if (this.m_resetLocks.contains(systemObject)) {
                this.getLogger().log(Level.WARNING, "resetObject is already active for {0} {1}", new Object[]{systemObject.getType(), systemObject.getName()});
            } else {
                this.m_resetLocks.add(systemObject);
                bl2 = true;
            }
        }
        if (bl2) {
            try {
                dBObjectChange = this.resetObjectImpl(systemObject, systemObject2, l, bl);
            }
            finally {
                collection = this.m_resetLocks;
                synchronized (collection) {
                    this.m_resetLocks.remove(systemObject);
                }
            }
        }
        return dBObjectChange;
    }

    private DBObjectChange resetObjectImpl(SystemObject systemObject, SystemObject systemObject2, Long l, boolean bl) {
        Object object;
        this.uncacheObject(systemObject);
        this.uncacheObject(systemObject2);
        SystemObject systemObject3 = null;
        if (bl && systemObject2 != null) {
            systemObject3 = systemObject instanceof AbstractBuildableObject ? (SystemObject)((AbstractBuildableObject)((Object)systemObject)).createStaticCopy() : (SystemObject)systemObject.copyTo(null, new IDPolicy.SameIDPolicy());
        }
        try {
            DBObjectID dBObjectID;
            Schema schema;
            if (systemObject2 == null) {
                object = systemObject.getName();
                schema = DBUtil.getSchema(systemObject);
                dBObjectID = systemObject.getID();
            } else {
                object = systemObject2.getName();
                schema = DBUtil.getSchema(systemObject2);
                dBObjectID = systemObject2.getID();
            }
            SystemObject systemObject4 = (SystemObject)systemObject.getClass().newInstance();
            systemObject4.setName((String)object);
            systemObject4.setID(dBObjectID);
            if (systemObject4 instanceof SchemaObject) {
                ((SchemaObject)systemObject4).setSchema(schema);
            }
            systemObject4.copyTo((DBObject)systemObject, new IDPolicy.SameIDPolicy());
        }
        catch (Exception exception) {
            this.getLogger().log(Level.WARNING, "Error wiping object properties - object reset may have failed", exception);
        }
        if (l == null) {
            this.putCachedTimestampKey(systemObject.getID(), null);
        } else {
            systemObject.setProperty(TIMESTAMP_PROPERTY, l);
        }
        this.markForLazyInit((AbstractBuildableObject)((Object)systemObject));
        this.cacheObject(systemObject, bl);
        object = null;
        if (systemObject3 != null) {
            object = DifferenceApplier.fireLazyChangeEvent(systemObject, systemObject3, this);
            this.fireObjectUpdated((DBObjectChange)object);
        }
        return object;
    }

    protected <T extends SystemObject> T loadObjectImpl(DBObjectCriteria<T> object) throws DBException {
        if (!((DBObjectCriteria)object).getSkipTimestampCheck()) {
            object = ((DBObjectCriteria)object).clone();
            ((DBObjectCriteria)object).setSkipTimestampCheck(true);
        }
        for (SystemObject systemObject : this.listObjects((DBObjectCriteria<T>)object)) {
            for (String string : ((DBObjectCriteria)object).getTypes()) {
                if (!this.isRequestedObject((T)systemObject, (DBObjectCriteria<T>)object)) continue;
                return (T)systemObject;
            }
        }
        return null;
    }

    @Deprecated
    protected SystemObject loadObjectImpl(String string, Schema schema, String string2) throws DBException {
        return null;
    }

    @Deprecated
    protected boolean isRequestedObject(SystemObject systemObject, String string, Schema schema, String string2) {
        return true;
    }

    protected <T extends SystemObject> boolean isRequestedObject(T t, DBObjectCriteria<T> dBObjectCriteria) {
        return dBObjectCriteria.accept(t);
    }

    protected SystemObject loadObjectImpl(BaseObjectID baseObjectID) throws DBException {
        SystemObject systemObject = null;
        if (!(baseObjectID instanceof IdentifierBasedID)) {
            DBObjectCriteria<SystemObject> dBObjectCriteria = DBObjectCriteria.createSingleObjectCriteria(baseObjectID.getType(), baseObjectID.getDatabaseName(), baseObjectID.getSchemaName(), baseObjectID.getName());
            dBObjectCriteria.setSkipTimestampCheck(true);
            systemObject = this.loadObjectImpl(dBObjectCriteria);
            if (systemObject != null && systemObject.getID() == null) {
                systemObject.setID(baseObjectID);
            }
        }
        return systemObject;
    }

    protected Long getExternalTimestampImpl(SystemObject systemObject) throws DBException {
        return null;
    }

    protected final Long getExternalTimestamp(SystemObject systemObject) throws DBException {
        DBObjectID dBObjectID = systemObject.getID();
        Object object = this.getCachedTimestamp(dBObjectID);
        if (object instanceof Long) {
            this.getLogger().log(Level.FINE, "Database {0}: timestamp query skipped for id {1}", new Object[]{this.getName(), dBObjectID});
            return (Long)object;
        }
        Long l = this.getExternalTimestampImpl(systemObject);
        if (l != null) {
            this.putCachedTimestampKey(dBObjectID, l);
        }
        return l;
    }

    protected final void markForLazyInit(AbstractBuildableObject abstractBuildableObject) {
        DBObjectBuilder dBObjectBuilder = this.getBuilderForType(abstractBuildableObject.getType());
        this.markForLazyInit(abstractBuildableObject, dBObjectBuilder);
    }

    protected final void markForLazyInit(AbstractBuildableObject abstractBuildableObject, DBObjectBuilder dBObjectBuilder) {
        if (dBObjectBuilder != null) {
            abstractBuildableObject.getPropertySupport().setBuilder(dBObjectBuilder);
        }
        this.getObjectFactory().ensureDerivedPropertyBuilder(abstractBuildableObject);
    }

    public static String convertObject(DBObject dBObject) {
        String string = dBObject != null ? dBObject.getName() : "";
        return ModelUtil.hasLength((String)string) ? string : "";
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String[] listObjectTypes() {
        return this.m_objectCache.listObjectTypes();
    }

    @Override
    public boolean supportsObjectType(String string) {
        if (this.isNewFromTemplateType(string)) {
            return true;
        }
        Object[] objectArray = this.listObjectTypes();
        return Arrays.binarySearch(objectArray, string) >= 0;
    }

    @Override
    public boolean createObjectTypeDisabled(String string) {
        return false;
    }

    @Override
    public final String[] listObjects(String string, Schema schema) throws DBException {
        return this.listObjects(string, schema, null);
    }

    @Override
    public final String[] listObjects(String string, Schema schema, String string2) throws DBException {
        return this.listObjectsImpl(string, schema, string2);
    }

    @Override
    public final SchemaObject[] listObjects(String[] stringArray, Schema schema) throws DBException {
        return this.listObjects(stringArray, schema, null);
    }

    @Override
    public final SchemaObject[] listObjects(String[] stringArray, Schema schema, String string) throws DBException {
        DBObjectCriteria<SystemObject> dBObjectCriteria = DBObjectCriteria.createCriteria(DBUtil.filterSchemaObjectTypes(stringArray), schema, string);
        Collection<SystemObject> collection = this.listObjects(dBObjectCriteria);
        return collection.toArray(new SchemaObject[collection.size()]);
    }

    @Override
    public final <T extends SystemObject> Collection<T> listObjects(DBObjectCriteria<T> dBObjectCriteria) throws DBException {
        dBObjectCriteria.setDatabaseDescriptor(this.getDescriptor());
        return this.listObjectsImpl(dBObjectCriteria);
    }

    @Override
    public final <T extends SystemObject> T getObject(DBObjectCriteria<T> dBObjectCriteria) throws DBException {
        if (dBObjectCriteria.isNameWild()) {
            this.getLogger().warning("getObject cannot process wildcards - use criteria \"name\" not \"nameLike\".");
        }
        return this.getObjectImpl(dBObjectCriteria);
    }

    @Override
    public final SchemaObject getObject(String string, Schema schema, String string2) throws DBException {
        SystemObject systemObject;
        SchemaObject schemaObject = null;
        if (string != null && Arrays.binarySearch(this.listObjectTypes(), string) >= 0 && schema != null && ModelUtil.hasLength((String)string2) && (systemObject = this.getObjectImpl(DBObjectCriteria.createSingleObjectCriteria(string, schema, string2))) instanceof SchemaObject) {
            schemaObject = (SchemaObject)systemObject;
        }
        return schemaObject;
    }

    @Override
    @Deprecated
    public boolean hasPriviledge(String string, Schema schema, String string2) {
        return this.hasSystemPrivilege(string, schema, string2);
    }

    @Override
    public boolean hasSystemPrivilege(String string, Schema schema, String string2) {
        return true;
    }

    @Override
    public boolean hasObjectPrivilege(SystemObject systemObject, String string) {
        return true;
    }

    @Override
    public void canUpdate(Difference difference, boolean bl, boolean bl2) throws DBException {
        Object dBException2;
        Object object;
        if (!difference.isList()) {
            throw new IllegalArgumentException("listDiff must be a LIST Difference");
        }
        if (!(difference.getOriginalObject() instanceof SystemObject[])) {
            throw new IllegalArgumentException("listDiff must be a LIST Difference of SystemObject[]");
        }
        DBException dBException = null;
        for (Difference object3 : difference.getChildren()) {
            object = (SystemObject)object3.getOriginalObject();
            dBException2 = (SystemObject)object3.getUpdatedObject();
            if (object != null || this.canCreate((SystemObject)dBException2, bl)) continue;
            dBException = DBException.append(dBException, new NameInUseException((DBObject)dBException2));
        }
        if (!bl2) {
            List<UpdateProcessor> list = this.getDescriptorOrFail().getUpdateProcessors();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (UpdateProcessor)iterator.next();
                if (!(object instanceof CascadeProcessor)) continue;
                try {
                    dBException2 = new DBObjectTransaction(this);
                    ((DBObjectTransaction)dBException2).setReplace(bl);
                    ((DBObjectTransaction)dBException2).setCascade(true);
                    ((DBObjectTransaction)dBException2).setUpdateProcessors(Collections.singletonList(object));
                    ((DBObjectTransaction)dBException2).includeListDifference(difference);
                    Difference difference2 = ((DBObjectTransaction)dBException2).getTransactionDifference();
                    DBObject[] dBObjectArray = (SystemObject[])difference.getOriginalObject();
                    DBObject[] dBObjectArray2 = (SystemObject[])difference2.getOriginalObject();
                    DBObjectIDSet dBObjectIDSet = new DBObjectIDSet(true);
                    dBObjectIDSet.addAll(dBObjectArray2);
                    dBObjectIDSet.removeAll(dBObjectArray);
                    if (!dBObjectIDSet.isEmpty()) {
                        throw new CascadeRequiredException(Arrays.asList(dBObjectArray), (Collection<DBObjectID>)dBObjectIDSet);
                    }
                }
                catch (DBException dBException3) {
                    dBException = DBException.append(dBException, dBException3);
                }
                break;
            }
        }
        if (dBException != null) {
            throw dBException;
        }
    }

    @Override
    public final void createObject(SystemObject systemObject, boolean bl) throws DBException {
        this.createObjects(new SystemObject[]{systemObject}, bl);
    }

    @Override
    public final void deleteObject(SystemObject systemObject, boolean bl) throws DBException {
        this.deleteObjects(new SystemObject[]{systemObject}, bl);
    }

    @Override
    public final void updateObject(SystemObject systemObject, SystemObject systemObject2) throws DBException {
        this.updateObjects(new SystemObject[]{systemObject}, new SystemObject[]{systemObject2});
    }

    @Override
    public final void updateObjects(SystemObject[] systemObjectArray, SystemObject[] systemObjectArray2) throws DBException {
        if (systemObjectArray == null || systemObjectArray2 == null || systemObjectArray.length == 0) {
            return;
        }
        if (systemObjectArray.length != systemObjectArray2.length) {
            throw new IllegalArgumentException("Number of old and new objects don't match");
        }
        DiffEngine diffEngine = this.getDiffEngine();
        if (diffEngine == null) {
            throw new IllegalStateException("Diff not supported, cannot update objects.");
        }
        Difference difference = diffEngine.difference(systemObjectArray = DBUtil.getProviderDefinitions((SystemObject[])systemObjectArray, (DBObjectProvider)this), systemObjectArray2);
        if (!difference.isSame()) {
            this.updateObjects(difference, false, false);
        }
    }

    @Override
    public void createSchema(Schema schema, boolean bl) throws DBException {
        this.createObject(schema, bl);
    }

    @Override
    public void deleteSchema(Schema schema, boolean bl) throws DBException {
        this.deleteObject(schema, bl);
    }

    @Override
    public void updateSchema(Schema schema, Schema schema2) throws DBException {
        this.updateObject(schema, schema2);
    }

    @Override
    public PropertyManager getPropertyManager() {
        return this.getDDLGenerator();
    }

    @Override
    public final DDLGenerator getDDLGenerator() {
        DatabaseDescriptor databaseDescriptor;
        if (this.m_ddlGenerator == null && (databaseDescriptor = this.getDescriptor()) != null) {
            this.m_ddlGenerator = databaseDescriptor.getDDLGenerator(this);
        }
        return this.m_ddlGenerator;
    }

    private DatabaseDescriptor getDescriptorOrFail() {
        DatabaseDescriptor databaseDescriptor = this.getDescriptor();
        if (databaseDescriptor == null) {
            throw new IllegalStateException("provider is missing a descriptor");
        }
        return databaseDescriptor;
    }

    protected final int getCasePolicy() {
        return this.getDescriptorOrFail().getCasePolicy();
    }

    @Deprecated
    protected final int getQuotedNameCasePolicy() {
        return this.getDescriptorOrFail().getQuotedNameCasePolicy();
    }

    @Override
    @Deprecated
    public final boolean isValidName(String string) {
        return this.isValidName(null, string);
    }

    @Override
    public final boolean isValidName(String string, String string2) {
        return this.getDescriptorOrFail().isValidName(string, string2);
    }

    @Override
    @Deprecated
    public final void validateName(String string) throws InvalidNameException {
        this.validateName(null, string);
    }

    @Override
    public final void validateName(String string, String string2) throws InvalidNameException {
        DBObjectValidator dBObjectValidator;
        DBObjectValidator dBObjectValidator2 = dBObjectValidator = string == null ? null : this.getValidatorForType(string);
        if (dBObjectValidator == null) {
            this.getDescriptorOrFail().validateName(string, string2);
        } else {
            dBObjectValidator.validateName(string, string2);
        }
    }

    @Override
    public final String quoteIdentifier(String string, boolean bl) throws DBException {
        return this.getDescriptorOrFail().quoteIdentifier(string, bl);
    }

    @Override
    public final String getInternalName(String string, String string2) {
        return this.getDescriptorOrFail().getInternalName(string, string2);
    }

    @Override
    public final String getInternalName(String string) {
        return this.getInternalName(string, null);
    }

    @Override
    public final String getExternalName(String string, String string2) {
        return this.getDescriptorOrFail().getExternalName(string, string2);
    }

    @Override
    public final String getExternalName(String string) {
        return this.getExternalName(string, null);
    }

    @Override
    public DataType[] listSupportedDataTypes() {
        Collection<DataType> collection = this.getDescriptorOrFail().listSupportedDataTypes();
        return collection.toArray(new DataType[collection.size()]);
    }

    @Override
    public DataType getDataType(String string) {
        return this.getDescriptorOrFail().getDataType(string);
    }

    @Override
    public DataType getOrCreateDataType(String string) {
        DataType dataType = this.getDataType(string);
        if (dataType == null) {
            this.getLogger().log(Level.FINE, "DataTypeRegistry had no \"" + string + "\" for provider " + this.getName());
            dataType = DataTypeRegistry.getInstance().createUserDataType(string, this);
        }
        return dataType;
    }

    @Override
    public final void validateObject(DBObject dBObject) throws ValidationException {
        this.validateObject(null, dBObject);
    }

    @Override
    @Deprecated
    public final void validateObject(DBObject dBObject, String string) throws ValidationException {
        this.validateObjectProperty(dBObject, string);
    }

    @Override
    @Deprecated
    public final void validateObjectProperty(DBObject dBObject, Object object) throws ValidationException {
        this.validateObjectProperty(dBObject, object == null ? null : String.valueOf(object));
    }

    @Override
    public final void validateObjectProperty(DBObject dBObject, String string) throws ValidationException {
        this.validateObjectProperty(null, dBObject, string);
    }

    @Override
    @Deprecated
    public final void validateSchema(Schema schema) throws ValidationException {
        this.validateObject(schema);
    }

    @Override
    public final void validateObject(DBObject dBObject, DBObject dBObject2) throws ValidationException {
        this.validateObject(dBObject, dBObject2, null);
    }

    @Override
    @Deprecated
    public final void validateObject(DBObject dBObject, DBObject dBObject2, String string) throws ValidationException {
        this.validateObjectProperty(dBObject, dBObject2, string);
    }

    @Override
    @Deprecated
    public final void validateObjectProperty(DBObject dBObject, DBObject dBObject2, Object object) throws ValidationException {
        this.validateObjectProperty(dBObject, dBObject2, object == null ? null : String.valueOf(object));
    }

    @Override
    public final void validateObjectProperty(DBObject dBObject, DBObject dBObject2, String string) throws ValidationException {
        this.validate(new ValidationContext<DBObject>(dBObject, dBObject2, ValidationLevel.FULL, string));
    }

    public void validate(ValidationContext<?> validationContext) throws ValidationException {
        this.validateImpl(validationContext);
    }

    private <T extends DBObject> void validateImpl(ValidationContext<T> validationContext) throws ValidationException {
        T t = validationContext.getUpdatedObject();
        DBObjectValidator<T> dBObjectValidator = this.getValidator(t);
        this.getObjectFactory().ensureDerivedPropertyBuilder((DBObject)t);
        dBObjectValidator.validate(validationContext);
    }

    @Override
    @Deprecated
    public final void validateSchema(Schema schema, Schema schema2) throws ValidationException {
        this.validateObject((DBObject)schema, schema2);
    }

    @Override
    public final void validateUniqueName(String string, DBObject dBObject, String string2) throws NameInUseException {
        if (ModelUtil.hasLength((String)string2)) {
            string = this.normaliseType(string);
            DBObject dBObject2 = Metadata.getInstance().newInstance(string);
            if (dBObject2 == null) {
                throw new IllegalStateException("Unknown or invalid type " + string);
            }
            dBObject2.setName(string2);
            if (dBObject2 instanceof SchemaObject && dBObject instanceof Schema) {
                ((SchemaObject)dBObject2).setSchema((Schema)dBObject);
            }
            this.validateUniqueName(dBObject2, dBObject);
        }
    }

    @Override
    public void validateUniqueName(DBObject dBObject, DBObject dBObject2) throws NameInUseException {
        block14: {
            String string;
            String string2;
            block16: {
                block15: {
                    Object object;
                    string2 = dBObject.getName();
                    if (!ModelUtil.hasLength((String)string2)) break block14;
                    string = dBObject.getType();
                    if (!this.supportsObjectType(string) || dBObject2 != null && !(dBObject2 instanceof Schema)) break block15;
                    Collection<?> collection = null;
                    try {
                        object = this.getNamespaceCriteria(string, (Schema)dBObject2, string2);
                        if (object != null) {
                            collection = this.listObjects((DBObjectCriteria)object);
                        }
                    }
                    catch (DBException dBException) {
                        this.getLogger().log(Level.WARNING, APIBundle.format("UNIQUE_NAME_CHECK_ERR", dBException.getMessage()));
                    }
                    if (collection != null && (object = collection.iterator()).hasNext()) {
                        SystemObject systemObject = (SystemObject)object.next();
                        throw new NameInUseException(dBObject, systemObject);
                    }
                    break block14;
                }
                if (!(dBObject2 instanceof Schema)) break block16;
                ArrayList<String> arrayList = new ArrayList<String>();
                Collection<String> collection = Metadata.getInstance().getOwnerTypes(string);
                for (String string3 : this.listObjectTypes()) {
                    if (!collection.contains(string3)) continue;
                    arrayList.add(string3);
                }
                if (arrayList.size() <= 0) break block14;
                Object[] objectArray = null;
                try {
                    objectArray = this.listObjects(arrayList.toArray(new String[arrayList.size()]), (Schema)dBObject2);
                }
                catch (DBException dBException) {
                    this.getLogger().log(Level.WARNING, APIBundle.format("UNIQUE_NAME_CHECK_ERR", dBException.getMessage()));
                }
                if (objectArray != null) {
                    for (Object object : objectArray) {
                        DBObject[] dBObjectArray;
                        if (DBUtil.areNamesAndTypesEqual((DBObject)object, dBObject.getParent())) continue;
                        if (string.equals("CONSTRAINT") && object instanceof Relation) {
                            Collection<Constraint> collection2 = Constraint.getConstraints((Relation)object, "UniqueConstraint", "PKConstraint");
                            dBObjectArray = collection2.toArray(new DBObject[collection2.size()]);
                        } else {
                            dBObjectArray = object.getOwnedObjects(string);
                        }
                        for (DBObject dBObject3 : dBObjectArray) {
                            if (!this.getDescriptor().areNamesEqual(dBObject3.getName(), string2, dBObject3.getType(), false)) continue;
                            throw new NameInUseException(dBObject, dBObject3);
                        }
                    }
                }
                break block14;
            }
            if (dBObject2 != null) {
                for (DBObject dBObject4 : dBObject2.getOwnedObjects(string)) {
                    if (!this.getDescriptor().areNamesEqual(dBObject4.getName(), string2, dBObject4.getType(), false)) continue;
                    throw new NameInUseException(dBObject, dBObject4);
                }
            }
        }
    }

    private DBObjectCriteria<?> getNamespaceCriteria(String string, Schema schema, String string2) {
        DBObjectCriteria<SystemObject> dBObjectCriteria = null;
        if (this.supportsObjectType(string)) {
            DBObjectValidator.NamespaceType namespaceType;
            DBObjectValidator dBObjectValidator = this.getValidatorForType(string);
            DBObjectValidator.NamespaceType namespaceType2 = namespaceType = dBObjectValidator == null ? DBObjectValidator.NamespaceType.SCHEMA : dBObjectValidator.getNamespaceType();
            Collection<String> collection = namespaceType == DBObjectValidator.NamespaceType.SCHEMA ? this.getDescriptor().listSchemaNamespaceTypes(this) : (namespaceType == DBObjectValidator.NamespaceType.TYPE ? Collections.singleton(string) : Collections.emptyList());
            if (collection.size() > 0) {
                dBObjectCriteria = DBObjectCriteria.createTypeCriteria(collection);
                dBObjectCriteria.setSchema(schema);
                dBObjectCriteria.setName(string2);
            }
        }
        return dBObjectCriteria;
    }

    @Override
    public String getUniqueName(String string, DBObject dBObject, String string2) {
        return this.getUniqueName(string, dBObject, string2, null);
    }

    @Override
    public String getUniqueName(String string, DBObject dBObject, String string2, Collection<String> collection) {
        DBObjectValidator dBObjectValidator;
        Set<String> set = NameComparator.createNameSet(this.getDescriptor(), false);
        if (collection != null) {
            set.addAll(collection);
        }
        string = this.normaliseType(string);
        if (!ModelUtil.hasLength((String)string2)) {
            string2 = string + 1;
        }
        int n = this.getCasePolicy();
        if (dBObject == null || dBObject instanceof Schema) {
            Object object;
            boolean bl = false;
            DBObjectCriteria<Object> dBObjectCriteria = this.getNamespaceCriteria(string, (Schema)dBObject, string2);
            if (dBObjectCriteria == null) {
                bl = true;
                object = Metadata.getInstance().getOwnerTypes(string);
                object.retainAll(Arrays.asList(this.listObjectTypes()));
                if (!object.isEmpty()) {
                    dBObjectCriteria = DBObjectCriteria.createTypeCriteria(object);
                    dBObjectCriteria.setSchema((Schema)dBObject);
                }
            } else {
                object = null;
                if (!bl && n != 0 && (object = (String)DBUtil.splitBaseName(string2).getFirst()) != null) {
                    object = object + DBObjectCriteria.LIKE_WILDCARD;
                }
                dBObjectCriteria.setNameLike((String)object);
            }
            object = null;
            if (dBObjectCriteria != null) {
                try {
                    object = this.listObjects(dBObjectCriteria);
                }
                catch (DBException dBException) {
                    this.getLogger().warning(APIBundle.format("UNIQUE_NAME_CHECK_ERR", dBException.getMessage()));
                }
            }
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    SystemObject systemObject = (SystemObject)iterator.next();
                    if (bl) {
                        this.addChildrenNames(systemObject.getOwnedObjects(string), set);
                        continue;
                    }
                    set.add(systemObject.getName());
                }
            }
        } else if (dBObject instanceof SystemObject && ((dBObjectValidator = this.getValidatorForType(string)) == null || dBObjectValidator.getNamespaceType() != DBObjectValidator.NamespaceType.NONE)) {
            this.addChildrenNames(dBObject.getOwnedObjects(string), set);
        }
        int n2 = this.getDescriptor().getMaxNameLength(string);
        return DBUtil.getUniqueName(set, string2, true, n2);
    }

    @Deprecated
    protected boolean getUniqueNameTreatIndexAsSchemaObject() {
        return false;
    }

    private void addChildrenNames(DBObject[] dBObjectArray, Collection collection) {
        for (int i = 0; i < dBObjectArray.length; ++i) {
            collection.add(dBObjectArray[i].getName());
        }
    }

    protected String normaliseType(String string) {
        return Constraint.getConstraintTypes().contains(string) ? "CONSTRAINT" : string;
    }

    @Override
    public DiffEngine getDiffEngine() {
        return null;
    }

    protected Difference ensureSystemObjectListDifference(Difference difference) throws IllegalArgumentException {
        Difference difference2;
        if (difference instanceof ResultSet && difference.isMap() && difference.getOriginalObject() instanceof SystemObject) {
            SystemObject[] systemObjectArray = new SystemObject[]{(SystemObject)difference.getOriginalObject()};
            SystemObject[] systemObjectArray2 = new SystemObject[]{(SystemObject)difference.getUpdatedObject()};
            difference2 = new ResultSet(null, systemObjectArray, (Object)systemObjectArray2, null, "LIST");
            ((ResultSet)difference2).addToList((ResultSet)difference);
        } else if (difference.isList()) {
            difference2 = difference;
        } else {
            throw new IllegalStateException("updateObjects must be called with a LIST Difference.");
        }
        return difference2;
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }

    protected void logEvent(String string, Object ... objectArray) {
        this.getLogger().log(Level.FINE, string, objectArray);
    }

    @Override
    public boolean isEditable(DBObject dBObject) {
        String string;
        DBObjectBuilder dBObjectBuilder;
        SystemObject systemObject;
        boolean bl = false;
        if (dBObject != null && (systemObject = DBUtil.getSystemObject(dBObject)) != null && (dBObjectBuilder = this.getBuilderForType(string = systemObject.getType())) != null && dBObjectBuilder.canBuildEditableObject()) {
            PropertyManager propertyManager = this.getPropertyManager();
            bl = propertyManager != null && (propertyManager.supportsAction(string, PropertyAction.Type.REPLACE) || propertyManager.supportsAction(string, PropertyAction.Type.ALTER));
        }
        return bl;
    }

    @Override
    public DBObject getDefaultTemplateForType(String string) {
        return null;
    }

    @Override
    public void setDefaultTemplateForType(String string, DBObject dBObject) {
        throw new RuntimeException("Cannot store defaults online");
    }

    @Override
    public boolean isNewFromTemplateType(String string) {
        return NEW_FROM_TEMPLATE_TYPE.equals(string);
    }

    @Deprecated
    protected void registerSchemaObjectExpander(SchemaObjectExpander schemaObjectExpander) {
    }

    @Deprecated
    public SchemaObjectExpander[] getSchemaObjectExpanders() {
        return new SchemaObjectExpander[0];
    }

    @Override
    public DBObjectFactory getObjectFactory() {
        if (this.m_dbObjFactory == null) {
            this.m_dbObjFactory = this.createObjectFactory();
        }
        return this.m_dbObjFactory;
    }

    protected DBObjectFactory createObjectFactory() {
        return new DBObjectFactory(this);
    }

    @Override
    public final void updateObjects(Difference difference, boolean bl, boolean bl2) throws DBException {
        difference = this.ensureSystemObjectListDifference(difference);
        DBObjectTransaction dBObjectTransaction = new DBObjectTransaction(this);
        dBObjectTransaction.setCascade(bl2);
        dBObjectTransaction.setReplace(bl);
        dBObjectTransaction.includeListDifference(difference);
        this.commitTransaction(dBObjectTransaction);
    }

    @Override
    public final void commitTransaction(DBObjectTransaction dBObjectTransaction) throws DBException {
        Collection<DBObjectChange> collection;
        for (oracle.javatools.db.event.DBObjectProviderListener collection2 : this.m_listeners) {
            try {
                collection2.transactionSubmitted(dBObjectTransaction);
            }
            catch (Exception exception) {
                this.processListenerException(collection2, exception);
            }
        }
        Difference difference = dBObjectTransaction.getTransactionDifference();
        difference.print();
        for (Object object : this.m_listeners) {
            try {
                ((oracle.javatools.db.event.DBObjectProviderListener)object).transactionProcessed(dBObjectTransaction, difference);
            }
            catch (Exception exception) {
                this.processListenerException(object, exception);
            }
        }
        if (!difference.isSame() && (collection = this.commitTransaction(dBObjectTransaction, difference)) != null) {
            for (oracle.javatools.db.event.DBObjectProviderListener dBObjectProviderListener : this.m_listeners) {
                try {
                    dBObjectProviderListener.transactionCommited(dBObjectTransaction, difference, collection);
                }
                catch (Exception exception) {
                    this.processListenerException(dBObjectProviderListener, exception);
                }
            }
        }
    }

    protected abstract Collection<DBObjectChange> commitTransaction(DBObjectTransaction var1, Difference var2) throws DBException;

    private static final class ListenerBridge
    extends oracle.javatools.db.event.DBObjectProviderListener {
        private DBObjectProviderListener m_list;

        ListenerBridge(DBObjectProviderListener dBObjectProviderListener) {
            this.m_list = dBObjectProviderListener;
        }

        @Override
        public void schemaObjectsAdded(DBObjectProvider dBObjectProvider, Schema schema, Collection<? extends SchemaObject> collection) {
            this.m_list.schemaObjectsAdded(dBObjectProvider, schema, collection.toArray(new SchemaObject[collection.size()]));
        }

        @Override
        public void schemaObjectsRemoved(DBObjectProvider dBObjectProvider, Schema schema, Collection<? extends SchemaObject> collection) {
            this.m_list.schemaObjectsRemoved(dBObjectProvider, schema, collection.toArray(new SchemaObject[collection.size()]));
        }

        @Override
        public void systemObjectsAdded(DBObjectProvider dBObjectProvider, Collection<? extends SystemObject> collection) {
            for (SystemObject systemObject : collection) {
                if (!(systemObject instanceof Schema)) continue;
                this.m_list.schemaAdded(dBObjectProvider, (Schema)systemObject);
            }
        }

        @Override
        public void systemObjectsRemoved(DBObjectProvider dBObjectProvider, Collection<? extends SystemObject> collection) {
            for (SystemObject systemObject : collection) {
                if (!(systemObject instanceof Schema)) continue;
                this.m_list.schemaRemoved(dBObjectProvider, (Schema)systemObject);
            }
        }

        @Override
        public void providerOpened(DBObjectProvider dBObjectProvider) {
            this.m_list.providerOpened(dBObjectProvider);
        }

        @Override
        public void providerClosed(DBObjectProvider dBObjectProvider) {
            this.m_list.providerClosed(dBObjectProvider);
        }

        @Override
        public void providerReloaded(DBObjectProvider dBObjectProvider) {
            this.m_list.providerReloaded(dBObjectProvider);
        }

        boolean isBridgeFor(DBObjectProviderListener dBObjectProviderListener) {
            return ModelUtil.areEqual((Object)this.m_list, (Object)dBObjectProviderListener);
        }
    }
}

