/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractChildBuildableObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IdentityColumnProperties;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.SQLFragment;

public class Column
extends AbstractChildBuildableObject {
    public static final String TYPE = "COLUMN";
    @Deprecated
    public static final String AUTO_GENERATED_SEQUENCE = "AUTO_GENERATED_SEQUENCE";
    @Deprecated
    public static final String AUTO_GENERATED_SEQUENCE_TRIGGER = "AUTO_GENERATED_SEQUENCE_TRIGGER";

    public Column() {
        this((String)null, (DataTypeUsage)null);
    }

    public Column(String string) {
        this(string, (DataTypeUsage)null);
    }

    public Column(String string, DataTypeUsage dataTypeUsage) {
        super(string, (DBObject)null);
        if (dataTypeUsage != null) {
            this.setDataTypeUsage(dataTypeUsage);
        }
        this.setNotNull(false);
    }

    public void setDefault(Object object) {
        this.setProperty("default", object);
    }

    public Object getDefault() {
        return this.getProperty("default");
    }

    public void setVirtualExpression(SQLFragment sQLFragment) {
        this.setProperty("virtualExpression", sQLFragment);
    }

    @Derived(value="virtualExpressionSource")
    @Internal
    public SQLFragment getVirtualExpression() {
        return (SQLFragment)this.getProperty("virtualExpression");
    }

    public void setVirtualExpressionSource(String string) {
        this.setProperty("virtualExpressionSource", string);
    }

    @TextProperty(multiLine=true)
    public String getVirtualExpressionSource() {
        SQLFragment sQLFragment;
        String string = (String)this.getProperty("virtualExpressionSource");
        if (string == null && (sQLFragment = (SQLFragment)this.getPropertySupport().get("virtualExpression")) != null) {
            string = sQLFragment.getSQLText();
        }
        return string;
    }

    public boolean isNotNull() {
        return (Boolean)this.getProperty("notNull", false);
    }

    public void setNotNull(boolean bl) {
        this.setProperty("notNull", bl);
    }

    public void setDataTypeUsage(DataTypeUsage dataTypeUsage) {
        this.setProperty("dataTypeUsage", dataTypeUsage);
    }

    public DataTypeUsage getDataTypeUsage() {
        return (DataTypeUsage)this.getProperty("dataTypeUsage");
    }

    public void setIdentityProperties(IdentityColumnProperties identityColumnProperties) {
        this.setProperty("identityProperties", identityColumnProperties);
    }

    public IdentityColumnProperties getIdentityProperties() {
        return (IdentityColumnProperties)this.getProperty("identityProperties");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Internal
    public Relation getRelation() {
        return (Relation)this.getParent();
    }

    public void setRelation(Relation relation) {
        this.setParent(relation);
    }

    @Transient
    @Deprecated
    public Long getPrecision() {
        DataTypeUsage dataTypeUsage = this.getDataTypeUsage();
        if (dataTypeUsage == null) {
            return null;
        }
        Long l = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "precision");
        Long l2 = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "size");
        return l == null ? l2 : l;
    }

    @Transient
    @Deprecated
    public void setPrecision(Long l) {
        DataTypeUsage dataTypeUsage = this.getDataTypeUsage();
        if (dataTypeUsage != null) {
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType(dataTypeUsage);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (dataType != null) {
                if (dataType.hasDataTypeAttribute("precision")) {
                    dataTypeUsage.putAttributeValue("precision", l);
                } else if (dataType.hasDataTypeAttribute("size")) {
                    dataTypeUsage.putAttributeValue("size", l);
                }
            }
        }
    }

    @Deprecated
    @Transient
    public Long getScale() {
        DataTypeUsage dataTypeUsage = this.getDataTypeUsage();
        return dataTypeUsage == null ? null : DataTypeHelper.getLongAttributeValue(dataTypeUsage, "scale");
    }

    @Deprecated
    @Transient
    public void setScale(Long l) {
        DataTypeUsage dataTypeUsage = this.getDataTypeUsage();
        if (dataTypeUsage != null) {
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType(dataTypeUsage);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (dataType != null && dataType.hasDataTypeAttribute("scale")) {
                dataTypeUsage.putAttributeValue("scale", l);
            }
        }
    }
}

