/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectID;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ProviderUsage;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyInitializer;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.util.DBObjectIDMap;
import oracle.javatools.db.util.DBObjectIDSet;
import oracle.javatools.util.ModelUtil;

public class DBObjectFactory {
    private DBObjectProvider m_pro;

    protected DBObjectFactory(DBObjectProvider dBObjectProvider) {
        this.m_pro = dBObjectProvider;
    }

    protected final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }

    private Schema getSchema(DBObject dBObject) {
        Schema schema;
        Schema schema2 = schema = dBObject instanceof Schema ? (Schema)dBObject : DBUtil.getSchema(dBObject);
        if (schema == null) {
            try {
                schema = this.getProvider().getDefaultSchema();
            }
            catch (DBException dBException) {
                this.getLogger().warning("Couldn't get default schema: " + dBException.getMessage());
            }
        }
        return schema;
    }

    public <T extends DBObject> T newObject(T t) {
        Table table = t instanceof Index ? ((Index)t).getTable() : null;
        return this.newObject(t, (DBObject)table);
    }

    public <T extends DBObject> T newObject(T t, DBObject dBObject) {
        return this.newObject(t, dBObject, true);
    }

    private <T extends DBObject> T newObject(T t, DBObject dBObject, boolean bl) {
        DBObject dBObject2 = null;
        try {
            if (t != null) {
                dBObject2 = TemplateExpander.initialiseObject(t);
                if (t instanceof SchemaObject && Boolean.TRUE.equals(t.getProperty("public")) && dBObject == null) {
                    dBObject = ((SchemaObject)t).getSchema();
                }
                this.setup(dBObject2, dBObject, bl);
            }
        }
        catch (Exception exception) {
            this.getLogger().log(DBLog.getExceptionLogLevel(), "Cannot instantiate new schema object", exception);
        }
        return (T)dBObject2;
    }

    public <T extends DBObject> T newObject(Class<T> clazz) {
        return this.newObject(clazz, null);
    }

    public <T extends DBObject> T newObject(Class<T> clazz, DBObject dBObject) {
        return this.newObject(clazz, dBObject, null);
    }

    public <T extends DBObject> T newObject(Class<T> clazz, DBObject dBObject, String string) {
        return this.newObject(clazz, dBObject, string, true, true);
    }

    public <T extends DBObject> T newObject(Class<T> clazz, DBObject dBObject, boolean bl, boolean bl2) {
        return this.newObject(clazz, dBObject, null, bl, bl2);
    }

    public <T extends DBObject> T newObject(Class<T> clazz, DBObject dBObject, String string, boolean bl, boolean bl2) {
        DBObject dBObject2 = null;
        try {
            DBObject dBObject3;
            String string2;
            if (bl && (string2 = Metadata.getType(clazz)) != null && (dBObject3 = this.m_pro.getDefaultTemplateForType(string2)) != null) {
                dBObject2 = this.newObject(dBObject3, dBObject);
            }
            if (dBObject2 == null) {
                dBObject2 = (DBObject)clazz.newInstance();
                dBObject2.setName(string);
                this.setup(dBObject2, dBObject, bl2);
            }
        }
        catch (Exception exception) {
            this.getLogger().log(DBLog.getExceptionLogLevel(), "Cannot instantiate new schema object", exception);
        }
        return (T)dBObject2;
    }

    private void setup(DBObject dBObject, DBObject dBObject2, boolean bl) {
        if (dBObject instanceof SchemaObject) {
            ((SchemaObject)dBObject).setSchema(this.getSchema(dBObject2));
        }
        if (!(dBObject2 instanceof Schema) && dBObject instanceof ChildDBObject) {
            ((ChildDBObject)dBObject).setParent(dBObject2);
        }
        if (bl) {
            this.initialiseProperties(dBObject);
            for (DBObject dBObject3 : dBObject.getOwnedObjects("COLUMN", "CONSTRAINT")) {
                this.initialiseProperties(dBObject3);
            }
        }
        this.ensureDerivedPropertyBuilder(dBObject);
        if (dBObject instanceof ProviderUsage) {
            ((ProviderUsage)((Object)dBObject)).setProvider(this.getProvider());
        }
    }

    public final DerivedPropertyBuilder ensureDerivedPropertyBuilder(DBObject dBObject) {
        return this.ensureDerivedPropertyBuilder(dBObject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DerivedPropertyBuilder ensureDerivedPropertyBuilder(DBObject dBObject, boolean bl) {
        DerivedPropertyBuilder derivedPropertyBuilder = null;
        if (dBObject != null) {
            if (dBObject instanceof AbstractBuildableObject) {
                AbstractBuildableObject.BuildablePropertySupport object;
                AbstractBuildableObject abstractBuildableObject = (AbstractBuildableObject)dBObject;
                AbstractBuildableObject.BuildablePropertySupport buildablePropertySupport = object = abstractBuildableObject.getPropertySupport();
                synchronized (buildablePropertySupport) {
                    DerivedPropertyBuilder derivedPropertyBuilder2 = object.getDerivedPropertyBuilder();
                    if (derivedPropertyBuilder2 == null || !this.isValidDerivedPropertyProvider(abstractBuildableObject, derivedPropertyBuilder2.getProvider())) {
                        derivedPropertyBuilder = this.m_pro.getDescriptor().getDerivedPropertyBuilder(abstractBuildableObject.getClass(), this.m_pro);
                        if (derivedPropertyBuilder != null) {
                            object.setDerivedPropertyBuilder(derivedPropertyBuilder);
                        }
                    } else {
                        derivedPropertyBuilder = derivedPropertyBuilder2;
                    }
                }
            }
            if (bl && dBObject instanceof AbstractDBObject) {
                for (DBObject dBObject2 : DBUtil.getExistingOwnedObjects(dBObject)) {
                    this.ensureDerivedPropertyBuilder(dBObject2);
                }
            }
        }
        return derivedPropertyBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractBuildableObject> boolean setDerivedPropertyBuilder(T t, DerivedPropertyBuilder<? super T> derivedPropertyBuilder) {
        boolean bl = false;
        if (t != null && derivedPropertyBuilder != null && derivedPropertyBuilder.getProvider() == this.m_pro) {
            AbstractBuildableObject.BuildablePropertySupport buildablePropertySupport;
            AbstractBuildableObject.BuildablePropertySupport buildablePropertySupport2 = buildablePropertySupport = t.getPropertySupport();
            synchronized (buildablePropertySupport2) {
                DerivedPropertyBuilder derivedPropertyBuilder2 = buildablePropertySupport.getDerivedPropertyBuilder();
                if (derivedPropertyBuilder2 == derivedPropertyBuilder) {
                    bl = true;
                } else if (derivedPropertyBuilder2 == null) {
                    buildablePropertySupport.setDerivedPropertyBuilder(derivedPropertyBuilder);
                    bl = true;
                }
            }
        }
        return bl;
    }

    private boolean isValidDerivedPropertyProvider(AbstractBuildableObject abstractBuildableObject, DBObjectProvider dBObjectProvider) {
        DBObjectProvider dBObjectProvider2;
        DBObjectID dBObjectID;
        boolean bl;
        boolean bl2 = bl = this.m_pro == dBObjectProvider;
        if (!bl && (dBObjectID = abstractBuildableObject.getID()) instanceof BaseObjectID && (dBObjectProvider2 = ((BaseObjectID)dBObjectID).getProvider()) == dBObjectProvider) {
            bl = true;
        }
        return bl;
    }

    @Deprecated
    public Object getExternalDefaultValue(DBObject dBObject, String string) {
        DatabaseDescriptor databaseDescriptor = this.getProvider().getDescriptor();
        return this.getValueImpl(dBObject, string, databaseDescriptor.getExternalPropertyDefaulters(this.getProvider()));
    }

    public Object getInitialValue(DBObject dBObject, String string) {
        DatabaseDescriptor databaseDescriptor = this.getProvider().getDescriptor();
        return this.getValueImpl(dBObject, string, databaseDescriptor.getPropertyInitializers(this.getProvider()));
    }

    private Object getValueImpl(DBObject dBObject, String string, List<PropertyInitializer> list) {
        if (list != null) {
            for (PropertyInitializer propertyInitializer : list) {
                String[] stringArray = propertyInitializer.getPropertyNames(dBObject.getClass());
                if (stringArray == null) continue;
                for (String string2 : stringArray) {
                    if (!string.equals(string2)) continue;
                    try {
                        return propertyInitializer.getPropertyInitialValue(dBObject, string2);
                    }
                    catch (PropertyInitializer.InitializationVeto initializationVeto) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    private void initialiseProperties(DBObject dBObject) {
        DBObjectID dBObjectID = dBObject.getID();
        if (dBObjectID == null) {
            dBObjectID = TemporaryObjectID.createID(dBObject);
            dBObject.setID(dBObjectID);
        }
        DBObjectProvider dBObjectProvider = this.getProvider();
        DatabaseDescriptor databaseDescriptor = dBObjectProvider.getDescriptor();
        HashSet<String> hashSet = new HashSet<String>();
        List<PropertyInitializer> list = databaseDescriptor.getPropertyInitializers(dBObjectProvider);
        for (PropertyInitializer propertyInitializer : list) {
            String[] stringArray = propertyInitializer.getPropertyNames(dBObject.getClass());
            if (stringArray == null) continue;
            for (String string : stringArray) {
                if (hashSet.contains(string)) continue;
                PropertyHelper propertyHelper = new PropertyHelper(this.m_pro);
                try {
                    if (dBObject instanceof SystemObject && !dBObjectProvider.getPropertyManager().canCreateProperty((SystemObject)dBObject, string)) continue;
                    Object object = propertyInitializer.getPropertyInitialValue(dBObject, string);
                    propertyHelper.setPropertyValue(dBObject, string, object);
                    hashSet.add(string);
                }
                catch (PropertyInitializer.InitializationVeto initializationVeto) {
                    // empty catch block
                }
            }
        }
    }

    public void ensureSchema(SchemaObject schemaObject) {
        Schema schema = schemaObject.getSchema();
        if (schema != null) {
            try {
                Schema schema2 = this.getProvider().getSchema(schema.getName());
                if (schema2 != null && schema2 != schema) {
                    schemaObject.setSchema(schema2);
                }
            }
            catch (DBException dBException) {
                DBLog.getLogger(this).log(Level.WARNING, dBException.getMessage());
            }
        }
    }

    public void ensureIDs(Collection<? extends DBObject> collection, Difference difference) {
        Map<DBObjectID, DBObjectID> map = this.newIDMap();
        if (difference != null) {
            this.populateIDMap(difference, map);
        }
        this.ensureIDsImpl(collection, map, false);
    }

    public DBObjectID ensureID(DBObject dBObject, boolean bl, boolean bl2) {
        DBObjectID dBObjectID;
        if (bl) {
            this.ensureIDsImpl(Collections.singletonList(dBObject), this.newIDMap(), bl2);
            dBObjectID = dBObject.getID();
        } else {
            dBObjectID = this.ensureIDImpl(dBObject, bl, true, bl2, null, null);
        }
        return dBObjectID;
    }

    private void ensureIDsImpl(Collection<? extends DBObject> collection, Map<DBObjectID, DBObjectID> map, boolean bl) {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (DBObject dBObject : collection) {
            if (dBObject == null) continue;
            this.ensureIDImpl(dBObject, true, false, bl, arrayList, map);
        }
        for (DBObject dBObject : arrayList) {
            this.checkReferences(dBObject, this.getReferenceIDs(dBObject), map);
        }
    }

    private DBObjectID ensureIDImpl(DBObject dBObject, boolean bl, boolean bl2, boolean bl3, Collection<DBObject> collection, Map<DBObjectID, DBObjectID> map) {
        Object object;
        Object object2;
        if (dBObject instanceof ProviderUsage) {
            ((ProviderUsage)((Object)dBObject)).setProvider(this.getProvider());
        }
        BaseObjectID baseObjectID = null;
        DBObjectID dBObjectID = this.getObjectID(dBObject);
        DBObjectID dBObjectID2 = null;
        DBObject dBObject2 = dBObject.getParent();
        if (bl2 && dBObject2 != null) {
            dBObjectID2 = this.ensureID(dBObject2, false, bl3);
        } else if (bl && !bl2 && dBObject2 != null) {
            dBObjectID2 = this.findParentID(dBObject2.getID());
        }
        if (dBObject instanceof SQLFragment) {
            this.ensureProvider(dBObject, true);
        }
        if (dBObjectID == null) {
            baseObjectID = this.createID(dBObject, dBObjectID2);
        } else if (dBObjectID instanceof TemporaryObjectID) {
            object2 = TemporaryObjectID.findOriginalObject((TemporaryObjectID)dBObjectID);
            if (object2 == null) {
                baseObjectID = this.createID(dBObject, dBObjectID2);
            } else {
                object = object2.getID();
                if (object instanceof BaseObjectID) {
                    baseObjectID = (BaseObjectID)object;
                    baseObjectID.setParent(dBObjectID2);
                    this.ensureProvider(baseObjectID);
                } else {
                    baseObjectID = this.createID(dBObject, dBObjectID2);
                }
                if (object != null && map != null) {
                    map.put((DBObjectID)object, baseObjectID);
                }
            }
            if (map != null) {
                map.put(dBObjectID, baseObjectID);
            }
        } else if (dBObjectID instanceof BaseObjectID) {
            if (dBObjectID.getType() == null) {
                ((BaseObjectID)dBObjectID).setType(dBObject.getType());
            }
            baseObjectID = ModelUtil.areDifferent((Object)dBObjectID2, (Object)dBObjectID.getParent()) ? (BaseObjectID)dBObjectID.copyTo(null) : (BaseObjectID)dBObjectID;
            this.ensureProvider(baseObjectID);
            baseObjectID.setParent(dBObjectID2);
            if (baseObjectID != dBObjectID) {
                map.put(dBObjectID, baseObjectID);
            }
        }
        if (baseObjectID instanceof NameBasedID) {
            String string;
            Object object3;
            Object object4;
            object2 = (NameBasedID)baseObjectID;
            object = null;
            if (dBObject instanceof SchemaObject && (object4 = ((BaseObjectID)object2).getSchemaName()) != null && (object3 = ((SchemaObject)dBObject).getSchema()) != null && ModelUtil.areDifferent((Object)(string = ((AbstractDBObject)object3).getName()), (Object)object4)) {
                object = string;
            }
            object4 = null;
            object3 = this.getName(dBObject, bl3);
            if (object3 != null && !((String)object3).equals(((BaseObjectID)object2).getName())) {
                object4 = object3;
            }
            if (object != null || object4 != null) {
                baseObjectID = (NameBasedID)((NameBasedID)object2).copyTo(null);
                if (object != null) {
                    baseObjectID.setSchemaName((String)object);
                }
                if (object4 != null) {
                    baseObjectID.setName((String)object4);
                }
                if (map != null) {
                    map.put((DBObjectID)object2, baseObjectID);
                }
            }
        }
        if (baseObjectID != null) {
            dBObject.setID(baseObjectID);
        }
        if (dBObject instanceof AbstractDBObject && !(object2 = this.getReferenceIDs(dBObject)).isEmpty()) {
            if (collection != null) {
                collection.add(dBObject);
            } else {
                this.checkReferences(dBObject, (Collection<DBObjectID>)object2, map);
            }
        }
        if (bl) {
            object2 = DBUtil.getExistingOwnedObjects(dBObject).iterator();
            while (object2.hasNext()) {
                object = object2.next();
                this.ensureIDImpl((DBObject)object, true, false, bl3, collection, map);
            }
            if (dBObject instanceof SchemaObject && (object2 = ((SchemaObject)dBObject).getSchema()) != null) {
                try {
                    object = this.getProvider().getSchema(((AbstractDBObject)object2).getName());
                    if (object != null && object != object2) {
                        ((SchemaObject)dBObject).setSchema((Schema)object);
                    }
                }
                catch (DBException dBException) {
                    this.getLogger().warning("Could not get Schema " + ((AbstractDBObject)object2).getName());
                }
            }
        }
        if (baseObjectID != null && baseObjectID.getParent() instanceof TemporaryObjectID) {
            this.getLogger().warning("Parent of " + baseObjectID.toString() + " is a TemporaryObjectID");
        }
        if (baseObjectID != null) {
            this.ensureBaseInfo(baseObjectID, dBObject, bl3);
        }
        this.ensureDerivedPropertyBuilder(dBObject);
        return baseObjectID;
    }

    private DBObjectID findParentID(DBObjectID dBObjectID) {
        DBObjectID dBObjectID2 = null;
        if (dBObjectID instanceof BaseObjectID) {
            dBObjectID2 = dBObjectID;
        }
        return dBObjectID2;
    }

    private BaseObjectID ensureProviderCanCopy(BaseObjectID baseObjectID, DBObjectProvider dBObjectProvider) {
        DBObjectProvider dBObjectProvider2 = baseObjectID.getProvider();
        if (dBObjectProvider2 != null && dBObjectProvider2 != dBObjectProvider) {
            BaseObjectID baseObjectID2 = BaseObjectID.copyWithNewProvider(baseObjectID, (AbstractDBObjectProvider)dBObjectProvider);
            return baseObjectID2;
        }
        baseObjectID.setProvider(dBObjectProvider);
        return null;
    }

    private void checkReferences(DBObject dBObject, Collection<DBObjectID> collection, Map<DBObjectID, DBObjectID> map) {
        Map<DBObjectID, DBObjectID> map2 = this.newIDMap();
        for (DBObjectID dBObjectID : collection) {
            DBObjectID dBObjectID2;
            this.ensureProvider(dBObjectID);
            if (dBObjectID instanceof BaseObjectID) {
                DBObjectID dBObjectID3;
                dBObjectID2 = (BaseObjectID)dBObjectID;
                DBObjectID dBObjectID4 = ((AbstractDBObjectID)dBObjectID2).getParent();
                if (dBObjectID4 instanceof TemporaryObjectID) {
                    dBObjectID3 = this.getRefIDForTempID((TemporaryObjectID)dBObjectID4, map2, map);
                    ((BaseObjectID)dBObjectID2).setParent(dBObjectID3);
                }
                if ((dBObjectID3 = this.ensureProviderCanCopy((BaseObjectID)dBObjectID2, this.getProvider())) != null) {
                    map2.put(dBObjectID2, dBObjectID3);
                }
            } else if (dBObjectID instanceof TemporaryObjectID) {
                this.getRefIDForTempID((TemporaryObjectID)dBObjectID, map2, map);
            }
            if (map == null || map2.containsKey(dBObjectID) || (dBObjectID2 = this.find(dBObjectID, map)) == null) continue;
            map2.put(dBObjectID, dBObjectID2);
        }
        if (map2.size() > 0) {
            dBObject.replaceReferenceIDs(map2);
        }
    }

    private DBObjectID find(DBObjectID dBObjectID, Map<DBObjectID, DBObjectID> map) {
        DBObjectID dBObjectID2 = null;
        if (map != null) {
            DBObjectID dBObjectID3;
            DBObjectIDSet dBObjectIDSet = new DBObjectIDSet(true);
            DBObjectID dBObjectID4 = dBObjectID;
            while (dBObjectID4 != null && (dBObjectID3 = map.get(dBObjectID4)) != null) {
                dBObjectIDSet.add(dBObjectID4);
                dBObjectID4 = dBObjectID3;
                if (!dBObjectIDSet.contains(dBObjectID4)) continue;
                break;
            }
            if (dBObjectID4 != dBObjectID && dBObjectID4 != null) {
                dBObjectID2 = dBObjectID4;
            }
        }
        return dBObjectID2;
    }

    private DBObjectID getRefIDForTempID(TemporaryObjectID temporaryObjectID, Map<DBObjectID, DBObjectID> map, Map<DBObjectID, DBObjectID> map2) {
        Object object;
        Object object2;
        DBObjectID dBObjectID = this.find(temporaryObjectID, map2);
        if (dBObjectID == null && (object2 = this.findTopMostTempID(temporaryObjectID)) != null && object2 != temporaryObjectID && map2 != null && (object = map2.get(object2)) != null) {
            dBObjectID = object;
        }
        if (dBObjectID == null) {
            object2 = temporaryObjectID.getOriginalObject();
            if (object2 == null) {
                object2 = temporaryObjectID.getDBObject();
            }
            if (object2 != null && !((dBObjectID = object2.getID()) instanceof BaseObjectID)) {
                try {
                    object = DBUtil.getProviderDefinition(object2, this.getProvider());
                    if (object != null) {
                        dBObjectID = object.getID();
                    }
                }
                catch (DBException dBException) {
                    this.getLogger().warning(dBException.getMessage());
                }
            }
            if (!(dBObjectID instanceof BaseObjectID)) {
                this.getLogger().warning("DBObjectFactory: found a TemporaryID that isn't fixed up: " + (dBObjectID == null ? "null" : dBObjectID.toString()));
            }
        }
        if (dBObjectID != null) {
            map.put(temporaryObjectID, dBObjectID);
            if (map2 != null) {
                map2.put(temporaryObjectID, dBObjectID);
            }
        } else {
            this.getLogger().warning("Found a TemporaryObjectID that doesn't resolve.");
        }
        return dBObjectID;
    }

    private DBObjectID findTopMostTempID(TemporaryObjectID temporaryObjectID) {
        DBObject dBObject = temporaryObjectID.getOriginalObject();
        if (dBObject != null) {
            DBObjectID dBObjectID = dBObject.getID();
            if (dBObjectID instanceof TemporaryObjectID) {
                return this.findTopMostTempID((TemporaryObjectID)dBObjectID);
            }
            if (dBObjectID != null) {
                return dBObjectID;
            }
        }
        return temporaryObjectID;
    }

    private void ensureProvider(DBObject dBObject, boolean bl) {
        this.ensureProvider(dBObject.getID());
        for (DBObjectID dBObjectID : dBObject.getReferenceIDs()) {
            this.ensureProvider(dBObjectID);
        }
        if (bl) {
            for (DBObject dBObject2 : DBUtil.getExistingOwnedObjects(dBObject)) {
                this.ensureProvider(dBObject2, true);
            }
        }
    }

    protected boolean isValidID(DBObjectID dBObjectID) {
        return dBObjectID instanceof BaseObjectID;
    }

    protected boolean useIdentifierBasedIDs(DBObject dBObject) {
        return false;
    }

    protected BaseObjectID createID(DBObject dBObject) {
        BaseObjectID baseObjectID = this.useIdentifierBasedIDs(dBObject) ? new IdentifierBasedID(dBObject, (Object)DBUtil.createUUID(), (AbstractDBObjectProvider)this.getProvider()) : new NameBasedID(dBObject, (AbstractDBObjectProvider)this.getProvider());
        dBObject.setID(baseObjectID);
        return baseObjectID;
    }

    protected BaseObjectID createID(DBObject dBObject, DBObjectID dBObjectID) {
        BaseObjectID baseObjectID = null;
        if (dBObjectID != null && !this.isValidID(dBObjectID)) {
            throw new IllegalStateException("Invalid object and/or parent sent to ID creation");
        }
        baseObjectID = this.createID(dBObject);
        baseObjectID.setParent(dBObjectID);
        return baseObjectID;
    }

    private void populateIDMap(Difference difference, Map<DBObjectID, DBObjectID> map) {
        if (difference.isLoaded()) {
            Object object = difference.getOriginalObject();
            Object object2 = difference.getUpdatedObject();
            if (object instanceof DBObject && object2 instanceof DBObject) {
                DBObjectID dBObjectID = ((DBObject)object).getID();
                DBObjectID object3 = ((DBObject)object2).getID();
                if (dBObjectID != null && object3 != null && !dBObjectID.equals(object3, true)) {
                    map.put(object3, dBObjectID);
                }
            }
            for (Difference difference2 : difference.getChildren()) {
                this.populateIDMap(difference2, map);
            }
        }
    }

    private Map<DBObjectID, DBObjectID> newIDMap() {
        return new DBObjectIDMap<DBObjectID>(true);
    }

    protected void ensureBaseInfo(BaseObjectID baseObjectID, DBObject dBObject, boolean bl) {
        Schema schema;
        DBObject dBObject2;
        DBObjectID dBObjectID;
        String string;
        if (baseObjectID.getType() == null) {
            baseObjectID.setType(dBObject.getType());
        }
        if ((string = this.getName(dBObject, bl)) != null) {
            baseObjectID.setName(string);
        }
        DBObjectID dBObjectID2 = dBObjectID = (dBObject2 = dBObject.getParent()) == null ? null : this.findParentID(this.getObjectID(dBObject2));
        if (dBObjectID != null) {
            baseObjectID.setParent(dBObjectID);
        }
        if (dBObject instanceof SchemaObject && (schema = ((SchemaObject)dBObject).getSchema()) != null) {
            baseObjectID.setSchemaName(schema.getName());
        }
    }

    private boolean isNameInternal(DBObject dBObject) {
        PropertyInfo propertyInfo = this.getProvider().getPropertyManager().findPropertyInfo(dBObject.getClass(), "name");
        return propertyInfo == null || propertyInfo.isInternal();
    }

    protected final String getName(DBObject dBObject, boolean bl) {
        String string = (String)dBObject.getProperty("name");
        if (string == null && (bl || !this.isNameInternal(dBObject))) {
            string = dBObject.getName();
        }
        return string;
    }

    public final void ensureProvider(DBObjectID dBObjectID) {
        if (dBObjectID instanceof BaseObjectID && dBObjectID != null && ((BaseObjectID)dBObjectID).getProvider() == null) {
            ((BaseObjectID)dBObjectID).setProvider(this.getProvider());
        }
        if (dBObjectID instanceof DataTypeID) {
            ((DataTypeID)dBObjectID).ensureProvider(this.getProvider());
        }
    }

    protected final DBObjectID getObjectID(DBObject dBObject) {
        return ((AbstractDBObject)dBObject).obtainActualID();
    }

    protected final Collection<DBObjectID> getReferenceIDs(DBObject dBObject) {
        ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
        ((AbstractDBObject)dBObject).getPropertySupport().addAllReferenceIDs(arrayList);
        return arrayList;
    }
}

