/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.diff.DBObjectIDComparator;
import oracle.javatools.util.ModelUtil;

public class IDByNameComparator
extends DBObjectIDComparator {
    public IDByNameComparator() {
        super(false);
    }

    @Override
    public int compare(DBObjectID dBObjectID, DBObjectID dBObjectID2) {
        int n;
        if (dBObjectID instanceof ReferenceID && dBObjectID2 instanceof ReferenceID) {
            n = dBObjectID.toString().compareTo(dBObjectID2.toString());
        } else {
            String string = this.getName(dBObjectID);
            String string2 = this.getName(dBObjectID2);
            n = ModelUtil.hasLength((String)string) && ModelUtil.hasLength((String)string2) ? string.compareTo(string2) : super.compare(dBObjectID, dBObjectID2);
        }
        return n;
    }

    private String getName(DBObjectID dBObjectID) {
        String string = null;
        if (dBObjectID instanceof BaseObjectID) {
            string = ((BaseObjectID)dBObjectID).getName();
        }
        if (dBObjectID != null && !ModelUtil.hasLength((String)string)) {
            try {
                DBObject dBObject = dBObjectID.resolveID();
                if (dBObject != null) {
                    string = dBObject.getName();
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return string;
    }
}

