/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.extension;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.extension.DatabaseMatcher;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.deferred.Thunk;

class MatcherCache<T> {
    private Map<String, Map<DatabaseMatcher, Map<String, T>>> m_cache = new TreeMap<String, Map<DatabaseMatcher, Map<String, T>>>();

    MatcherCache() {
    }

    public void put(String string, T t, DatabaseMatcher databaseMatcher) {
        String string2 = databaseMatcher.getDatabaseType();
        if (string != null && t != null && string2 != null) {
            T t2;
            Map<String, T> map;
            Map<DatabaseMatcher, Map<String, T>> map2 = this.m_cache.get(string2);
            if (map2 == null) {
                map2 = new HashMap<DatabaseMatcher, Map<String, T>>();
                this.m_cache.put(string2, map2);
            }
            if ((map = map2.get(databaseMatcher)) == null) {
                map = new TreeMap<String, T>();
                map2.put(databaseMatcher, map);
            }
            if ((t2 = map.get(string)) == null) {
                map.put(string, t);
            } else if (ModelUtil.areDifferent(t2, t)) {
                DBLog.getLogger(this).log(Level.WARNING, "Cannot register {0}: {1} already has {2} already registered", new String[]{this.getClass(t).getName(), string, this.getClass(t2).getName()});
            }
        }
    }

    private Class getClass(Object object) {
        if (object instanceof Class) {
            return (Class)object;
        }
        return object.getClass();
    }

    public Map<String, T> getAll(String string, int n) {
        TreeMap<String, T> treeMap = null;
        Map<DatabaseMatcher, Map<String, T>> map = this.m_cache.get(string);
        if (map != null) {
            for (Map.Entry<DatabaseMatcher, Map<String, T>> entry : map.entrySet()) {
                if (!entry.getKey().matches(string, n)) continue;
                if (treeMap == null) {
                    treeMap = new TreeMap<String, T>();
                }
                treeMap.putAll(entry.getValue());
            }
        }
        return treeMap;
    }

    static class ClassCache<T>
    extends MatcherCache<Thunk> {
        ClassCache() {
        }

        public void putClass(String string, Class<? extends T> clazz, DatabaseMatcher databaseMatcher) {
            this.put(string, Thunk.directReference(clazz), databaseMatcher);
        }

        public Map<String, Class<? extends T>> getAllClasses(String string, int n) {
            TreeMap<String, Class> treeMap = null;
            Map map = this.getAll(string, n);
            if (map != null) {
                treeMap = new TreeMap<String, Class>();
                for (Map.Entry entry : map.entrySet()) {
                    Class clazz = (Class)((Thunk)entry.getValue()).get();
                    if (clazz == null) continue;
                    treeMap.put(entry.getKey(), clazz);
                }
            }
            return treeMap;
        }
    }
}

