/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.hive.HivePartition;
import oracle.javatools.db.hive.HivePartitionProperties;
import oracle.javatools.db.hive.HiveSkewProperties;

public class HivePropertyMetadata {
    public static final String COLLECTION_DELIM = "colelction.delim";
    public static final String FIELD_DELIM = "field.delim";
    public static final String LINE_DELIM = "line.delim";
    public static final String MAPKEY_DELIM = "mapkey.delim";
    public static final String ESCAPE_CHAR = "escape.delim";
    public static final String NULL_FORMAT = "serialization.null.format";
    private static final List<String> s_delimProps;
    private static final List<String> s_delimSerDeProps;

    public static Collection<String> getDelimitedProperties() {
        return s_delimProps;
    }

    public static Collection<String> getDelimitedSerDeProperties() {
        return s_delimSerDeProps;
    }

    public static String getDelimitedProperty(String string) {
        int n = s_delimSerDeProps.indexOf(string);
        return n >= 0 ? s_delimProps.get(n) : null;
    }

    public static String getDelimitedSerDeProperty(String string) {
        int n = s_delimProps.indexOf(string);
        return n >= 0 ? s_delimSerDeProps.get(n) : null;
    }

    static String getSkewValue(HivePartition hivePartition, HiveSkewProperties hiveSkewProperties) {
        String[] stringArray = hivePartition.getValues();
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null) {
            boolean bl;
            DBObjectID[] dBObjectIDArray = hiveSkewProperties.getSkewedColumns();
            int n = dBObjectIDArray.length == 0 ? stringArray.length : dBObjectIDArray.length;
            boolean bl2 = bl = n > 1;
            if (bl) {
                stringBuilder.append('(');
            }
            for (int i = 0; i < n; ++i) {
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\'');
                if (i < stringArray.length && stringArray[i] != null) {
                    stringBuilder.append(stringArray[i]);
                }
                stringBuilder.append('\'');
            }
            if (bl) {
                stringBuilder.append(')');
            }
        }
        return stringBuilder.toString();
    }

    static String getPartitionSpec(HivePartition hivePartition, HivePartitionProperties hivePartitionProperties) {
        DBObjectID[] dBObjectIDArray = hivePartitionProperties.getPartitionColumns();
        String[] stringArray = hivePartition.getValues();
        StringBuilder stringBuilder = new StringBuilder();
        int n = dBObjectIDArray.length == 0 ? (stringArray == null ? 0 : stringArray.length) : dBObjectIDArray.length;
        for (int i = 0; i < n; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            DBObjectID dBObjectID = i < dBObjectIDArray.length ? dBObjectIDArray[i] : null;
            stringBuilder.append(HivePropertyMetadata.getColumnName(dBObjectID, hivePartitionProperties)).append("='");
            if (stringArray != null && i < stringArray.length && stringArray[i] != null) {
                stringBuilder.append((Object)stringArray[i]);
            }
            stringBuilder.append('\'');
        }
        return stringBuilder.toString();
    }

    private static String getColumnName(DBObjectID dBObjectID, DBObject dBObject) {
        String string;
        if (dBObjectID == null) {
            string = null;
        } else if (dBObjectID instanceof TemporaryObjectID) {
            string = ((TemporaryObjectID)dBObjectID).getDBObject().getName();
        } else if (dBObjectID instanceof NameBasedID) {
            string = ((NameBasedID)dBObjectID).getName();
        } else {
            Relation relation = DBUtil.findParentOfType(dBObject, Relation.class);
            DBObject dBObject2 = relation == null ? null : relation.findOwnedObject(dBObjectID);
            string = dBObject2 == null ? null : dBObject2.getName();
        }
        return string;
    }

    public static void refactorValues(PropertyChangeEvent propertyChangeEvent, HivePartition[] hivePartitionArray) {
        block9: {
            DBObjectID[] dBObjectIDArray;
            DBObjectID[] dBObjectIDArray2;
            if (hivePartitionArray.length <= 0 || (dBObjectIDArray2 = (DBObjectID[])propertyChangeEvent.getOldValue()) == (dBObjectIDArray = (DBObjectID[])propertyChangeEvent.getNewValue())) break block9;
            if (dBObjectIDArray2 == null) {
                for (HivePartition hivePartition : hivePartitionArray) {
                    hivePartition.setValues(new String[dBObjectIDArray.length]);
                }
            } else if (dBObjectIDArray == null) {
                for (HivePartition hivePartition : hivePartitionArray) {
                    hivePartition.setValues(new String[0]);
                }
            } else {
                TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
                DiffEngine diffEngine = GenericDiffEngine.getDiffEngine(true);
                Difference difference = diffEngine.difference(dBObjectIDArray2, dBObjectIDArray);
                for (Difference difference2 : difference.getChildren()) {
                    int n = difference2.getIndexOfUpdatedObject();
                    if (n < 0) continue;
                    treeMap.put(n, difference2.getIndexOfOriginalObject());
                }
                for (HivePartition hivePartition : hivePartitionArray) {
                    String[] stringArray = hivePartition.getValues();
                    String[] stringArray2 = new String[dBObjectIDArray.length];
                    for (int i = 0; i < dBObjectIDArray.length; ++i) {
                        Integer n = (Integer)treeMap.get(i);
                        if (n == null || n < 0 || n >= stringArray.length) continue;
                        stringArray2[i] = stringArray[n];
                    }
                    hivePartition.setValues(stringArray2);
                }
            }
        }
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList.add("collectionItemDelim");
        arrayList2.add(COLLECTION_DELIM);
        arrayList.add("fieldEscape");
        arrayList2.add(ESCAPE_CHAR);
        arrayList.add("fieldDelim");
        arrayList2.add(FIELD_DELIM);
        arrayList.add("lineDelim");
        arrayList2.add(LINE_DELIM);
        arrayList.add("mapKeyDelim");
        arrayList2.add(MAPKEY_DELIM);
        arrayList.add("nullFormat");
        arrayList2.add(NULL_FORMAT);
        s_delimProps = Collections.unmodifiableList(arrayList);
        s_delimSerDeProps = Collections.unmodifiableList(arrayList2);
    }
}

