/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;

public class DatabaseLink
extends AbstractSchemaObject {
    public static final String TYPE = "DATABASE LINK";
    public static final String PUBLIC_TYPE = "PUBLIC DATABASE LINK";

    public DatabaseLink() {
        this(null, null, null);
    }

    public DatabaseLink(String string, Schema schema, DBObjectID dBObjectID) {
        super(string, schema, dBObjectID);
        this.setPublic(false);
        this.setShared(false);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public boolean isPublic() {
        return (Boolean)this.getProperty("public", false);
    }

    public void setPublic(boolean bl) {
        this.setProperty("public", bl);
    }

    public boolean isShared() {
        return (Boolean)this.getProperty("shared", false);
    }

    public void setShared(boolean bl) {
        this.setProperty("shared", bl);
    }

    @Deprecated
    @Transient
    public boolean isCurrentUser() {
        return Boolean.TRUE.equals(this.getConnectToUser());
    }

    @Deprecated
    @Transient
    public void setCurrentUser(boolean bl) {
        this.setConnectToUser(bl);
    }

    @Nullable(value=Nullable.NullBehaviour.NULLABLE)
    public Boolean getConnectToUser() {
        return (Boolean)this.getProperty("connectToUser");
    }

    public void setConnectToUser(Boolean bl) {
        this.setProperty("connectToUser", bl);
    }

    public String getUsername() {
        return (String)this.getProperty("username");
    }

    public void setUsername(String string) {
        this.setProperty("username", string);
    }

    @Transient
    @TextProperty(password=true)
    public String getPassword() {
        return (String)this.getProperty("password");
    }

    @Transient
    public void setPassword(String string) {
        this.setProperty("password", string);
    }

    @Transient
    @TextProperty(password=true)
    public String getPasswordX() {
        return (String)this.getProperty("passwordX");
    }

    @Transient
    public void setPasswordX(String string) {
        this.setProperty("passwordX", string);
    }

    @TextProperty(multiLine=true)
    public String getHost() {
        return (String)this.getProperty("host");
    }

    public void setHost(String string) {
        this.setProperty("host", string);
    }

    public String getCreated() {
        return (String)this.getProperty("created");
    }

    public void setCreated(String string) {
        this.setProperty("created", string);
    }

    @Deprecated
    public DBObjectProvider getDBLink() {
        return null;
    }

    @Deprecated
    public String getAuthentificationUser() {
        return this.getAuthentificationUsername();
    }

    public String getAuthentificationUsername() {
        return (String)this.getProperty("authentificationUsername");
    }

    public void setAuthentificationUsername(String string) {
        this.setProperty("authentificationUsername", string);
    }

    @Transient
    @TextProperty(password=true)
    public String getAuthentificationPassword() {
        return (String)this.getProperty("authentificationPassword");
    }

    @Transient
    public void setAuthentificationPassword(String string) {
        this.setProperty("authentificationPassword", string);
    }

    @Transient
    @TextProperty(password=true)
    public String getAuthentificationPasswordX() {
        return (String)this.getProperty("authentificationPasswordX");
    }

    @Transient
    public void setAuthentificationPasswordX(String string) {
        this.setProperty("authentificationPasswordX", string);
    }

    @Deprecated
    public static interface DefaultSchemaFinder {
        public Schema findDefaultSchema(DatabaseLink var1);
    }
}

