/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import oracle.javatools.db.AbstractChildBuildableObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.refactoring.CascadeAction;

public class OracleTablePartitions
extends AbstractChildBuildableObject {
    @PropertyKey(value=OracleTablePartitions.class, childOf={Table.class}, provider=OracleDatabase.class)
    @Nullable(value=Nullable.NullBehaviour.NULLABLE)
    public static final String KEY = "OracleTablePartitions";
    public static final String TYPE = "PARTITION MODEL";

    public OracleTablePartitions() {
    }

    public OracleTablePartitions(PartitionType partitionType, ObjectType objectType) {
        this.setPartitionType(partitionType);
        this.setObjectType(objectType);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setPartitionType(PartitionType partitionType) {
        this.setProperty("partitionType", (Object)partitionType);
    }

    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public PartitionType getPartitionType() {
        return (PartitionType)((Object)this.getProperty("partitionType"));
    }

    public void setObjectType(ObjectType objectType) {
        this.setProperty("objectType", (Object)objectType);
    }

    public ObjectType getObjectType() {
        return (ObjectType)((Object)this.getProperty("objectType"));
    }

    public void setSubpartitionModel(OracleTablePartitions oracleTablePartitions) {
        this.setProperty("subpartitionModel", oracleTablePartitions);
    }

    public OracleTablePartitions getSubpartitionModel() {
        return (OracleTablePartitions)this.getProperty("subpartitionModel");
    }

    public OracleTablePartitions getPartitionSetModel() {
        return (OracleTablePartitions)this.getProperty("partitionSetModel");
    }

    public void setPartitionSetModel(OracleTablePartitions oracleTablePartitions) {
        this.setProperty("partitionSetModel", oracleTablePartitions);
    }

    public void setPartitionColumns(DBObjectID[] dBObjectIDArray) {
        this.getChildSupport("partitionColumns").setChildArray(dBObjectIDArray);
    }

    @References(value=Column.class, internal=true)
    public DBObjectID[] getPartitionColumns() {
        return this.getChildSupport("partitionColumns").getChildArray(DBObjectID.class);
    }

    public void addPartitionColumn(DBObjectID dBObjectID) {
        if (dBObjectID != null) {
            this.getChildSupport("partitionColumns").addChild(dBObjectID);
        }
    }

    public void addPartitionColumn(DBObjectID dBObjectID, int n) {
        if (dBObjectID != null) {
            this.getChildSupport("partitionColumns").addChild(n, dBObjectID);
        }
    }

    public void removePartitionColumn(DBObjectID dBObjectID) {
        this.getChildSupport("partitionColumns").removeChild(dBObjectID);
    }

    public void setReferencePartitionModelID(DBObjectID dBObjectID) {
        this.setProperty("referencePartitionModelID", dBObjectID);
    }

    @Derived(value="referenceConstraintID")
    @References(value=OracleTablePartitions.class)
    @Internal
    public DBObjectID getReferencePartitionModelID() {
        return (DBObjectID)this.getProperty("referencePartitionModelID");
    }

    public void setReferenceConstraintID(DBObjectID dBObjectID) {
        this.setProperty("referenceConstraintID", dBObjectID);
    }

    @References(value=FKConstraint.class, internal=true, cascade=CascadeAction.DELETE)
    public DBObjectID getReferenceConstraintID() {
        return (DBObjectID)this.getProperty("referenceConstraintID");
    }

    public void setPartitionsMappingType(PartitionsMappingType partitionsMappingType) {
        this.setProperty("partitionsMappingType", (Object)partitionsMappingType);
    }

    public PartitionsMappingType getPartitionsMappingType() {
        return (PartitionsMappingType)((Object)this.getProperty("partitionsMappingType"));
    }

    public void setHashQuantity(Integer n) {
        this.setProperty("hashQuantity", n);
    }

    public Integer getHashQuantity() {
        return (Integer)this.getProperty("hashQuantity");
    }

    @Transient
    @Deprecated
    public void setHashQuantityTablespaces(String[] stringArray) {
        this.setHashQuantityTablespaceIds(null);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addHashQuantityTablespace(stringArray[i]);
            }
        }
    }

    public void setHashQuantityTablespaceIds(DBObjectID[] dBObjectIDArray) {
        this.getChildSupport("hashQuantityTablespaceIds").setChildArray(dBObjectIDArray);
    }

    @Deprecated
    public void addHashQuantityTablespace(String string) {
        if (string != null) {
            ReferenceID referenceID = new ReferenceID("TABLESPACE", (Schema)null, string);
            this.addHashQuantityTablespace(referenceID);
        }
    }

    public void addHashQuantityTablespace(DBObjectID dBObjectID) {
        if (dBObjectID != null) {
            this.getChildSupport("hashQuantityTablespaceIds").addChild(dBObjectID);
        }
    }

    @Deprecated
    public void removeHashQuantityTablespace(String string) {
        for (DBObjectID dBObjectID : this.getHashQuantityTablespaceIds()) {
            Tablespace tablespace = null;
            try {
                tablespace = (Tablespace)dBObjectID.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (!tablespace.getName().equals(string)) continue;
            this.removeHashQuantityTablespace(dBObjectID);
        }
    }

    public void removeHashQuantityTablespace(DBObjectID dBObjectID) {
        this.getChildSupport("hashQuantityTablespaceIds").removeChild(dBObjectID);
    }

    @Deprecated
    public String[] getHashQuantityTablespaces() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DBObjectID dBObjectID : this.getHashQuantityTablespaceIds()) {
            Tablespace tablespace = null;
            try {
                tablespace = (Tablespace)dBObjectID.resolveID();
                if (tablespace == null) continue;
                arrayList.add(tablespace.getName());
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @References(value=Tablespace.class)
    public DBObjectID[] getHashQuantityTablespaceIds() {
        return this.getChildSupport("hashQuantityTablespaceIds").getChildArray(DBObjectID.class);
    }

    public void setPartitions(TablePartition[] tablePartitionArray) {
        this.getChildSupport("partitions").setChildArray(tablePartitionArray);
    }

    public TablePartition[] getPartitions() {
        return this.getChildSupport("partitions").getChildArray(TablePartition.class);
    }

    public void addPartition(TablePartition tablePartition) {
        this.getChildSupport("partitions").addChild(tablePartition);
    }

    public void removePartition(TablePartition tablePartition) {
        this.getChildSupport("partitions").removeChild(tablePartition);
    }

    public void addPartition(int n, TablePartition tablePartition) {
        this.getChildSupport("partitions").addChild(n, tablePartition);
    }

    public TablePartition createPartition(String string) {
        TablePartition tablePartition = new TablePartition(string, this.getPartitionType(), this.getObjectType());
        this.addPartition(tablePartition);
        return tablePartition;
    }

    public static enum ObjectType {
        PARTITION,
        SUBPARTITION,
        SUBPARTITION_TEMPLATE,
        PARTITION_LEVEL_SUBPARTITION,
        PARTITIONSET,
        PARTITIONSET_LEVEL_SUBPARTITION_TEMPLATE;

    }

    public static enum PartitionsMappingType {
        AUTO;

    }

    public static enum PartitionType {
        RANGE,
        HASH,
        LIST,
        REFERENCE,
        CONSISTENT_HASH;

    }
}

