/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.bigdata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.Directory;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameters;
import oracle.javatools.db.ora.bigdata.BigDataJsonEntry;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.util.Tuple;

public final class BigDataAccessParameterMetadata {
    public static final String ADDITIONAL = "com.oracle.bigdata.ad";
    public static final String TABLENAME = "com.oracle.bigdata.tablename";
    public static final String FIELDCOUNT = "com.oracle.bigdata.fieldcount";
    public static final String FIELDS = "com.oracle.bigdata.fields";
    public static final String FILEFORMAT = "com.oracle.bigdata.fileformat";
    public static final String ROWFORMAT = "com.oracle.bigdata.rowformat";
    public static final String CLASS = "com.oracle.bigdata.class";
    public static final String COLMAP = "com.oracle.bigdata.colmap";
    public static final String CLUSTER = "com.oracle.bigdata.cluster";
    public static final String DATEMASK = "com.oracle.bigdata.datemask";
    public static final String ERROROPT = "com.oracle.bigdata.erroropt";
    public static final String LOG_EXEC = "com.oracle.bigdata.log.exec";
    public static final String LOG_OPT = "com.oracle.bigdata.log.opt";
    public static final String LOG_QC = "com.oracle.bigdata.log.qc";
    public static final String MAXLEN = "com.oracle.bigdata.maxlen";
    public static final String OVERFLOW = "com.oracle.bigdata.overflow";
    public static final String TBLPROPERTIES = "com.oracle.bigdata.tblproperties";
    public static final String DATAMODE = "com.oracle.bigdata.datamode";
    private static final String NONE = "NONE";
    private static final String NORMAL = "NORMAL";
    private static final String TEXTFILE = "TEXTFILE";
    private static final String SEQUENCEFILE = "SEQUENCEFILE";
    private static final String RCFILE = "RCFILE";
    private static final String INPUTFORMAT = "INPUTFORMAT '<input_class>' OUTPUTFORMAT '<output_class>'";
    private static final String DELIMITED = "DELIMITED";
    private static final String DELIMITED_FIELDS = "DELIMITED FIELDS TERMINATED BY '<char>'";
    private static final String DELIMITED_FIELDS_ESC = "DELIMITED FIELDS TERMINATED BY '<char>' ESCAPED BY '<char>'";
    private static final String DELIMITED_COLLECTION_ITEMS = "DELIMITED COLLECTION ITEMS TERMINATED BY '<char>'";
    private static final String DELIMITED_MAP_KEY = "DELIMITED MAP KEYS TERMINATED BY '<char>'";
    private static final String DELIMITED_LINES = "DELIMITED LINES TERMINATED BY '<char>'";
    private static final String SERDE = "SERDE '<serde_name>'";
    private static final String SERDE_WITH_PROPS = "SERDE '<serde_name>' WITH SERDEPROPERTIES ( \"name\" = \"value\" )";
    private static final String AUTOMATIC = "automatic";
    private static final String JAVA = "java";
    private static final String C = "c";

    public static String stripLineEscapes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                int n = string2.length();
                if (string2.endsWith("\\")) {
                    --n;
                }
                stringBuilder.append(string2, 0, n);
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            return string.replaceAll("\\\\\\r?\\n", "\n");
        }
    }

    public static String checkLineBreaks(String string) {
        String string2 = null;
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            try {
                String string3 = bufferedReader.readLine();
                while (string3 != null) {
                    String string4 = bufferedReader.readLine();
                    stringBuilder.append(string3);
                    if (string4 != null) {
                        if (!string3.endsWith("\\")) {
                            stringBuilder.append("\\");
                        }
                        stringBuilder.append("\n");
                    }
                    string3 = string4;
                }
                string2 = stringBuilder.toString();
            }
            catch (IOException iOException) {
                string2 = string;
            }
        }
        return string2;
    }

    public static boolean isBigDataAccessDriver(String string) {
        return "ORACLE_HIVE".equals(string) || "ORACLE_HDFS".equals(string) || "ORACLE_BIGDATA".equals(string);
    }

    public static boolean isAdditionalAccessParameter(String string) {
        return string.startsWith(ADDITIONAL);
    }

    public static Collection<String> getAllowedParameterNames(String string) {
        TreeSet<String> treeSet = null;
        if (BigDataAccessParameterMetadata.isBigDataAccessDriver(string)) {
            treeSet = new TreeSet<String>();
            boolean bl = "ORACLE_BIGDATA".equals(string);
            if (bl) {
                treeSet.add(CLASS);
            }
            if (bl || "ORACLE_HIVE".equals(string)) {
                treeSet.add(TABLENAME);
            }
            if (bl || "ORACLE_HDFS".equals(string)) {
                treeSet.add(FIELDCOUNT);
                treeSet.add(FIELDS);
                treeSet.add(FILEFORMAT);
                treeSet.add(ROWFORMAT);
                treeSet.add(TBLPROPERTIES);
            }
            treeSet.add(COLMAP);
            treeSet.add(CLUSTER);
            treeSet.add(DATEMASK);
            treeSet.add(ERROROPT);
            treeSet.add(LOG_EXEC);
            treeSet.add(LOG_OPT);
            treeSet.add(LOG_QC);
            treeSet.add(MAXLEN);
            treeSet.add(OVERFLOW);
            treeSet.add(DATAMODE);
        }
        return treeSet;
    }

    public static boolean isLocationParameter(String string) {
        return LOG_EXEC.equals(string) || LOG_QC.equals(string);
    }

    public static boolean hasAllowedParameterValues(String string, Relation relation, DBObjectProvider dBObjectProvider) {
        return LOG_OPT.equals(string) || FILEFORMAT.equals(string) || ROWFORMAT.equals(string) || DATAMODE.equals(string) || CLUSTER.equals(string) && dBObjectProvider != null && dBObjectProvider.supportsObjectType("DIRECTORY");
    }

    public static List<String> getAllowedParameterValues(String string, Relation relation, DBObjectProvider dBObjectProvider) {
        List<Object> list = null;
        if (LOG_OPT.equals(string)) {
            list = Arrays.asList(NONE, NORMAL);
        } else if (CLUSTER.equals(string)) {
            list = new ArrayList();
            DBObjectCriteria<Directory> dBObjectCriteria = new DBObjectCriteria<Directory>(Directory.class, new String[0]);
            dBObjectCriteria.setSchemaName("SYS");
            dBObjectCriteria.setNameLike("ORA_BIGDATA_CL_" + DBObjectCriteria.LIKE_WILDCARD);
            try {
                for (Directory directory : dBObjectProvider.listObjects(dBObjectCriteria)) {
                    String string2 = directory.getName();
                    if (string2 == null || !string2.startsWith("ORA_BIGDATA_CL_")) continue;
                    list.add(string2.substring("ORA_BIGDATA_CL_".length()));
                }
            }
            catch (DBException dBException) {
                DBLog.getLogger(BigDataAccessParameters.class).warning(dBException.getMessage());
            }
        } else if (FILEFORMAT.equals(string)) {
            list = Arrays.asList(INPUTFORMAT, RCFILE, SEQUENCEFILE, TEXTFILE);
        } else if (ROWFORMAT.equals(string)) {
            list = Arrays.asList(DELIMITED, DELIMITED_COLLECTION_ITEMS, DELIMITED_FIELDS, DELIMITED_FIELDS_ESC, DELIMITED_LINES, DELIMITED_MAP_KEY, SERDE, SERDE_WITH_PROPS);
        } else if (DATAMODE.equals(string)) {
            list = Arrays.asList(AUTOMATIC, C, JAVA);
        }
        return list;
    }

    public static TemplateValue getParameterTemplateValue(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Tuple<String, String> tuple = BigDataJsonEntry.getJsonEntryNames(string);
        if (tuple != null) {
            string3 = BigDataJsonEntry.getDefaultValueString((String)tuple.object1(), string);
            BigDataJsonEntry bigDataJsonEntry = new BigDataJsonEntry((String)tuple.object1(), new SimpleSQLFragment("DUMMY"));
            String string5 = bigDataJsonEntry.getSQLText();
            String[] stringArray = string5.split("DUMMY");
            if (stringArray.length == 1 || stringArray.length == 2) {
                String string6;
                string2 = "{" + stringArray[0];
                StringBuilder stringBuilder = new StringBuilder();
                if (stringArray.length == 2) {
                    stringBuilder.append(stringArray[1]);
                }
                if (!BigDataJsonEntry.isJsonEntryOptional(string, string6 = (String)tuple.object2())) {
                    BigDataJsonEntry bigDataJsonEntry2 = new BigDataJsonEntry((String)tuple.object2(), new SimpleSQLFragment(""));
                    stringBuilder.append(", ").append(bigDataJsonEntry2.getSQLText());
                }
                stringBuilder.append("}");
                string4 = stringBuilder.toString();
            }
        } else if (LOG_OPT.equals(string)) {
            string3 = NONE;
        } else if (FILEFORMAT.equals(string)) {
            string3 = TEXTFILE;
        } else if (ROWFORMAT.equals(string)) {
            string3 = DELIMITED;
        } else if (DATAMODE.equals(string)) {
            string3 = JAVA;
        }
        return string2 == null && string3 == null ? null : new TemplateValue(string2, string3, string4);
    }

    public static class TemplateValue {
        private final String m_before;
        private final String m_val;
        private final String m_after;

        private TemplateValue(String string, String string2, String string3) {
            this.m_before = string;
            this.m_val = string2;
            this.m_after = string3;
        }

        public String getBefore() {
            return this.m_before;
        }

        public String getValue() {
            return this.m_val;
        }

        public String getAfter() {
            return this.m_after;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendIfNotNull(stringBuilder, this.m_before);
            this.appendIfNotNull(stringBuilder, this.m_val);
            this.appendIfNotNull(stringBuilder, this.m_after);
            return stringBuilder.toString();
        }

        private void appendIfNotNull(StringBuilder stringBuilder, String string) {
            if (string != null) {
                stringBuilder.append(string);
            }
        }
    }
}

