/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.bigdata;

import java.util.Collection;
import java.util.TreeSet;
import oracle.javatools.db.Column;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.bigdata.BigDataJsonArray;
import oracle.javatools.db.ora.bigdata.BigDataJsonObject;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class BigDataJsonEntry
extends AbstractSQLFragment {
    public static final String TYPE = "BigDataJsonEntry";
    public static final String ACTION = "action";
    public static final String BYTES = "bytes";
    public static final String COL = "col";
    public static final String FIELD = "field";
    public static final String MASK = "mask";
    public static final String VALUE = "value";
    public static final String ERROR = "error";
    public static final String TRUNCATE = "truncate";
    public static final String SETNULL = "setnull";
    public static final String REJECT = "reject";
    public static final String REPLACE = "replace";

    public BigDataJsonEntry() {
    }

    public BigDataJsonEntry(String string, SQLFragment sQLFragment) {
        this.setName(string);
        this.setValueFragment(sQLFragment);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public SQLFragment getValueFragment() {
        return (SQLFragment)this.getProperty("valueFragment");
    }

    public void setValueFragment(SQLFragment sQLFragment) {
        this.setProperty("valueFragment", sQLFragment);
    }

    @Override
    public String getSQLText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"").append(this.getName()).append("\": ");
        this.appendValue(stringBuilder);
        return stringBuilder.toString();
    }

    public String getValueSQLText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendValue(stringBuilder);
        return stringBuilder.toString();
    }

    private void appendValue(StringBuilder stringBuilder) {
        SQLFragment sQLFragment = this.getValueFragment();
        if (sQLFragment instanceof SQLFragment && this.isNonStringEntry()) {
            stringBuilder.append(sQLFragment.getSQLText());
        } else {
            BigDataJsonEntry.appendBigDataSQLText(stringBuilder, sQLFragment);
        }
    }

    private boolean isNonStringEntry() {
        return BYTES.equals(this.getName());
    }

    static void appendBigDataSQLText(StringBuilder stringBuilder, SQLFragment sQLFragment) {
        boolean bl;
        String string = sQLFragment == null ? null : sQLFragment.getSQLText();
        boolean bl2 = bl = !ModelUtil.hasLength((String)string) || !(sQLFragment instanceof BigDataJsonArray) && !(sQLFragment instanceof BigDataJsonObject);
        if (bl) {
            stringBuilder.append("\"");
        }
        if (string != null) {
            stringBuilder.append(string);
        }
        if (bl) {
            stringBuilder.append("\"");
        }
    }

    public static Tuple<String, String> getJsonEntryNames(String string) {
        Tuple tuple = null;
        if ("com.oracle.bigdata.colmap".equals(string)) {
            tuple = new Tuple((Object)COL, (Object)FIELD);
        } else if ("com.oracle.bigdata.datemask".equals(string)) {
            tuple = new Tuple((Object)MASK, (Object)COL);
        } else if ("com.oracle.bigdata.maxlen".equals(string)) {
            tuple = new Tuple((Object)BYTES, (Object)COL);
        } else if ("com.oracle.bigdata.overflow".equals(string)) {
            tuple = new Tuple((Object)ACTION, (Object)COL);
        } else if ("com.oracle.bigdata.erroropt".equals(string)) {
            tuple = new Tuple((Object)ACTION, (Object)COL);
        }
        return tuple;
    }

    public static boolean isJsonEntryOptional(String string, String string2) {
        return COL.equals(string2) && !"com.oracle.bigdata.colmap".equals(string);
    }

    public static Collection<String> getAllowedValueStrings(String string, String string2, Relation relation) {
        TreeSet<String> treeSet = null;
        if (COL.equals(string)) {
            treeSet = new TreeSet<String>();
            if (relation != null) {
                for (Column column : relation.getColumns()) {
                    treeSet.add(column.getName());
                }
            }
        } else if (ACTION.equals(string)) {
            treeSet = new TreeSet();
            if ("com.oracle.bigdata.erroropt".equals(string2)) {
                treeSet.add(REJECT);
                treeSet.add(REPLACE);
                treeSet.add(SETNULL);
            } else {
                treeSet.add(ERROR);
                treeSet.add(TRUNCATE);
            }
        }
        return treeSet;
    }

    public static String getDefaultValueString(String string, String string2) {
        String string3 = BYTES.equals(string) ? String.valueOf(4000) : ("com.oracle.bigdata.overflow".equals(string2) && ACTION.equals(string) ? ERROR : ("com.oracle.bigdata.erroropt".equals(string2) && ACTION.equals(string) ? REJECT : null));
        return string3;
    }

    public static boolean hasExtendedEntry(String string, String string2) {
        return ACTION.equals(string) && "com.oracle.bigdata.erroropt".equals(string2);
    }

    public static String getExtendedEntryName(String string, String string2, String string3) {
        String string4 = ACTION.equals(string) && REPLACE.equals(string2) && "com.oracle.bigdata.erroropt".equals(string3) ? VALUE : null;
        return string4;
    }
}

