/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.sql.BuiltInFunctionArgument;
import oracle.javatools.db.sql.SQLCallable;

public class BuiltInFunction
extends AbstractBuildableObject
implements SQLCallable {
    public static final String TYPE = "BuiltInFunction";
    private int m_minargs;
    private int m_maxargs;
    private String m_signature;
    private String m_fullSignature;

    public BuiltInFunction() {
        this.setAggregate(this.isAggregate());
        this.setParenthesesRequired(this.isParenthesesRequired());
        this.setVariableArgumentList(this.isVariableArgumentList());
        this.setWindow(this.isWindow());
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setDescription(String string) {
        this.setProperty("description", string);
    }

    public String getDescription() {
        return (String)this.getProperty("description");
    }

    public void setAggregate(boolean bl) {
        this.setProperty("aggregate", bl);
    }

    @Override
    public boolean isAggregate() {
        return (Boolean)this.getProperty("aggregate", false);
    }

    public void setWindow(boolean bl) {
        this.setProperty("window", bl);
    }

    @Override
    public boolean isWindow() {
        return (Boolean)this.getProperty("window", false);
    }

    @Override
    public boolean isVariableArgumentList() {
        return (Boolean)this.getProperty("variableArgumentList", false);
    }

    public void setVariableArgumentList(boolean bl) {
        this.setProperty("variableArgumentList", bl);
    }

    public void setReturnTypeID(DBObjectID dBObjectID) {
        this.setProperty("returnTypeID", dBObjectID);
    }

    @Override
    public DBObjectID getReturnTypeID() {
        return (DBObjectID)this.getProperty("returnTypeID");
    }

    public void setArguments(BuiltInFunctionArgument[] builtInFunctionArgumentArray) {
        this.getChildSupport("arguments").setChildArray(builtInFunctionArgumentArray);
        this.m_signature = null;
        this.m_minargs = 0;
        this.m_maxargs = 0;
        for (BuiltInFunctionArgument builtInFunctionArgument : this.getArguments()) {
            if (!builtInFunctionArgument.isOptional()) {
                ++this.m_minargs;
            }
            ++this.m_maxargs;
        }
    }

    public BuiltInFunctionArgument[] getArguments() {
        return this.getChildSupport("arguments").getChildArray(BuiltInFunctionArgument.class);
    }

    public void setArgumentDefiningReturnType(Integer n) {
        this.setProperty("argumentDefiningReturnType", n);
    }

    @Override
    public Integer getArgumentDefiningReturnType() {
        return (Integer)this.getProperty("argumentDefiningReturnType");
    }

    public void setParenthesesRequired(boolean bl) {
        this.setProperty("parenthesesRequired", bl);
        this.m_signature = null;
    }

    @Override
    public boolean isParenthesesRequired() {
        return (Boolean)this.getProperty("parenthesesRequired", false);
    }

    public int getMaxArgs() {
        return this.m_maxargs;
    }

    public int getMinArgs() {
        return this.m_minargs;
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    public String getSignature(boolean bl) {
        if (this.m_signature == null) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder.append(this.getName());
            stringBuilder2.append(this.getName());
            if (this.isParenthesesRequired()) {
                stringBuilder.append("(");
                stringBuilder2.append("(");
            }
            int n = 0;
            for (BuiltInFunctionArgument builtInFunctionArgument : this.getArguments()) {
                DBObjectID dBObjectID;
                if (n++ > 0) {
                    stringBuilder.append(",");
                    stringBuilder2.append(",");
                }
                if (builtInFunctionArgument.isOptional()) {
                    stringBuilder.append("[");
                    stringBuilder2.append("[");
                }
                if ((dBObjectID = builtInFunctionArgument.getDataTypeID()) == null) {
                    stringBuilder2.append("?");
                } else {
                    stringBuilder2.append(DBUtil.getDBObjectName(dBObjectID));
                }
                if (!builtInFunctionArgument.isOptional()) continue;
                stringBuilder.append("]");
                stringBuilder2.append("]");
            }
            if (this.isVariableArgumentList()) {
                if (n > 0) {
                    stringBuilder.append(",");
                    stringBuilder2.append(",");
                }
                stringBuilder.append("...");
                stringBuilder2.append("...");
            }
            if (this.isParenthesesRequired()) {
                stringBuilder.append(")");
                stringBuilder2.append(")");
            }
            stringBuilder2.append(":");
            Integer n2 = this.getArgumentDefiningReturnType();
            if (n2 != null) {
                stringBuilder2.append(n2);
            } else {
                DBObjectID dBObjectID = this.getReturnTypeID();
                if (dBObjectID == null) {
                    stringBuilder2.append("?");
                } else {
                    stringBuilder2.append(DBUtil.getDBObjectName(dBObjectID));
                }
            }
            stringBuilder2.append("/");
            stringBuilder2.append(this.isAggregate() ? "Y" : "N");
            stringBuilder2.append(this.isWindow() ? "Y" : "N");
            this.m_signature = stringBuilder.toString();
            this.m_fullSignature = stringBuilder2.toString();
        }
        return bl ? this.m_fullSignature : this.m_signature;
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.m_signature = null;
    }
}

