/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class Function
extends Operation {
    public Function() {
        this((String)null, (SQLFragment[])null);
    }

    public Function(String string, SQLFragment[] sQLFragmentArray) {
        this(string, sQLFragmentArray, false);
    }

    public Function(String string, SQLFragment[] sQLFragmentArray, String string2) {
        this(string, sQLFragmentArray, string2, false);
    }

    public Function(String string, SQLFragment[] sQLFragmentArray, boolean bl) {
        this(string, sQLFragmentArray, ", ", bl);
    }

    public Function(String string, SQLFragment[] sQLFragmentArray, String string2, boolean bl) {
        super(sQLFragmentArray);
        this.setFunctionFormat(true);
        this.setSeparator(string2);
        this.setGrouping(bl);
        this.setDistinct(false);
        this.setFunction(string);
    }

    public String getFunction() {
        return (String)this.getProperty("function");
    }

    public void setFunction(String string) {
        if (this.isSymbolFunction(string)) {
            this.setFunctionFormat(false);
            this.setSeparator(null);
            this.setCommutative(true);
        } else {
            this.setFunctionFormat(true);
        }
        this.setProperty("function", string);
    }

    public boolean isGrouping() {
        return (Boolean)this.getProperty("grouping", false);
    }

    public void setGrouping(boolean bl) {
        this.setProperty("grouping", bl);
    }

    public boolean isDistinct() {
        return (Boolean)this.getProperty("distinct", false);
    }

    public void setDistinct(boolean bl) {
        this.setProperty("distinct", bl);
    }

    public String getTrimLeader() {
        return (String)this.getProperty("trimLeader");
    }

    public void setTrimLeader(String string) {
        this.setProperty("trimLeader", string);
    }

    public String getDistinctSource() {
        return (String)this.getProperty("distinctSource");
    }

    public void setDistinctSource(String string) {
        this.setProperty("distinctSource", string);
    }

    @Override
    protected String getDistinctText() {
        String string = "";
        if (this.isGrouping() && ModelUtil.hasLength((String)this.getDistinctSource())) {
            string = this.getDistinctSource() + " ";
        } else if (ModelUtil.hasLength((String)this.getTrimLeader())) {
            string = this.getTrimLeader() + " ";
        }
        return string;
    }

    @Override
    protected String getOperatorText() {
        return this.getFunction();
    }

    private boolean isSymbolFunction(String string) {
        if (ModelUtil.hasLength((String)string)) {
            for (int i = 0; i < string.length(); ++i) {
                if (!Character.isLetterOrDigit(string.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getSeparator() {
        return super.getSeparator();
    }

    @Override
    public void setSeparator(String string) {
        super.setSeparator(string);
    }

    public void setDataTypeID(DBObjectID dBObjectID) {
        this.setProperty("dataTypeID", dBObjectID);
    }

    @Override
    public DBObjectID getDataTypeID() {
        return (DBObjectID)this.getProperty("dataTypeID");
    }
}

