/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBLog;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinCondition;
import oracle.javatools.db.sql.SQLFragment;

public class JoinObject
extends AbstractSQLFragment {
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";
    public static final String FULL = "FULL";
    public static final String INNER = "INNER";
    public static final String CROSS = "CROSS";
    private static final String PARTITION_BY = "PARTITION BY";

    public JoinObject() {
        this(null, null, null);
    }

    public JoinObject(FromObject fromObject, FromObject fromObject2, JoinCondition joinCondition) {
        this(fromObject, fromObject2, null, false, joinCondition);
    }

    public JoinObject(FromObject fromObject, FromObject fromObject2, String string, boolean bl, JoinCondition joinCondition) {
        this.setIncludeJoinKeyword(true);
        this.setLeftExpression(fromObject);
        this.setRightExpression(fromObject2);
        this.setJoinType(string);
        this.setNatural(bl);
        this.setCondition(joinCondition);
    }

    public FromObject getLeftExpression() {
        return (FromObject)this.getProperty("leftExpression");
    }

    public void setLeftExpression(FromObject fromObject) {
        this.setProperty("leftExpression", fromObject);
    }

    public FromObject getRightExpression() {
        return (FromObject)this.getProperty("rightExpression");
    }

    public void setRightExpression(FromObject fromObject) {
        this.setProperty("rightExpression", fromObject);
    }

    public boolean getIncludeJoinKeyword() {
        return (Boolean)this.getProperty("includeJoinKeyword", true);
    }

    public void setIncludeJoinKeyword(boolean bl) {
        this.setProperty("includeJoinKeyword", bl);
    }

    public String getJoinType() {
        return (String)this.getProperty("joinType");
    }

    public void setJoinType(String string) {
        this.setProperty("joinType", string);
    }

    public boolean isNatural() {
        return (Boolean)this.getProperty("natural", false);
    }

    public void setNatural(boolean bl) {
        if (CROSS.equals(this.getJoinType()) && bl) {
            DBLog.getLogger(this).warning(APIBundle.get("SQL_CROSS_NOT_NATURAL"));
        }
        this.setProperty("natural", bl);
    }

    public JoinCondition getCondition() {
        return (JoinCondition)this.getProperty("condition");
    }

    public void setCondition(JoinCondition joinCondition) {
        if ((this.isNatural() || CROSS.equals(this.getJoinType())) && joinCondition != null) {
            DBLog.getLogger(this).warning(APIBundle.get("SQL_CROSS_NAT_NO_COND"));
        } else {
            this.setProperty("condition", joinCondition);
        }
    }

    public ExpressionList getLeftPartitionBy() {
        return (ExpressionList)this.getProperty("leftPartitionBy");
    }

    public void setLeftPartitionBy(ExpressionList expressionList) {
        this.setProperty("leftPartitionBy", expressionList);
    }

    public ExpressionList getRightPartitionBy() {
        return (ExpressionList)this.getProperty("rightPartitionBy");
    }

    public void setRightPartitionBy(ExpressionList expressionList) {
        this.setProperty("rightPartitionBy", expressionList);
    }

    public boolean isOuterJoin() {
        String string = this.getJoinType();
        return string != null && !string.equals(INNER) && !string.equals(CROSS);
    }

    private boolean needsBrackets(FromObject fromObject) {
        boolean bl = false;
        if (fromObject != null) {
            SQLFragment sQLFragment = fromObject.getExpression();
            bl = sQLFragment instanceof JoinObject;
        }
        return bl;
    }

    @Override
    public String getSQLText() {
        JoinCondition joinCondition;
        StringBuilder stringBuilder = new StringBuilder();
        FromObject fromObject = this.getLeftExpression();
        String string = this.getTextOrNull(fromObject, this.needsBrackets(fromObject));
        stringBuilder.append(string);
        ExpressionList expressionList = this.getLeftPartitionBy();
        if (expressionList != null) {
            stringBuilder.append(" ").append(this.createPartitionByText(expressionList));
        }
        if (this.isNatural()) {
            stringBuilder.append(" ").append("NATURAL");
        }
        String string2 = this.getJoinType();
        boolean bl = this.getIncludeJoinKeyword();
        if (INNER.equals(string2)) {
            if (bl) {
                stringBuilder.append(" ").append(string2);
            }
        } else if (CROSS.equals(string2)) {
            stringBuilder.append(" ").append(CROSS);
        } else if (this.isOuterJoin()) {
            stringBuilder.append(" ").append(string2);
            if (bl) {
                stringBuilder.append(" ").append("OUTER");
            }
        }
        stringBuilder.append(" ").append("JOIN").append(" ");
        FromObject fromObject2 = this.getRightExpression();
        String string3 = this.getTextOrNull(fromObject2, this.needsBrackets(fromObject2));
        stringBuilder.append(string3);
        ExpressionList expressionList2 = this.getRightPartitionBy();
        if (expressionList2 != null) {
            stringBuilder.append(" ").append(this.createPartitionByText(expressionList2));
        }
        if ((joinCondition = this.getCondition()) != null && !this.isNatural()) {
            stringBuilder.append(" ").append(joinCondition.getSQLText());
        }
        return stringBuilder.toString();
    }

    private String createPartitionByText(ExpressionList expressionList) {
        StringBuilder stringBuilder = new StringBuilder(PARTITION_BY);
        String string = expressionList.getSQLText();
        if (expressionList.getArgumentCount() == 1) {
            string = this.surroundWithBrackets(string, true);
        }
        return PARTITION_BY + string;
    }
}

