/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.sql.AbstractFromObjectUsage;
import oracle.javatools.db.sql.AbstractProviderUsageSQLFragment;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.util.ModelUtil;

public class SQLFragmentExpressionBuilder {
    public static SQLFragment getExpression(DBObjectProvider dBObjectProvider, Relation relation, ExpressionType expressionType, String string) {
        SQLFragment sQLFragment = null;
        try {
            sQLFragment = SQLFragmentExpressionBuilder.getExpressionOrFail(dBObjectProvider, relation, expressionType, string);
        }
        catch (SQLQueryException sQLQueryException) {
            sQLFragment = new SimpleSQLFragment(string);
        }
        return sQLFragment;
    }

    @Deprecated
    public static SQLFragment getExpression(DBObjectProvider dBObjectProvider, Relation relation, ExpressionType expressionType, String string, boolean bl) throws SQLQueryException {
        if (bl) {
            return SQLFragmentExpressionBuilder.getExpression(dBObjectProvider, relation, expressionType, string);
        }
        return SQLFragmentExpressionBuilder.getExpressionOrFail(dBObjectProvider, relation, expressionType, string);
    }

    public static SQLFragment getExpressionOrFail(DBObjectProvider dBObjectProvider, Relation relation, ExpressionType expressionType, String string) throws SQLQueryException {
        Object object = null;
        if (ModelUtil.hasLength((String)string)) {
            Object object2;
            AbstractBuildableObject abstractBuildableObject;
            if (relation != null && expressionType == ExpressionType.ITEM && (abstractBuildableObject = (Column)DBUtil.findChildByName(relation, "columns", dBObjectProvider.getInternalName(string), true, dBObjectProvider)) != null && abstractBuildableObject.getID() != null) {
                object2 = new ColumnUsage(abstractBuildableObject.getID());
                ((AbstractFromObjectUsage)object2).setQualified(false);
                ((AbstractProviderUsageSQLFragment)object2).setProvider(dBObjectProvider);
                object = object2;
            }
            if (object == null) {
                abstractBuildableObject = relation == null ? null : relation.getSchema();
                object2 = SQLQueryBuilderFactory.createBuilder(dBObjectProvider, (Schema)abstractBuildableObject);
                if (object2 instanceof AbstractSQLQueryBuilder) {
                    Object object3;
                    String string2 = null;
                    String string3 = null;
                    if (relation != null) {
                        ((AbstractSQLQueryBuilder)object2).setSingleRelation(relation);
                        object3 = relation.getName();
                        string3 = dBObjectProvider.getExternalName((String)object3);
                        if (!((String)object3).equals(string3) && !string3.startsWith("\"")) {
                            string3 = "DUAL";
                        }
                    } else {
                        string3 = "DUAL";
                    }
                    if (expressionType == ExpressionType.CONDITION) {
                        try {
                            string2 = "SELECT 1 FROM " + string3 + " WHERE ";
                            object2.buildQuery(string2 + string);
                            object3 = object2.getSQLQuery();
                            if (object3 != null) {
                                object = ((SQLQuery)object3).getWhereObject();
                                ((SQLQuery)object3).setWhereObject(null);
                            }
                        }
                        catch (SQLQueryException sQLQueryException) {
                            SQLFragmentExpressionBuilder.throwModifiedException(sQLQueryException, string, string2);
                        }
                    } else if (expressionType == ExpressionType.ITEM) {
                        object3 = "SELECT ";
                        String string4 = " FROM " + string3;
                        String string5 = (String)object3 + string + string4;
                        try {
                            SelectObject[] selectObjectArray;
                            object2.buildQuery(string5);
                            SQLQuery sQLQuery = object2.getSQLQuery();
                            if (sQLQuery != null && (selectObjectArray = sQLQuery.getSelectObjects()).length > 0 && selectObjectArray[0] != null) {
                                object = selectObjectArray[0].getExpression();
                                selectObjectArray[0].setExpression(null);
                            }
                        }
                        catch (SQLQueryException sQLQueryException) {
                            SQLFragmentExpressionBuilder.throwModifiedException(sQLQueryException, string, new String[]{object3, string4});
                        }
                    }
                }
                if (object != null) {
                    SQLFragmentExpressionBuilder.resetFromObjectIDs(object);
                    object.setParent(null);
                } else if (!object2.matchesProvider()) {
                    object = new SimpleSQLFragment(string);
                } else {
                    throw new IllegalStateException("Build succeeded but we have no fragment");
                }
            }
        }
        return object;
    }

    private static void throwModifiedException(SQLQueryException sQLQueryException, String string, String ... stringArray) throws SQLQueryException {
        if (!(sQLQueryException instanceof SQLParseException) || stringArray.length == 0 || !ModelUtil.hasLength((String)stringArray[0])) {
            throw sQLQueryException;
        }
        SQLParseException sQLParseException = (SQLParseException)sQLQueryException;
        int n = stringArray[0].length();
        String string2 = sQLParseException.getFragmentMessage(string, n);
        for (String string3 : new String[]{"'FROM'", "from_clause"}) {
            int n2 = string2.indexOf(string3);
            if (n2 <= 0) continue;
            int n3 = n2;
            int n4 = n2 + string3.length();
            if (string2.charAt(n3 - 1) == ',') {
                --n3;
            }
            string2 = string2.substring(0, n3) + string2.substring(n4);
        }
        throw new SQLQueryException((SQLFragment)sQLQueryException.getObject(), string2, sQLQueryException);
    }

    private static void resetFromObjectIDs(SQLFragment sQLFragment) {
        if (sQLFragment instanceof ColumnUsage) {
            ((ColumnUsage)sQLFragment).setFromObjectID(null);
            ((ColumnUsage)sQLFragment).setQualified(false);
        }
        for (DBObject dBObject : sQLFragment.getOwnedObjects()) {
            if (!(dBObject instanceof SQLFragment)) continue;
            SQLFragmentExpressionBuilder.resetFromObjectIDs((SQLFragment)dBObject);
        }
    }

    public static enum ExpressionType {
        ITEM,
        CONDITION;

    }
}

