/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.util.DBObjectIDMap;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.MultiMap;

public class DBObjectValidationModel {
    private DBObjectIDMap<MultiMap<String, ValidationException>> m_objs = new DBObjectIDMap(true);

    public void add(ValidationException ... validationExceptionArray) {
        if (validationExceptionArray != null) {
            ValidationException[] validationExceptionArray2 = validationExceptionArray;
            int n = validationExceptionArray2.length;
            for (int i = 0; i < n; ++i) {
                for (ValidationException validationException = validationExceptionArray2[i]; validationException != null; validationException = (ValidationException)validationException.getNextException()) {
                    for (DBObject dBObject = validationException.getObject(); dBObject != null; dBObject = dBObject.getParent()) {
                        this.addImpl(dBObject, validationException);
                    }
                }
            }
        }
    }

    private void addImpl(DBObject dBObject, ValidationException validationException) {
        DBObjectID dBObjectID = this.normaliseID(dBObject);
        if (dBObjectID != null) {
            MultiMap multiMap = (MultiMap)this.m_objs.get(dBObjectID);
            if (multiMap == null) {
                multiMap = new MultiMap(LinkedHashSet.class);
                this.m_objs.put(dBObjectID, multiMap);
            }
            String string = validationException.getPropertyName();
            DBObject dBObject2 = validationException.getObject();
            if (dBObject2 != dBObject) {
                string = Property.createPath(DBUtil.getPropertyPath(dBObject, dBObject2), string);
            }
            multiMap.add((Object)string, (Object)validationException);
        }
    }

    private DBObjectID normaliseID(DBObject dBObject) {
        return dBObject == null ? null : this.normaliseID(dBObject.getID());
    }

    private DBObjectID normaliseID(DBObjectID dBObjectID) {
        DBObjectID dBObjectID2;
        DBObjectID dBObjectID3 = dBObjectID;
        if (dBObjectID instanceof TemporaryObjectID && (dBObjectID2 = TemporaryObjectID.findOriginalID((TemporaryObjectID)dBObjectID)) != null) {
            dBObjectID3 = dBObjectID2;
        }
        return dBObjectID3;
    }

    public Map<String, Collection<ValidationException>> getValidationMap(DBObject dBObject) {
        MultiMap<String, ValidationException> multiMap = this.getValidationMapImpl(dBObject);
        return multiMap == null ? Collections.emptyMap() : Collections.unmodifiableMap(multiMap);
    }

    private MultiMap<String, ValidationException> getValidationMapImpl(DBObject dBObject) {
        MultiMap multiMap = null;
        DBObjectID dBObjectID = this.normaliseID(dBObject);
        if (dBObjectID != null) {
            multiMap = (MultiMap)this.m_objs.get(dBObjectID);
        }
        return multiMap;
    }

    public boolean isValid(DBObject dBObject) {
        return this.getValidationMapImpl(dBObject) == null;
    }

    public Collection<String> getInvalidProperties(DBObject dBObject) {
        Set set = null;
        MultiMap<String, ValidationException> multiMap = this.getValidationMapImpl(dBObject);
        if (multiMap != null) {
            set = multiMap.keySet();
        }
        return set == null ? Collections.emptyList() : Collections.unmodifiableCollection(set);
    }

    public boolean isValid(DBObject dBObject, String string) {
        return !this.getInvalidProperties(dBObject).contains(string);
    }

    public Collection<ValidationException> getValidation(DBObject dBObject, String string) {
        Collection collection = null;
        MultiMap<String, ValidationException> multiMap = this.getValidationMapImpl(dBObject);
        if (multiMap != null) {
            collection = multiMap.get((Object)string);
        }
        return collection == null ? Collections.emptyList() : Collections.unmodifiableCollection(collection);
    }
}

