/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.javatools.exports.library.ClassPathEntry;
import oracle.javatools.exports.library.ExportLibrary;
import oracle.javatools.exports.library.FileExportLibrary;
import oracle.javatools.exports.library.LibraryDependency;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.marshal.AttributeMarker;
import oracle.jdeveloper.library.AbstractLibrary;
import oracle.jdeveloper.library.EndorsedStandardsOverride;
import oracle.jdeveloper.library.ExtensionLibrary;
import oracle.jdeveloper.library.JLibraryDefinition;

public final class AddinLibrary
extends AbstractLibrary
implements ExtensionLibrary,
EndorsedStandardsOverride,
ExportLibrary {
    private static final URLPath EMPTY_URL_PATH = new URLPath();
    private final boolean exportAware;
    private final String providerExtension;
    private final URL origin;
    private final String id;
    private final String name;
    private final String description;
    private final Boolean deployed;
    private final Boolean hidden;
    private final Boolean forceExtInit;
    private final Map<ClassPathEntry, ClassPathEntry> classPathEntries;
    private final URLPath classPath;
    private final Map<String, List<URL>> exportSpecificationPaths;
    private final Collection<LibraryDependency> dependencies;
    private final URLPath srcPath;
    private final URLPath docPath;
    private final URLPath endorsedDirs;
    private final URLPath endorsedSrcPath;
    private final URLPath endorsedDocPath;
    private Set<ClassPathEntry> suppliedClassPath;

    public AddinLibrary(String name, URLPath clsPath, URLPath srcPath, URLPath docPath, Boolean deployed) {
        this(name, clsPath, srcPath, docPath, deployed, true, null);
    }

    public AddinLibrary(String name, URLPath clsPath, URLPath srcPath, URLPath docPath, Boolean deployed, Boolean forceExtInit, String providerExtension) {
        this(name, clsPath, srcPath, docPath, deployed, forceExtInit, providerExtension, false);
    }

    public AddinLibrary(String name, URLPath clsPath, URLPath srcPath, URLPath docPath, Boolean deployed, Boolean forceExtInit, String providerExtension, Boolean hidden) {
        this(name, clsPath, srcPath, docPath, deployed, forceExtInit, providerExtension, hidden, EMPTY_URL_PATH, EMPTY_URL_PATH, EMPTY_URL_PATH);
    }

    public AddinLibrary(String name, URLPath classPath, URLPath srcPath, URLPath docPath, Boolean deployed, Boolean forceExtInit, String providerExtension, Boolean hidden, URLPath endorsedDirs, URLPath endorsedSrcPath, URLPath endorsedDocPath) {
        this(null, name, classPath, srcPath, docPath, deployed, forceExtInit, providerExtension, hidden, endorsedDirs, endorsedSrcPath, endorsedDocPath);
    }

    public AddinLibrary(URL origin, String name, URLPath classPath, URLPath srcPath, URLPath docPath, Boolean deployed, Boolean forceExtInit, String providerExtension, Boolean hidden, URLPath endorsedDirs, URLPath endorsedSrcPath, URLPath endorsedDocPath) {
        this.exportAware = false;
        this.origin = origin;
        this.providerExtension = providerExtension;
        this.id = ExportLibrary.syntheticId((String)(providerExtension != null ? providerExtension : "unknown"), (String)name);
        this.name = name;
        this.description = "";
        this.deployed = deployed != null ? deployed : Boolean.FALSE;
        this.hidden = hidden != null ? hidden.booleanValue() : Boolean.FALSE.booleanValue();
        this.forceExtInit = forceExtInit != null ? forceExtInit : Boolean.TRUE;
        this.classPathEntries = null;
        this.classPath = new URLPath(classPath);
        this.exportSpecificationPaths = Collections.emptyMap();
        this.dependencies = Collections.emptyList();
        this.srcPath = new URLPath(srcPath);
        this.docPath = new URLPath(docPath);
        this.endorsedDirs = new URLPath(endorsedDirs);
        this.endorsedSrcPath = new URLPath(endorsedSrcPath);
        this.endorsedDocPath = new URLPath(endorsedDocPath);
    }

    public AddinLibrary(FileExportLibrary library) {
        this.exportAware = true;
        this.origin = library.getOrigin();
        this.providerExtension = library.getExtensionId();
        this.id = library.getId();
        this.name = library.getName();
        this.description = library.getDescription();
        this.deployed = library.isSet(FileExportLibrary.LibraryFlag.DEPLOYED);
        this.hidden = library.isSet(FileExportLibrary.LibraryFlag.HIDDEN);
        this.forceExtInit = !library.isSet(FileExportLibrary.LibraryFlag.LAZY);
        this.classPathEntries = new LinkedHashMap<ClassPathEntry, ClassPathEntry>();
        this.classPath = new URLPath();
        for (ClassPathEntry entry : library.getResolvedClassPath()) {
            this.classPathEntries.put(entry, entry);
            this.classPath.add(entry.getUrl());
        }
        this.exportSpecificationPaths = library.getExportSpecificationPaths();
        this.dependencies = library.getDependencies();
        this.srcPath = new URLPath(library.getSourcePath());
        this.docPath = new URLPath(library.getDocPath());
        this.endorsedDirs = new URLPath(library.getEndorsedDirectoriesPath());
        this.endorsedSrcPath = new URLPath(library.getEndorsedSourcePath());
        this.endorsedDocPath = new URLPath(library.getEndorsedDocPath());
    }

    public URL getOrigin() {
        return this.origin;
    }

    @Override
    public String getProviderExtensionId() {
        return this.providerExtension;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Boolean getDeployedByDefault() throws AttributeMarker {
        return this.deployed;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean getForceExtensionInitialization() {
        return this.forceExtInit;
    }

    @Override
    public URLPath getClassPath() {
        return new URLPath(this.classPath);
    }

    public Set<ClassPathEntry> getSuppliedClassPath() {
        if (this.suppliedClassPath != null) {
            return this.suppliedClassPath;
        }
        this.suppliedClassPath = new LinkedHashSet<ClassPathEntry>(this.classPath.size());
        if (this.exportAware) {
            for (ClassPathEntry entry : this.classPathEntries.keySet()) {
                if (!entry.isSupplied()) continue;
                this.suppliedClassPath.add(entry);
            }
        } else {
            for (URL url : this.classPath.getEntries()) {
                this.suppliedClassPath.add(new ClassPathEntry(url, ClassPathEntry.EntryType.SUPPLIED_ABSENT, null, false));
            }
        }
        return this.suppliedClassPath;
    }

    public Set<ClassPathEntry> getResolvedClassPath() {
        return this.exportAware ? this.classPathEntries.keySet() : this.getSuppliedClassPath();
    }

    public Map<String, List<URL>> getExportSpecificationPaths() {
        return this.exportSpecificationPaths;
    }

    public Collection<LibraryDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public URLPath getSourcePath() {
        return new URLPath(this.srcPath);
    }

    @Override
    public URLPath getDocPath() {
        return new URLPath(this.docPath);
    }

    @Override
    public URLPath getEndorsedStandardsDirectories() {
        return this.endorsedDirs;
    }

    @Override
    public URLPath getEndorsedStandardsSourcePath() {
        return this.endorsedSrcPath;
    }

    @Override
    public URLPath getEndorsedStandardsDocPath() {
        return this.endorsedDocPath;
    }

    @Override
    public String getShortLabel() {
        return this.name;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    @Override
    public Icon getIcon() {
        return OracleIcons.getIcon((String)"library.png");
    }

    @Override
    @Deprecated
    public JLibraryDefinition getDefaultLibraryDefinition() {
        return this;
    }

    @Override
    @Deprecated
    public JLibraryDefinition getLibraryDefinition(VersionNumber jdkVer) {
        return this;
    }

    @Override
    public void setDeployedByDefault(Boolean deployed) {
        this.immutable();
    }

    @Override
    public void markDirty(boolean dirty) {
        this.immutable();
    }

    @Override
    public void setClassPath(URLPath clsPath) {
        this.immutable();
    }

    @Override
    @Deprecated
    public void setDefaultClassPath(URLPath clsPath) {
        this.immutable();
    }

    @Override
    @Deprecated
    public void setDefaultDocPath(URLPath docPath) {
        this.immutable();
    }

    @Override
    @Deprecated
    public void setDefaultSourcePath(URLPath srcPath) {
        this.immutable();
    }

    @Override
    public void setDocPath(URLPath docPath) {
        this.immutable();
    }

    @Override
    public void setLocked(boolean isLocked) {
        this.immutable();
    }

    @Override
    public void setName(String name) {
        this.immutable();
    }

    @Override
    public void setSourcePath(URLPath srcPath) {
        this.immutable();
    }

    private void immutable() {
        throw new UnsupportedOperationException("AddinLibrary instances are immutable.");
    }
}

