/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.library.ApplicationLibraryList;
import oracle.jdeveloper.library.ClasspathPanel;
import oracle.jdeveloper.library.InternalLibraryList;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.model.ApplicationLibraries;

public final class ApplicationClasspathPanel
extends ClasspathPanel {
    private Workspace workspace;
    private ApplicationLibraries libraries;
    private static final String[] PROPERTYKEYS = new String[]{"libraryReferences", "modulePathLibraryReferences", "internalDefinitions"};
    private static URL defaultDirectory;

    @Override
    protected String getHelpTopicID() {
        return "f1_idecustapplibclasspath_html";
    }

    @Override
    protected URL getDefaultDirectory() {
        return defaultDirectory == null ? URLFileSystem.getParent((URL)this.workspace.getURL()) : defaultDirectory;
    }

    @Override
    protected boolean showExports() {
        return false;
    }

    @Override
    protected boolean showAsModuleColumn() {
        return true;
    }

    @Override
    protected boolean showJDK() {
        return false;
    }

    public String getDataKey() {
        return "oracle.jdeveloper.model.ApplicationLibraries";
    }

    public String[] getPropertyKeys() {
        return PROPERTYKEYS;
    }

    @Override
    public void onProjectPanelEntry(TraversableContext tc) {
        this.workspace = (Workspace)tc.find("Application");
        this.libraries = tc.getWizardCallbacks() != null ? (ApplicationLibraries)((Object)tc.find("oracle.jdeveloper.model.ApplicationLibraries")) : ApplicationLibraries.getInstance(ApplicationClasspathPanel.getPropertyData((Namespace)tc));
        super.onProjectPanelEntry(tc);
    }

    @Override
    protected InternalLibraryList getLibraryList() {
        return this.libraries.getLibraryDefinitions();
    }

    @Override
    protected InternalLibraryList newLibraryList() {
        return new ApplicationLibraryList(HashStructure.newInstance());
    }

    @Override
    protected List<JLibrary> getLibraries() {
        return this.libraries.getLibraryReferences();
    }

    @Override
    protected void setLibraries(List<JLibrary> libraries) {
        this.libraries.setLibraryReferences(libraries);
    }

    @Override
    protected JDK getJDK() {
        return null;
    }

    @Override
    protected void setJDK(JDK jdk) {
    }

    @Override
    protected List<JLibrary> getExports() {
        return Collections.emptyList();
    }

    @Override
    protected void setExports(List<JLibrary> exports) {
    }

    @Override
    protected Collection<LibraryList> getBuiltInLibraryLists() {
        ArrayList<LibraryList> lists = new ArrayList<LibraryList>(super.getBuiltInLibraryLists());
        lists.remove(JLibraryManager.getAddinLibraries());
        return lists;
    }

    @Override
    protected List<JLibrary> getModulePathLibraries() {
        return this.libraries.getModulePathLibraryReferences();
    }

    @Override
    protected void setModulePathLibraries(List<JLibrary> modulePathLibraries) {
        this.libraries.setModulePathLibraryReferences(modulePathLibraries);
    }
}

