/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.buildtools;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.buildtools.ModuleConfiguration;

public final class WorkspaceConfiguration {
    public static final String DATA_KEY = "oracle.jdevimpl.buildtools.WorkspaceConfiguration";
    public static final String MODULAR_BUILD_KEY = "modularBuild";
    private static final Object GUARD = new String("Workspace Configuration Guard");
    private final boolean modularBuild;
    private final URL workspaceUrl;
    private int modularBuildVersion = -1;

    private WorkspaceConfiguration(boolean modularBuild, URL workspaceUrl) {
        this.modularBuild = modularBuild;
        this.workspaceUrl = workspaceUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkspaceConfiguration getWorkspaceConfiguration(Workspace workspace) {
        Map properties = workspace.getTransientProperties();
        Object object = GUARD;
        synchronized (object) {
            WorkspaceConfiguration configuration = (WorkspaceConfiguration)properties.get(DATA_KEY);
            if (configuration == null) {
                boolean modularBuild;
                HashStructure structure = workspace.getProperties();
                if (structure.containsKey(DATA_KEY)) {
                    HashStructure dataKeyStructure = structure.getHashStructure(DATA_KEY);
                    modularBuild = dataKeyStructure.getBoolean(MODULAR_BUILD_KEY, false);
                } else {
                    modularBuild = false;
                }
                configuration = new WorkspaceConfiguration(modularBuild, workspace.getURL());
                properties.put(DATA_KEY, configuration);
            }
            return configuration;
        }
    }

    public boolean isModularBuildWorkspace() {
        return this.modularBuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getModularBuildVersion() {
        URL secondFile;
        String workspaceName;
        if (this.modularBuildVersion >= 0) {
            return this.modularBuildVersion;
        }
        URL workspaceDir = URLFileSystem.getParent((URL)this.workspaceUrl);
        URL firstFile = URLFactory.newURL((URL)workspaceDir, (String)((workspaceName = URLFileSystem.getName((URL)this.workspaceUrl)) + ".properties"));
        if (URLFileSystem.exists((URL)firstFile)) {
            InputStream stream = null;
            try {
                stream = firstFile.openStream();
                Properties properties = new Properties();
                properties.load(stream);
                String value = properties.getProperty("jdevadf.modular.build.version");
                if (value != null) {
                    try {
                        this.modularBuildVersion = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        Logger.getLogger(ModuleConfiguration.class.getName()).log(Level.SEVERE, "number for " + firstFile, e);
                    }
                }
            }
            catch (IOException e) {
                Logger.getLogger(ModuleConfiguration.class.getName()).log(Level.SEVERE, "exception reading " + firstFile, e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (this.modularBuildVersion < 0 && !"jdevadf".equals(workspaceName) && URLFileSystem.exists((URL)(secondFile = URLFactory.newURL((URL)URLFileSystem.getParent((URL)workspaceDir), (String)"jdevadf/jdevadf.properties")))) {
            InputStream stream = null;
            try {
                stream = secondFile.openStream();
                Properties properties = new Properties();
                properties.load(stream);
                String value = properties.getProperty("jdevadf.modular.build.version");
                if (value != null) {
                    try {
                        this.modularBuildVersion = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        Logger.getLogger(ModuleConfiguration.class.getName()).log(Level.SEVERE, "number for " + secondFile, e);
                    }
                }
            }
            catch (IOException e) {
                Logger.getLogger(ModuleConfiguration.class.getName()).log(Level.SEVERE, "exception reading " + secondFile, e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (this.modularBuildVersion < 0) {
            this.modularBuildVersion = 0;
            Logger.getLogger(ModuleConfiguration.class.getName()).log(Level.SEVERE, "no property file containing the modular build version number found");
        }
        return this.modularBuildVersion;
    }

    public static boolean isModularBuildWorkspace(Context context) {
        return context != null && WorkspaceConfiguration.isModularBuildWorkspace((Element)context.getWorkspace());
    }

    public static boolean isModularBuildWorkspace(Element element) {
        return element instanceof Workspace && WorkspaceConfiguration.getWorkspaceConfiguration((Workspace)element).isModularBuildWorkspace();
    }

    public static int getModularBuildVersion(Workspace workspace) {
        return WorkspaceConfiguration.getWorkspaceConfiguration(workspace).getModularBuildVersion();
    }

    public static boolean isJdevadfWorkspace(Context context) {
        return context != null && WorkspaceConfiguration.isJdevadfWorkspace((Element)context.getWorkspace());
    }

    public static boolean isJdevadfWorkspace(Element element) {
        return WorkspaceConfiguration.isModularBuildWorkspace(element) && URLFileSystem.getPath((URL)((Workspace)element).getURL()).endsWith("jdevadf/jdevadf.jws");
    }
}

