/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.core;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.xml.bind.DatatypeConverter;

public class HadoopEncryption {
    static final String OSCH_CONN_SYSTEM_ID = "oracle.hadoop.connection.system.id";
    static final String OSCH_CONN_ENCRYPTED_PASSWORD = "oracle.hadoop.connection.encryptedPassword";
    static final String OSCH_CONN_PASSWORD = "oracle.hadoop.connection.password";
    static final String OLH_CONN_PASSWORD = "oracle.hadoop.loader.connection.password";
    static final String OLH_CONN_SYSTEM_ID = "oracle.hadoop.loader.connection.system.id";
    static final String OLH_CONN_ENCRYPTED_PASSWORD = "oracle.hadoop.loader.connection.encryptedPassword";
    static final String BDA_COPY_CONN_PASSWORD = "oracle.hadoop.ctoh.connection.password";
    static final String BDA_COPY_SYSTEM_ID = "oracle.hadoop.ctoh.connection.systemId";
    static final String BDA_COPY_CONN_ENCRYPTED_PASSWORD = "oracle.hadoop.ctoh.connection.encrypted.password";

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String getRandomUUID() {
        return UUID.randomUUID().toString();
    }

    public static String encryptPassword(String string, String string2, byte[] byArray) {
        if (HadoopEncryption.isNullOrEmpty(string) || HadoopEncryption.isNullOrEmpty(string2) || null == byArray || byArray.length == 0) {
            throw new RuntimeException("null input args");
        }
        try {
            Wrapper wrapper = Wrapper.newInstance(string2, byArray);
            return wrapper.encrypt(string.toCharArray());
        }
        catch (CharacterCodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException exception) {
            throw new RuntimeException("Unable to encrypt password: ", exception);
        }
    }

    public static byte[] getOLHSalt(String string, String string2) {
        int n;
        if (HadoopEncryption.isNullOrEmpty(string) || HadoopEncryption.isNullOrEmpty(string2)) {
            throw new IllegalStateException("cannot construct salt from null values");
        }
        byte[] byArray = new byte[]{-116, 77, 101, -88, -97, 80, 82, 51};
        int n2 = byArray.length;
        for (n = 0; n < string.length(); ++n) {
            byArray[n % n2] = (byte)(string.charAt(n) ^ byArray[n % n2]);
        }
        for (n = 0; n < string2.length(); ++n) {
            byArray[n % n2] = (byte)(string2.charAt(n) ^ byArray[n % n2]);
        }
        return byArray;
    }

    public static byte[] getOSCHSalt(String string) {
        if (HadoopEncryption.isNullOrEmpty(string)) {
            throw new IllegalStateException("null or empty table name");
        }
        byte[] byArray = new byte[]{-116, 77, 101, -88, -97, 80, 82, 51};
        int n = byArray.length;
        for (int i = 0; i < string.length(); ++i) {
            byArray[i % n] = (byte)(string.charAt(i) ^ byArray[i % n]);
        }
        return byArray;
    }

    public static byte[] getCTOHSalt(String string, String string2) {
        String[] stringArray = new String[]{string, string2};
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null && stringArray[i].trim().length() != 0) continue;
            throw new IllegalStateException("cannot construct salt from null values");
        }
        byte[] byArray = new byte[]{-116, 77, 101, -88, -97, 80, 82, 51};
        int n = byArray.length;
        for (String string3 : stringArray) {
            byte[] byArray2 = string3.getBytes(StandardCharsets.UTF_8);
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[i % n] = (byte)(byArray2[i] ^ byArray[i % n]);
            }
        }
        return byArray;
    }

    public static final class Wrapper {
        private static final int ITERATION_COUNT = 42;
        private Cipher m_encoder;
        private Cipher m_decoder;
        private AlgorithmParameterSpec m_paramSpec;
        private SecretKey m_key;
        private CharsetEncoder m_charEnc;
        private CharsetDecoder m_charDec;

        public static Wrapper newInstance(String string, byte[] byArray) throws InvalidKeySpecException, NoSuchAlgorithmException {
            if (null == string || null == byArray) {
                throw new IllegalArgumentException("null arguments");
            }
            return new Wrapper(string, byArray);
        }

        private Wrapper(String string, byte[] byArray) throws InvalidKeySpecException, NoSuchAlgorithmException {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), byArray, 42);
            this.m_key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(pBEKeySpec);
            this.m_paramSpec = new PBEParameterSpec(byArray, 42);
        }

        public String encrypt(char[] cArray) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException, CharacterCodingException, IllegalBlockSizeException, BadPaddingException {
            if (null == cArray || cArray.length == 0) {
                throw new IllegalArgumentException("null input value");
            }
            byte[] byArray = null;
            if (this.m_encoder == null) {
                this.m_encoder = Cipher.getInstance(this.m_key.getAlgorithm());
                this.m_encoder.init(1, (Key)this.m_key, this.m_paramSpec);
            }
            if (this.m_charEnc == null) {
                this.m_charEnc = StandardCharsets.UTF_8.newEncoder();
            }
            ByteBuffer byteBuffer = this.m_charEnc.encode(CharBuffer.wrap(cArray));
            byte[] byArray2 = new byte[byteBuffer.limit()];
            byteBuffer.get(byArray2);
            byArray = this.m_encoder.doFinal(byArray2);
            return DatatypeConverter.printBase64Binary((byte[])byArray);
        }

        public char[] decrypt(String string) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, CharacterCodingException {
            if (HadoopEncryption.isNullOrEmpty(string)) {
                throw new IllegalArgumentException("null input string");
            }
            if (this.m_decoder == null) {
                this.m_decoder = Cipher.getInstance(this.m_key.getAlgorithm());
                this.m_decoder.init(2, (Key)this.m_key, this.m_paramSpec);
            }
            byte[] byArray = DatatypeConverter.parseBase64Binary((String)string);
            byte[] byArray2 = this.m_decoder.doFinal(byArray);
            if (this.m_charDec == null) {
                this.m_charDec = StandardCharsets.UTF_8.newDecoder();
            }
            CharBuffer charBuffer = this.m_charDec.decode(ByteBuffer.wrap(byArray2));
            char[] cArray = new char[charBuffer.limit()];
            charBuffer.get(cArray);
            return cArray;
        }
    }
}

