/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.readers.DataReaderException;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.hadoop.core.HadoopGenericTable;
import oracle.dbtools.raptor.hadoop.core.HadoopImportDataFormat;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.core.HadoopUtils;
import oracle.dbtools.raptor.hadoop.readers.TableReader;
import oracle.dbtools.raptor.hadoop.ui.HadoopUIUtils;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;

public abstract class HadoopIGeneralPage
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    protected HadoopProperties _hProps;
    private JTextPane _instructions;
    protected JLabel _sourceTypeLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("SOURCE_TYPE")));
    protected JComboBox<String> _sourceTypeCmp;
    private ActionListener _sourceTypeListener;
    protected JLabel _sConnLabel;
    private String[] HIVE = new String[]{"Hive"};
    protected DBConnectionComboBox _sourceConnSelector = new DBConnectionComboBox(this.HIVE);
    private JPanel _sourcePanel;
    protected JLabel _schemaLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("SCHEMA")));
    protected JComboBox<String> _schemaCmp;
    private ActionListener _schemaListener;
    protected JLabel _tableLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("TABLE")));
    protected JComboBox<String> _tableCmp = new JComboBox();
    protected JLabel _dHostLabel;
    protected JComboBox<String> _dHostCmp;
    private ActionListener _dHostListener;
    private boolean init = false;
    private boolean _isHostValid = false;
    protected boolean _isSourceChanged = true;
    protected String _hostName;
    String _schemaName;
    protected TraversableContext _dataContext;

    protected abstract String[] getSourceTypes();

    protected abstract HadoopImportDataFormat getDataFormat();

    protected abstract String getInstructionsText();

    protected abstract String getHostTooltip();

    protected abstract void updateExpectedTransition();

    protected abstract JPanel getSourcePanel();

    protected TraversableContext getContext() {
        return this._dataContext;
    }

    public void onEntry(TraversableContext traversableContext) {
        this._dataContext = traversableContext;
        this._hProps = (HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES"));
        this._dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (!this.init) {
            this.build();
            this.init = true;
        }
    }

    private void build() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.initInstructions();
        this.initSourcePanel();
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 6));
        jPanel2.add((Component)this._instructions, "North");
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 8));
        int n = 0;
        jPanel3.add((Component)this._dHostLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel3.add(this._dHostCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(HadoopWizArb.getString("SSH_CONN")));
        jPanel4.add((Component)jPanel3, "North");
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(6, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel4, LayoutControl.GBC.gbc((int)0, (int)1, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        this._sourcePanel = this.getSourcePanel();
        jPanel.add((Component)this._sourcePanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 2, new Insets(16, 0, 0, 0), 0, 0));
        JPanel jPanel5 = new JPanel();
        jPanel.add((Component)jPanel5, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 20, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.setBorder(BorderFactory.createEmptyBorder());
        this.add(jPanel, "Center");
    }

    private void initInstructions() {
        this._instructions = new JTextPane();
        this._instructions.setEditable(false);
        this._instructions.setOpaque(false);
        this._instructions.setRequestFocusEnabled(false);
        this._instructions.setFocusable(false);
        this._instructions.setText(this.getInstructionsText());
    }

    private void initSourcePanel() {
        this._sourceTypeCmp = new JComboBox<String>(this.getSourceTypes());
        this._sourceTypeCmp.setToolTipText(HadoopWizArb.getString("SOURCE_TYPE_TIP"));
        if (this._sourceTypeListener == null) {
            this.addSourceTypeListener();
        }
        this._sourceTypeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("SOURCE_TYPE")));
        this._sourceTypeLabel.setLabelFor(this._sourceTypeCmp);
        this._schemaLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("SCHEMA")));
        this._schemaCmp = HadoopUIUtils.getSQLCombo(this._schemaLabel);
        this._schemaLabel.setLabelFor(this._schemaCmp);
        if (this._schemaListener == null) {
            this.addSchemaListener();
        }
        this._tableLabel.setLabelFor(this._tableCmp);
        this._tableCmp = HadoopUIUtils.getSQLCombo(this._tableLabel);
        this._tableLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("TABLE")));
        this.initHost();
        this.connCmpInit();
    }

    private void initHost() {
        if (this._dHostLabel == null) {
            this._dHostLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("HOST")));
            this._dHostLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("HOST")));
            Store store = Client.getInstance().getStore();
            Collection collection = store.listHosts();
            this._dHostCmp = new JComboBox();
            this._dHostCmp.setToolTipText(this.getHostTooltip());
            this._dHostLabel.setLabelFor(this._dHostCmp);
            for (String string : collection) {
                this._dHostCmp.addItem(string);
            }
            this._dHostCmp.setSelectedIndex(-1);
            this.addDHostListener();
        }
    }

    private void addDHostListener() {
        this._dHostListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HadoopIGeneralPage.this._hostName = (String)HadoopIGeneralPage.this._dHostCmp.getSelectedItem();
                HadoopIGeneralPage.this._isHostValid = false;
                if (HadoopIGeneralPage.this._hostName != null && !HadoopIGeneralPage.this._hostName.isEmpty()) {
                    HadoopIGeneralPage.this._isHostValid = HadoopUIUtils.isHostScriptExcutable(HadoopIGeneralPage.this._hProps, HadoopIGeneralPage.this._hostName);
                }
            }
        };
        this._dHostCmp.addActionListener(this._dHostListener);
    }

    private void addSourceTypeListener() {
        this._sourceTypeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HadoopIGeneralPage.this.setHiveComponentsEnabled(HadoopIGeneralPage.this._sourceTypeCmp.getSelectedIndex() == 0);
                HadoopIGeneralPage.this.setTextComponentsEnabled(HadoopIGeneralPage.this._sourceTypeCmp.getSelectedIndex() != 0);
                HadoopIGeneralPage.this.updateExpectedTransition();
            }
        };
        this._sourceTypeCmp.addActionListener(this._sourceTypeListener);
    }

    protected void setHiveComponentsEnabled(boolean bl) {
        this._sConnLabel.setEnabled(bl);
        this._sourceConnSelector.getJComboBox().setEnabled(bl);
        this._schemaLabel.setEnabled(bl);
        this._schemaCmp.setEnabled(bl);
        this._tableLabel.setEnabled(bl);
        this._tableCmp.setEnabled(bl);
    }

    protected void setTextComponentsEnabled(boolean bl) {
    }

    private void addSchemaListener() {
        this._schemaListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                if (jComboBox.getSelectedIndex() > -1) {
                    String string = (String)HadoopIGeneralPage.this._sourceConnSelector.getJComboBox().getSelectedItem();
                    HadoopUIUtils.setTableModel(HadoopIGeneralPage.this._tableCmp, string, (String)jComboBox.getSelectedItem(), false);
                } else {
                    HadoopIGeneralPage.this._tableCmp.setModel(new DefaultComboBoxModel());
                }
                if (HadoopIGeneralPage.this._tableCmp.getItemCount() > 0) {
                    HadoopIGeneralPage.this._tableCmp.setSelectedIndex(0);
                }
                HadoopIGeneralPage.this._tableCmp.setSelectedIndex(-1);
                HadoopIGeneralPage.this._sourcePanel.validate();
            }
        };
        this._schemaCmp.addActionListener(this._schemaListener);
    }

    private void connCmpInit() {
        this._sourceConnSelector.getJComboBox().addItemListener(new Connector(this._sourceConnSelector, this._schemaCmp, this._tableCmp));
        this._sourceConnSelector.getJComboBox().setSelectedIndex(-1);
        this._sConnLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("S_HIVE_CON_LABEL")));
        this._sConnLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("S_HIVE_CON_LABEL")));
        this._sConnLabel.setLabelFor(this._sourceConnSelector.getJComboBox());
    }

    public String getSourceConnection() {
        if (this._sourceConnSelector != null) {
            return this._sourceConnSelector.getCurrentConnectionName();
        }
        return null;
    }

    public void setSourceConnection(String string) {
        if (this._sourceConnSelector != null) {
            this._sourceConnSelector.setCurrentConnection(string);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        boolean bl;
        boolean bl2 = bl = this._sourceTypeCmp.getSelectedIndex() == 0;
        if (bl) {
            String string = this.getSourceConnection();
            Connection connection = null;
            this._dataContext = traversableContext;
            if (string != null) {
                try {
                    connection = Connections.getInstance().getConnection(string);
                }
                catch (Exception exception) {
                    Throwable throwable;
                    Exception exception2;
                    while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                        exception2 = (Exception)throwable;
                    }
                    ExceptionHandler.handleException((String)string, (Throwable)exception2);
                    throw new TraversalException(null);
                }
            }
            if (this._sourceTypeCmp.getSelectedIndex() == 0 && connection == null) {
                throw new TraversalException(HadoopWizArb.getString("NO_SOURCE_CONNECTION"));
            }
            String string2 = (String)this._schemaCmp.getSelectedItem();
            String string3 = (String)this._tableCmp.getSelectedItem();
            if (string2 == null || string2.isEmpty()) {
                throw new TraversalException(HadoopWizArb.getString("NO_SOURCE_SCHEMA"));
            }
            if (string3 == null || string3.isEmpty()) {
                throw new TraversalException(HadoopWizArb.getString("NO_SOURCE_TABLE"));
            }
            this._isSourceChanged = false;
            if (!(this._hProps.get(HadoopKeys.SOURCE_TYPE) != null && this._hProps.get(HadoopKeys.SOURCE_CONN_NAME) != null && this._hProps.get(HadoopKeys.SOURCE_SCHEMA_NAME) != null && this._hProps.get(HadoopKeys.SOURCE_TABLE_NAME) != null && (this._sourceTypeCmp.getSelectedIndex() != 0 || this._hProps.get(HadoopKeys.SOURCE_CONN_NAME).equals(string) && this._hProps.get(HadoopKeys.SOURCE_SCHEMA_NAME).equals(string2) && this._hProps.get(HadoopKeys.SOURCE_TABLE_NAME).equals(string3)))) {
                this._isSourceChanged = true;
                this._hProps.put(HadoopKeys.SOURCE_CONN, connection);
                this._hProps.put(HadoopKeys.SOURCE_CONN_NAME, string);
                this._hProps.put(HadoopKeys.SOURCE_SCHEMA_NAME, string2);
                this._hProps.put(HadoopKeys.SOURCE_TABLE_NAME, string3);
                this._dataContext.put(HadoopKeys.SOURCE_CONN_NAME.toString(), (Object)string);
                HadoopGenericTable hadoopGenericTable = new HadoopGenericTable((Connection)this._hProps.get(HadoopKeys.SOURCE_CONN), (String)this._hProps.get(HadoopKeys.SOURCE_SCHEMA_NAME), (String)this._hProps.get(HadoopKeys.SOURCE_TABLE_NAME));
                this._hProps.put(HadoopKeys.SOURCE_GENERIC_TABLE, (Object)hadoopGenericTable);
                this._hProps.put(HadoopKeys.PARTITION_KEYS, hadoopGenericTable.getPartitions());
                this._hProps.put(HadoopKeys.IS_SOURCE_PARTITIONED, hadoopGenericTable.isPartitioned());
                DBObject dBObject = HadoopUtils.getDBO(string, "TABLE", string2, string3);
                this._hProps.put(HadoopKeys.SOURCE_DBO, dBObject);
                ExtractListModel extractListModel = (ExtractListModel)this._hProps.get(HadoopKeys.EXTRACT_LIST_MODEL);
                extractListModel = new ExtractListModel(dBObject);
                extractListModel.isDDLEnabled(false);
                extractListModel.isDataEnabled(true);
                extractListModel.setDataFormat((ExtractDataFormat)this._hProps.get(HadoopKeys.EXTRACT_DATA_FORMAT));
                traversableContext.put("EXTRACT_LIST_MODEL", (Object)extractListModel);
                this._hProps.put(HadoopKeys.EXTRACT_LIST_MODEL, extractListModel);
                this._hProps.put(HadoopKeys.EXTRACT_OBJECT, extractListModel.getFirstDataObject());
                extractListModel.setSourceConnName(string);
                traversableContext.put("CONNECTION_NAME", (Object)extractListModel.getSourceConnName());
                LoadFile loadFile = this.buildLoadFileForTable(hadoopGenericTable);
                this._hProps.put(ImportKeys.LOAD_FILE, loadFile);
                TableReader tableReader = new TableReader();
                tableReader.setGenericTable(hadoopGenericTable);
                try {
                    tableReader.openFile("");
                }
                catch (DataReaderException dataReaderException) {
                    // empty catch block
                }
                HadoopImportDataFormat hadoopImportDataFormat = this.getDataFormat();
                this._hProps.put(ImportKeys.IMPORT_DATA_FORMAT, (Object)hadoopImportDataFormat);
                DataPreviewGizmo dataPreviewGizmo = new DataPreviewGizmo((DataReadable)tableReader);
                dataPreviewGizmo.setDataFormat((ImportDataFormat)hadoopImportDataFormat);
                dataPreviewGizmo.initTable();
                dataPreviewGizmo.populateDataTable();
                this._hProps.put(ImportKeys.GIZMO, dataPreviewGizmo);
                this._hProps.put(ImportKeys.FILE_COLUMNS, hadoopGenericTable.getColumns());
                this._hProps.put(ImportKeys.SELECTED_COLUMNS, this._hProps.get(ImportKeys.FILE_COLUMNS));
                this._hProps.put(ImportKeys.SELECTABLE_COLUMNS, new Column[0]);
            }
        } else if (this._hProps.get(HadoopKeys.SOURCE_TYPE) == null || this._hProps.get(HadoopKeys.SOURCE_TYPE) != this._sourceTypeCmp.getSelectedItem()) {
            this._isSourceChanged = true;
            this._hProps.put(HadoopKeys.SOURCE_CONN, null);
            this._hProps.put(HadoopKeys.SOURCE_CONN_NAME, null);
            this._hProps.put(HadoopKeys.SOURCE_SCHEMA_NAME, null);
            this._hProps.put(HadoopKeys.SOURCE_TABLE_NAME, null);
            this._dataContext.put(HadoopKeys.SOURCE_CONN_NAME.toString(), null);
            this._hProps.put(HadoopKeys.SOURCE_GENERIC_TABLE, null);
            this._hProps.put(HadoopKeys.PARTITION_KEYS, null);
            this._hProps.put(HadoopKeys.IS_SOURCE_PARTITIONED, false);
            this._hProps.put(HadoopKeys.SOURCE_DBO, null);
            traversableContext.put("EXTRACT_LIST_MODEL", null);
            this._hProps.put(HadoopKeys.EXTRACT_LIST_MODEL, null);
            this._hProps.put(HadoopKeys.EXTRACT_OBJECT, null);
            traversableContext.put("CONNECTION_NAME", null);
            HadoopImportDataFormat hadoopImportDataFormat = this.getDataFormat();
            this._hProps.put(ImportKeys.IMPORT_DATA_FORMAT, (Object)hadoopImportDataFormat);
            this._hProps.put(ImportKeys.GIZMO, null);
            this._hProps.put(ImportKeys.FILE_COLUMNS, null);
            this._hProps.put(ImportKeys.SELECTABLE_COLUMNS, new Column[0]);
        }
        if (this._hostName == null || this._hostName.isEmpty()) {
            throw new TraversalException(HadoopWizArb.getString("HOST_ERROR"));
        }
        if (!this._isHostValid) {
            throw new TraversalException(HadoopWizArb.getString("TEMP_DIR_ERROR1"));
        }
        this._hProps.put(HadoopKeys.DDL_ENABLED, false);
        this._hProps.put(HadoopKeys.DATA_ENABLED, true);
        this._hProps.put(HadoopKeys.SOURCE_TYPE, this._sourceTypeCmp.getSelectedItem());
    }

    private LoadFile buildLoadFileForTable(HadoopGenericTable hadoopGenericTable) {
        LoadFile loadFile = new LoadFile();
        if (loadFile.getFieldCount() == 0 || hadoopGenericTable.getTable().getColumnCount() != loadFile.getFieldCount()) {
            loadFile.setFields(new LoadField[0]);
            int n = 0;
            for (Column column : hadoopGenericTable.getColumns()) {
                LoadField loadField = new LoadField();
                loadField.setName(column.getName());
                loadField.setFormat("");
                loadField.setDetectedType(column.getType());
                loadField.setDetectedPrecision(column.getPrecision());
                loadField.setDetectedScale(column.getScale());
                loadField.setLength(column.getPrecision());
                loadField.isLoad(true);
                loadField.isCompatible(true);
                loadField.isChecked(true);
                loadField.setColumn(column);
                loadFile.addField(loadField);
                column.setSourceColumnName(column.getName());
                column.setSourceColID(n);
                ++n;
            }
        }
        return loadFile;
    }

    private static class Connector
    implements ItemListener {
        private DBConnectionComboBox m_selector;
        private JComboBox<String> m_schemaCmp;
        private JComboBox<String> m_tableCmp;

        Connector(DBConnectionComboBox dBConnectionComboBox, JComboBox<String> jComboBox, JComboBox<String> jComboBox2) {
            this.m_selector = dBConnectionComboBox;
            this.m_schemaCmp = jComboBox;
            this.m_tableCmp = jComboBox2;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                try {
                    String string = this.m_selector.getCurrentConnectionName();
                    Connections.getInstance().getConnection(string);
                    HadoopUIUtils.setSchemaModel(this.m_schemaCmp, string);
                    this.m_tableCmp.setModel(new DefaultComboBoxModel());
                    this.m_tableCmp.setSelectedIndex(-1);
                }
                catch (Exception exception) {
                    Throwable throwable;
                    Exception exception2;
                    this.m_selector.getJComboBox().setSelectedIndex(-1);
                    while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                        exception2 = (Exception)throwable;
                    }
                    ExceptionHandler.handleException((Throwable)exception2);
                }
            }
        }
    }
}

